/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.invbillreport;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bd.sbd.utils.StringUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.balance.BalanceUpdateHandle;
import kd.scmc.im.business.helper.AuxptyFilterHelper;
import kd.scmc.im.business.helper.DymAccDataSourceHelper;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.consts.InvBillRptConst;
import kd.scmc.im.consts.InvCountSchemeConst;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;
import kd.scmc.im.report.helper.ReportGeneralOpHelper;
import kd.scmc.im.report.invbillreport.BaseInvBillRptFilteInfo;
import kd.scmc.im.report.invbillreport.DymAccDSInfo;
import kd.scmc.im.utils.DateUtils;

public class BaseInvBillRptQuery
extends AbstractReportListDataPlugin {
    public static final String TRASCEIVER_RECEIVE = "0";
    public static final String TRASCEIVER_SEND = "1";
    public static final String TRASCEIVER_RECEIVE_AND_SEND = "2";
    private static Log logger = LogFactory.getLog(BaseInvBillRptQuery.class);
    protected static final List<String> bdFieldList = Arrays.asList("invtype", "baseunit", "billtype", "biztype", "warehouse", "invstatus", "location", "project", "invscheme");
    protected static final List<String> bdCanZeroFieldList = Arrays.asList("location", "project");
    protected static final List<String> entryFieldList = Arrays.asList("invtype", "material", "materialname1", "modelnum1", "lotnumber", "baseunit", "warehouse", "location", "invstatus", "ownertype", "project");
    protected static final List<String> qtyFieldList = Arrays.asList("inqty", "inbaseqty", "inqty2nd", "outqty", "outbaseqty", "outqty2nd");
    protected static final List<String> materialFieldList = Arrays.asList("material", "materialname1", "modelnum1", "group");
    protected static final List<String> dateFieldList = Arrays.asList("biztime", "auditdate", "bookdate");
    protected static final List<String> balanceFieldList = Arrays.asList("material", "materialname1", "modelnum1", "baseunit");
    protected static final String BILLENTRY_PRE = "billentry.";
    protected static final String BD_NAME_SUF = ".name";

    public DataSet query(ReportQueryParam paramReportQueryParam, Object paramObject) throws Throwable {
        FilterInfo filterInfo = paramReportQueryParam.getFilter();
        Date startDate = filterInfo.getDate("startdate");
        Date endDate = filterInfo.getDate("enddate");
        QFilter timefilter = new QFilter("bookdate", ">=", (Object)ReportGeneralOpHelper.getStartTimeOfToday(startDate));
        timefilter.and(new QFilter("bookdate", "<=", (Object)ReportGeneralOpHelper.getLastTimeOfToday(endDate)));
        List headFilters = filterInfo.getHeadFilters();
        List<QFilter> newHeadFilters = this.buildHeadFilters(headFilters);
        DataSet billSet = DymAccDSInfo.handleUpdateBill(filterInfo, timefilter, newHeadFilters);
        billSet = AuxptyFilterHelper.filterAuxpty((DataSet)billSet, (ReportQueryParam)paramReportQueryParam);
        billSet = this.dealBillDataSet(billSet, filterInfo);
        billSet = this.addQtyFilter(billSet, headFilters);
        return billSet;
    }

    private DataSet queryBillDataSetBeforeStartDate(FilterInfo filterInfo) throws ParseException {
        Date startDate = filterInfo.getDate("startdate");
        Date firstDayOfMonth = DateUtils.getFirstDayOfMonthByDate((Date)startDate);
        QFilter timefilter = new QFilter("bookdate", "<", (Object)ReportGeneralOpHelper.getStartTimeOfToday(startDate)).and("bookdate", ">=", (Object)firstDayOfMonth);
        DataSet billSet = DymAccDSInfo.handleUpdateBill(filterInfo, timefilter, this.buildHeadFilters(filterInfo.getHeadFilters()));
        return billSet;
    }

    public DataSet dealBillDataSet(DataSet billDataSet, FilterInfo filterInfo) {
        return billDataSet;
    }

    private DataSet addQtyFilter(DataSet billSet, List<QFilter> headFilters) {
        StringBuilder buf = new StringBuilder();
        int seq = 0;
        String singleFilterString = "";
        for (QFilter filter : headFilters) {
            String property = filter.getProperty();
            if (!qtyFieldList.contains(property)) continue;
            String cp = filter.getCP();
            Object value = filter.getValue();
            String decimalVal = new BigDecimal(value.toString()).setScale(10).toPlainString();
            singleFilterString = property + cp + decimalVal;
            if (seq > 0) {
                buf.append(" and ");
            }
            buf.append(singleFilterString);
            ++seq;
        }
        String bufStr = buf.toString();
        if (StringUtils.isBlank((String)bufStr)) {
            return billSet;
        }
        return billSet.filter(bufStr);
    }

    private List<QFilter> buildHeadFilters(List<QFilter> headFilters) throws ParseException {
        ArrayList<QFilter> newHeadFilters = new ArrayList<QFilter>();
        for (QFilter filter : headFilters) {
            String property = filter.getProperty();
            if (!InvBillRptConst.DETAIL_HEADFILTER_LIST.contains(property) || qtyFieldList.contains(property) || materialFieldList.contains(property)) continue;
            QFilter newFilter = this.rebuildFilter(filter);
            List nests = newFilter.getNests(true);
            for (QFilter.QFilterNest net : nests) {
                QFilter netFilter = net.getFilter();
                this.rebuildFilter(netFilter);
            }
            newHeadFilters.add(newFilter);
        }
        return newHeadFilters;
    }

    private QFilter rebuildFilter(QFilter filter) throws ParseException {
        String oldProperty = filter.getProperty();
        String property = filter.getProperty();
        if ("warehouse".equals(property) || "location".equals(property)) {
            return filter;
        }
        if (entryFieldList.contains(oldProperty)) {
            property = BILLENTRY_PRE + property;
        }
        if (bdFieldList.contains(oldProperty)) {
            String cp = filter.getCP();
            if (bdCanZeroFieldList.contains(oldProperty) && cp.equals("is null")) {
                return new QFilter(property, "=", (Object)0);
            }
            if (bdCanZeroFieldList.contains(oldProperty) && cp.equals("is not null")) {
                return new QFilter(property, "!=", (Object)0);
            }
            property = property + BD_NAME_SUF;
            filter.__setProperty(property);
        } else if (dateFieldList.contains(oldProperty)) {
            filter.__setProperty(property);
            Object value = filter.getValue();
            if (!Objects.isNull(value) && value instanceof String) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date dateValue = simpleDateFormat.parse((String)value);
                filter.__setValue((Object)dateValue);
            }
        } else {
            filter.__setProperty(property);
        }
        return filter;
    }

    private List<QFilter> getBalanceHeadFilters(List<QFilter> headFilters) {
        ArrayList<QFilter> newHeadFilters = new ArrayList<QFilter>();
        for (QFilter filter : headFilters) {
            String property = filter.getProperty();
            if (!balanceFieldList.contains(property)) continue;
            this.rebuildBalanceHeadFilter(filter);
            List nests = filter.getNests(true);
            for (QFilter.QFilterNest net : nests) {
                QFilter netFilter = net.getFilter();
                this.rebuildBalanceHeadFilter(netFilter);
            }
            newHeadFilters.add(filter);
        }
        return newHeadFilters;
    }

    private void rebuildBalanceHeadFilter(QFilter filter) {
        String property = filter.getProperty();
        if (bdFieldList.contains(property)) {
            filter.__setProperty(property + BD_NAME_SUF);
        } else {
            switch (property) {
                case "material": {
                    filter.__setProperty("material.number");
                    break;
                }
                case "materialname1": {
                    filter.__setProperty("material.name");
                    break;
                }
                case "modelnum1": {
                    filter.__setProperty("material.modelnum");
                    break;
                }
            }
        }
    }

    protected DataSet getInvBalanceDataSetWithBgnQty(FilterInfo filterInfo) throws ParseException {
        DataSet invBalanceDataSet = this.getInvBalanceDataSet(filterInfo);
        String[] invBalanceField = BaseInvBillRptQuery.getDataSetFieldArray(invBalanceDataSet);
        DataSet beforeStartDataSet = this.queryBillDataSetBeforeStartDate(filterInfo);
        String[] recAndSendField = this.getRecAndSendField();
        if (invBalanceDataSet.copy().isEmpty()) {
            invBalanceDataSet = ReportGeneralOpHelper.addSumColumn(beforeStartDataSet.groupBy(ReportGeneralOpHelper.removeFiled(invBalanceField, "bgnqty", "bgnbaseqty", "bgnqty2nd", "endperiod")), recAndSendField).finish();
            HashMap<String, String> mapperbgn = new HashMap<String, String>();
            mapperbgn.put("bgnqty", "inqty - outqty");
            mapperbgn.put("bgnbaseqty", "inbaseqty - outbaseqty");
            mapperbgn.put("bgnqty2nd", "inqty2nd - outqty2nd");
            invBalanceDataSet = BaseInvBillRptQuery.handleNullFiledAsZero(invBalanceDataSet, recAndSendField);
            invBalanceDataSet = invBalanceDataSet.select(BaseInvBillRptQuery.mapperFileds(ReportGeneralOpHelper.removeFiled(invBalanceField, "endperiod"), mapperbgn, new String[0]));
            invBalanceDataSet = ReportCommonFilterOrChangeOp.filterOwner(filterInfo, invBalanceDataSet);
            invBalanceDataSet = ReportCommonFilterOrChangeOp.filterKeeper(filterInfo, invBalanceDataSet);
            return invBalanceDataSet;
        }
        String[] invBalanceDimensionField = null;
        invBalanceDimensionField = "im_invacc".equals(InvAccConst.getBalTb()) ? InvCountSchemeConst.getInvbalanceDimensionField() : (String[])DymAccDataSourceHelper.getBalanceUpdateKeys().get();
        DataSet invBalanceToStartDateBillDataSet = this.addJoinColumn(beforeStartDataSet.leftJoin(invBalanceDataSet), invBalanceDimensionField).select(beforeStartDataSet.getRowMeta().getFieldNames(), new String[]{"0 as bgnqty", "0 as bgnbaseqty", "0 as bgnqty2nd", "endperiod"}).finish();
        invBalanceToStartDateBillDataSet = invBalanceToStartDateBillDataSet.select(ReportGeneralOpHelper.addFileds(ReportGeneralOpHelper.addFileds(invBalanceDimensionField, recAndSendField), "bgnqty", "bgnbaseqty", "bgnqty2nd", "biztime", "endperiod", "materialname1", "modelnum1"));
        invBalanceToStartDateBillDataSet = invBalanceToStartDateBillDataSet.removeFields(new String[]{"endperiod", "biztime"});
        invBalanceDataSet = invBalanceDataSet.select(ReportGeneralOpHelper.addFileds(ReportGeneralOpHelper.addFileds(invBalanceDimensionField, this.getBalRecAndSendField()), "materialname1", "modelnum1"));
        invBalanceDataSet = invBalanceToStartDateBillDataSet.union(invBalanceDataSet);
        HashMap<String, String> mapperbgn = new HashMap<String, String>();
        mapperbgn.put("bgnqty", "(bgnqty + inqty) - outqty");
        mapperbgn.put("bgnbaseqty", "(bgnbaseqty + inbaseqty) - outbaseqty");
        mapperbgn.put("bgnqty2nd", "(bgnqty2nd + inqty2nd) - outqty2nd");
        invBalanceDataSet = BaseInvBillRptQuery.handleNullFiledAsZero(invBalanceDataSet, recAndSendField).select(invBalanceDataSet.getRowMeta().getFieldNames());
        invBalanceDataSet = invBalanceDataSet.select(BaseInvBillRptQuery.mapperFileds(invBalanceDataSet.getRowMeta().getFieldNames(), mapperbgn, new String[0]));
        invBalanceDataSet = ReportGeneralOpHelper.addSumColumn(invBalanceDataSet.groupBy(ReportGeneralOpHelper.addFileds(invBalanceDimensionField, "materialname1", "modelnum1")), this.getBgnQtyField()).finish();
        invBalanceDataSet = ReportCommonFilterOrChangeOp.filterOwner(filterInfo, invBalanceDataSet);
        invBalanceDataSet = ReportCommonFilterOrChangeOp.filterKeeper(filterInfo, invBalanceDataSet);
        return invBalanceDataSet;
    }

    protected DataSet getInvBalanceDataSet(FilterInfo filterInfo) {
        Date startDate = filterInfo.getDate("startdate");
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        Integer startTime = Integer.valueOf(format.format(startDate));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter invBalacneIsinitAndEnddate = new QFilter("endperiod", ">=", (Object)startTime).and("period", "<", (Object)startTime);
        qFilters.add(invBalacneIsinitAndEnddate);
        qFilters.add(BaseInvBillRptFilteInfo.getInvBalanceQFilter(filterInfo));
        if (!BalanceUpdateHandle.isNewPeriodBal()) {
            qFilters.add(new QFilter("balancetype", "=", (Object)Character.valueOf('1')));
        }
        qFilters.addAll(this.getBalanceHeadFilters(filterInfo.getHeadFilters()));
        String[] invBalanceDimensionField = null;
        invBalanceDimensionField = "im_invacc".equals(InvAccConst.getBalTb()) ? InvCountSchemeConst.getInvbalanceDimensionField() : (String[])DymAccDataSourceHelper.getBalanceUpdateKeys().get();
        String[] InvBalanceSelectFileds = ReportGeneralOpHelper.addFileds(ReportGeneralOpHelper.addFileds(invBalanceDimensionField, this.getInvBalacneEndQtyFieldAsBgnQty()), "endperiod");
        InvBalanceSelectFileds = ReportGeneralOpHelper.addFileds(InvBalanceSelectFileds, "material.name as materialname1", "material.modelnum as modelnum1");
        logger.info(ResManager.loadKDString((String)String.format("\u67e5\u8be2\u671f\u672b\u4f59\u989d\u8868\u7684\u8fc7\u6ee4\u6761\u4ef6\uff1a%s", qFilters), (String)"BaseInvBillRptQuery_1", (String)"scmc-im-report", (Object[])new Object[0]));
        String entityInvbalance = "im_invbalance";
        if (BalanceUpdateHandle.isNewPeriodBal()) {
            entityInvbalance = "im_inv_periodbalance";
        }
        DataSet invBalance = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityInvbalance, (String)ReportGeneralOpHelper.arraysToString(InvBalanceSelectFileds), (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"");
        DataSet classifiedMaterialDataSet = ReportCommonFilterOrChangeOp.getClassifiedMaterialDataSet(filterInfo, true);
        invBalance = classifiedMaterialDataSet.join(invBalance).on("material", "material").select(ReportGeneralOpHelper.addFileds(invBalance.getRowMeta().getFieldNames(), "groupname")).finish();
        HashSet<String> headerFieldsSet = new HashSet<String>(16);
        headerFieldsSet.add("group");
        invBalance = DymAccDSInfo.filterHeader(filterInfo, invBalance, headerFieldsSet);
        ArrayList<String> invBalanceDimensionFieldList = new ArrayList<String>(Arrays.asList(invBalanceDimensionField));
        invBalanceDimensionFieldList.add("materialname1");
        invBalanceDimensionFieldList.add("modelnum1");
        ArrayList<String> bgnQtyFieldList = new ArrayList<String>(Arrays.asList(this.getBgnQtyField()));
        invBalanceDimensionFieldList.addAll(bgnQtyFieldList);
        invBalance.select(invBalanceDimensionFieldList.toArray(new String[0]));
        return invBalance;
    }

    protected DataSet filterData(FilterInfo filterInfo, DataSet dataSet) {
        QFilter qtydisplay = BaseInvBillRptFilteInfo.handleQtyDisplayQfilter(filterInfo);
        if (qtydisplay != null) {
            dataSet = dataSet.filter(qtydisplay.toString());
        }
        return dataSet;
    }

    public static String[] getColumnFileds() {
        return new String[]{"org", "material", "baseunit", "unit", "unit2nd", "qty", "lotnumber", "auxpty", "baseqty", "qtyunit2nd", "warehouse", "location", "project", "keepertype", "keeper", "invtype", "invstatus", "ownertype", "owner", "producedate", "expirydate", "creator", "auditor"};
    }

    public static String[] mapperFileds(String[] sourceFileds, Map<String, String> mapper, String ... excludeField) {
        if (sourceFileds == null || sourceFileds.length == 0) {
            return new String[0];
        }
        boolean isNeedMapper = true;
        if (mapper == null || mapper.size() == 0) {
            isNeedMapper = false;
        }
        HashSet<String> excludes = new HashSet<String>(excludeField.length);
        for (String exclude : excludeField) {
            excludes.add(exclude);
        }
        ArrayList<String> list = new ArrayList<String>(sourceFileds.length);
        for (String filed : sourceFileds) {
            if (excludes.contains(filed) || mapper == null) continue;
            String mapField = mapper.get(filed);
            if (isNeedMapper && mapField != null) {
                filed = mapField + " as " + filed;
            }
            list.add(filed);
        }
        return list.toArray(new String[list.size()]);
    }

    protected String[] getBgnQtyField() {
        return new String[]{"bgnqty", "bgnbaseqty", "bgnqty2nd"};
    }

    protected String[] getInvBalacneEndQtyFieldAsBgnQty() {
        if (BalanceUpdateHandle.isNewPeriodBal()) {
            return new String[]{"qty_bal as bgnqty", "baseqty_bal as bgnbaseqty", "qty2nd_bal as bgnqty2nd"};
        }
        return new String[]{"endqty as bgnqty", "endbaseqty as bgnbaseqty", "endqty2nd as bgnqty2nd"};
    }

    protected String[] getRecAndSendField() {
        return new String[]{"outqty", "outbaseqty", "outqty2nd", "inqty", "inbaseqty", "inqty2nd"};
    }

    protected String[] getBalRecAndSendField() {
        return new String[]{"0 as outqty", "0 as outbaseqty", "0 as outqty2nd", "0 as inqty", "0 as inbaseqty", "0 as inqty2nd", "bgnqty", "bgnbaseqty", "bgnqty2nd"};
    }

    protected JoinDataSet addJoinColumn(JoinDataSet dataSet, String ... joinFields) {
        for (String joinField : joinFields) {
            dataSet.on(joinField, joinField);
        }
        return dataSet;
    }

    public static String[] getDataSetFieldArray(DataSet dataSet) {
        Set<String> fileds = ReportGeneralOpHelper.getDataSetField(dataSet);
        return fileds.toArray(new String[fileds.size()]);
    }

    public static DataSet handleNullFiledAsZero(DataSet dataSet, String ... handleFields) {
        if (handleFields == null || handleFields.length == 0) {
            return dataSet;
        }
        HashMap<String, String> mapper = new HashMap<String, String>(handleFields.length);
        for (String handleField : handleFields) {
            mapper.put(handleField, "case " + handleField + " when null then 0 else " + handleField + " end");
        }
        String[] fileds = BaseInvBillRptQuery.mapperFileds(BaseInvBillRptQuery.getDataSetFieldArray(dataSet), mapper, new String[0]);
        return dataSet.select(fileds);
    }
}

