/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.invbillreport;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.utils.StringUtils;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.DymAccDSMappingBill;
import kd.scmc.im.business.helper.DymAccDataSourceHelper;
import kd.scmc.im.business.helper.InvcountSchemeHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;
import kd.scmc.im.report.helper.ReportGeneralOpHelper;
import kd.scmc.im.report.helper.ReportQueryHelper;

public class DymAccDSInfo {
    private static final String TRASCEIVER_RECEIVE = "0";
    private static final String TRASCEIVER_SEND = "1";
    private static final String TRASCEIVER_RECEIVE_AND_SEND = "2";
    private static String[] columnField = new String[]{"org", "material", "baseunit", "unit", "unit2nd", "qty", "lotnumber", "auxpty", "baseqty", "qtyunit2nd", "warehouse", "location", "project", "keepertype", "keeper", "invtype", "invstatus", "ownertype", "owner", "producedate", "expirydate", "creator", "auditor", "auditdate", "configuredcode", "tracknumber"};
    private static String[] invFormIds = new String[]{"im_transinbill", "im_transoutbill", "im_transdirbill", "im_mdc_mftmanuinbill", "im_mdc_mftreturnorder", "im_saloutbill", "im_purreceivebill", "im_mdc_mftfeedorder", "im_purinbill", "im_productinbill", "im_otheroutbill", "im_disassemblebill", "im_otherinbill", "im_materialreqoutbill", "im_mdc_omcmplinbill", "im_locationtransfer", "im_mdc_omoutbill", "im_assembbill", "im_mdc_omreturnbill", "im_adjustbill", "im_mdc_omfeedbill", "im_mdc_mftproorder", "im_mdc_mftreturnbill"};
    protected static final List<String> invList = Arrays.asList("lotnumber", "qtyunit2nd", "creator", "auditor", "auditdate");
    private static final Set<String> invBillSet = new HashSet<String>(32);
    protected static final List<String> mdcBillIdList = Arrays.asList("im_mdc_mftmanuinbill", "im_mdc_mftreturnorder", "im_mdc_mftfeedorder", "im_mdc_omcmplinbill", "im_mdc_omoutbill", "im_mdc_omreturnbill", "im_mdc_omfeedbill", "im_mdc_mftproorder", "im_mdc_mftreturnbill");
    private static final List<String> mainBillNumberList = Arrays.asList("im_mdc_mftreturnorder", "im_materialreqoutbill", "im_mdc_mftreturnbill", "im_transdirbill", "im_mdc_mftproorder", "im_purinbill", "im_transinbill", "im_purreceivebill", "im_mdc_mftfeedorder", "im_mdc_mftmanuinbill", "im_transoutbill", "im_saloutbill", "im_mdc_omcmplinbill", "im_mdc_omoutbill", "im_mdc_omreturnbill", "im_mdc_omfeedbill");
    private static final List<String> materialFieldList = Arrays.asList("material", "materialname1", "modelnum1");

    public static DataSet handleUpdateBill(FilterInfo filterInfo, QFilter timeFilter, List<QFilter> headFilter) {
        List listDymAccDSMappingBill = DymAccDataSourceHelper.getUpdateBillFromDymAccDS((boolean)false);
        DataSet billSet = DymAccDSInfo.getBillDataSet(listDymAccDSMappingBill, filterInfo, timeFilter, headFilter);
        billSet = ReportQueryHelper.filterNoUpdateField(billSet, filterInfo);
        billSet = ReportCommonFilterOrChangeOp.filterOwner(filterInfo, billSet);
        billSet = ReportCommonFilterOrChangeOp.filterKeeper(filterInfo, billSet);
        billSet = ReportCommonFilterOrChangeOp.getClassifiedMaterialDataSet(filterInfo, true).leftJoin(billSet).on("material", "material").select(ReportGeneralOpHelper.addFileds(ReportGeneralOpHelper.getDataSetFieldArray(billSet), "group", "groupname", "materialtype", "materialname1", "modelnum1", "materialnumber")).finish();
        billSet = billSet.filter("billno is not null");
        billSet = DymAccDSInfo.filterHeaderMaterial(filterInfo, billSet);
        HashSet<String> headerFieldsSet = new HashSet<String>(16);
        headerFieldsSet.add("group");
        billSet = DymAccDSInfo.filterHeader(filterInfo, billSet, headerFieldsSet);
        return billSet;
    }

    private static List<QFilter> getReportBasicFilter(DymAccDSMappingBill dymAccDSMappingBill, FilterInfo filterInfo, QFilter timeFilter, List<QFilter> headFilter) {
        QFilter BillEntryFilter;
        QFilter billHeadFilter;
        ArrayList<QFilter> reportBasicFilter = new ArrayList<QFilter>(16);
        String formId = dymAccDSMappingBill.getSrcbill();
        Map mapping = dymAccDSMappingBill.getMapping();
        QFilter materialFilter = DymAccDSInfo.addMaterialFilter(filterInfo, mapping, formId);
        if (null != materialFilter) {
            reportBasicFilter.add(materialFilter);
        }
        if (null != (billHeadFilter = DymAccDSInfo.addBillHeadFilter(filterInfo, mapping))) {
            reportBasicFilter.add(billHeadFilter);
        }
        if (null != (BillEntryFilter = DymAccDSInfo.addBillEntryFilter(filterInfo, mapping))) {
            reportBasicFilter.add(BillEntryFilter);
        }
        reportBasicFilter.add(timeFilter);
        List<QFilter> reBuildHeadFilter = DymAccDSInfo.reBuildHeadFilter(headFilter, mapping);
        reportBasicFilter.addAll(reBuildHeadFilter);
        return reportBasicFilter;
    }

    private static List<QFilter> reBuildHeadFilter(List<QFilter> headFilter, Map<String, String> mapping) {
        ArrayList<QFilter> buildFilter = new ArrayList<QFilter>(headFilter.size());
        for (QFilter qFilter : headFilter) {
            buildFilter.add(qFilter.copy());
        }
        for (QFilter qFilter : buildFilter) {
            DymAccDSInfo.rebuildWarehouseFilter(qFilter, mapping);
            DymAccDSInfo.rebuildLocationFilter(qFilter, mapping);
            List nests = qFilter.getNests(true);
            for (QFilter.QFilterNest net : nests) {
                QFilter netFilter = net.getFilter();
                DymAccDSInfo.rebuildWarehouseFilter(netFilter, mapping);
                DymAccDSInfo.rebuildLocationFilter(qFilter, mapping);
            }
        }
        return buildFilter;
    }

    private static void rebuildWarehouseFilter(QFilter qFilter, Map<String, String> mapping) {
        String property = qFilter.getProperty();
        if ("warehouse".equals(property)) {
            String mapProperty = mapping.get(property);
            qFilter.__setProperty(mapProperty + ".name");
        }
    }

    private static void rebuildLocationFilter(QFilter qFilter, Map<String, String> mapping) {
        String property = qFilter.getProperty();
        if (!"location".equals(property)) {
            return;
        }
        String cp = qFilter.getCP();
        String mapProperty = mapping.get(property);
        if (cp.equals("is null")) {
            qFilter.clearNests();
            qFilter.__setProperty(mapProperty);
            qFilter.__setCP("=");
            qFilter.__setValue((Object)0);
        } else if (cp.equals("is not null")) {
            qFilter.clearNests();
            qFilter.__setProperty(mapProperty);
            qFilter.__setCP("!=");
            qFilter.__setValue((Object)0);
        } else {
            qFilter.__setProperty(mapProperty + ".name");
        }
    }

    private static DataSet getBillDataSet(List<DymAccDSMappingBill> listDymAccDSMappingBill, FilterInfo filterInfo, QFilter timeFilter, List<QFilter> headFilter) {
        List<OrmInput> billSubIosCopy;
        DataSet billSet = null;
        DataSet schemeAddBillSet = null;
        DataSet schemeSubBillSet = null;
        Algo algo = Algo.create((String)DymAccDSInfo.getAlgoKeyAndMethodName());
        ArrayList<OrmInput> billAddIos = new ArrayList<OrmInput>(listDymAccDSMappingBill.size());
        ArrayList<OrmInput> billSubIos = new ArrayList<OrmInput>(listDymAccDSMappingBill.size());
        boolean isNotUpdateBill = filterInfo.getBoolean("isnotupdatebill");
        Object[] invschemeFilterParams = DymAccDSInfo.invschemeFilterParams(headFilter);
        Boolean filterContainInvscheme = (Boolean)invschemeFilterParams[0];
        Boolean invschemeFilterIsNull = (Boolean)invschemeFilterParams[1];
        for (DymAccDSMappingBill dymAccDSMappingBill : listDymAccDSMappingBill) {
            List<QFilter> updateQFilter;
            String formId = dymAccDSMappingBill.getSrcbill();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formId);
            boolean isNeedInvScheme = true;
            if ("im_adjustbill".equals(formId) || "im_locationtransfer".equals(formId) || "im_assembbill".equals(formId) || "im_disassemblebill".equals(formId)) {
                if (DymAccDSInfo.isIgnoreNotInvScheme(filterInfo) || filterContainInvscheme.booleanValue() && !invschemeFilterIsNull.booleanValue()) continue;
                isNeedInvScheme = false;
            } else if (!MetaDataHelper.isExistField((IDataEntityType)mainEntityType, (String)"invscheme") || filterContainInvscheme.booleanValue() && invschemeFilterIsNull.booleanValue()) continue;
            DymAccDSInfo.setSelectedFiledsByFromId(dymAccDSMappingBill, isNeedInvScheme);
            List<QFilter> reportBasicFilter = DymAccDSInfo.getReportBasicFilter(dymAccDSMappingBill, filterInfo, timeFilter, headFilter);
            if (isNeedInvScheme) {
                OrmInput billInput;
                if (!isNotUpdateBill) {
                    updateQFilter = DymAccDSInfo.getUpdateQFilter(dymAccDSMappingBill);
                    if (!updateQFilter.isEmpty()) {
                        reportBasicFilter.addAll(updateQFilter);
                    }
                } else {
                    QFilter mdcFilter = DymAccDSInfo.getMdcBillTypeFilter(formId, dymAccDSMappingBill);
                    if (null != mdcFilter) {
                        reportBasicFilter.add(mdcFilter);
                    }
                }
                if ((billInput = DymAccDSInfo.getBillInput(dymAccDSMappingBill, reportBasicFilter)) == null) continue;
                if ("ADD".equals(dymAccDSMappingBill.getUpdateType())) {
                    billAddIos.add(billInput);
                    continue;
                }
                if (!"SUB".equals(dymAccDSMappingBill.getUpdateType())) continue;
                billSubIos.add(billInput);
                continue;
            }
            if (!isNotUpdateBill && !(updateQFilter = DymAccDSInfo.getUpdateQFilter(dymAccDSMappingBill)).isEmpty()) {
                reportBasicFilter.addAll(updateQFilter);
            }
            billSet = DymAccDSInfo.handleUpdateBillNotSceme(billSet, dymAccDSMappingBill, formId, reportBasicFilter);
        }
        List<OrmInput> billAddIosCopy = isNotUpdateBill ? DymAccDSInfo.getOrmInputs(billAddIos) : billAddIos;
        List<OrmInput> list = billSubIosCopy = isNotUpdateBill ? DymAccDSInfo.getOrmInputs(billSubIos) : billSubIos;
        if (!billAddIos.isEmpty()) {
            schemeAddBillSet = DymAccDSInfo.handleBillDataSet(algo.createDataSet((Input[])billAddIosCopy.toArray(new OrmInput[billAddIosCopy.size()])), "ADD");
        }
        if (!billSubIos.isEmpty()) {
            schemeSubBillSet = DymAccDSInfo.handleBillDataSet(algo.createDataSet((Input[])billSubIosCopy.toArray(new OrmInput[billSubIosCopy.size()])), "SUB");
        }
        if (billSet != null) {
            String[] fieldNames = null;
            if (schemeAddBillSet != null) {
                fieldNames = schemeAddBillSet.getRowMeta().getFieldNames();
            } else if (fieldNames == null && schemeSubBillSet != null) {
                fieldNames = schemeSubBillSet.getRowMeta().getFieldNames();
            } else if (fieldNames == null) {
                return billSet;
            }
            billSet = billSet.select(fieldNames);
            return billSet.union(schemeAddBillSet).union(schemeSubBillSet);
        }
        if (schemeAddBillSet != null) {
            return schemeAddBillSet.union(schemeSubBillSet);
        }
        return schemeSubBillSet;
    }

    private static Object[] invschemeFilterParams(List<QFilter> headFilter) {
        Boolean filterContainInvscheme = false;
        Boolean invschemeFilterIsNull = false;
        Iterator<QFilter> it = headFilter.iterator();
        while (it.hasNext()) {
            QFilter filter = it.next();
            String property = filter.getProperty();
            if (!"invscheme.name".equals(property)) continue;
            filterContainInvscheme = true;
            String cp = filter.getCP();
            if (!cp.equals("is null")) continue;
            invschemeFilterIsNull = true;
            it.remove();
        }
        return new Object[]{filterContainInvscheme, invschemeFilterIsNull};
    }

    private static List<OrmInput> getOrmInputs(List<OrmInput> billSubIos) {
        ArrayList<OrmInput> billSubIosCopy = new ArrayList<OrmInput>(billSubIos.size());
        for (OrmInput billSubIo : billSubIos) {
            boolean needAdd = true;
            String entityName = billSubIo.getEntityName();
            QFilter[] filters = billSubIo.getFilters();
            block1: for (OrmInput ormInput : billSubIosCopy) {
                QFilter[] copyfilter;
                String copyName = ormInput.getEntityName();
                if (!entityName.equals(copyName) || filters.length != (copyfilter = ormInput.getFilters()).length) continue;
                for (int i = 0; i < filters.length; ++i) {
                    boolean equals = filters[i].toString().equals(copyfilter[i].toString());
                    if (!equals) continue block1;
                }
                needAdd = false;
            }
            if (!needAdd) continue;
            billSubIosCopy.add(billSubIo);
        }
        return billSubIosCopy;
    }

    protected static DataSet handleUpdateBillNotSceme(DataSet billSet, DymAccDSMappingBill dymAccDSMappingBill, String formId, List<QFilter> reportBasicFilter) {
        try {
            if ("ADD".equals(dymAccDSMappingBill.getUpdateType())) {
                billSet = billSet != null ? billSet.union(DymAccDSInfo.handleUpdateBillRecByRecAndSendType(dymAccDSMappingBill, reportBasicFilter)) : DymAccDSInfo.handleUpdateBillRecByRecAndSendType(dymAccDSMappingBill, reportBasicFilter);
            } else if ("SUB".equals(dymAccDSMappingBill.getUpdateType())) {
                billSet = billSet != null ? billSet.union(DymAccDSInfo.handleUpdateBillSendByRecAndSendType(dymAccDSMappingBill, reportBasicFilter)) : DymAccDSInfo.handleUpdateBillSendByRecAndSendType(dymAccDSMappingBill, reportBasicFilter);
            }
        }
        catch (AlgoException algoException) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u95f4\u6570\u636eunion\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u201c%1$s\u201d\u7684\u4f59\u989d\u89c4\u5219\u6620\u5c04\u914d\u7f6e\u201c%2$s\u201d\u3002", (String)"DymAccDSInfo_0", (String)"scmc-im-report", (Object[])new Object[0]), formId, algoException.getMessage()));
        }
        catch (Exception e) {
            throw e;
        }
        return billSet;
    }

    private static DataSet handleUpdateBillRecByRecAndSendType(DymAccDSMappingBill dymAccDSMappingBill, List<QFilter> reportBasicFilter) {
        String formId = dymAccDSMappingBill.getSrcbill();
        DataSet billSet = QueryServiceHelper.queryDataSet((String)DymAccDSInfo.getAlgoKeyAndMethodName(), (String)formId, (String)dymAccDSMappingBill.getSelectedFileds(), (QFilter[])reportBasicFilter.toArray(new QFilter[reportBasicFilter.size()]), null);
        billSet = billSet.addField(TRASCEIVER_RECEIVE, "outqty");
        billSet = billSet.addField(TRASCEIVER_RECEIVE, "outbaseqty");
        billSet = billSet.addField(TRASCEIVER_RECEIVE, "outqty2nd");
        billSet = billSet.addField("qty", "inqty");
        billSet = billSet.addField("baseqty", "inbaseqty");
        billSet = billSet.addField("qtyunit2nd", "inqty2nd");
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "transnumber", String.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "invscheme", Long.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "configuredcode", Long.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "tracknumber", Long.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"producedate", Timestamp.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"expirydate", Timestamp.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "mainbillnumber", String.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "tracknumber.number", String.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "project.number", String.class);
        return billSet;
    }

    private static DataSet handleUpdateBillSendByRecAndSendType(DymAccDSMappingBill dymAccDSMappingBill, List<QFilter> reportBasicFilter) {
        String formId = dymAccDSMappingBill.getSrcbill();
        DataSet billSet = QueryServiceHelper.queryDataSet((String)DymAccDSInfo.getAlgoKeyAndMethodName(), (String)formId, (String)dymAccDSMappingBill.getSelectedFileds(), (QFilter[])reportBasicFilter.toArray(new QFilter[reportBasicFilter.size()]), null);
        billSet = billSet.addField("qty", "outqty");
        billSet = billSet.addField("baseqty", "outbaseqty");
        billSet = billSet.addField("qtyunit2nd", "outqty2nd");
        billSet = billSet.addField(TRASCEIVER_RECEIVE, "inqty");
        billSet = billSet.addField(TRASCEIVER_RECEIVE, "inbaseqty");
        billSet = billSet.addField(TRASCEIVER_RECEIVE, "inqty2nd");
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "transnumber", String.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "invscheme", Long.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "configuredcode", Long.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "tracknumber", Long.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"producedate", Timestamp.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"expirydate", Timestamp.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "mainbillnumber", String.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "tracknumber.number", String.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "project.number", String.class);
        return billSet;
    }

    private static OrmInput getBillInputByRecAndSendType(DymAccDSMappingBill dymAccDSMappingBill, List<QFilter> reportBasicFilter) {
        String formId = dymAccDSMappingBill.getSrcbill();
        if ("ADD".equals(dymAccDSMappingBill.getUpdateType())) {
            reportBasicFilter.add(new QFilter("invscheme.transceivertype.transceiver", "in", (Object)new String[]{TRASCEIVER_RECEIVE, TRASCEIVER_RECEIVE_AND_SEND}));
        } else {
            reportBasicFilter.add(new QFilter("invscheme.transceivertype.transceiver", "in", (Object)new String[]{TRASCEIVER_SEND, TRASCEIVER_RECEIVE_AND_SEND}));
        }
        OrmInput updateInput = new OrmInput(DymAccDSInfo.getAlgoKeyAndMethodName(), formId, dymAccDSMappingBill.getSelectedFileds(), reportBasicFilter.toArray(new QFilter[reportBasicFilter.size()]));
        return updateInput;
    }

    private static QFilter getMdcBillTypeFilter(String formId, DymAccDSMappingBill dymAccDSMappingBill) {
        if (!mdcBillIdList.contains(formId)) {
            return null;
        }
        QFilter mdcBillTypefilter = null;
        QFilter filter = dymAccDSMappingBill.getqFilter();
        String filterProperty = filter.getProperty();
        Object value = filter.getValue();
        if (filterProperty.equals("billtype.number")) {
            mdcBillTypefilter = new QFilter(filterProperty, "=", value);
            return mdcBillTypefilter;
        }
        List nests = dymAccDSMappingBill.getqFilter().getNests(true);
        for (QFilter.QFilterNest qFilterNest : nests) {
            String property = qFilterNest.getFilter().getProperty();
            if (!property.equals("billtype.number")) continue;
            mdcBillTypefilter = qFilterNest.getFilter();
            return mdcBillTypefilter;
        }
        return mdcBillTypefilter;
    }

    private static String getAlgoKeyAndMethodName() {
        return Thread.currentThread().getStackTrace()[2].toString();
    }

    private static List<QFilter> getUpdateQFilter(DymAccDSMappingBill dymAccDSMappingBill) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter dymAccfilter = dymAccDSMappingBill.getqFilter();
        if (dymAccfilter != null) {
            qFilters.add(dymAccDSMappingBill.getqFilter());
        }
        return qFilters;
    }

    private static void setSelectedFiledsByFromId(DymAccDSMappingBill dymAccDSMappingBill, boolean isNeedInvScheme) {
        String formId = dymAccDSMappingBill.getSrcbill();
        String[] columnFileds = DymAccDSInfo.getColumnFileds();
        Map mapping = dymAccDSMappingBill.getMapping();
        Set keySet = mapping.keySet();
        ArrayList<String> selectFiledFromDB = new ArrayList<String>(columnFileds.length + 11);
        if (invBillSet.isEmpty()) {
            DymAccDSInfo.initInvBillSet();
        }
        if (invBillSet.contains(formId)) {
            String string = ((String)mapping.get("material")).replace("material.masterid", "materialmasterid").replace("material1.masterid", "materialmasterid1");
            mapping.put("material", string);
        }
        for (String columnFiled : columnFileds) {
            if ("lotnumber".equals(columnFiled)) {
                selectFiledFromDB.add((String)mapping.get("lotnum") + " as lotnumber");
            }
            if ("qtyunit2nd".equals(columnFiled)) {
                selectFiledFromDB.add((String)mapping.get("qty2nd") + " as qtyunit2nd");
            }
            if (keySet.contains(columnFiled)) {
                selectFiledFromDB.add((String)mapping.get(columnFiled) + " as " + columnFiled);
                continue;
            }
            if (invList.contains(columnFiled)) continue;
            Object defaultValue = DymAccDSInfo.getFieldDefaultValue(columnFiled);
            selectFiledFromDB.add(defaultValue + " as " + columnFiled);
        }
        selectFiledFromDB.add("id");
        selectFiledFromDB.add("billno");
        selectFiledFromDB.add("billstatus");
        selectFiledFromDB.add("biztime");
        selectFiledFromDB.add("biztype");
        selectFiledFromDB.add("creator");
        selectFiledFromDB.add("auditor");
        selectFiledFromDB.add("auditdate");
        selectFiledFromDB.add("billtype");
        selectFiledFromDB.add("bookdate");
        selectFiledFromDB.add("billentry.noupdateinvfields as noupdateinvfields");
        String string = null == mapping.get("project") ? "''" : (String)mapping.get("project") + ".number";
        selectFiledFromDB.add(string + " as project.number");
        String tracknumberField = null == mapping.get("tracknumber") ? "''" : (String)mapping.get("tracknumber") + ".number";
        selectFiledFromDB.add(tracknumberField + " as tracknumber.number");
        DymAccDSInfo.setMainBillNumber(formId, selectFiledFromDB);
        if (isNeedInvScheme) {
            selectFiledFromDB.add("invscheme");
            selectFiledFromDB.add("invscheme.transceivertype.id as transnumber");
        } else {
            selectFiledFromDB.add("0 as invscheme");
            if ("ADD".equals(dymAccDSMappingBill.getUpdateType())) {
                switch (formId) {
                    case "im_adjustbill": {
                        selectFiledFromDB.add("'transrec' as transnumber");
                        break;
                    }
                    case "im_assembbill": {
                        selectFiledFromDB.add("'assembbillrec' as transnumber");
                        break;
                    }
                    case "im_locationtransfer": {
                        selectFiledFromDB.add("'locationtransferbillrec' as transnumber");
                        break;
                    }
                    case "im_disassemblebill": {
                        selectFiledFromDB.add("'disassemblebillrec' as transnumber");
                        break;
                    }
                }
            } else if ("SUB".equals(dymAccDSMappingBill.getUpdateType())) {
                switch (formId) {
                    case "im_adjustbill": {
                        selectFiledFromDB.add("'transsend' as transnumber");
                        break;
                    }
                    case "im_assembbill": {
                        selectFiledFromDB.add("'assembbillsend' as transnumber");
                        break;
                    }
                    case "im_locationtransfer": {
                        selectFiledFromDB.add("'locationtransferbillsend' as transnumber");
                        break;
                    }
                    case "im_disassemblebill": {
                        selectFiledFromDB.add("'disassemblebillsend' as transnumber");
                        break;
                    }
                }
            }
        }
        dymAccDSMappingBill.setSelectedFileds(ReportGeneralOpHelper.listToString(selectFiledFromDB));
    }

    private static void setMainBillNumber(String formId, List<String> selectFiledFromDB) {
        if (mainBillNumberList.contains(formId)) {
            selectFiledFromDB.add("billentry.mainbillnumber  as mainbillnumber");
        } else {
            selectFiledFromDB.add("''  as mainbillnumber");
        }
    }

    private static Object getFieldDefaultValue(String columnFiled) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)InvAccConst.getBalTb());
        Map allFields = dt.getAllFields();
        IDataEntityProperty property = (IDataEntityProperty)allFields.get(columnFiled);
        if (property instanceof BasedataProp || property instanceof QtyProp) {
            return 0;
        }
        if (property instanceof TextProp || property instanceof ItemClassTypeProp) {
            return null;
        }
        if (property instanceof DateProp) {
            return null;
        }
        return null;
    }

    protected static QFilter addMaterialFilter(FilterInfo filterInfo, Map<String, String> mapping, String formId) {
        QFilter materialFilter = null;
        materialFilter = invBillSet.contains(formId) ? ReportCommonFilterOrChangeOp.getMaterialFromToFilter(filterInfo, mapping.get("material").replace("material.masterid", "materialmasterid"), true) : ReportCommonFilterOrChangeOp.getMaterialFromToFilter(filterInfo, mapping.get("material"), true);
        return materialFilter;
    }

    private static QFilter addBillEntryFilter(FilterInfo filterInfo, Map<String, String> mapping) {
        QFilter tracknumberFilter;
        QFilter configuredCodeFilter;
        QFilter projectFilter;
        QFilter lotnumberFilter;
        QFilter locationFilter;
        QFilter warehouseFilter;
        DynamicObjectCollection invstatusheads;
        QFilter qFilter = new QFilter(TRASCEIVER_SEND, "=", (Object)1);
        DynamicObjectCollection ivntypeheads = filterInfo.getDynamicObjectCollection("ivntypehead");
        if (ivntypeheads != null && ivntypeheads.size() > 0) {
            HashSet<Object> ivntypeIds = new HashSet<Object>();
            for (Iterator ivntype : ivntypeheads) {
                ivntypeIds.add(ivntype.getPkValue());
            }
            QFilter ivntypeheadFilter = new QFilter(mapping.get("invtype"), "in", ivntypeIds);
            qFilter.and(ivntypeheadFilter);
        }
        if ((invstatusheads = filterInfo.getDynamicObjectCollection("invstatushead")) != null && invstatusheads.size() > 0) {
            HashSet<Object> invstatusIds = new HashSet<Object>();
            for (DynamicObject invstatus : invstatusheads) {
                invstatusIds.add(invstatus.getPkValue());
            }
            QFilter invstatusheadFilter = new QFilter(mapping.get("invstatus"), "in", invstatusIds);
            qFilter.and(invstatusheadFilter);
        }
        if (mapping.get("warehouse") != null && (warehouseFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, mapping.get("warehouse") + ".number", "warehousefrom", "warehouseto")) != null) {
            qFilter.and(warehouseFilter);
        }
        if (mapping.get("location") != null && (locationFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, mapping.get("location") + ".number", "locationfrom", "locationto")) != null) {
            qFilter.and(locationFilter);
        }
        if (mapping.get("lotnum") != null && (lotnumberFilter = ReportCommonFilterOrChangeOp.getTextFromToFilter(filterInfo, mapping.get("lotnum"), "lotnumberfrom", "lotnumberto")) != null) {
            qFilter.and(lotnumberFilter);
        }
        if (mapping.get("project") != null && (projectFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, mapping.get("project") + ".number", "projectfrom", "projectto")) != null) {
            qFilter.and(projectFilter);
        }
        if (mapping.get("configuredcode") != null && (configuredCodeFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, mapping.get("configuredcode") + ".number", "configuredcodefrom", "configuredcodeto")) != null) {
            qFilter.and(configuredCodeFilter);
        }
        if (mapping.get("tracknumber") != null && (tracknumberFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, mapping.get("tracknumber") + ".number", "tracknumberfrom", "tracknumberto")) != null) {
            qFilter.and(tracknumberFilter);
        }
        if (filterInfo.getLong("auxpty") != 0L) {
            qFilter.and(mapping.get("auxpty"), "=", (Object)filterInfo.getLong("auxpty"));
        }
        return qFilter;
    }

    private static QFilter addBillHeadFilter(FilterInfo filterInfo, Map<String, String> mapping) {
        QFilter invschemeFilter;
        QFilter biztypeFilter;
        QFilter filter = null;
        Object org = filterInfo.getValue("multiorghead");
        if (org instanceof DynamicObjectCollection) {
            ArrayList<Long> orgIds = new ArrayList<Long>();
            for (DynamicObject dynamicObject : (DynamicObjectCollection)org) {
                orgIds.add((Long)dynamicObject.getPkValue());
            }
            filter = new QFilter(mapping.get("org"), "in", orgIds);
        } else {
            DynamicObject orgHead = filterInfo.getDynamicObject("orghead");
            if (orgHead == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DymAccDSInfo_1", (String)"scmc-im-report", (Object[])new Object[0]));
            }
            filter = new QFilter(mapping.get("org"), "=", orgHead.getPkValue());
        }
        HashSet<String> billstatus = new HashSet<String>();
        billstatus.add("C");
        if (filterInfo.getBoolean("billstatushead")) {
            billstatus.add("B");
        }
        filter.and("billstatus", "in", billstatus);
        QFilter billnoFilter = ReportCommonFilterOrChangeOp.getTextFromToFilter(filterInfo, "billno", "billnofrom", "billnoto");
        if (billnoFilter != null) {
            filter.and(billnoFilter);
        }
        if ((biztypeFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "biztype.number", "biztypefrom", "biztypeto")) != null) {
            filter.and(biztypeFilter);
        }
        if ((invschemeFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "invscheme.number", "invschemefrom", "invschemeto")) != null) {
            filter.and(invschemeFilter);
        }
        return filter;
    }

    private static DataSet filterHeaderMaterial(FilterInfo filterInfo, DataSet billSet) {
        List headFilters = filterInfo.getHeadFilters();
        StringBuilder buf = new StringBuilder();
        int seq = 0;
        for (QFilter filter : headFilters) {
            String cp;
            String property = filter.getProperty();
            if (!materialFieldList.contains(property)) continue;
            if (seq > 0) {
                buf.append(" and ");
            }
            if ("material".equals(property)) {
                property = "materialnumber";
            }
            if ((cp = filter.getCP()).equals("is null")) {
                buf.append("(").append(property).append(" is null or ").append(property).append(" = '')");
            } else if (cp.equals("is not null")) {
                buf.append(property).append(" is not null and ").append(property).append(" != ''");
            } else {
                Object val = filter.getValue() instanceof String ? filter.getValue().toString().replace("'", "\\'") : filter.getValue();
                buf.append(property).append(" ").append(cp).append(" '").append(val).append("'");
            }
            ++seq;
        }
        String bufStr = buf.toString();
        if (StringUtils.isBlank((String)bufStr)) {
            return billSet;
        }
        return billSet.filter(bufStr);
    }

    public static DataSet filterHeader(FilterInfo filterInfo, DataSet billSet, Set<String> headerFieldsSet) {
        List headFilters = filterInfo.getHeadFilters();
        StringBuilder buf = new StringBuilder();
        int seq = 0;
        for (QFilter filter : headFilters) {
            String cp;
            String property = filter.getProperty();
            if (!headerFieldsSet.contains(property)) continue;
            if (seq > 0) {
                buf.append(" and ");
            }
            if ("group".equals(property)) {
                property = "groupname";
            }
            if ((cp = filter.getCP()).equals("is null")) {
                buf.append("(").append(property).append(" is null or ").append(property).append(" = '')");
            } else if (cp.equals("is not null")) {
                buf.append(property).append(" is not null and ").append(property).append(" != ''");
            } else {
                Object val = filter.getValue() instanceof String ? filter.getValue().toString().replace("'", "\\'") : filter.getValue();
                buf.append(property).append(" ").append(cp).append(" '").append(val).append("'");
            }
            ++seq;
        }
        String bufStr = buf.toString();
        if (!StringUtils.isBlank((String)bufStr)) {
            billSet = billSet.filter(bufStr);
        }
        if (headerFieldsSet.contains("group")) {
            billSet = billSet.removeFields(new String[]{"groupname"});
        }
        return billSet;
    }

    public static String[] getColumnFileds() {
        String[] columnFields = (String[])DymAccDataSourceHelper.getBalanceUpdateKeys().get();
        ArrayList<Object> copyColumnList = new ArrayList<Object>(16);
        List<Object> columnList = columnFields == null ? Collections.emptyList() : Arrays.asList(columnFields);
        copyColumnList.addAll(columnList);
        for (String column : columnField) {
            if (copyColumnList.contains(column)) continue;
            copyColumnList.add(column);
        }
        columnFields = copyColumnList.toArray(new String[copyColumnList.size()]);
        return columnFields;
    }

    private static OrmInput getBillInput(DymAccDSMappingBill dymAccDSMappingBill, List<QFilter> reportBasicFilter) {
        return DymAccDSInfo.getBillInputByRecAndSendType(dymAccDSMappingBill, reportBasicFilter);
    }

    private static DataSet handleBillDataSet(DataSet billSet, String str) {
        if ("ADD".contentEquals(str)) {
            billSet = billSet.addField(TRASCEIVER_RECEIVE, "outqty");
            billSet = billSet.addField(TRASCEIVER_RECEIVE, "outbaseqty");
            billSet = billSet.addField(TRASCEIVER_RECEIVE, "outqty2nd");
            billSet = billSet.addField("qty", "inqty");
            billSet = billSet.addField("baseqty", "inbaseqty");
            billSet = billSet.addField("qtyunit2nd", "inqty2nd");
        } else {
            billSet = billSet.addField("qty", "outqty");
            billSet = billSet.addField("baseqty", "outbaseqty");
            billSet = billSet.addField("qtyunit2nd", "outqty2nd");
            billSet = billSet.addField(TRASCEIVER_RECEIVE, "inqty");
            billSet = billSet.addField(TRASCEIVER_RECEIVE, "inbaseqty");
            billSet = billSet.addField(TRASCEIVER_RECEIVE, "inqty2nd");
        }
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "transnumber", String.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "billType", String.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "outqty", BigDecimal.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "outbaseqty", BigDecimal.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "outqty2nd", BigDecimal.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "inqty", BigDecimal.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "inbaseqty", BigDecimal.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "inqty2nd", BigDecimal.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "mainbillnumber", String.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "billtype", Long.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"producedate", Timestamp.class);
        billSet = InvcountSchemeHelper.changFiledDataType((DataSet)billSet, (String)"expirydate", Timestamp.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "configuredcode", Long.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "tracknumber", Long.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "tracknumber.number", String.class);
        billSet = ReportGeneralOpHelper.changFiledDataType(billSet, "project.number", String.class);
        return billSet;
    }

    private static void initInvBillSet() {
        for (String invFormId : invFormIds) {
            invBillSet.add(invFormId);
        }
    }

    private static boolean isIgnoreNotInvScheme(FilterInfo filterInfo) {
        DynamicObjectCollection invSchemefrom = filterInfo.getDynamicObjectCollection("invschemefrom");
        DynamicObject invSchemeto = filterInfo.getDynamicObject("invschemeto");
        return invSchemefrom != null || invSchemeto != null;
    }
}

