/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.invbillreport;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.AuxptyFilterHelper;
import kd.scmc.im.business.helper.DymAccDataSourceHelper;
import kd.scmc.im.report.helper.ReportGeneralOpHelper;
import kd.scmc.im.report.invbillreport.BaseInvBillRptFilteInfo;
import kd.scmc.im.report.invbillreport.BaseInvBillRptQuery;

public class InvBillDetailRptQuery
extends BaseInvBillRptQuery {
    private static Log logger = LogFactory.getLog(InvBillDetailRptQuery.class);
    private static String noBgnQtyDataSelectFileds = "org,material,baseunit,unit,unit2nd,qty,lotnumber,auxpty,baseqty,qtyunit2nd,warehouse,location,project,keepertype,keeper,invtype,invstatus,ownertype,owner,producedate,expirydate,id,billno,billstatus,biztime,bookdate,biztype,creator,auditor,billType,invscheme,outqty,outbaseqty,outqty2nd,inqty,inbaseqty,inqty2nd,transnumber,group,materialtype,linetype,balanceqty,balancebaseqty,balanceqty2nd,auditdate,materialname1,modelnum1";

    private static String getNoBgnQtyDataSelectFields() {
        String[] listFieldsList = noBgnQtyDataSelectFileds.split(",");
        String[] columnFields = (String[])DymAccDataSourceHelper.getBalanceUpdateKeys().get();
        ArrayList<String> copyColumnList = new ArrayList<String>(16);
        List<String> columnList = Arrays.asList(listFieldsList);
        copyColumnList.addAll(columnList);
        for (String column : columnFields) {
            if (copyColumnList.contains(column)) continue;
            copyColumnList.add(column);
        }
        CharSequence[] dealColumnFields = copyColumnList.toArray(new String[copyColumnList.size()]);
        return String.join((CharSequence)",", dealColumnFields);
    }

    @Override
    public DataSet query(ReportQueryParam paramReportQueryParam, Object paramObject) throws Throwable {
        DataSet billSet = super.query(paramReportQueryParam, paramObject);
        FilterInfo filterInfo = paramReportQueryParam.getFilter();
        boolean beginandbalance = filterInfo.getBoolean("beginandbalance");
        if (beginandbalance) {
            return this.handleBeginAndBalanceDataSet(billSet, filterInfo, paramReportQueryParam);
        }
        QFilter qtydisplay = BaseInvBillRptFilteInfo.handleQtyDisplayQfilter(filterInfo);
        if (qtydisplay != null) {
            billSet = billSet.filter(qtydisplay.toString());
        }
        billSet = billSet.orderBy(this.orderByStrings(filterInfo));
        return billSet;
    }

    private String[] orderByStrings(FilterInfo filterInfo) {
        if (filterInfo.getDynamicObjectCollection("ivntypehead") != null) {
            return new String[]{"invtype", "org", "material", "auxpty", "biztime", "billno", "ownertype", "owner", "warehouse", "location", "lotnumber", "project"};
        }
        return new String[]{"org", "material", "auxpty", "biztime", "billno", "ownertype", "owner", "warehouse", "location", "lotnumber", "project"};
    }

    private static String getNoBgnQtyDataSelectFileds() {
        List<Object> asList = Arrays.asList((Object[])DymAccDataSourceHelper.getBalanceUpdateKeys().get());
        String noBgnQty = InvBillDetailRptQuery.getNoBgnQtyDataSelectFields();
        if (!asList.contains("producedate")) {
            noBgnQty = noBgnQty.replace("producedate,", " ").intern();
        }
        if (!asList.contains("expirydate")) {
            noBgnQty = noBgnQty.replace("expirydate,", " ").intern();
        }
        return noBgnQty;
    }

    private DataSet handleBeginAndBalanceDataSet(DataSet billSet, FilterInfo filterInfo, ReportQueryParam paramReportQueryParam) throws ParseException {
        if (filterInfo.getString("hyperlinkFromSumPpt") != null && billSet.isEmpty()) {
            logger.info(ResManager.loadKDString((String)"\u6c47\u603b\u8868\u8df3\u8f6c\u94fe\u63a5\u8fc7\u6765\uff0c\u67e5\u8be2\u671f\u95f4\u65e0\u5355\u636e\u53d1\u751f\u989d", (String)"InvBillDetailRptQuery_4", (String)"scmc-im-report", (Object[])new Object[0]));
            return this.handleNoDataSummaryLinkJump(filterInfo, billSet);
        }
        billSet = billSet.orderBy(new String[]{"material", "auxpty", "org", "biztime", "auditdate"});
        ArrayList<DataSet> listDataSet = new ArrayList<DataSet>();
        DataSet balanceDataSet = this.getInvBalanceDataSetWithBgnQty(filterInfo);
        balanceDataSet = AuxptyFilterHelper.filterAuxpty((DataSet)balanceDataSet, (ReportQueryParam)paramReportQueryParam);
        GroupbyDataSet groupbyDataSet = balanceDataSet.groupBy(new String[]{"material", "baseunit", "unit", "materialname1", "modelnum1"});
        DataSet materialGroupBalanceDataSet = ReportGeneralOpHelper.addSumColumn(groupbyDataSet, this.getBgnQtyField()).finish().select(ReportGeneralOpHelper.addFileds(this.getBgnQtyField(), "material", "baseunit", "unit", "materialname1", "modelnum1"));
        DataSet allMaterialGroupDataSet = null;
        DataSet materialGroupBillSetNotInBalanceDataSet = billSet.copy().groupBy(new String[]{"material", "baseunit", "unit", "materialname1", "modelnum1"}).finish();
        allMaterialGroupDataSet = materialGroupBalanceDataSet.union(materialGroupBillSetNotInBalanceDataSet = materialGroupBillSetNotInBalanceDataSet.fullJoin(materialGroupBalanceDataSet).on("material", "material").select(new String[]{"bgnqty", "bgnbaseqty", "bgnqty2nd", "material", "baseunit", "unit", "materialname1", "modelnum1"}).finish().filter("bgnqty is null and material is not null"));
        if (allMaterialGroupDataSet.copy().isEmpty()) {
            logger.info(ResManager.loadKDString((String)"\u5355\u636e\u4e0e\u4f59\u989d\u8868\u94fe\u63a5\u4e4b\u540e\u65e0\u6570\u636e,\u76f4\u63a5\u8fd4\u56de", (String)"InvBillDetailRptQuery_2", (String)"scmc-im-report", (Object[])new Object[0]));
            return allMaterialGroupDataSet;
        }
        StringBuilder infoBuilder = new StringBuilder();
        while (allMaterialGroupDataSet.hasNext()) {
            Row row = allMaterialGroupDataSet.next();
            ArrayList<BigDecimal> initBalanceDataList = new ArrayList<BigDecimal>();
            Long materialId = row.getLong("material");
            Long baseUnitId = row.getLong("baseunit");
            Long unitId = row.getLong("unit");
            String materialName = row.getString("materialname1");
            String modelnum = row.getString("modelnum1");
            initBalanceDataList.add(row.getBigDecimal("bgnqty") == null ? BigDecimal.ZERO : row.getBigDecimal("bgnqty"));
            initBalanceDataList.add(row.getBigDecimal("bgnbaseqty") == null ? BigDecimal.ZERO : row.getBigDecimal("bgnbaseqty"));
            initBalanceDataList.add(row.getBigDecimal("bgnqty2nd") == null ? BigDecimal.ZERO : row.getBigDecimal("bgnqty2nd"));
            DataSet materialBeginAndBalanceDetail = this.handleBeginAndBalanceDetail(billSet, materialId, baseUnitId, unitId, initBalanceDataList, filterInfo, materialName, modelnum);
            if (materialBeginAndBalanceDetail.isEmpty()) {
                infoBuilder.append(ResManager.loadKDString((String)"\u904d\u5386\u7269\u6599\u5206\u7ec4,{0}\u7269\u6599ID\u5728\u67e5\u8be2\u671f\u95f4\u4e2d\u65e0\u5355\u636e\u53d1\u751f", (String)"InvBillDetailRptQuery_3", (String)"scmc-im-report", (Object[])new Object[]{materialId})).append("\n");
                String qtydisplay = filterInfo.getString("qtydisplay");
                if (qtydisplay != null) continue;
                String[] fields = InvBillDetailRptQuery.getDataSetFieldArray(billSet);
                String[] addFileds = ReportGeneralOpHelper.removeFiled(fields, "material", "baseunit", "unit", "materialname1", "modelnum1");
                DataSet dataSet = this.handleNoDataDetailReportQueryBgn(materialId, baseUnitId, unitId, materialName, modelnum, initBalanceDataList, addFileds);
                dataSet = this.setSpecialNullFieldsType(billSet.copy(), dataSet);
                listDataSet.add(dataSet);
                continue;
            }
            listDataSet.add(materialBeginAndBalanceDetail.select(InvBillDetailRptQuery.getNoBgnQtyDataSelectFileds()));
        }
        if (infoBuilder.length() > 0) {
            logger.info(infoBuilder.toString());
        }
        DataSet finalDataSet = null;
        ArrayList dataList = new ArrayList(listDataSet.size());
        Iterator iterator = listDataSet.iterator();
        while (iterator.hasNext()) {
            if (finalDataSet != null) {
                dataList.add(iterator.next());
                continue;
            }
            finalDataSet = (DataSet)iterator.next();
        }
        if (!dataList.isEmpty() && finalDataSet != null) {
            finalDataSet = finalDataSet.union(dataList.toArray(new DataSet[dataList.size()]));
        }
        if (finalDataSet == null) {
            return billSet.filter("1 != 1");
        }
        return finalDataSet;
    }

    private DataSet setSpecialNullFieldsType(DataSet billSet, DataSet dataSet) {
        String[] fieldNames;
        RowMeta billSetRowMeta = billSet.getRowMeta();
        RowMeta dataSetRowMeta = dataSet.getRowMeta();
        block10: for (String fieldName : fieldNames = InvBillDetailRptQuery.getNoBgnQtyDataSelectFileds().split(",")) {
            String trimFieldName;
            switch (trimFieldName = fieldName.trim()) {
                case "linetype": {
                    dataSetRowMeta.getField(trimFieldName).setDataType((DataType)DataType.IntegerType);
                    continue block10;
                }
                case "balanceqty": 
                case "balancebaseqty": 
                case "balanceqty2nd": {
                    dataSetRowMeta.getField(trimFieldName).setDataType((DataType)DataType.BigDecimalType);
                    continue block10;
                }
                default: {
                    DataType fieldDataType = billSetRowMeta.getField(trimFieldName).getDataType();
                    dataSetRowMeta.getField(trimFieldName).setDataType(fieldDataType);
                }
            }
        }
        return dataSet;
    }

    /*
     * Exception decompiling
     */
    private DataSet handleNoDataDetailReportQueryBgn(long materialId, Long baseUnitId, Long unitId, String materialName, String modelnum, List<BigDecimal> initBalanceDataList, String[] addFileds) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private DataSet handleNoDataSummaryLinkJump(FilterInfo filterInfo, DataSet dataSet) {
        DynamicObjectCollection materialDoc;
        RowMeta commonRowFiled = new RowMeta(new Field[]{new Field("linetype", (DataType)DataType.IntegerType), new Field("material", (DataType)DataType.LongType), new Field("baseunit", (DataType)DataType.LongType), new Field("materialname1", (DataType)DataType.StringType), new Field("modelnum1", (DataType)DataType.StringType), new Field("group", (DataType)DataType.LongType), new Field("balanceqty", (DataType)DataType.BigDecimalType), new Field("balancebaseqty", (DataType)DataType.BigDecimalType), new Field("balanceqty2nd", (DataType)DataType.BigDecimalType)});
        Long materialId = 0L;
        Long baseunitId = 0L;
        String materialName = "";
        String modelNum = "";
        Object material = filterInfo.getValue("materialnumberfrom");
        if (material instanceof DynamicObjectCollection && (materialDoc = (DynamicObjectCollection)material).size() > 0) {
            DynamicObject materialDo = (DynamicObject)materialDoc.get(0);
            materialId = (Long)materialDo.getPkValue();
            materialName = materialDo.getString("name");
            modelNum = materialDo.getString("modelnum");
            DynamicObject materialInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material");
            baseunitId = materialInfo.getLong("baseunit_id");
        }
        Algo algo = Algo.create((String)"noDataForSummary");
        ArrayList<Object[]> addBgnData = new ArrayList<Object[]>();
        addBgnData.add(new Object[]{1, materialId, baseunitId, materialName, modelNum, filterInfo.getLong("group"), filterInfo.getBigDecimal("bgnqty"), filterInfo.getBigDecimal("bgnbaseqty"), filterInfo.getBigDecimal("bgnqty2nd")});
        ArrayList<Object[]> balanceData = new ArrayList<Object[]>();
        balanceData.add(new Object[]{2, materialId, baseunitId, materialName, modelNum, filterInfo.getLong("group"), filterInfo.getBigDecimal("balanceqty"), filterInfo.getBigDecimal("balancebaseqty"), filterInfo.getBigDecimal("balanceqty2nd")});
        try (DataSet bgnDataSet = algo.createDataSet(addBgnData.iterator(), commonRowFiled);
             DataSet balanceDataSet = algo.createDataSet(balanceData.iterator(), commonRowFiled);){
            String[] addFileds = ReportGeneralOpHelper.removeFiled(InvBillDetailRptQuery.getDataSetFieldArray(dataSet), "material", "linetype");
            dataSet = bgnDataSet.addNullField(addFileds).union(balanceDataSet.addNullField(addFileds));
        }
        return dataSet.orderBy(new String[]{"material", "auxpty", "org", "biztime", "auditdate"});
    }

    private DataSet handleBeginAndBalanceDetail(DataSet copyBillSet, Long materialId, Long baseUnitId, Long unitId, List<BigDecimal> initBalanceDataList, FilterInfo filterInfo, String materialName, String modelnum) {
        QFilter filter = new QFilter("material", "=", (Object)materialId);
        filter.and("unit", "=", (Object)unitId);
        DataSet materialGroupDataSet = copyBillSet.copy().filter(filter.toString());
        if (materialGroupDataSet.isEmpty()) {
            return materialGroupDataSet;
        }
        DataSet groupDatSet = materialGroupDataSet.addNullField(new String[]{"linetype"});
        QFilter qtydisplay = BaseInvBillRptFilteInfo.handleQtyDisplayDetailQfilter(filterInfo);
        if (qtydisplay != null) {
            groupDatSet = groupDatSet.filter(qtydisplay.toString());
        }
        DataSet newGroupDatSet = this.handleDownAndUpRow(groupDatSet, initBalanceDataList);
        String selectMaterialBeginAndBalanceFields = this.getMaterialBeginAndBalanceFiledExpr(ReportGeneralOpHelper.getDataSetField(newGroupDatSet), initBalanceDataList, materialId, baseUnitId, unitId, materialName, modelnum);
        DataSet cloneNewGroupDatSet = newGroupDatSet.copy();
        String selectMaterialSumFields = this.getMaterialSumFiledExpr(ReportGeneralOpHelper.getDataSetField(newGroupDatSet), cloneNewGroupDatSet, initBalanceDataList, materialId, baseUnitId, unitId, materialName, modelnum);
        DataSet newMaterialBeginAndBalanceRowDataSet = newGroupDatSet.select(selectMaterialBeginAndBalanceFields).limit(0, 1);
        DataSet newMaterialSumRowDataSet = newGroupDatSet.select(selectMaterialSumFields).limit(0, 1);
        return newMaterialBeginAndBalanceRowDataSet.union(newGroupDatSet).union(newMaterialSumRowDataSet);
    }

    private DataSet handleDownAndUpRow(DataSet groupDatSet, List<BigDecimal> initBalanceDataList) {
        Set<String> fields = ReportGeneralOpHelper.getDataSetField(groupDatSet);
        StringBuilder sb = new StringBuilder();
        for (String fieldName : fields) {
            if ("balanceqty".equals(fieldName) || "balancebaseqty".equals(fieldName) || "balanceqty2nd".equals(fieldName)) continue;
            sb.append(fieldName);
            sb.append(", ");
        }
        String balanceqtyValue = null;
        String balancebaseqtyValue = null;
        String balanceqty2ndValue = null;
        balanceqtyValue = initBalanceDataList.get(0).compareTo(BigDecimal.ZERO) == 0 ? "" : (initBalanceDataList.get(0).compareTo(BigDecimal.ZERO) > 0 ? "+" + initBalanceDataList.get(0) : initBalanceDataList.get(0).toString());
        balancebaseqtyValue = initBalanceDataList.get(1).compareTo(BigDecimal.ZERO) == 0 ? "" : (initBalanceDataList.get(1).compareTo(BigDecimal.ZERO) > 0 ? "+" + initBalanceDataList.get(1) : initBalanceDataList.get(1).toString());
        balanceqty2ndValue = initBalanceDataList.get(2).compareTo(BigDecimal.ZERO) == 0 ? "" : (initBalanceDataList.get(2).compareTo(BigDecimal.ZERO) > 0 ? "+" + initBalanceDataList.get(2) : initBalanceDataList.get(2).toString());
        DataSet tmpGroupDatSet = groupDatSet.select("PreRowValue(balanceqty)+inqty-outqty as balanceqty,PreRowValue(balancebaseqty)+inbaseqty-outbaseqty as balancebaseqty,PreRowValue(balanceqty2nd)+inqty2nd-outqty2nd as balanceqty2nd ," + sb.toString().substring(0, sb.toString().lastIndexOf(44)));
        String balanceQty = "balanceqty" + balanceqtyValue + " as balanceqty, ";
        String balanceBaseQty = "balancebaseqty" + balancebaseqtyValue + " as balancebaseqty, ";
        String balanceQty2nd = "balanceqty2nd" + balanceqty2ndValue + " as balanceqty2nd ";
        sb.append(balanceQty).append(balanceBaseQty).append(balanceQty2nd);
        DataSet newGroupDatSet = tmpGroupDatSet.select(sb.toString());
        return newGroupDatSet;
    }

    private String getMaterialBeginAndBalanceFiledExpr(Set<String> fieldNamesSet, List<BigDecimal> initBalanceDataList, Long materialId, Long baseUnitId, Long unitId, String materialName, String modelnum) {
        StringBuilder sb = new StringBuilder();
        for (String fieldName : fieldNamesSet) {
            String materialStr;
            if (!("balanceqty".equals(fieldName) || "balancebaseqty".equals(fieldName) || "balanceqty2nd".equals(fieldName) || "linetype".equals(fieldName) || "material".equals(fieldName) || "materialname1".equals(fieldName) || "modelnum1".equals(fieldName) || "baseunit".equals(fieldName) || "unit".equals(fieldName))) {
                String nullAsField = "null as " + fieldName + ", ";
                sb.append(nullAsField);
                continue;
            }
            if ("linetype".equals(fieldName)) {
                String lineType = "1 as " + fieldName + ", ";
                sb.append(lineType);
                continue;
            }
            if ("balanceqty".equals(fieldName)) {
                BigDecimal balanceqty = initBalanceDataList.get(0);
                String balanceQtyStr = (balanceqty.stripTrailingZeros().toPlainString().equals("0") ? Integer.valueOf(0) : balanceqty) + " as " + fieldName + ", ";
                sb.append(balanceQtyStr);
                continue;
            }
            if ("balancebaseqty".equals(fieldName)) {
                BigDecimal balancebaseqty = initBalanceDataList.get(1);
                String balanceBaseQtyStr = (balancebaseqty.stripTrailingZeros().toPlainString().equals("0") ? Integer.valueOf(0) : balancebaseqty) + " as " + fieldName + ", ";
                sb.append(balanceBaseQtyStr);
                continue;
            }
            if ("balanceqty2nd".equals(fieldName)) {
                BigDecimal balanceqty2nd = initBalanceDataList.get(2);
                String balanceQty2ndStr = (balanceqty2nd.stripTrailingZeros().toPlainString().equals("0") ? Integer.valueOf(0) : balanceqty2nd) + " as " + fieldName + ", ";
                sb.append(balanceQty2ndStr);
                continue;
            }
            if ("material".equals(fieldName)) {
                materialStr = materialId + " as " + fieldName + ",";
                sb.append(materialStr);
                continue;
            }
            if ("materialname1".equals(fieldName)) {
                materialStr = "'" + materialName.replace("'", "\\'") + "' as " + fieldName + ",";
                sb.append(materialStr);
                continue;
            }
            if ("modelnum1".equals(fieldName)) {
                materialStr = "'" + modelnum.replace("'", "\\'") + "' as " + fieldName + ",";
                sb.append(materialStr);
                continue;
            }
            if ("baseunit".equals(fieldName)) {
                materialStr = baseUnitId + " as " + fieldName + ",";
                sb.append(materialStr);
                continue;
            }
            if (!"unit".equals(fieldName)) continue;
            materialStr = unitId + " as " + fieldName + ",";
            sb.append(materialStr);
        }
        return sb.toString().substring(0, sb.toString().lastIndexOf(44));
    }

    private String getMaterialSumFiledExpr(Set<String> fieldNamesSet, DataSet cloneNewGroupDatSet, List<BigDecimal> initBalanceDataList, Long materialId, Long baseUnitId, Long unitId, String materialName, String modelnum) {
        BigDecimal suminqty = BigDecimal.ZERO;
        BigDecimal suminbaseqty = BigDecimal.ZERO;
        BigDecimal suminqty2nd = BigDecimal.ZERO;
        BigDecimal sumoutqty = BigDecimal.ZERO;
        BigDecimal sumoutbaseqty = BigDecimal.ZERO;
        BigDecimal sumoutqty2nd = BigDecimal.ZERO;
        BigDecimal sumbalanceqty = BigDecimal.ZERO;
        BigDecimal sumbalancebaseqty = BigDecimal.ZERO;
        BigDecimal sumbalanceqty2nd = BigDecimal.ZERO;
        while (cloneNewGroupDatSet.hasNext()) {
            Row row = cloneNewGroupDatSet.next();
            BigDecimal inqty = row.getBigDecimal("inqty");
            BigDecimal inbaseqty = row.getBigDecimal("inbaseqty");
            BigDecimal inqty2nd = row.getBigDecimal("inqty2nd");
            BigDecimal outqty = row.getBigDecimal("outqty");
            BigDecimal outbaseqty = row.getBigDecimal("outbaseqty");
            BigDecimal outqty2nd = row.getBigDecimal("outqty2nd");
            suminqty = suminqty.add(inqty);
            suminbaseqty = suminbaseqty.add(inbaseqty);
            suminqty2nd = suminqty2nd.add(inqty2nd);
            sumoutqty = sumoutqty.add(outqty);
            sumoutbaseqty = sumoutbaseqty.add(outbaseqty);
            sumoutqty2nd = sumoutqty2nd.add(outqty2nd);
        }
        sumbalanceqty = suminqty.subtract(sumoutqty).add(initBalanceDataList.get(0));
        sumbalancebaseqty = suminbaseqty.subtract(sumoutbaseqty).add(initBalanceDataList.get(1));
        sumbalanceqty2nd = suminqty2nd.subtract(sumoutqty2nd).add(initBalanceDataList.get(2));
        StringBuilder sb = new StringBuilder();
        for (String fieldName : fieldNamesSet) {
            String materialStr;
            if (!("linetype".equals(fieldName) || "inqty".equals(fieldName) || "inbaseqty".equals(fieldName) || "inqty2nd".equals(fieldName) || "outqty".equals(fieldName) || "outbaseqty".equals(fieldName) || "outqty2nd".equals(fieldName) || "balanceqty".equals(fieldName) || "unit".equals(fieldName) || "balancebaseqty".equals(fieldName) || "balanceqty2nd".equals(fieldName) || "material".equals(fieldName) || "materialname1".equals(fieldName) || "modelnum1".equals(fieldName) || "baseunit".equals(fieldName))) {
                String nullAsField = " null as " + fieldName + ", ";
                sb.append(nullAsField);
                continue;
            }
            if ("linetype".equals(fieldName)) {
                String lineTypeStr = "2 as " + fieldName + ", ";
                sb.append(lineTypeStr);
                continue;
            }
            if ("inqty".equals(fieldName)) {
                String inQtyStr = suminqty.stripTrailingZeros().toPlainString() + " as " + fieldName + ", ";
                sb.append(inQtyStr);
                continue;
            }
            if ("inbaseqty".equals(fieldName)) {
                String inBaseQtyf = suminbaseqty.stripTrailingZeros().toPlainString() + " as " + fieldName + ", ";
                sb.append(inBaseQtyf);
                continue;
            }
            if ("inqty2nd".equals(fieldName)) {
                String inQty2ndStr = suminqty2nd.stripTrailingZeros().toPlainString() + " as " + fieldName + ", ";
                sb.append(inQty2ndStr);
                continue;
            }
            if ("outqty".equals(fieldName)) {
                String outQtyStr = sumoutqty.stripTrailingZeros().toPlainString() + " as " + fieldName + ", ";
                sb.append(outQtyStr);
                continue;
            }
            if ("outbaseqty".equals(fieldName)) {
                String outBaseQtyStr = sumoutbaseqty.stripTrailingZeros().toPlainString() + " as " + fieldName + ", ";
                sb.append(outBaseQtyStr);
                continue;
            }
            if ("outqty2nd".equals(fieldName)) {
                String outQty2ndStr = sumoutqty2nd.stripTrailingZeros().toPlainString() + " as " + fieldName + ", ";
                sb.append(outQty2ndStr);
                continue;
            }
            if ("balanceqty".equals(fieldName)) {
                String balanceQtyStr = sumbalanceqty.stripTrailingZeros().toPlainString() + " as " + fieldName + ", ";
                sb.append(balanceQtyStr);
                continue;
            }
            if ("balancebaseqty".equals(fieldName)) {
                String balanceBaseQtyStr = sumbalancebaseqty.stripTrailingZeros().toPlainString() + " as " + fieldName + ", ";
                sb.append(balanceBaseQtyStr);
                continue;
            }
            if ("balanceqty2nd".equals(fieldName)) {
                String balanceQty2ndStr = sumbalanceqty2nd.stripTrailingZeros().toPlainString() + " as " + fieldName + ", ";
                sb.append(balanceQty2ndStr);
                continue;
            }
            if ("material".equals(fieldName)) {
                materialStr = materialId + " as " + fieldName + ",";
                sb.append(materialStr);
                continue;
            }
            if ("materialname1".equals(fieldName)) {
                materialStr = "'" + materialName.replace("'", "\\'") + "' as " + fieldName + ",";
                sb.append(materialStr);
                continue;
            }
            if ("modelnum1".equals(fieldName)) {
                materialStr = "'" + modelnum.replace("'", "\\'") + "' as " + fieldName + ",";
                sb.append(materialStr);
                continue;
            }
            if ("baseunit".equals(fieldName)) {
                materialStr = baseUnitId + " as " + fieldName + ",";
                sb.append(materialStr);
                continue;
            }
            if (!"unit".equals(fieldName)) continue;
            materialStr = unitId + " as " + fieldName + ",";
            sb.append(materialStr);
        }
        return sb.toString().substring(0, sb.toString().lastIndexOf(44));
    }
}

