/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.invbillreport;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.consts.InvBillRptConst;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;
import kd.scmc.im.report.invbillreport.BaseInvBillRptBeforeF7Select;
import kd.scmc.im.report.invbillreport.BaseInvBillRptPlugin;
import kd.scmc.im.utils.FormUtils;

public class InvBillSumRptPlugin
extends BaseInvBillRptPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"multiorghead"});
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"gradecount"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"onlycountline"});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        BaseInvBillRptBeforeF7Select baseInvBillRptBeforeF7Select = new BaseInvBillRptBeforeF7Select((IFormView)this.getView());
        baseInvBillRptBeforeF7Select.beforeF7Select(e, "multiorghead");
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        ReportList reportList = (ReportList)evt.getSource();
        int rowIndex = evt.getRowIndex();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        DynamicObjectCollection auxentry = this.getModel().getEntryEntity("auxentry");
        if ("material".equals(evt.getFieldName())) {
            this.showBills(rowData, auxentry);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        switch (key = e.getProperty().getName()) {
            case "countcolumn": {
                this.handleCountcolumnChangeEvent(newValue, oldValue);
                break;
            }
            case "multiorghead": {
                this.handleMultiOrgChangeEvent((DynamicObjectCollection)newValue, (DynamicObjectCollection)oldValue);
                break;
            }
            case "sumref": {
                this.handleSumrefChangeEvent((String)newValue);
            }
            default: {
                super.propertyChanged(e);
            }
        }
    }

    private void handleSumrefChangeEvent(String newValue) {
        if (newValue == null) {
            return;
        }
        if (!newValue.contains("owner") && "owner".equals(this.getModel().getValue("countcolumn"))) {
            this.getModel().setValue("countcolumn", null);
        }
    }

    private void handleCountcolumnChangeEvent(Object newValue, Object oldValue) {
        String countcolumn;
        Object sumref;
        if (newValue != null && !((String)newValue).trim().equals("")) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"gradecount"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"onlycountline"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"gradecount"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"onlycountline"});
        }
        if ("owner".equals(newValue) && ((sumref = this.getModel().getValue("sumref")) == null || !((String)sumref).contains("owner"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6c47\u603b\u4f9d\u636e\u672a\u52fe\u9009\u8d27\u4e3b\u3002", (String)"InvBillSumRptPlugin_0", (String)"scmc-im-report", (Object[])new Object[0]));
            this.getModel().setValue("countcolumn", oldValue);
        }
        if ("".equals(countcolumn = (String)this.getModel().getValue("countcolumn"))) {
            this.getModel().setValue("onlycountline", (Object)false);
        }
    }

    private void handleMultiOrgChangeEvent(DynamicObjectCollection newValue, DynamicObjectCollection oldValue) {
        if (newValue == null || newValue.size() == 0) {
            ArrayList<Long> listOrgId = new ArrayList<Long>();
            for (DynamicObject dynamicObject : oldValue) {
                listOrgId.add(dynamicObject.getLong("fbasedataid_id"));
                this.getModel().setValue("multiorghead", (Object)listOrgId.toArray());
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"InvBillSumRptPlugin_1", (String)"scmc-im-report", (Object[])new Object[0]));
            return;
        }
        this.getModel().beginInit();
        this.getModel().createNewData();
        ArrayList<Long> listOrgId = new ArrayList<Long>();
        for (DynamicObject dynamicObject : newValue) {
            listOrgId.add(dynamicObject.getLong("fbasedataid_id"));
        }
        this.getModel().setValue("multiorghead", (Object)listOrgId.toArray());
        this.getModel().endInit();
        this.getView().updateView();
    }

    @Override
    public void beforeQuery(ReportQueryParam queryParam) {
        String[] sumref;
        super.beforeQuery(queryParam);
        HashSet<String> hiddenColumn = new HashSet<String>();
        hiddenColumn.add("lotnumber");
        hiddenColumn.add("owner");
        hiddenColumn.add("warehouse");
        hiddenColumn.add("location");
        hiddenColumn.add("project");
        hiddenColumn.add("configuredcode");
        hiddenColumn.add("tracknumber");
        hiddenColumn.add("auxpty");
        hiddenColumn.add("keeper");
        for (String ref : sumref = this.getSumField()) {
            hiddenColumn.remove(ref);
        }
        if (hiddenColumn.contains("owner")) {
            hiddenColumn.add("ownertype");
        }
        if (hiddenColumn.contains("keeper")) {
            hiddenColumn.add("keepertype");
        }
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        List columns = reportList.getColumns();
        this.setNeedHiddenColumn(columns, hiddenColumn);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ReportCommonFilterOrChangeOp.initMultiOrg(this.getView(), "multiorghead");
    }

    public void afterSetModelValue(DynamicObject scheme) {
        Object o;
        DynamicObjectCollection projectFrom;
        DynamicObjectCollection locationFrom;
        DynamicObjectCollection warehouseFrom;
        DynamicObjectCollection materiaNumFrom;
        if (scheme == null) {
            return;
        }
        this.getModel().setValue("orghead", scheme.get("orghead"));
        this.getModel().setValue("multiorghead", scheme.get("multiorghead"));
        DataEntityPropertyCollection dataEntityPropertyCollection = scheme.getDataEntityType().getProperties();
        for (IDataEntityProperty property : dataEntityPropertyCollection) {
            String name = property.getName();
            if ("orghead".equals(name) || "multiorghead".equals(name) || "auxentry".equals(name)) continue;
            DataChangeHelper.setValue((IDataModel)this.getModel(), (String)name, (Object)scheme.get(name), (boolean)false);
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection materialGrpFrom = dataEntity.getDynamicObjectCollection("materialgroupfrom");
        if (materialGrpFrom.size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"materialgroupto"});
        }
        if ((materiaNumFrom = dataEntity.getDynamicObjectCollection("materialnumberfrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"materialnumberto"});
        }
        if ((warehouseFrom = dataEntity.getDynamicObjectCollection("warehousefrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"warehouseto"});
        }
        if ((locationFrom = dataEntity.getDynamicObjectCollection("locationfrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"locationto"});
        }
        if ((projectFrom = dataEntity.getDynamicObjectCollection("projectfrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"projectto"});
        }
        if ((o = dataEntity.get("lotnumberfrom")) == null || "".equals(o)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"lotnumberto"});
        }
    }

    protected void showBills(DynamicObject rowData, DynamicObjectCollection auxentry) {
        ReportShowParameter rsp = new ReportShowParameter();
        this.setInvBillReportFilterValue(rowData);
        rsp.setQueryParam(this.getQueryParam());
        Map customParams = rsp.getCustomParams();
        List<Map<String, Object>> auxentryListMap = this.getAuxentryListMap(auxentry);
        customParams.put("auxentry", SerializationUtils.toJsonString(auxentryListMap));
        this.handleHyperLinkClickCustomParams(rowData, customParams);
        rsp.setFormId("im_invbillreport");
        rsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)rsp);
    }

    private List<Map<String, Object>> getAuxentryListMap(DynamicObjectCollection auxentry) {
        ArrayList<Map<String, Object>> auxentryListMap = new ArrayList<Map<String, Object>>(auxentry.size());
        for (DynamicObject entry : auxentry) {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            DynamicObject auxproperty = (DynamicObject)entry.get("auxproperty");
            if (null == auxproperty) continue;
            map.put("auxproperty", auxproperty.getPkValue());
            DynamicObjectCollection auxdetailbd = (DynamicObjectCollection)entry.get("auxdetailbd");
            ArrayList<Object> auxdetailbdIdSet = new ArrayList<Object>(auxdetailbd.size());
            for (DynamicObject auxdetail : auxdetailbd) {
                auxdetailbdIdSet.add(auxdetail.get(2));
            }
            map.put("auxdetailbd", auxdetailbdIdSet);
            String auxdetailbasebd = (String)entry.get("auxdetailbasebd");
            map.put("auxdetailbasebd", auxdetailbasebd);
            String auxdetailbasebdid = (String)entry.get("auxdetailbasebdid");
            map.put("auxdetailbasebdid", auxdetailbasebdid);
            String auxdetailtxt = (String)entry.get("auxdetailtxt");
            map.put("auxdetailtxt", auxdetailtxt);
            auxentryListMap.add(map);
        }
        return auxentryListMap;
    }

    private void setInvBillReportFilterValue(DynamicObject rowData) {
        DynamicObject tracknumberLink;
        DynamicObject configuredcodeLink;
        DynamicObject projectLink;
        String lotnumerLink;
        DynamicObject locationHyperLink;
        DynamicObject warehouseHyperLink;
        DynamicObject materialHyperLink;
        Long masterid;
        Map materialInvInfos;
        DynamicObject invtypeLink;
        String ownertypeheadLink;
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        DynamicObject orgHyperLink = rowData.getDynamicObject("org");
        if (orgHyperLink != null) {
            filterInfo.addFilterItem("orghead", orgHyperLink.getPkValue());
        }
        if ((ownertypeheadLink = rowData.getString("ownertype")) != null && !ownertypeheadLink.isEmpty()) {
            DynamicObject ownerLink = rowData.getDynamicObject("owner");
            filterInfo.addFilterItem("ownerto", (Object)ownerLink);
            filterInfo.addFilterItem("ownertypehead", (Object)ownertypeheadLink);
            switch (ownertypeheadLink) {
                case "bos_org": {
                    filterInfo.addFilterItem("accountownerfrom", (Object)ownerLink);
                    break;
                }
                case "bd_supplier": {
                    filterInfo.addFilterItem("supplierownerfrom", (Object)ownerLink);
                    break;
                }
                case "bd_customer": {
                    filterInfo.addFilterItem("customerownerfrom", (Object)ownerLink);
                    break;
                }
            }
        }
        if ((invtypeLink = rowData.getDynamicObject("invtype")) != null) {
            filterInfo.addFilterItem("ivntypehead", (Object)invtypeLink);
        }
        Object materialtypeLink = rowData.get("materialtype");
        filterInfo.addFilterItem("materialtypehead", materialtypeLink);
        DynamicObject materialGroupTypeLink = rowData.getDynamicObject("group");
        if (materialGroupTypeLink != null) {
            filterInfo.addFilterItem("materialgroupfrom", (Object)materialGroupTypeLink);
            filterInfo.addFilterItem("materialgroupto", (Object)materialGroupTypeLink);
        }
        if ((materialInvInfos = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (QFilter[])new QFilter("masterid", "=", (Object)(masterid = (Long)(materialHyperLink = rowData.getDynamicObject("material")).getPkValue())).toArray())) == null || materialInvInfos.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u884c\u4e2d\u7684\u4e3b\u7269\u6599\u6ca1\u6709\u5bf9\u5e94\u7684\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u3002", (String)"InvBillSumRptPlugin_2", (String)"scmc-im-report", (Object[])new Object[0]));
        }
        if (materialHyperLink != null) {
            filterInfo.addFilterItem("materialnumberfrom", (Object)masterid);
            filterInfo.addFilterItem("materialnumberto", (Object)masterid);
        }
        if ((warehouseHyperLink = rowData.getDynamicObject("warehouse")) != null) {
            filterInfo.addFilterItem("warehousefrom", (Object)warehouseHyperLink);
            filterInfo.addFilterItem("warehouseto", (Object)warehouseHyperLink);
        }
        if ((locationHyperLink = rowData.getDynamicObject("location")) != null) {
            filterInfo.addFilterItem("locationfrom", (Object)locationHyperLink);
            filterInfo.addFilterItem("locationto", (Object)locationHyperLink);
        }
        if ((lotnumerLink = rowData.getString("lotnumber")) != null && !lotnumerLink.isEmpty()) {
            filterInfo.addFilterItem("lotnumberfrom", (Object)lotnumerLink);
            filterInfo.addFilterItem("lotnumberto", (Object)lotnumerLink);
        }
        if ((projectLink = rowData.getDynamicObject("project")) != null) {
            filterInfo.addFilterItem("projectfrom", (Object)projectLink);
            filterInfo.addFilterItem("projectto", (Object)projectLink);
        }
        if ((configuredcodeLink = rowData.getDynamicObject("configuredcode")) != null) {
            filterInfo.addFilterItem("configuredcodefrom", (Object)configuredcodeLink);
            filterInfo.addFilterItem("configuredcodeto", (Object)configuredcodeLink);
        }
        if ((tracknumberLink = rowData.getDynamicObject("tracknumber")) != null) {
            filterInfo.addFilterItem("tracknumberfrom", (Object)tracknumberLink);
            filterInfo.addFilterItem("tracknumberto", (Object)tracknumberLink);
        }
    }

    private void handleHyperLinkClickCustomParams(DynamicObject rowData, Map<String, Object> customParams) {
        customParams.put("hyperlinkFromSumPpt", "hyperlinkFromSumPpt");
        DynamicObject auxpty = rowData.getDynamicObject("auxpty");
        if (auxpty != null) {
            customParams.put("auxpty", rowData.getDynamicObject("auxpty").getPkValue());
        }
        customParams.put("bgnqty", rowData.getBigDecimal("bgnqty"));
        customParams.put("bgnbaseqty", rowData.getBigDecimal("bgnbaseqty"));
        customParams.put("bgnqty2nd", rowData.getBigDecimal("bgnqty2nd"));
        customParams.put("balanceqty", rowData.getBigDecimal("balanceqty"));
        customParams.put("balancebaseqty", rowData.getBigDecimal("balancebaseqty"));
        customParams.put("balanceqty2nd", rowData.getBigDecimal("balanceqty2nd"));
    }

    private String[] getSumField() {
        String groupByFiled = "invtype,material,unit,baseunit,unit2nd";
        String sumRef = (String)this.getModel().getValue("sumref");
        if (sumRef != null && !sumRef.trim().equals("") && !sumRef.trim().equals("null")) {
            groupByFiled = groupByFiled + sumRef;
        }
        String[] groupByFields = groupByFiled.split(",");
        return groupByFields;
    }

    public void setSortAndFilter(List<SortAndFilterEvent> list) {
        super.setSortAndFilter(list);
        for (SortAndFilterEvent event : list) {
            if (!InvBillRptConst.SUM_HEADFILTER_LIST.contains(event.getColumnName())) continue;
            event.setFilter(true);
        }
    }
}

