/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.invbillreport;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.scmc.im.business.helper.AuxptyFilterHelper;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;
import kd.scmc.im.report.helper.ReportGeneralOpHelper;
import kd.scmc.im.report.invbillreport.BaseInvBillRptQuery;
import kd.scmc.im.report.invbillreport.DymAccDSInfo;

public class InvBillSumRptQuery
extends BaseInvBillRptQuery {
    private Map<String, String> recs = new LinkedHashMap<String, String>();
    private Map<String, String> sends = new LinkedHashMap<String, String>();
    private Set<String> recAndSendFieldSet = new LinkedHashSet<String>();

    @Override
    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        FilterInfo filterInfo = queryParam.getFilter();
        this.handleTransceiver(filterInfo);
        DataSet dataSet = super.query(queryParam, selectedObj);
        dataSet = this.addTransceiverColumn(filterInfo, dataSet);
        String[] recAndSendFields = ReportGeneralOpHelper.addFileds(this.getRecAndSendField(), this.recAndSendFieldSet.toArray(new String[this.recAndSendFieldSet.size()]));
        String[] sumFields = this.getSumField(filterInfo);
        dataSet = this.sumDataSet(sumFields, dataSet, recAndSendFields);
        dataSet = this.addBgnQty(filterInfo, dataSet, sumFields, recAndSendFields, queryParam);
        dataSet = this.calBalanceQty(dataSet);
        dataSet = this.addBaseMaterialGroup(dataSet, filterInfo);
        HashSet<String> headerFieldsSet = new HashSet<String>(16);
        headerFieldsSet.add("group");
        dataSet = DymAccDSInfo.filterHeader(filterInfo, dataSet, headerFieldsSet);
        dataSet = this.filterData(filterInfo, dataSet);
        String[] countFileds = ReportGeneralOpHelper.addFileds(recAndSendFields, "bgnqty", "bgnbaseqty", "bgnqty2nd", "balanceqty", "balancebaseqty", "balanceqty2nd");
        dataSet = this.addCountLine(filterInfo, dataSet, countFileds);
        dataSet = InvBillSumRptQuery.handleNullFiledAsZero(dataSet, "bgnqty", "inqty", "outqty", "balanceqty");
        dataSet = dataSet.filter(this.getIgnoreFilter());
        return dataSet;
    }

    private String getIgnoreFilter() {
        String ignore = "bgnqty != 0 or inqty != 0 or outqty!=0 or balanceqty!=0";
        StringBuilder recAndSendQtyFilterString = new StringBuilder();
        for (String qtyField : this.recAndSendFieldSet) {
            this.addRecAndSendQtyFilter(qtyField, recAndSendQtyFilterString);
        }
        StringBuilder rs = new StringBuilder();
        if (recAndSendQtyFilterString.length() > 0) {
            rs.append(ignore);
            rs.append(" or (");
            rs.append((CharSequence)recAndSendQtyFilterString);
            rs.append(")");
            ignore = rs.toString();
        }
        return ignore;
    }

    private void addRecAndSendQtyFilter(String qtyField, StringBuilder recAndSendQtyFilterString) {
        String filterString = "(" + qtyField + "!= null and " + qtyField + "!= 0)";
        if (recAndSendQtyFilterString.length() == 0) {
            recAndSendQtyFilterString.append(filterString);
        } else {
            recAndSendQtyFilterString.append(" or ");
            recAndSendQtyFilterString.append(filterString);
        }
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List oldColumns = super.getColumns(columns);
        ArrayList<AbstractReportColumn> newColumns = new ArrayList<AbstractReportColumn>(oldColumns.size() + 2);
        Set<String> recsKey = this.recs.keySet();
        Set<String> sendsKey = this.sends.keySet();
        HashSet<String> setIntersection = new HashSet<String>();
        setIntersection.addAll(recsKey);
        setIntersection.retainAll(sendsKey);
        block8: for (AbstractReportColumn abstractReportColumn : oldColumns) {
            if (abstractReportColumn instanceof ReportColumnGroup) {
                String key;
                newColumns.add(abstractReportColumn);
                ReportColumnGroup column = (ReportColumnGroup)abstractReportColumn;
                switch (key = column.getFieldKey()) {
                    case "in": {
                        ReportColumnGroup reportColumnGroup;
                        for (Map.Entry<String, String> entry : this.recs.entrySet()) {
                            reportColumnGroup = null;
                            reportColumnGroup = setIntersection.contains(entry.getKey()) ? this.createQtyGroup("rec", String.format(ResManager.loadKDString((String)"%1$s\u5165", (String)"InvBillSumRptQuery_10", (String)"scmc-im-report", (Object[])new Object[0]), entry.getValue()), entry.getKey()) : this.createQtyGroup("rec", entry.getValue(), entry.getKey());
                            newColumns.add((AbstractReportColumn)reportColumnGroup);
                        }
                        continue block8;
                    }
                    case "out": {
                        ReportColumnGroup reportColumnGroup;
                        for (Map.Entry<String, String> entry : this.sends.entrySet()) {
                            reportColumnGroup = null;
                            reportColumnGroup = setIntersection.contains(entry.getKey()) ? this.createQtyGroup("send", String.format(ResManager.loadKDString((String)"%1$s\u51fa", (String)"InvBillSumRptQuery_11", (String)"scmc-im-report", (Object[])new Object[0]), entry.getValue()), entry.getKey()) : this.createQtyGroup("send", entry.getValue(), entry.getKey());
                            newColumns.add((AbstractReportColumn)reportColumnGroup);
                        }
                        continue block8;
                    }
                }
                continue;
            }
            newColumns.add(abstractReportColumn);
        }
        return newColumns;
    }

    private void handleTransceiver(FilterInfo filterInfo) {
        String shwospecialbill;
        DynamicObjectCollection receivers = filterInfo.getDynamicObjectCollection("showreceiver");
        if (receivers != null && receivers.size() != 0) {
            for (DynamicObject receiver : receivers) {
                String transceiver = receiver.getString("transceiver");
                String transceiverName = receiver.getString("name");
                String transceiverNumber = receiver.getPkValue().toString();
                if ("2".equals(transceiver) || "0".equals(transceiver)) {
                    this.recs.put(transceiverNumber, transceiverName);
                }
                if (!"2".equals(transceiver) && !"1".equals(transceiver)) continue;
                this.sends.put(transceiverNumber, transceiverName);
            }
        }
        if ((shwospecialbill = filterInfo.getString("shwospecialbill")) != null && !shwospecialbill.trim().equals("")) {
            String[] specialbills;
            String[] stringArray = specialbills = shwospecialbill.trim().split(",");
            int n = stringArray.length;
            block23: for (int i = 0; i < n; ++i) {
                String specialbill;
                switch (specialbill = stringArray[i]) {
                    case "transrec": {
                        this.recs.put("transrec", ResManager.loadKDString((String)"\u5f62\u6001\u8f6c\u6362\u5165", (String)"InvBillSumRptQuery_0", (String)"scmc-im-report", (Object[])new Object[0]));
                        continue block23;
                    }
                    case "transsend": {
                        this.sends.put("transsend", ResManager.loadKDString((String)"\u5f62\u6001\u8f6c\u6362\u51fa", (String)"InvBillSumRptQuery_1", (String)"scmc-im-report", (Object[])new Object[0]));
                        continue block23;
                    }
                    case "initbill": {
                        this.recs.put("initbill", ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5355\u636e", (String)"InvBillSumRptQuery_2", (String)"scmc-im-report", (Object[])new Object[0]));
                        continue block23;
                    }
                    case "assembbillrec": {
                        this.recs.put("assembbillrec", ResManager.loadKDString((String)"\u7ec4\u88c5\u540e", (String)"InvBillSumRptQuery_3", (String)"scmc-im-report", (Object[])new Object[0]));
                        continue block23;
                    }
                    case "assembbillsend": {
                        this.sends.put("assembbillsend", ResManager.loadKDString((String)"\u7ec4\u88c5\u524d", (String)"InvBillSumRptQuery_4", (String)"scmc-im-report", (Object[])new Object[0]));
                        continue block23;
                    }
                    case "locationtransferbillrec": {
                        this.recs.put("locationtransferbillrec", ResManager.loadKDString((String)"\u4ed3\u4f4d\u79fb\u52a8\u8c03\u5165", (String)"InvBillSumRptQuery_5", (String)"scmc-im-report", (Object[])new Object[0]));
                        continue block23;
                    }
                    case "locationtransferbillsend": {
                        this.sends.put("locationtransferbillsend", ResManager.loadKDString((String)"\u4ed3\u4f4d\u79fb\u52a8\u8c03\u51fa", (String)"InvBillSumRptQuery_6", (String)"scmc-im-report", (Object[])new Object[0]));
                        continue block23;
                    }
                    case "disassemblebillsend": {
                        this.sends.put("disassemblebillsend", ResManager.loadKDString((String)"\u62c6\u5378\u524d", (String)"InvBillSumRptQuery_14", (String)"scmc-im-report", (Object[])new Object[0]));
                        continue block23;
                    }
                    case "disassemblebillrec": {
                        this.recs.put("disassemblebillrec", ResManager.loadKDString((String)"\u62c6\u5378\u540e", (String)"InvBillSumRptQuery_15", (String)"scmc-im-report", (Object[])new Object[0]));
                        continue block23;
                    }
                }
            }
        }
    }

    private ReportColumnGroup createQtyGroup(String prefix, String groupName, String number) {
        String recqty2ndkey;
        String recbaseqtykey;
        ReportColumnGroup reportColumnGroup = new ReportColumnGroup();
        reportColumnGroup.setCaption(new LocaleString(groupName));
        reportColumnGroup.setFieldKey(number);
        List recColumns = reportColumnGroup.getChildren();
        String recqtyKey = prefix + "qty" + number;
        if (this.recAndSendFieldSet.contains(recqtyKey)) {
            recColumns.add(this.createDecimalColumn(ResManager.loadKDString((String)"\u6570\u91cf", (String)"InvBillSumRptQuery_7", (String)"scmc-im-report", (Object[])new Object[0]), recqtyKey, "unit"));
        }
        if (this.recAndSendFieldSet.contains(recbaseqtykey = prefix + "baseqty" + number)) {
            recColumns.add(this.createDecimalColumn(ResManager.loadKDString((String)"\u57fa\u672c\u6570\u91cf", (String)"InvBillSumRptQuery_16", (String)"scmc-im-report", (Object[])new Object[0]), recbaseqtykey, "baseunit"));
        }
        if (this.recAndSendFieldSet.contains(recqty2ndkey = prefix + "qty2nd" + number)) {
            recColumns.add(this.createDecimalColumn(ResManager.loadKDString((String)"\u8f85\u52a9\u6570\u91cf", (String)"InvBillSumRptQuery_8", (String)"scmc-im-report", (Object[])new Object[0]), recqty2ndkey, "unit2nd"));
        }
        return reportColumnGroup;
    }

    private ReportColumn createDecimalColumn(String caption, String key, String unitKey) {
        ReportColumn column = new ReportColumn();
        column.setCaption(new LocaleString(caption));
        column.setFieldKey(key);
        column.setFieldType("qty");
        column.setMeasureUnitField(unitKey);
        return column;
    }

    private DataSet addTransceiverColumn(FilterInfo filterInfo, DataSet dataSet) {
        Set<String> recsKeys = this.recs.keySet();
        Set<String> sendsKeys = this.sends.keySet();
        for (String column : recsKeys) {
            if (filterInfo.getBoolean("displayqty")) {
                if (filterInfo.getBoolean("invunit")) {
                    this.recAndSendFieldSet.add("recqty" + column);
                    dataSet = dataSet.addField("case transnumber when '" + column + "' then inqty else 0 end", "recqty" + column);
                } else {
                    this.recAndSendFieldSet.add("recbaseqty" + column);
                    dataSet = dataSet.addField("case transnumber when '" + column + "' then inbaseqty else 0 end", "recbaseqty" + column);
                }
            }
            if (!filterInfo.getBoolean("displayqty2nd")) continue;
            this.recAndSendFieldSet.add("recqty2nd" + column);
            dataSet = dataSet.addField("case transnumber when '" + column + "' then inqty2nd else 0 end", "recqty2nd" + column);
        }
        for (String column : sendsKeys) {
            if (filterInfo.getBoolean("displayqty")) {
                if (filterInfo.getBoolean("invunit")) {
                    this.recAndSendFieldSet.add("sendqty" + column);
                    dataSet = dataSet.addField("case transnumber when '" + column + "' then outqty else 0 end", "sendqty" + column);
                } else {
                    this.recAndSendFieldSet.add("sendbaseqty" + column);
                    dataSet = dataSet.addField("case transnumber when '" + column + "' then outbaseqty else 0 end", "sendbaseqty" + column);
                }
            }
            if (!filterInfo.getBoolean("displayqty2nd")) continue;
            this.recAndSendFieldSet.add("sendqty2nd" + column);
            dataSet = dataSet.addField("case transnumber when '" + column + "' then outqty2nd else 0 end", "sendqty2nd" + column);
        }
        return dataSet;
    }

    private DataSet addBaseMaterialGroup(DataSet dataSet, FilterInfo filterInfo) {
        DataSet materialGroup = ReportCommonFilterOrChangeOp.getClassifiedMaterialDataSet(filterInfo, true);
        Set<String> columns = ReportGeneralOpHelper.getDataSetField(dataSet);
        dataSet = materialGroup.leftJoin(dataSet).on("material", "material").select(new String[]{"group", "materialtype", "groupname"}, columns.toArray(new String[columns.size()])).finish();
        return dataSet;
    }

    private DataSet addCountLine(FilterInfo filterInfo, DataSet dataSet, String[] countFileds) {
        dataSet = dataSet.addField("'2'", "linetype");
        Set<String> fsFields = ReportGeneralOpHelper.getDataSetField(dataSet);
        HashMap<String, String> mapper = new HashMap<String, String>(28);
        mapper.put("material", "0");
        mapper.put("materialname1", "''");
        mapper.put("modelnum1", "''");
        mapper.put("baseunit", "0");
        mapper.put("unit", "0");
        mapper.put("unit2nd", "0");
        mapper.put("auxpty", "0");
        mapper.put("warehouse", "0");
        mapper.put("location", "0");
        mapper.put("project", "0");
        mapper.put("outinvtype", "0");
        mapper.put("outinvstatus", "0");
        mapper.put("outownertype", "0");
        mapper.put("outowner", "0");
        mapper.put("invstatus", "0");
        mapper.put("ownertype", "''");
        mapper.put("bizorg", "0");
        mapper.put("lotnumber", "''");
        mapper.put("keeper", "0");
        mapper.put("keepertype", "''");
        DataSet dataSetWithCountLine = dataSet;
        String countcolumn = filterInfo.getString("countcolumn");
        if (countcolumn != null && !countcolumn.equals("")) {
            String[] orderbyColumn = null;
            DataSet countDataSet = null;
            switch (countcolumn) {
                case "invtype": {
                    orderbyColumn = new String[]{"invtype", "linetype"};
                    mapper.put("materialtype", "''");
                    mapper.put("group", "0");
                    mapper.put("invtype", "invtype");
                    mapper.put("linetype", "'3'");
                    mapper.put("org", "0");
                    mapper.put("owner", "0");
                    String[] invfs = fsFields.toArray(new String[fsFields.size()]);
                    invfs = InvBillSumRptQuery.mapperFileds(invfs, mapper, new String[0]);
                    countDataSet = ReportGeneralOpHelper.addSumColumn(dataSet.groupBy(new String[]{"invtype"}), countFileds).finish().select(invfs);
                    break;
                }
                case "basematerialgroup": {
                    orderbyColumn = new String[]{"group", "linetype"};
                    mapper.put("materialtype", "''");
                    mapper.put("group", "group");
                    mapper.put("invtype", "0");
                    mapper.put("org", "0");
                    mapper.put("linetype", "'3'");
                    mapper.put("owner", "0");
                    String[] groupfs = fsFields.toArray(new String[fsFields.size()]);
                    groupfs = InvBillSumRptQuery.mapperFileds(groupfs, mapper, new String[0]);
                    countDataSet = ReportGeneralOpHelper.addSumColumn(dataSet.groupBy(new String[]{"group"}), countFileds).finish().select(groupfs);
                    break;
                }
                case "owner": {
                    orderbyColumn = new String[]{"owner", "linetype"};
                    mapper.put("materialtype", "''");
                    mapper.put("group", "0");
                    mapper.put("invtype", "0");
                    mapper.put("org", "0");
                    mapper.put("owner", "owner");
                    mapper.put("ownertype", "ownertype");
                    mapper.put("linetype", "'3'");
                    String[] ownerfs = fsFields.toArray(new String[fsFields.size()]);
                    ownerfs = InvBillSumRptQuery.mapperFileds(ownerfs, mapper, new String[0]);
                    countDataSet = ReportGeneralOpHelper.addSumColumn(dataSet.groupBy(new String[]{"ownertype", "owner"}), countFileds).finish().select(ownerfs);
                    break;
                }
            }
            if (countDataSet != null) {
                dataSetWithCountLine = !filterInfo.getBoolean("onlycountline") ? dataSetWithCountLine.union(countDataSet) : countDataSet;
                dataSetWithCountLine = dataSetWithCountLine.orderBy(orderbyColumn);
            }
        }
        if (filterInfo.getBoolean("totalline")) {
            mapper.put("materialtype", "''");
            mapper.put("invtype", "0");
            mapper.put("org", "0");
            mapper.put("owner", "0");
            mapper.put("group", "0");
            mapper.put("ownertype", "''");
            mapper.put("linetype", "'4'");
            mapper.put("lotnumber", "''");
            String[] fs = fsFields.toArray(new String[fsFields.size()]);
            fs = InvBillSumRptQuery.mapperFileds(fs, mapper, new String[0]);
            DataSet countLine = ReportGeneralOpHelper.addSumColumn(dataSet.groupBy(), countFileds).finish().select(fs);
            dataSetWithCountLine = dataSetWithCountLine.union(countLine);
        }
        return dataSetWithCountLine;
    }

    private DataSet addBgnQty(FilterInfo filterInfo, DataSet dataSet, String[] sumFields, String[] countFiled, ReportQueryParam queryParam) throws ParseException {
        DataSet invBalanceDataSet = this.getInvBalanceDataSetWithBgnQty(filterInfo);
        invBalanceDataSet = AuxptyFilterHelper.filterAuxpty((DataSet)invBalanceDataSet, (ReportQueryParam)queryParam);
        invBalanceDataSet = ReportGeneralOpHelper.addSumColumn(invBalanceDataSet.groupBy(sumFields), this.getBgnQtyField()).finish();
        DataSet leftdataSet = this.addJoinColumn(dataSet.leftJoin(invBalanceDataSet), sumFields).select(ReportGeneralOpHelper.addFileds(countFiled, sumFields), this.getBgnQtyField()).finish();
        DataSet rightdataSet = this.addJoinColumn(dataSet.rightJoin(invBalanceDataSet), sumFields).select(countFiled, ReportGeneralOpHelper.addFileds(sumFields, this.getBgnQtyField())).finish();
        String[] totalfiled = ReportGeneralOpHelper.addFileds(ReportGeneralOpHelper.addFileds(sumFields, this.getBgnQtyField()), countFiled);
        dataSet = leftdataSet.union(rightdataSet).groupBy(totalfiled).finish();
        return InvBillSumRptQuery.handleNullFiledAsZero(dataSet, ReportGeneralOpHelper.addFileds(this.getBgnQtyField(), this.getRecAndSendField()));
    }

    private DataSet calBalanceQty(DataSet dataSet) {
        return dataSet.addField("(bgnqty + inqty) - outqty", "balanceqty").addField("(bgnbaseqty + inbaseqty) - outbaseqty", "balancebaseqty").addField("(bgnqty2nd + inqty2nd) - outqty2nd", "balanceqty2nd");
    }

    private DataSet sumDataSet(String[] groupByFields, DataSet dataSet, String[] sumField) {
        dataSet = ReportGeneralOpHelper.addSumColumn(dataSet.groupBy(groupByFields), sumField).finish();
        return dataSet;
    }

    protected String[] getSumField(FilterInfo filterInfo) {
        String groupByFiled = "org,invtype,material,invstatus,materialname1,modelnum1";
        String sumRef = filterInfo.getString("sumref");
        if (sumRef != null && !sumRef.trim().equals("") && !sumRef.trim().equals("null")) {
            groupByFiled = groupByFiled + sumRef;
        }
        String[] groupByFields = groupByFiled.split(",");
        if (filterInfo.getBoolean("displayqty")) {
            groupByFields = filterInfo.getBoolean("invunit") ? ReportGeneralOpHelper.addFileds(groupByFields, "unit") : ReportGeneralOpHelper.addFileds(groupByFields, "baseunit");
        }
        if (filterInfo.getBoolean("displayqty2nd")) {
            groupByFields = ReportGeneralOpHelper.addFileds(groupByFields, "unit2nd");
        }
        HashSet<String> owners = new HashSet<String>();
        for (String string : groupByFields) {
            if ("owner".equals(string)) {
                owners.add("ownertype");
            }
            if (!"keeper".equals(string)) continue;
            owners.add("keepertype");
        }
        if (owners.size() > 0) {
            groupByFields = ReportGeneralOpHelper.addFileds(groupByFields, owners.toArray(new String[owners.size()]));
        }
        return groupByFields;
    }
}

