/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.invbillreport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.param.ParamPublishObject;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.utils.FormUtils;

public class WarehouseIsolateRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"warehousefrom", "warehouseto"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (!"warehousefrom".equals(key) && !"warehouseto".equals(key)) {
            return;
        }
        String reportName = this.getView().getModel().getDataEntityType().getName();
        String orgKey = this.getOrgKey(reportName);
        Object org = this.getView().getModel().getValue(orgKey);
        if ("multiorgheadbyowner".equals(orgKey) && ((DynamicObjectCollection)org).isEmpty()) {
            return;
        }
        List<DynamicObject> warehouses = this.getWarehouses(org, reportName, false);
        if (!warehouses.isEmpty()) {
            int index;
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            List<Long> warehouseIds = this.getWarehouseIds(warehouses);
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            boolean hasWarehouseFilter = false;
            for (index = 0; index < qFilters.size(); ++index) {
                if (!"id".equals(((QFilter)qFilters.get(index)).getProperty())) continue;
                hasWarehouseFilter = true;
                break;
            }
            if (hasWarehouseFilter) {
                qFilters.remove(index);
            }
            qFilters.add(new QFilter("id", "in", warehouseIds));
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        String reportName = this.getView().getModel().getDataEntityType().getName();
        FilterInfo filter = queryParam.getFilter();
        String orgKey = this.getOrgKey(reportName);
        Object orgValue = filter.getValue(orgKey);
        if ("multiorgheadbyowner".equals(orgKey) && (orgValue == null || ((DynamicObjectCollection)orgValue).isEmpty())) {
            return;
        }
        DynamicObjectCollection warehouseFrom = filter.getDynamicObjectCollection("warehousefrom");
        DynamicObject warehouseTo = filter.getDynamicObject("warehouseto");
        if (warehouseFrom != null && !warehouseFrom.isEmpty() && warehouseTo != null) {
            return;
        }
        List<DynamicObject> warehouses = this.getWarehouses(orgValue, reportName, true);
        this.sortWarehouse(warehouses);
        if (warehouses == null || warehouses.isEmpty()) {
            return;
        }
        if (warehouseFrom != null && !warehouseFrom.isEmpty()) {
            this.dealFilterByWarehouseFrom(queryParam, warehouseFrom, warehouses);
        } else if (warehouseFrom == null && warehouseTo != null) {
            this.dealFilterByWarehouseTo(queryParam, warehouseTo, warehouses);
        } else if (warehouseFrom == null) {
            this.dealFilter(queryParam, warehouses);
        }
    }

    private void dealFilter(ReportQueryParam queryParam, List<DynamicObject> warehouses) {
        DynamicObjectCollection warehouseFromFilter = new DynamicObjectCollection();
        warehouseFromFilter.addAll(warehouses);
        queryParam.getFilter().getFilterItem("warehousefrom").setValue((Object)warehouseFromFilter);
        if (warehouses.size() == 1) {
            queryParam.getFilter().getFilterItem("warehouseto").setValue(warehouseFromFilter.get(0));
        }
    }

    private void dealFilterByWarehouseTo(ReportQueryParam queryParam, DynamicObject warehouseTo, List<DynamicObject> warehouses) {
        int index = this.getIndex(warehouses, warehouseTo);
        DynamicObjectCollection warehouseFromFilter = new DynamicObjectCollection();
        warehouseFromFilter.addAll(warehouses.isEmpty() ? warehouses : warehouses.subList(0, index + 1));
        queryParam.getFilter().getFilterItem("warehousefrom").setValue((Object)warehouseFromFilter);
        queryParam.getFilter().getFilterItem("warehouseto").setValue(warehouseFromFilter.size() == 1 ? warehouseFromFilter.get(0) : null);
    }

    private void dealFilterByWarehouseFrom(ReportQueryParam queryParam, DynamicObjectCollection warehouseFrom, List<DynamicObject> warehouses) {
        if (warehouseFrom.size() != 1) {
            return;
        }
        int index = this.getIndex(warehouses, (DynamicObject)warehouseFrom.get(0));
        warehouseFrom.clear();
        List<DynamicObject> subList = warehouses.subList(index, warehouses.size());
        warehouseFrom.addAll(subList);
        queryParam.getFilter().getFilterItem("warehousefrom").setValue((Object)warehouseFrom);
        if (subList.size() == 1) {
            queryParam.getFilter().getFilterItem("warehouseto").setValue((Object)subList.get(0));
        }
    }

    private int getIndex(List<DynamicObject> warehouses, DynamicObject dynamicObject) {
        int index = 0;
        for (DynamicObject warehouse : warehouses) {
            String warehouseNumber;
            String number = dynamicObject.getString("number");
            if (number.equals(warehouseNumber = warehouse.getString("number"))) break;
            ++index;
        }
        return index;
    }

    private void sortWarehouse(List<DynamicObject> warehouses) {
        if (warehouses == null || warehouses.isEmpty()) {
            return;
        }
        warehouses.remove(null);
        warehouses.sort(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return o1.getString("number").compareTo(o2.getString("number"));
            }
        });
    }

    private List<Long> getWarehouseIds(List<DynamicObject> warehouses) {
        ArrayList<Long> warehouseIds = new ArrayList<Long>(warehouses.size());
        for (DynamicObject warehouse : warehouses) {
            if (warehouse == null || warehouse.getPkValue() == null) continue;
            warehouseIds.add(Long.parseLong(warehouse.getPkValue().toString()));
        }
        return warehouseIds;
    }

    private List<DynamicObject> getWarehouses(Object org, String reportName, boolean isQuery) {
        List<Object> warehouses = new ArrayList<DynamicObject>(16);
        Long userId = UserServiceHelper.getCurrentUserId();
        if (org instanceof DynamicObject) {
            DynamicObject orgObj = (DynamicObject)org;
            Object warehouseIsolate = AppParameterHelper.getAppParameterByFormId((String)reportName, (Long)Long.parseLong(orgObj.getPkValue().toString()), (String)"fwarehouseisolate");
            if (warehouseIsolate instanceof Boolean && ((Boolean)warehouseIsolate).booleanValue()) {
                warehouses = WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId((Long)userId, Collections.singletonList((Long)orgObj.getPkValue()), null);
            }
        } else if (org instanceof DynamicObjectCollection) {
            ArrayList<Long> listOrgId = new ArrayList<Long>();
            for (DynamicObject dynamicObject : (DynamicObjectCollection)org) {
                listOrgId.add(dynamicObject.getLong(isQuery ? "id" : "fbasedataid_id"));
            }
            ParamPublishObject param = ParameterReader.getParameterObject(null, (String)"=9Q86DR2P+Q");
            ArrayList isolateOrgList = new ArrayList(16);
            ArrayList<Long> notIsolateOrgList = new ArrayList<Long>(16);
            WareHouseIsolateHelper.buildIsolateList(listOrgId, isolateOrgList, notIsolateOrgList);
            List<DynamicObject> notIsoWarehouse = WarehouseIsolateRptPlugin.getAllWarehouse(notIsolateOrgList);
            List isoWarehouses = WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId((Long)userId, isolateOrgList, null);
            HashSet<DynamicObject> dynamicObjects = new HashSet<DynamicObject>(notIsoWarehouse);
            dynamicObjects.addAll(isoWarehouses);
            warehouses.addAll(dynamicObjects);
        }
        return warehouses;
    }

    private static List<DynamicObject> getAllWarehouse(List<Long> orgIds) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        if (orgIds == null || orgIds.isEmpty()) {
            return result;
        }
        QFilter orgf = new QFilter("org", "in", (Object)orgIds.toArray());
        orgf.and(new QFilter("startstatus", "=", (Object)"B"));
        Map warehouseDycs = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)"warehouse", (QFilter[])new QFilter[]{orgf});
        for (DynamicObject warehouseSetup : warehouseDycs.values()) {
            result.add(warehouseSetup.getDynamicObject("warehouse"));
        }
        return result;
    }

    private String getOrgKey(String reportName) {
        String orgKey;
        switch (reportName) {
            case "im_invbillsum": 
            case "im_invaccreport": 
            case "im_invbillreport": 
            case "im_measuredeviationadjust": {
                boolean isQueryByOwner = "im_invaccreport".equals(reportName) && "B".equals(this.getView().getModel().getValue("radiogroupfield"));
                orgKey = isQueryByOwner ? "multiorgheadbyowner" : "multiorghead";
                break;
            }
            default: {
                orgKey = "orghead";
            }
        }
        return orgKey;
    }
}

