/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.measureadjust;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.report.common.AnalyseReportConst;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;
import kd.scmc.im.report.helper.OwnerTypeViewHelper;
import kd.scmc.im.report.measureadjust.MeasureDeviationAdjustBeforeF7Select;
import kd.scmc.im.report.measureadjust.MeasureDeviationAdjustPropChanged;
import kd.scmc.im.utils.FormUtils;

public class MeasureDeviationAdjustPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"lotnumberfrom"});
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"multiorghead", "accountownerfrom", "supplierownerfrom", "customerownerfrom", "ownerto", "materialgroupstandard", "materialgroupfrom", "materialgroupto", "materialnumberfrom", "materialnumberto", "warehousefrom", "warehouseto", "locationfrom", "locationto", "projectfrom", "projectto", "invstatushead", "ivntypehead", "configuredcodeto"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        HashMap prop = new HashMap(1);
        HashMap<String, Integer> editor = new HashMap<String, Integer>(1);
        editor.put("maxlength", 8000);
        prop.put("item", editor);
        this.getView().updateControlMetadata("lotnumberfrom", prop);
        OwnerTypeViewHelper.setEnableUI(this.getModel(), (IFormView)this.getView());
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        MeasureDeviationAdjustBeforeF7Select measureDeviationAdjustBeforeF7Select = new MeasureDeviationAdjustBeforeF7Select((IFormView)this.getView());
        measureDeviationAdjustBeforeF7Select.beforeF7Select(e, "multiorghead");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        MeasureDeviationAdjustPropChanged measureDeviationAdjustPropChanged = new MeasureDeviationAdjustPropChanged((IFormView)this.getView());
        measureDeviationAdjustPropChanged.propertyChanged(e);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        queryParam.getFilter().addFilterItem("orgIdsString", this.getView().getFormShowParameter().getCustomParams().get("HasPermissionAndStartedInvOrg"));
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String formid;
        ReportShowParameter showParameter = (ReportShowParameter)e.getSource();
        Map<Boolean, String> hasPermission = ReportCommonFilterOrChangeOp.checkBillPermission(showParameter, formid = showParameter.getFormId());
        if (hasPermission.containsKey(Boolean.FALSE)) {
            e.setCancel(Boolean.TRUE.booleanValue());
            e.setCancelMessage(hasPermission.get(Boolean.FALSE));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ReportCommonFilterOrChangeOp.initOrg(this.getView(), "multiorghead");
        this.getModel().setValue("materialgroupstandard", (Object)AnalyseReportConst.INIT_MATERIALGROUPSTANDARD_ID);
        this.handleResetButtonEvent();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("openformin".equals(operateKey) || "openformout".equals(operateKey)) {
            this.openOtherInOutBill(operateKey);
        }
    }

    private void openOtherInOutBill(String opKey) {
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        int[] selectedRows = reportList.getEntryState().getSelectedRows();
        if (selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u540e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MeasureDeviationAdjustPlugin_0", (String)"scmc-im-report", (Object[])new Object[0]));
            return;
        }
        IReportListModel reportModel = reportList.getReportModel();
        BillShowParameter showParameter = new BillShowParameter();
        DynamicObjectCollection rowDataList = new DynamicObjectCollection();
        DynamicObject row = reportModel.getRowData(selectedRows[0]);
        DynamicObject org = row.getDynamicObject("org");
        if (org == null) {
            return;
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)org.getPkValue()));
        switch (opKey) {
            case "openformin": {
                showParameter = this.adjustIn(reportList, rowDataList, baseDataFilter, showParameter);
                break;
            }
            case "openformout": {
                showParameter = this.adjustOut(reportList, rowDataList, baseDataFilter, showParameter);
                break;
            }
        }
        if (showParameter == null) {
            return;
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private BillShowParameter adjustOut(ReportList reportList, DynamicObjectCollection rowDataList, QFilter baseDataFilter, BillShowParameter showParameter) {
        int[] selectedRows = reportList.getEntryState().getSelectedRows();
        IReportListModel reportModel = reportList.getReportModel();
        for (int rowIndex : selectedRows) {
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            BigDecimal qty = rowData.getBigDecimal("qty");
            BigDecimal baseqty = rowData.getBigDecimal("baseqty");
            BigDecimal qty2nd = rowData.getBigDecimal("qty2nd");
            if (qty.compareTo(BigDecimal.ZERO) <= 0 && baseqty.compareTo(BigDecimal.ZERO) <= 0 && qty2nd.compareTo(BigDecimal.ZERO) <= 0) continue;
            rowDataList.add((Object)rowData);
        }
        if (rowDataList.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bf9\u6570\u91cf\u6216\u57fa\u672c\u6570\u91cf\u6216\u8f85\u52a9\u6570\u91cf\u4e3a\u8d1f\u6570\u7684\u5206\u5f55\u8fdb\u884c\u51fa\u5e93\u8c03\u6574\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MeasureDeviationAdjustPlugin_1", (String)"scmc-im-report", (Object[])new Object[0]));
            return null;
        }
        Map<String, Object> paramMap = this.dealMaterialInvInfo(rowDataList, baseDataFilter, "adjustout");
        paramMap.put("isMeasureAdjust", true);
        paramMap.put("org", this.getModel().getValue("multiorghead"));
        showParameter.setFormId("im_otheroutbill");
        showParameter.setCustomParams(paramMap);
        return showParameter;
    }

    private BillShowParameter adjustIn(ReportList reportList, DynamicObjectCollection rowDataList, QFilter baseDataFilter, BillShowParameter showParameter) {
        int[] selectedRows = reportList.getEntryState().getSelectedRows();
        IReportListModel reportModel = reportList.getReportModel();
        for (int rowIndex : selectedRows) {
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            BigDecimal qty = rowData.getBigDecimal("qty");
            BigDecimal baseQty = rowData.getBigDecimal("baseqty");
            BigDecimal qty2nd = rowData.getBigDecimal("qty2nd");
            if (qty.compareTo(BigDecimal.ZERO) >= 0 && baseQty.compareTo(BigDecimal.ZERO) >= 0 && qty2nd.compareTo(BigDecimal.ZERO) >= 0) continue;
            rowDataList.add((Object)rowData);
        }
        if (rowDataList.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bf9\u6570\u91cf\u6216\u57fa\u672c\u6570\u91cf\u6216\u8f85\u52a9\u6570\u91cf\u4e3a\u6b63\u6570\u7684\u5206\u5f55\u8fdb\u884c\u5165\u5e93\u8c03\u6574\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MeasureDeviationAdjustPlugin_2", (String)"scmc-im-report", (Object[])new Object[0]));
            return null;
        }
        Map<String, Object> paramMap = this.dealMaterialInvInfo(rowDataList, baseDataFilter, "adjustin");
        paramMap.put("isMeasureAdjust", true);
        paramMap.put("org", this.getModel().getValue("multiorghead"));
        showParameter.setFormId("im_otherinbill");
        showParameter.setCustomParams(paramMap);
        return showParameter;
    }

    private Map<String, Object> dealMaterialInvInfo(DynamicObjectCollection rowDataList, QFilter baseDataFilter, String mode) {
        ArrayList<Long> masterIds = new ArrayList<Long>(rowDataList.size());
        for (DynamicObject row : rowDataList) {
            DynamicObject material = row.getDynamicObject("material");
            Long masterId = material.getLong("id");
            masterIds.add(masterId);
        }
        QFilter qFilter = new QFilter("masterid", "in", masterIds);
        qFilter.and(baseDataFilter);
        Map materialDymLoad = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)"id", (QFilter[])qFilter.toArray());
        HashMap<Long, Long> rowIdAndInvIdMap = new HashMap<Long, Long>(materialDymLoad.size());
        for (Map.Entry entry : materialDymLoad.entrySet()) {
            Long masterId = ((DynamicObject)entry.getValue()).getLong("masterid.id");
            rowIdAndInvIdMap.put(masterId, (Long)entry.getKey());
        }
        ArrayList rowParamList = new ArrayList();
        for (DynamicObject rowData : rowDataList) {
            HashMap<String, Object> rowParamMap = new HashMap<String, Object>(32);
            DynamicObject material = rowData.getDynamicObject("material");
            Long rowDataMaterialId = material.getLong("masterid");
            if (rowIdAndInvIdMap.containsKey(rowDataMaterialId)) {
                rowParamMap.put("material", rowIdAndInvIdMap.get(rowDataMaterialId));
            }
            rowParamMap.put("materialmasterid", rowDataMaterialId);
            rowParamMap.put("unit", rowData.get("unit.id"));
            rowParamMap.put("baseunit", rowData.get("baseunit.id"));
            rowParamMap.put("auxpty", rowData.get("auxpty.id"));
            rowParamMap.put("unit2nd", rowData.get("unit2nd.id"));
            BigDecimal qty = rowData.getBigDecimal("qty");
            BigDecimal baseQty = rowData.getBigDecimal("baseqty");
            BigDecimal qty2nd = rowData.getBigDecimal("qty2nd");
            if ("adjustin".equals(mode)) {
                if (qty.compareTo(BigDecimal.ZERO) > 0) {
                    qty = BigDecimal.ZERO;
                }
                if (baseQty.compareTo(BigDecimal.ZERO) > 0) {
                    baseQty = BigDecimal.ZERO;
                }
                if (qty2nd.compareTo(BigDecimal.ZERO) > 0) {
                    qty2nd = BigDecimal.ZERO;
                }
            } else {
                if (qty.compareTo(BigDecimal.ZERO) < 0) {
                    qty = BigDecimal.ZERO;
                }
                if (baseQty.compareTo(BigDecimal.ZERO) < 0) {
                    baseQty = BigDecimal.ZERO;
                }
                if (qty2nd.compareTo(BigDecimal.ZERO) < 0) {
                    qty2nd = BigDecimal.ZERO;
                }
            }
            rowParamMap.put("qty", qty);
            rowParamMap.put("baseqty", baseQty);
            rowParamMap.put("qty2nd", qty2nd);
            rowParamMap.put("lotnum", rowData.get("lotnum"));
            rowParamMap.put("producedate", rowData.get("producedate"));
            rowParamMap.put("expirydate", rowData.get("expirydate"));
            rowParamMap.put("warehouse", rowData.get("warehouse.id"));
            rowParamMap.put("location", rowData.get("location.id"));
            rowParamMap.put("project", rowData.get("project.id"));
            rowParamMap.put("configuredcode", rowData.get("configuredcode.id"));
            rowParamMap.put("tracknumber", rowData.get("tracknumber.id"));
            rowParamMap.put("invtype", rowData.get("invtype.id"));
            rowParamMap.put("invstatus", rowData.get("invstatus.id"));
            rowParamMap.put("ownertype", rowData.get("ownertype"));
            rowParamMap.put("owner", rowData.get("owner.id"));
            rowParamMap.put("keepertype", rowData.get("keepertype"));
            rowParamMap.put("keeper", rowData.get("keeper.id"));
            rowParamList.add(rowParamMap);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("rows", rowParamList);
        return hashMap;
    }

    public void afterSetModelValue(DynamicObject scheme) {
        if (scheme == null) {
            return;
        }
        this.getModel().setValue("multiorghead", scheme.get("multiorghead"));
        DataEntityPropertyCollection dataEntityPropertyCollection = scheme.getDataEntityType().getProperties();
        for (IDataEntityProperty property : dataEntityPropertyCollection) {
            String name = property.getName();
            if ("multiorghead".equals(name)) continue;
            DataChangeHelper.setValue((IDataModel)this.getModel(), (String)name, (Object)scheme.get(name), (boolean)false);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("multiorghead");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"MeasureDeviationAdjustPlugin_3", (String)"scmc-im-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void formatDisplayFilterField(FormatShowFilterEvent e) {
        ReportCommonFilterOrChangeOp.formatDisplayFilterField(e);
    }

    public void click(EventObject evt) {
        TextEdit textEdit;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit && "lotnumberfrom".equals(key = (textEdit = (TextEdit)source).getKey())) {
            this.showLotnumber(key);
        }
    }

    private void showLotnumber(String actionId) {
        IReportView view = this.getView();
        Object value = this.getModel().getValue(actionId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setTargetKey(actionId);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("params", value);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("im_multitext");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (returnDataObj instanceof Map) {
            Map returnData = (Map)returnDataObj;
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replaceAll("\n", ",");
                this.getModel().setValue(actionId, (Object)value);
            }
        }
    }

    private void handleResetButtonEvent() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"materialgroupto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"materialnumberto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"warehouseto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"locationto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"projectto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"lotnumberto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"configuredcodeto"});
    }
}

