/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.measureadjust;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;
import kd.scmc.im.report.helper.ReportGeneralOpHelper;
import kd.scmc.sbs.business.reservation.ReserveHelper;

public class MeasureDeviationAdjustQuery
extends AbstractReportListDataPlugin {
    private String algoKey = ((Object)((Object)this)).getClass().getName();

    public DataSet query(ReportQueryParam queryParam, Object arg1) throws Throwable {
        FilterInfo filterInfo = queryParam.getFilter();
        List<QFilter> qFilters = this.buildInvAccPartFilter(filterInfo);
        DataSet invAccDataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)InvAccConst.getBalTb(), (String)String.join((CharSequence)",", this.buildSelectorAcc()), (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"");
        DataSet materialRelatedDataSet = ReportCommonFilterOrChangeOp.getClassifiedMaterialDataSet(filterInfo, true);
        invAccDataSet = materialRelatedDataSet.leftJoin(invAccDataSet).on("material", "material").select(ReportGeneralOpHelper.addFileds(this.getDataSetFieldArray(invAccDataSet), "group", "materialtype")).finish();
        invAccDataSet = invAccDataSet.filter("org is not null");
        invAccDataSet = ReportCommonFilterOrChangeOp.filterOwner(filterInfo, invAccDataSet);
        invAccDataSet = ReserveHelper.getAvbbaseqty((DataSet)invAccDataSet);
        return invAccDataSet;
    }

    private String[] getDataSetFieldArray(DataSet dataSet) {
        Set<String> fileds = ReportGeneralOpHelper.getDataSetField(dataSet);
        return fileds.toArray(new String[fileds.size()]);
    }

    private List<String> buildSelectorAcc() {
        ArrayList<String> selectorList = new ArrayList<String>();
        Set selectorSet = EntityMetadataCache.getDataEntityType((String)InvAccConst.getBalTb()).getAllFields().keySet();
        selectorList.addAll(selectorSet);
        selectorList.add("'0' as summarytype");
        selectorList.add("id");
        selectorList.add("material.number");
        selectorList.add("material.name as materialnames");
        selectorList.add("warehouse.number");
        return selectorList;
    }

    private List<QFilter> buildInvAccPartFilter(FilterInfo filterInfo) {
        QFilter tracknumberFilter;
        QFilter configuredCodeFilter;
        QFilter projectFilter;
        QFilter lotnumberFilter;
        QFilter locationFilter;
        QFilter warehouseFilter;
        DynamicObjectCollection invStatusHeads;
        DynamicObjectCollection ivnTypeHeads;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        DynamicObject org = (DynamicObject)filterInfo.getValue("multiorghead");
        if (org == null) {
            String orgIdString = (String)filterInfo.getValue("orgIdString");
            List orgIds = SerializationUtils.fromJsonStringToList((String)orgIdString, Long.class);
            qFilters.add(new QFilter("org", "in", (Object)orgIds));
        } else {
            qFilters.add(new QFilter("org", "=", org.getPkValue()));
        }
        String ownerTypehead = filterInfo.getString("ownertypehead");
        if (ownerTypehead != null && !ownerTypehead.trim().equals("")) {
            QFilter ownerTypeFilter = new QFilter("ownertype", "=", (Object)ownerTypehead);
            qFilters.add(ownerTypeFilter);
        }
        if ((ivnTypeHeads = filterInfo.getDynamicObjectCollection("ivntypehead")) != null && ivnTypeHeads.size() > 0) {
            HashSet<Object> ivnTypeIds = new HashSet<Object>();
            for (Iterator ivnType : ivnTypeHeads) {
                ivnTypeIds.add(ivnType.getPkValue());
            }
            QFilter ivnTypeHeadFilter = new QFilter("invtype", "in", ivnTypeIds);
            qFilters.add(ivnTypeHeadFilter);
        }
        if ((invStatusHeads = filterInfo.getDynamicObjectCollection("invstatushead")) != null && invStatusHeads.size() > 0) {
            HashSet<Object> ivnStatusIds = new HashSet<Object>();
            for (DynamicObject invStatus : invStatusHeads) {
                ivnStatusIds.add(invStatus.getPkValue());
            }
            QFilter ivnStatusHeadFilter = new QFilter("invstatus", "in", ivnStatusIds);
            qFilters.add(ivnStatusHeadFilter);
        }
        if ((warehouseFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "warehouse.number", "warehousefrom", "warehouseto")) != null) {
            qFilters.add(warehouseFilter);
        }
        if ((locationFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "location.number", "locationfrom", "locationto")) != null) {
            qFilters.add(locationFilter);
        }
        if ((lotnumberFilter = ReportCommonFilterOrChangeOp.getTextFromToFilter(filterInfo, "lotnum", "lotnumberfrom", "lotnumberto")) != null) {
            qFilters.add(lotnumberFilter);
        }
        if ((projectFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "project.number", "projectfrom", "projectto")) != null) {
            qFilters.add(projectFilter);
        }
        if (null != (configuredCodeFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "configuredcode.number", "configuredcodefrom", "configuredcodeto"))) {
            qFilters.add(configuredCodeFilter);
        }
        if ((tracknumberFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "tracknumber.number", "tracknumberfrom", "tracknumberto")) != null) {
            qFilters.add(tracknumberFilter);
        }
        qFilters.add(this.addMeasureDeviationFilter());
        return qFilters;
    }

    private QFilter addMeasureDeviationFilter() {
        QFilter qFilter11 = new QFilter("unit2nd", "=", (Object)0);
        QFilter qFilter12 = new QFilter("qty", "=", (Object)0).and("baseqty", "<>", (Object)0).or(new QFilter("qty", "<>", (Object)0).and("baseqty", "=", (Object)0));
        qFilter11 = qFilter11.and(qFilter12);
        QFilter qFilter21 = new QFilter("unit2nd", "<>", (Object)0);
        QFilter qFilter22 = new QFilter("qty", "=", (Object)0).and("qty2nd", "<>", (Object)0);
        qFilter22 = qFilter22.or(new QFilter("qty", "<>", (Object)0).and("qty2nd", "=", (Object)0));
        qFilter22 = qFilter22.or(new QFilter("qty", "=", (Object)0).and("baseqty", "<>", (Object)0).and("qty2nd", "=", (Object)0));
        qFilter22 = qFilter22.or(new QFilter("qty", "<>", (Object)0).and("baseqty", "=", (Object)0).and("qty2nd", "<>", (Object)0));
        qFilter21 = qFilter21.and(qFilter22);
        QFilter qFilter31 = new QFilter("qty", ">", (Object)0).and(new QFilter("baseqty", "<", (Object)0).or("qty2nd", "<", (Object)0));
        qFilter31 = qFilter31.or(new QFilter("baseqty", ">", (Object)0).and(new QFilter("qty", "<", (Object)0).or("qty2nd", "<", (Object)0)));
        qFilter31 = qFilter31.or(new QFilter("qty2nd", ">", (Object)0).and(new QFilter("qty", "<", (Object)0).or("baseqty", "<", (Object)0)));
        qFilter11 = qFilter11.or(qFilter21).or(qFilter31);
        return qFilter11;
    }
}

