/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.botp.mdc;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class OmCmplinBill2ApBusBillBotpPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entitys;
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entity : entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString())) {
            DynamicObject dataEntity = entity.getDataEntity();
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                DynamicObject material = entry.getDynamicObject("e_material");
                DynamicObject srcUnit = entry.getDynamicObject("e_baseunit");
                BigDecimal srcQty = entry.getBigDecimal("e_baseunitqty");
                DynamicObject desUnit = entry.getDynamicObject("e_measureunit");
                entry.set("e_quantity", (Object)OmCmplinBill2ApBusBillBotpPlugin.getDesQtyConv(material, srcUnit, srcQty, desUnit));
            }
        }
    }

    public static BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        if (material != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(BigDecimal.ZERO) != 0) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                return srcQty;
            }
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)material.getPkValue()), (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null && muConv.getInt("numerator") != 0) {
                int precision = desUnit.getInt("precision");
                String precisionAccount = desUnit.getString("precisionaccount");
                if (StringUtils.isNotEmpty((CharSequence)precisionAccount)) {
                    int roundingMode = 0;
                    switch (Integer.parseInt(precisionAccount)) {
                        case 1: {
                            roundingMode = 4;
                            break;
                        }
                        case 2: {
                            roundingMode = 1;
                            break;
                        }
                        case 3: {
                            roundingMode = 0;
                            break;
                        }
                        default: {
                            roundingMode = 4;
                        }
                    }
                    return srcQty.multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), precision, roundingMode);
                }
            }
        }
        return BigDecimal.ZERO;
    }
}

