/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.mdc.backflush;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.im.business.mdc.backflush.TailDiffBackFlush;

public class TailDiffBackFlushHelper {
    private static ThreadLocal<Map<Long, List<Map<String, Object>>>> mSrcBillRowMapHolder = new ThreadLocal();
    private static final Log logger = LogFactory.getLog(TailDiffBackFlushHelper.class);

    public static void setSrcBillAutoBFHolderData(List<Map<String, Object>> bfParam) {
        logger.info("setSrcBillAutoBFHolderData begin");
        String entityName = "";
        HashMap<Long, ArrayList<Map>> srcBillRowMap = new HashMap<Long, ArrayList<Map>>(16);
        for (Map<String, Object> objInfo : bfParam) {
            entityName = (String)objInfo.get("billentity");
            Map<String, String> reflectInfoMap = TailDiffBackFlushHelper.getSrcReflectInfo(entityName);
            if (reflectInfoMap.size() <= 0) continue;
            Map objEntryInfo = (Map)objInfo.get("billentry");
            for (Map.Entry entry : objEntryInfo.entrySet()) {
                Map innerMap = (Map)entry.getValue();
                Long orderentryid = (Long)innerMap.get("orderentryid");
                ArrayList<Map> srcBillLst = (ArrayList<Map>)srcBillRowMap.get(orderentryid);
                if (srcBillLst == null) {
                    srcBillLst = new ArrayList<Map>(16);
                }
                srcBillLst.add(innerMap);
                srcBillRowMap.put(orderentryid, srcBillLst);
            }
        }
        mSrcBillRowMapHolder.set(srcBillRowMap);
        logger.info("setSrcBillAutoBFHolderData end");
    }

    public static void clearSrcBillAutoBFHolderData() {
        mSrcBillRowMapHolder.remove();
    }

    public static void excuteAuto(Map<String, Object> judgeResult, HashMap<String, Object> judgeParam, Map<String, Object> backFlushBillParam) {
        logger.info("excuteAuto begin");
        String stockNameObj = String.valueOf(backFlushBillParam.get("stockname"));
        String srcBillentityObj = String.valueOf(backFlushBillParam.get("billentity"));
        if (stockNameObj == null || srcBillentityObj == null) {
            return;
        }
        String srcBillentityStr = String.valueOf(srcBillentityObj);
        String stockNameObjStr = String.valueOf(stockNameObj);
        Map<String, String> reflectInfoMap = TailDiffBackFlushHelper.getSrcReflectInfo(srcBillentityStr);
        new TailDiffBackFlush(stockNameObjStr, reflectInfoMap).caleAutoNowbfqtyTailDiff(mSrcBillRowMapHolder, judgeResult, judgeParam);
        logger.info("excuteAuto end");
    }

    public static void excuteHand(List<DynamicObject> billEntryList, String stockName) {
        logger.info("excuteHand begin");
        Map<String, List<DynamicObject>> srcBillRowsGrp = billEntryList.stream().collect(Collectors.groupingBy(p -> p.getString("sourcebillentry")));
        for (Map.Entry<String, List<DynamicObject>> srcBillRows : srcBillRowsGrp.entrySet()) {
            List<DynamicObject> srcBillRowLst = srcBillRows.getValue();
            String sourcebillVal = srcBillRows.getKey();
            Map<String, String> reflectInfoMap = TailDiffBackFlushHelper.getSrcReflectInfoByVal(sourcebillVal, stockName);
            if (reflectInfoMap == null || stockName == null) continue;
            new TailDiffBackFlush(stockName, reflectInfoMap).caleNowbfqtyTailDiff(srcBillRowLst);
        }
        logger.info("excuteHand end");
    }

    private static Map<String, String> getBillEntitys(String stockName) {
        HashMap<String, String> billentityMap = new HashMap<String, String>(16);
        if (stockName == null) {
            stockName = "";
        }
        billentityMap.put("A", "im_mdc_mftmanuinbill");
        billentityMap.put("B", "pom_mftorderreport");
        billentityMap.put("C", "sfc_processreportbill");
        billentityMap.put("G", "im_mdc_mftreturnbill");
        if (StringUtils.equalsIgnoreCase((CharSequence)stockName, (CharSequence)"om_mftstock")) {
            billentityMap.put("A", "im_mdc_omcmplinbill");
        }
        return billentityMap;
    }

    private static Map<String, String> getSrcReflectInfoByVal(String entityVal, String stockName) {
        Map<String, String> reflectInfoMap = new HashMap<String, String>(16);
        Map<String, String> billEntityMap = TailDiffBackFlushHelper.getBillEntitys(stockName);
        String entityName = billEntityMap.get(entityVal);
        if (entityName != null) {
            reflectInfoMap = TailDiffBackFlushHelper.getSrcReflectInfo(entityName);
        }
        return reflectInfoMap;
    }

    public static Map<String, String> getSrcReflectInfo(String entityName) {
        String sourcebill = "";
        String baseqtyName = "baseqty";
        String entryIdName = "id";
        String mftentryidName = "mftentryid";
        String mftentryidType = "";
        String mftstockName = "pom_mftstock";
        String entryName = "";
        HashMap<String, String> refMap = new HashMap<String, String>(16);
        refMap.put("sourcebillNumber", entityName);
        boolean existSrcReflect = Boolean.TRUE;
        switch (entityName) {
            case "im_mdc_mftmanuinbill": {
                sourcebill = "A";
                baseqtyName = "baseqty";
                mftentryidName = "manuentryid";
                entryName = "billentry";
                break;
            }
            case "pom_mftorderreport": {
                sourcebill = "B";
                baseqtyName = "completbsqty";
                entryName = "sumentry";
                mftentryidType = "String";
                break;
            }
            case "sfc_processreportbill": {
                sourcebill = "C";
                baseqtyName = "completbaseqty";
                mftentryidName = "manufactureentryid";
                entryName = "sumentry";
                break;
            }
            case "im_mdc_mftreturnbill": {
                sourcebill = "G";
                mftentryidName = "manuentryid";
                entryName = "billentry";
                break;
            }
            case "im_mdc_omcmplinbill": {
                sourcebill = "A";
                baseqtyName = "baseqty";
                mftentryidName = "manuentryid";
                entryName = "billentry";
                break;
            }
            case "im_mdc_ominbill": {
                baseqtyName = "baseqty";
                mftentryidName = "mainbillentryid";
                entryName = "billentry";
                break;
            }
            default: {
                existSrcReflect = Boolean.FALSE;
            }
        }
        refMap.put("baseqtyName", baseqtyName);
        refMap.put("entryIdName", entryIdName);
        refMap.put("sourceBill", sourcebill);
        refMap.put("mftstockName", mftstockName);
        refMap.put("mftentryidName", mftentryidName);
        refMap.put("mftentryidType", mftentryidType);
        refMap.put("entryName", entryName);
        if (!existSrcReflect) {
            refMap = new HashMap(16);
        }
        return refMap;
    }
}

