/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.common.mdc.botp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class MdcSettleCurrencyBotpPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(tgtMainType);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject obj = entity.getDataEntity();
            if (obj.getDynamicObject("org") == null) continue;
            orgIds.add(obj.getDynamicObject("org").getLong("id"));
        }
        HashMap currencyMap = new HashMap(16);
        if (CollectionUtils.isNotEmpty(orgIds)) {
            for (Long orgId : orgIds) {
                Map currencyAndExRateMap = CurrencyHelper.getCurrencyAndExRateTable((Long)orgId);
                if (!MapUtils.isNotEmpty((Map)currencyAndExRateMap)) continue;
                currencyMap.put(orgId, currencyAndExRateMap.get("baseCurrencyID"));
            }
        }
        HashSet baseCurrencyIds = new HashSet(currencyMap.values());
        QFilter filter = new QFilter("id", "in", baseCurrencyIds);
        Map bdCurrency = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (QFilter[])new QFilter[]{filter});
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject obj = entity.getDataEntity();
            if (obj.getDynamicObject("org") == null) continue;
            Long currencyId = (Long)currencyMap.get(obj.getDynamicObject("org").getLong("id"));
            obj.set("settlecurrency", bdCurrency.get(currencyId));
        }
    }
}

