/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.common.mdc.helper;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.MatchingRuleOutHelper;
import kd.scmc.im.common.mdc.utils.StockBackFlushUtils;
import org.apache.commons.lang3.StringUtils;

public class InvMatchingRuleOutHelper {
    private static final Log logger = LogFactory.getLog(InvMatchingRuleOutHelper.class);
    private static Map<String, String> cacheMap = new HashMap<String, String>();

    public static Map<String, Object> invAccQueryForMatchingRule(DynamicObjectCollection selectEntrys, Object orgId, String pagecachebfinvqty, Map<Object, List<DynamicObject>> stockBFMap, Map<DynamicObject, String> res) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (selectEntrys.isEmpty() || !(orgId instanceof Long)) {
            result.put("success", false);
            result.put("message", ResManager.loadKDString((String)"\u5206\u5f55\u53c2\u6570\u4e3a\u7a7a\u6216\u8005\u7ec4\u7ec7ID\u4e0d\u4e3aLong\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u3002", (String)"InvMatchingRuleOutHelper_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            logger.info("\u5206\u5f55\u53c2\u6570\u4e3a\u7a7a\u6216\u8005\u7ec4\u7ec7ID\u4e0d\u4e3aLong\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
            return result;
        }
        DynamicObject materialReqOutBill = BusinessDataServiceHelper.newDynamicObject((String)"im_mdc_mftproorder");
        DynamicObjectCollection billEntry = (DynamicObjectCollection)materialReqOutBill.get("billentry");
        result.put("success", true);
        for (DynamicObject entry : selectEntrys) {
            String newMessage;
            int seq = entry.getInt("seq");
            String confirmMsg = InvMatchingRuleOutHelper.matchingRuleOutValidateAlertMsg(entry);
            if (!confirmMsg.isEmpty()) {
                logger.info(String.format("\u7b2c%s\u884c", seq) + confirmMsg);
                int currentSeq = billEntry.size() + 1;
                entry.set("seq", (Object)currentSeq);
                billEntry.add((Object)entry);
                continue;
            }
            Map<String, Object> singleEntryMap = InvMatchingRuleOutHelper.getInsertEntryMap(orgId, entry);
            String message = result.get("message") == null ? "" : result.get("message").toString();
            DynamicObject material = entry.getDynamicObject("material").getDynamicObject("masterid");
            String materialName = material.getString("name");
            String materialNumber = material.getString("number");
            BigDecimal qty = (BigDecimal)singleEntryMap.get("qty");
            BigDecimal invQty = (BigDecimal)singleEntryMap.get("count");
            if ("true".equals(pagecachebfinvqty)) {
                if (invQty.compareTo(BigDecimal.ZERO) <= 0) {
                    result.put("success", false);
                    newMessage = message + String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u6279\u6b21\u5012\u51b2\u7269\u6599\u201c%2$s\u201d\uff08%3$s\uff09\uff0c\u5e93\u5b58\u6570\u91cf\u22640\u3002", (String)"InvMatchingRuleOutHelper_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), seq, materialName, materialNumber);
                    result.put("message", newMessage);
                    logger.info("\u5206\u5f55\u7b2c%s\u884c\u5e93\u5b58\u4e0d\u8db3\u3002");
                } else if (qty.compareTo(invQty) > 0 && res != null) {
                    StockBackFlushUtils.setErr(entry, res, stockBFMap, "E");
                }
            } else if (qty.compareTo(invQty) > 0) {
                result.put("success", false);
                newMessage = message + String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u6279\u6b21\u5012\u51b2\u7269\u6599%2$s\uff08%3$s\uff09\uff0c\u5e93\u5b58\u6570\u91cf\u77ed\u7f3a\uff1b", (String)"InvMatchingRuleOutHelper_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), seq, materialName, materialNumber);
                result.put("message", newMessage);
                logger.info("\u5206\u5f55\u7b2c%s\u884c\u5e93\u5b58\u4e0d\u8db3\u3002");
            }
            InvMatchingRuleOutHelper.buildEntrys(billEntry, entry, singleEntryMap);
        }
        if (((Boolean)result.get("success")).booleanValue()) {
            result.put("success", true);
            result.put("message", ResManager.loadKDString((String)"\u5339\u914d\u89c4\u5219\u51fa\u5e93\u6210\u529f\u3002", (String)"InvMatchingRuleOutHelper_3", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            InvMatchingRuleOutHelper.getWarehouse(billEntry);
            result.put("result", billEntry);
        } else {
            StringBuilder alertMsg = new StringBuilder(result.get("message").toString());
            result.put("message", alertMsg.length() > 0 ? alertMsg.deleteCharAt(alertMsg.length() - 1).append("\u3002").toString() : alertMsg.toString());
        }
        return result;
    }

    private static void getWarehouse(DynamicObjectCollection billEntry) {
        InvMatchingRuleOutHelper.setDynamicObject(billEntry, "warehouse", "bd_warehouse", "status,enable,name,number,isopenlocation,entryentity,entryentity.location");
        InvMatchingRuleOutHelper.setDynamicObject(billEntry, "location", "bd_location", "name,number");
        InvMatchingRuleOutHelper.setDynamicObject(billEntry, "lot", "bd_lot", "number");
    }

    private static void setDynamicObject(DynamicObjectCollection billEntry, String name, String number, String query) {
        HashMap wareHouse = new HashMap(billEntry.size());
        for (DynamicObject billEntryDym : billEntry) {
            wareHouse.put(billEntryDym.get(name) instanceof DynamicObject ? ((Long)((DynamicObject)billEntryDym.get(name)).getPkValue()).longValue() : billEntryDym.getLong(name), null);
        }
        QFilter filter = new QFilter("id", "in", wareHouse.keySet());
        Map loads = BusinessDataServiceHelper.loadFromCache((String)number, (String)query, (QFilter[])new QFilter[]{filter});
        Iterator iterator = billEntry.iterator();
        while (iterator.hasNext()) {
            DynamicObject billEntryDym;
            billEntryDym.set(name, loads.get((billEntryDym = (DynamicObject)iterator.next()).get(name) instanceof DynamicObject ? ((Long)((DynamicObject)billEntryDym.get(name)).getPkValue()).longValue() : billEntryDym.getLong(name)));
        }
    }

    private static String matchingRuleOutValidateAlertMsg(DynamicObject entry) {
        DynamicObject material = entry.getDynamicObject("material");
        if (Objects.isNull(material)) {
            return ResManager.loadKDString((String)"\u7269\u6599\u4e3a\u7a7a", (String)"InvMatchingRuleOutHelper_4", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        }
        String rule = material.getString("outboundrules");
        if (StringUtils.isEmpty((CharSequence)rule)) {
            return ResManager.loadKDString((String)"\u7269\u6599\u672a\u8bbe\u7f6e\u51fa\u5e93\u89c4\u5219\u3002", (String)"InvMatchingRuleOutHelper_5", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        }
        boolean enableLot = material.getBoolean("enablelot");
        boolean enableShelf = material.getBoolean("enableshelflifemgr");
        if (!enableLot && !enableShelf) {
            return ResManager.loadKDString((String)"\u7269\u6599\u672a\u542f\u7528\u201c\u6279\u53f7\u7ba1\u7406\u201d\u548c\u201c\u4fdd\u8d28\u671f\u7ba1\u7406\u201d\uff0c\u65e0\u6cd5\u5339\u914d\u89c4\u5219\u51fa\u5e93\u3002", (String)"InvMatchingRuleOutHelper_6", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        }
        String lotNumber = entry.getString("lotnumber");
        if (StringUtils.isNotEmpty((CharSequence)lotNumber) && enableLot && !enableShelf) {
            return ResManager.loadKDString((String)"\u7269\u6599\u5df2\u542f\u7528\u6279\u53f7\u7ba1\u7406\uff0c\u4f46\u672a\u542f\u7528\u4fdd\u8d28\u671f\u7ba1\u7406\uff0c\u8bf7\u586b\u5199\u5206\u5f55\u6279\u53f7\u3002", (String)"InvMatchingRuleOutHelper_7", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        }
        Object unit = entry.get("unit");
        BigDecimal qty = entry.getBigDecimal("qty");
        Object outInvType = entry.get("outinvtype");
        Object outInvStatus = entry.get("outinvstatus");
        Object outOwnerType = entry.get("outownertype");
        Object outOwner = entry.get("outowner");
        Object outKeeperType = entry.get("outkeepertype");
        Object outKeeper = entry.get("outkeeper");
        StringBuilder alertMsg = new StringBuilder();
        if (null == unit || BigDecimal.ZERO.compareTo(qty) == 0 || null == outInvType || null == outInvStatus || null == outOwnerType || null == outOwner || null == outKeeperType || null == outKeeper) {
            if (null == unit) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"InvMatchingRuleOutHelper_8", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            if (BigDecimal.ZERO.compareTo(qty) == 0) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u6570\u91cf", (String)"InvMatchingRuleOutHelper_9", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            if (null == outInvType) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u5e93\u5b58\u7c7b\u578b", (String)"InvMatchingRuleOutHelper_10", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            if (null == outInvStatus) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u5e93\u5b58\u72b6\u6001", (String)"InvMatchingRuleOutHelper_11", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            if (null == outOwnerType) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u8d27\u4e3b\u7c7b\u578b", (String)"InvMatchingRuleOutHelper_12", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            if (null == outOwner) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u8d27\u4e3b", (String)"InvMatchingRuleOutHelper_13", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            if (null == outKeeperType) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u4fdd\u7ba1\u8005\u7c7b\u578b", (String)"InvMatchingRuleOutHelper_14", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            if (null == outKeeper) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u4fdd\u7ba1\u8005", (String)"InvMatchingRuleOutHelper_15", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            String msg = ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvMatchingRuleOutHelper_16", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            alertMsg.insert(0, msg);
        }
        if (alertMsg.length() > 0) {
            return alertMsg.toString();
        }
        return alertMsg.toString();
    }

    private static void buildEntrys(DynamicObjectCollection billEntry, DynamicObject srcEntry, Map<String, Object> insertEntryInfo) {
        int seq = billEntry.size() + 1;
        List entryInfoList = (List)insertEntryInfo.get("entryInfo");
        int size = entryInfoList.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject newEntry = (DynamicObject)OrmUtils.clone((IDataEntityBase)srcEntry, (boolean)false, (boolean)true);
            InvMatchingRuleOutHelper.clearInvField(newEntry);
            newEntry.set("seq", (Object)seq);
            Map entryInfo = (Map)entryInfoList.get(i);
            newEntry.set("auxpty", entryInfo.get("auxpty"));
            newEntry.set("qty", entryInfo.get("qty"));
            InvMatchingRuleOutHelper.setBaseAuxQty(newEntry);
            Date produceDate = InvMatchingRuleOutHelper.parseDate((String)entryInfo.get("producedate"));
            newEntry.set("producedate", (Object)produceDate);
            Date expiryDate = InvMatchingRuleOutHelper.parseDate((String)entryInfo.get("expirydate"));
            newEntry.set("expirydate", (Object)expiryDate);
            newEntry.set("warehouse", entryInfo.get("warehouse"));
            newEntry.set("location", entryInfo.get("location"));
            newEntry.set("lot", entryInfo.get("lot"));
            newEntry.set("lotnumber", entryInfo.get("lotnumber"));
            newEntry.set("project", entryInfo.get("project"));
            billEntry.add((Object)newEntry);
            ++seq;
        }
    }

    private static void clearInvField(DynamicObject newEntry) {
        newEntry.set("baseqty", (Object)BigDecimal.ZERO);
        newEntry.set("qtyunit2nd", (Object)BigDecimal.ZERO);
    }

    private static void setBaseAuxQty(DynamicObject newEntry) {
        int seq = newEntry.getInt("seq");
        DynamicObject materialInfo = newEntry.getDynamicObject("material");
        if (materialInfo == null) {
            logger.info(String.format("\u7b2c%s\u884c\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u4e3a\u7a7a,\u65e0\u6cd5\u8ba1\u7b97\u57fa\u672c\u6570\u91cf\u548c\u6570\u91cf", seq));
            return;
        }
        DynamicObject material = materialInfo.getDynamicObject("masterid");
        if (material == null) {
            logger.info(String.format("\u7b2c%s\u884c\u7269\u6599\u4e3a\u7a7a,\u65e0\u6cd5\u8ba1\u7b97\u57fa\u672c\u6570\u91cf\u548c\u6570\u91cf", seq));
            return;
        }
        BigDecimal qty = newEntry.getBigDecimal("qty");
        DynamicObject unit = newEntry.getDynamicObject("unit");
        DynamicObject baseUnit = newEntry.getDynamicObject("baseunit");
        if (unit == null || baseUnit == null) {
            logger.info(String.format("\u7b2c%s\u884c\u8ba1\u91cf\u5355\u4f4d\u6216\u57fa\u672c\u5355\u4f4d\u4e3a\u7a7a,\u65e0\u6cd5\u8ba1\u7b97\u57fa\u672c\u6570\u91cf\u548c\u6570\u91cf", seq));
            return;
        }
        BigDecimal baseUnitRate = BillUnitAndQtytHelper.getUnitRateConv((Long)((Long)material.getPkValue()), (Long)((Long)unit.getPkValue()), (Long)((Long)baseUnit.getPkValue()), cacheMap);
        if (baseUnitRate == null || BigDecimal.ZERO.compareTo(baseUnitRate) == 0) {
            logger.info(String.format("\u7b2c%s\u884c\u8ba1\u91cf\u5355\u4f4d-\u57fa\u672c\u5355\u4f4d\u6362\u7b97\u7387\u4e3a\u7a7a\u6216\u8005\u4e3a0", seq));
            return;
        }
        BigDecimal baseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
        newEntry.set("baseqty", (Object)baseQty);
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        if (auxptyUnit == null || BigDecimal.ZERO.compareTo(baseQty) == 0) {
            logger.info(String.format("\u7b2c%s\u884c\u8f85\u52a9\u5355\u4f4d\u4e3a\u7a7a\u6216\u8005\u57fa\u672c\u6570\u91cf\u4e3a0", seq));
            return;
        }
        BigDecimal unit2ndRate = BillUnitAndQtytHelper.getUnitRateConv((Long)((Long)material.getPkValue()), (Long)((Long)auxptyUnit.getPkValue()), (Long)((Long)baseUnit.getPkValue()), cacheMap);
        if (unit2ndRate == null || BigDecimal.ZERO.compareTo(unit2ndRate) == 0) {
            logger.info(String.format("\u7b2c%s\u884c\u57fa\u672c\u5355\u4f4d-\u8f85\u52a9\u5355\u4f4d\u6362\u7b97\u7387\u4e3a\u7a7a\u6216\u8005\u4e3a0", seq));
            return;
        }
        BigDecimal qtyUnit2nd = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxptyUnit);
        newEntry.set("qtyunit2nd", (Object)qtyUnit2nd);
    }

    private static Map<String, Object> getInsertEntryMap(Object orgId, DynamicObject entry) {
        DynamicObject materialInvInfo = entry.getDynamicObject("material");
        String rule = materialInvInfo.getString("outboundrules");
        BigDecimal qty = entry.getBigDecimal("qty");
        Map<String, Object> paramsMap = InvMatchingRuleOutHelper.buildFilterParams(entry);
        paramsMap.put("org", orgId);
        List orderByRule = MatchingRuleOutHelper.getOrderByRule((String)rule);
        ArrayList<QFilter> lotInTrackFilter = new ArrayList<QFilter>(16);
        lotInTrackFilter.add(new QFilter("material", "=", materialInvInfo.getPkValue()));
        lotInTrackFilter.add(new QFilter("org", "=", orgId));
        boolean useLotMainFile = LotMainFileHelper.isUseLotMainFile();
        DataSet lotInTracksSet = MatchingRuleOutHelper.getLotinTracksDataSet(lotInTrackFilter, (boolean)useLotMainFile);
        return MatchingRuleOutHelper.getInsertEntryInfo((DataSet)lotInTracksSet, (BigDecimal)qty, paramsMap, (List)orderByRule, (boolean)true, (String)"im_purinbill", null, null, (boolean)useLotMainFile);
    }

    private static Date parseDate(String dateStr) {
        Date date;
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = sd.parse(dateStr);
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u65e5\u671f\u201d\u8f6c\u6362\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InvMatchingRuleOutHelper_17", (String)"scmc-mm-mdc", (Object[])new Object[0]));
        }
        return date;
    }

    private static Map<String, Object> buildFilterParams(DynamicObject entry) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        DynamicObject auxpty = entry.getDynamicObject("auxpty");
        DynamicObject materialInvInfo = entry.getDynamicObject("material");
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        DynamicObject baseunit = entry.getDynamicObject("baseunit");
        DynamicObject warehouse = entry.getDynamicObject("warehouse");
        DynamicObject locaition = entry.getDynamicObject("location");
        DynamicObject outinvtype = entry.getDynamicObject("outinvtype");
        DynamicObject outinvstatus = entry.getDynamicObject("outinvstatus");
        Object ownertype = entry.get("outownertype");
        DynamicObject owner = entry.getDynamicObject("outowner");
        Object keepertype = entry.get("outkeepertype");
        DynamicObject keeper = entry.getDynamicObject("outkeeper");
        DynamicObject project = entry.getDynamicObject("project");
        DynamicObject unit = entry.getDynamicObject("unit");
        paramsMap.put("material", null == material ? Integer.valueOf(0) : material.getPkValue());
        paramsMap.put("invstatus", null == outinvstatus ? Integer.valueOf(0) : outinvstatus.getPkValue());
        paramsMap.put("baseunit", null == baseunit ? Integer.valueOf(0) : baseunit.getPkValue());
        paramsMap.put("unit", null == unit ? Integer.valueOf(0) : unit.getPkValue());
        if (null != auxpty) {
            paramsMap.put("auxpty", auxpty.getPkValue());
        }
        if (null != warehouse) {
            paramsMap.put("warehouse", warehouse.getPkValue());
        }
        if (null != locaition) {
            paramsMap.put("location", locaition.getPkValue());
        }
        if (null != project) {
            paramsMap.put("project", project.getPkValue());
        }
        paramsMap.put("invtype", null == outinvtype ? Integer.valueOf(0) : outinvtype.getPkValue());
        paramsMap.put("ownertype", ownertype);
        paramsMap.put("owner", null == owner ? Integer.valueOf(0) : owner.getPkValue());
        paramsMap.put("keepertype", keepertype);
        paramsMap.put("keeper", null == keeper ? Integer.valueOf(0) : keeper.getPkValue());
        return paramsMap;
    }
}

