/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.common.mdc.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.LineTypeHelper;
import kd.scmc.im.common.mdc.helper.MdcApplyBillImportHelper;
import kd.scmc.im.formplugin.ImApplyBillPropChanged;
import kd.scmc.im.formplugin.mdc.mftreqbill.MdcApplyBillUtils;
import kd.scmc.im.utils.BigDecimalUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class MdcApplyBillImport {
    private ImportDataEventArgs e;
    private IDataModel model;
    private IFormView view;
    private AbstractFormPlugin plugin;
    private String mftOrderEntityKey;
    private String mftStockEntityKey;
    Map<Long, Set<Long>> warehouseLocationMap = new HashMap<Long, Set<Long>>(16);

    public MdcApplyBillImport(ImportDataEventArgs e, IDataModel model, IFormView view, AbstractFormPlugin plugin) {
        this.e = e;
        this.model = model;
        this.view = view;
        this.plugin = plugin;
    }

    public void doAfterImportData() {
        boolean isOk = this.checkData();
        if (!isOk) {
            return;
        }
        this.initData();
        boolean bizIsOk = this.bizDataCheck();
        if (!bizIsOk) {
            return;
        }
        this.defaultValue();
        this.relationValue();
    }

    private boolean checkData() {
        DynamicObject dataEntity = this.model.getDataEntity();
        Object orgObj = dataEntity.get("org");
        if (MdcApplyBillImportHelper.isEmpty(orgObj)) {
            String err = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7533\u8bf7\u7ec4\u7ec7\u3002", (String)"MdcApplyBillImport_0", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            this.addCancelMessage(err);
            return false;
        }
        return true;
    }

    private void initData() {
        DynamicObject dataEntity = this.model.getDataEntity();
        DynamicObjectCollection billentryColl = dataEntity.getDynamicObjectCollection("billentry");
        HashSet<Long> bd_warehouseIds = new HashSet<Long>(16);
        HashSet<Long> locationIds = new HashSet<Long>(16);
        for (DynamicObject entry : billentryColl) {
            Object locationObj;
            Long locationId;
            Object outwarehouseidObj;
            Long outwarehouseId;
            Object warehouseObj = entry.get("warehouse");
            Long warehouseId = MdcApplyBillImportHelper.getDyObjId(warehouseObj);
            if (!MdcApplyBillImportHelper.isEmpty(warehouseId)) {
                bd_warehouseIds.add(warehouseId);
            }
            if (!MdcApplyBillImportHelper.isEmpty(outwarehouseId = MdcApplyBillImportHelper.getDyObjId(outwarehouseidObj = entry.get("outwarehouseid")))) {
                bd_warehouseIds.add(outwarehouseId);
            }
            if (MdcApplyBillImportHelper.isEmpty(locationId = MdcApplyBillImportHelper.getDyObjId(locationObj = entry.get("location")))) continue;
            locationIds.add(locationId);
        }
        QFilter qfilter = new QFilter("id", "in", bd_warehouseIds);
        qfilter.and(new QFilter("entryentity.location.id", "in", locationIds));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "initData"), (String)"bd_warehouse", (String)"id,entryentity,entryentity.location", (QFilter[])qfilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                Long wareHouseId = next.getLong("id");
                Long locationId = next.get("entryentity.location") == null ? 0L : next.getLong("entryentity.location");
                if (locationId == 0L) continue;
                Set ids = this.warehouseLocationMap.computeIfAbsent(wareHouseId, k -> new HashSet(16));
                ids.add(locationId);
            }
        }
    }

    private boolean bizDataCheck() {
        boolean isOkBizCheck = true;
        DynamicObject dataEntity = this.model.getDataEntity();
        Object billtypeObj = dataEntity.get("billtype");
        if (MdcApplyBillImportHelper.isEmpty(billtypeObj)) {
            this.addCancelMessage(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MdcApplyBillImport_3", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return false;
        }
        Object reqtypeObj = dataEntity.get("reqtype");
        if (MdcApplyBillImportHelper.isEmpty(reqtypeObj)) {
            this.addCancelMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9886\u6599\u7c7b\u578b\u201d\u3002", (String)"MdcApplyBillImport_4", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return false;
        }
        DynamicObject billtype = dataEntity.getDynamicObject("billtype");
        String billtypeNumber = billtype.getString("number");
        if ("im_mdc_mftreqapplybill_BT_S".equals(billtypeNumber) || "im_mdc_omreqapplybill_BT_S".equals(billtypeNumber)) {
            if (!Arrays.asList("A", "B").contains(reqtypeObj)) {
                this.addCancelMessage(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e3a\u9886\u6599\u7533\u8bf7\uff0c\u9886\u6599\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c\u5b9a\u989d\u9886\u6599\u201d\u6216\u201c\u8d85\u989d\u9886\u6599\u201d\u3002", (String)"MdcApplyBillImport_5", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                return false;
            }
        } else if ("im_mdc_mftbackapplybill_BT_S".equals(billtypeNumber)) {
            if (!Arrays.asList("C", "D").contains(reqtypeObj)) {
                this.addCancelMessage(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e3a\u9000\u6599\u7533\u8bf7\uff0c\u9886\u6599\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c\u5b9a\u989d\u9000\u6599\u201d\u6216\u201c\u8d85\u989d\u9000\u6599\u201d\u3002", (String)"MdcApplyBillImport_6", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                return false;
            }
        } else if ("im_mdc_mftfeedapplybill_BT_S".equals(billtypeNumber) && !"E".equals(reqtypeObj)) {
            this.addCancelMessage(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e3a\u8865\u6599\u7533\u8bf7\uff0c\u9886\u6599\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c\u8865\u6599\u201d\u3002", (String)"MdcApplyBillImport_7", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection billentryColl = dataEntity.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : billentryColl) {
            Object outlocationObj;
            Long outlocationId;
            Object outwarehouseidObj;
            Long outwarehouseId;
            Long locationId;
            Object warehouseObj = entry.get("warehouse");
            Object locationObj = entry.get("location");
            Long warehouseId = MdcApplyBillImportHelper.getDyObjId(warehouseObj);
            if (!this.isLegalLocationInWarehouse(warehouseId, locationId = MdcApplyBillImportHelper.getDyObjId(locationObj))) {
                this.addCancelMessage(ResManager.loadKDString((String)"\u4f9b\u8d27\u4ed3\u4f4d\u503c\u4e0d\u5728\u4f9b\u8d27\u4ed3\u5e93\u5bf9\u5e94\u201c\u53ef\u9009\u4ed3\u4f4d\u201d\u7684\u8303\u56f4\u4e4b\u5185,\u8bf7\u4fee\u6539\u3002", (String)"MdcApplyBillImport_8", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                isOkBizCheck = false;
            }
            if (this.isLegalLocationInWarehouse(outwarehouseId = MdcApplyBillImportHelper.getDyObjId(outwarehouseidObj = entry.get("outwarehouseid")), outlocationId = MdcApplyBillImportHelper.getDyObjId(outlocationObj = entry.get("outlocation")))) continue;
            this.addCancelMessage(ResManager.loadKDString((String)"\u8c03\u51fa\u4ed3\u4f4d\u503c\u4e0d\u5728\u8c03\u51fa\u4ed3\u5e93\u5bf9\u5e94\u201c\u53ef\u9009\u4ed3\u4f4d\u201d\u7684\u8303\u56f4\u4e4b\u5185\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MdcApplyBillImport_9", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            isOkBizCheck = false;
        }
        return isOkBizCheck;
    }

    private void defaultValue() {
        DynamicObject bizTypeDyObj;
        Object biztype;
        Long biztypeId;
        DynamicObject bosOrg;
        DynamicObject dataEntity = this.model.getDataEntity();
        Object orgObj = dataEntity.get("org");
        Long orgId = MdcApplyBillImportHelper.getDyObjId(orgObj);
        Object invorgObj = dataEntity.get("invorg");
        if (MdcApplyBillImportHelper.isEmpty(invorgObj) && (bosOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org")).getBoolean("fisinventory")) {
            dataEntity.set("invorg", (Object)bosOrg);
            invorgObj = bosOrg;
        }
        if (MdcApplyBillImportHelper.isEmpty(invorgObj)) {
            String err = ResManager.loadKDString((String)"\u83b7\u53d6\u4e0d\u5230\u201c\u9ed8\u8ba4\u5e93\u5b58\u7ec4\u7ec7\u201d\uff0c\u8bf7\u5bfc\u5165\u5e93\u5b58\u7ec4\u7ec7\u6216\u4fee\u6539\u7533\u8bf7\u7ec4\u7ec7\u7684\u5e93\u5b58\u804c\u80fd\u3002", (String)"MdcApplyBillImport_1", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            this.addCancelMessage(err);
            return;
        }
        Object materialtypeObj = dataEntity.get("materialtype");
        String materialtypeStr = "";
        if (MdcApplyBillImportHelper.isEmpty(materialtypeObj)) {
            String appId = this.view.getFormShowParameter().getAppId();
            if (StringUtils.equals((CharSequence)"pom", (CharSequence)appId)) {
                this.model.setValue("materialtype", (Object)"A");
                materialtypeStr = "A";
            } else if (StringUtils.equals((CharSequence)"om", (CharSequence)appId)) {
                this.model.setValue("materialtype", (Object)"C");
                materialtypeStr = "C";
            }
        } else {
            materialtypeStr = materialtypeObj.toString();
        }
        this.mftOrderEntityKey = MdcApplyBillUtils.getEntityName(materialtypeStr, 0);
        this.mftStockEntityKey = MdcApplyBillUtils.getEntityName(materialtypeStr, 1);
        this.applyUserInit();
        this.initCurrency();
        Object billtypeObj = dataEntity.get("billtype");
        String billTypeNum = "";
        if (billtypeObj instanceof DynamicObject) {
            billTypeNum = ((DynamicObject)billtypeObj).getString("number");
        }
        if ((biztypeId = MdcApplyBillImportHelper.getDyObjId(biztype = dataEntity.get("biztype"))) == null && billtypeObj instanceof DynamicObject && (bizTypeDyObj = BizTypeHelper.getBizTypeByBillType((String)"im_mdc_mftomreqapplybill", (DynamicObject)((DynamicObject)billtypeObj))) != null) {
            dataEntity.set("biztype", (Object)bizTypeDyObj);
            biztypeId = bizTypeDyObj.getLong("id");
        }
        Long defaultLineTypeId = null;
        if (biztypeId != null) {
            defaultLineTypeId = LineTypeHelper.getDefaultLineType((Long)biztypeId);
        }
        DynamicObjectCollection billentryColl = dataEntity.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : billentryColl) {
            PropertyChangedArgs propertyChangedArgs;
            DynamicProperty materialProperty;
            ChangeData[] changeSet;
            int changeIndex = entry.getInt("seq") - 1;
            Object materialObj = entry.get("material");
            Object orderno = entry.get("orderno");
            Object orderentryseqObj = entry.get("orderentryseq");
            Object qtyunit2ndObj = entry.get("qtyunit2nd");
            Object linetypeObj = entry.get("linetype");
            Object qtyObj = entry.get("qty");
            Object backfeedreasonObj = entry.get("backfeedreason");
            if (MdcApplyBillImportHelper.isEmpty(linetypeObj)) {
                entry.set("linetype", (Object)defaultLineTypeId);
            }
            int orderentryseq = 1;
            if (MdcApplyBillImportHelper.isEmpty(orderentryseqObj)) {
                entry.set("orderentryseq", (Object)"1");
            } else {
                orderentryseq = Integer.parseInt(orderentryseqObj.toString());
            }
            if (!StringUtils.isBlank((Object)orderno)) {
                QFilter filter = new QFilter("billno", "=", orderno);
                filter.and(MdcApplyBillUtils.getOrderQFilter(this.model));
                filter.and(new QFilter("treeentryentity.planstatus", "=", (Object)"C"));
                filter.and(new QFilter("transactiontype.isoffreqallowed", "=", (Object)true));
                String sels = "treeentryentity,treeentryentity.id,treeentryentity.producttype,treeentryentity.material";
                DynamicObject order = BusinessDataServiceHelper.loadSingle((String)this.mftOrderEntityKey, (String)sels, (QFilter[])new QFilter[]{filter});
                if (order == null) {
                    this.addCancelMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u5de5\u5355\u53f7\uff0c\u5de5\u5355\u53ef\u9009\u6761\u4ef6\u4e3a\u201c\u5141\u8bb8\u7ec4\u4ef6\u6e05\u5355\u5916\u9886\u9000\u6599=\u662f \u751f\u4ea7\u7ec4\u7ec7=\u7533\u8bf7\u7ec4\u7ec7 \u72b6\u6001=\u5ba1\u6838 \u4ea7\u54c1\u7c7b\u578b=\u4e3b\u4ea7\u54c1 \u4e1a\u52a1\u72b6\u6001=\u6b63\u5e38 \u8ba1\u5212\u72b6\u6001=\u4e0b\u8fbe \u4efb\u52a1\u72b6\u6001=\u672a\u5f00\u5de5/\u5f00\u5de5/\u90e8\u5206\u5b8c\u5de5 \u9879\u76ee\u53f7=\u9879\u76ee\u53f7(\u53ef\u9009)\u201d\u3002", (String)"MdcApplyBillImport_10", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection entrys = order.getDynamicObjectCollection("treeentryentity");
                if (orderentryseq > entrys.size()) {
                    this.addCancelMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u5de5\u5355\u884c\u53f7\u3002", (String)"MdcApplyBillImport_2", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                    return;
                }
                String stockSels = "orderno,orderid,orderentryid,billno,billtype,tracknumber,bdproject";
                QFilter[] stockQf = new QFilter[]{new QFilter("orderentryid", "=", ((DynamicObject)entrys.get(orderentryseq - 1)).getPkValue())};
                DynamicObject stockdym = BusinessDataServiceHelper.loadSingle((String)this.mftStockEntityKey, (String)stockSels, (QFilter[])stockQf);
                MdcApplyBillUtils.setStockInfo(stockdym, changeIndex, this.model);
                this.setReworkFlag(this.model.getValue("material", changeIndex), entrys, changeIndex);
            } else {
                MdcApplyBillUtils.setStockInfo(null, changeIndex, this.model);
            }
            ImApplyBillPropChanged imApplyBillPropChanged = new ImApplyBillPropChanged(this.view, this.plugin);
            if (materialObj != null) {
                QFilter filter;
                DynamicObject order;
                changeSet = new ChangeData[]{new ChangeData(changeIndex, dataEntity, null, materialObj)};
                materialProperty = entry.getDynamicObjectType().getProperty("material");
                propertyChangedArgs = new PropertyChangedArgs((IDataEntityProperty)materialProperty, changeSet);
                imApplyBillPropChanged.propertyChanged(propertyChangedArgs);
                this.setSupplyDefalut(changeIndex);
                Object orderentryid = this.model.getValue("orderentryid", changeIndex);
                if (ObjectUtils.isNotEmpty((Object)orderentryid) && null != (order = BusinessDataServiceHelper.loadSingle((String)this.mftOrderEntityKey, (String)"treeentryentity,treeentryentity.id,treeentryentity.producttype,treeentryentity.material", (QFilter[])new QFilter[]{filter = new QFilter("treeentryentity.id", "=", orderentryid)}))) {
                    DynamicObjectCollection entrys = order.getDynamicObjectCollection("treeentryentity");
                    this.setReworkFlag(materialObj, entrys, changeIndex);
                }
                this.model.setValue("mversion", null, changeIndex);
            }
            if (qtyObj != null) {
                this.model.setValue("qty", qtyObj, changeIndex);
                changeSet = new ChangeData[]{new ChangeData(changeIndex, dataEntity, null, qtyObj)};
                materialProperty = entry.getDynamicObjectType().getProperty("qty");
                propertyChangedArgs = new PropertyChangedArgs((IDataEntityProperty)materialProperty, changeSet);
                imApplyBillPropChanged.propertyChanged(propertyChangedArgs);
            }
            this.setBizQtyAndUnit(changeIndex);
            if (!"im_mdc_mftbackapplybill_BT_S".equals(billTypeNum)) continue;
            if (backfeedreasonObj == null) {
                String errStr = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e3a\u201c\u751f\u4ea7\u9000\u6599\u7533\u8bf7\u201d,\u7b2c%1$s\u884c\u5206\u5f55\u7684\u201c\u9000\u6599\u539f\u56e0\u201d\u5fc5\u586b\u3002", (String)"MdcApplyBillImport_11", (String)"scmc-mm-mdc", (Object[])new Object[0]), changeIndex + 1);
                this.addCancelMessage(errStr);
                continue;
            }
            DynamicObject backfeedreasonDyObj = (DynamicObject)backfeedreasonObj;
            String groupattribute = (backfeedreasonDyObj = BusinessDataServiceHelper.loadSingleFromCache((Object)backfeedreasonDyObj.getPkValue(), (String)"mpdm_feedreason")).getString("group.groupattribute");
            if ("A".equals(groupattribute)) continue;
            String errStr = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e3a\u751f\u4ea7\u9000\u6599\u7533\u8bf7,\u7b2c%1$s\u884c\u5206\u5f55\u9000\u6599\u539f\u56e0\u7684\u5206\u7ec4\u5c5e\u6027\u5fc5\u987b\u4e3a\u201c\u9000\u6599\u201d\u3002", (String)"MdcApplyBillImport_12", (String)"scmc-mm-mdc", (Object[])new Object[0]), changeIndex + 1);
            this.addCancelMessage(errStr);
        }
    }

    private void relationValue() {
    }

    private void addCancelMessage(String errmsg) {
        this.e.setCancel(true);
        this.e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), errmsg);
    }

    private void applyUserInit() {
        Object applyOrgObj = this.model.getValue("org");
        if (applyOrgObj == null) {
            return;
        }
        Long applyOrgId = MdcApplyBillImportHelper.getDyObjId(applyOrgObj);
        Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)applyOrgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        Object settleOrgId = null;
        if (map != null) {
            settleOrgId = map.get("id");
        }
        this.model.setValue("accountorg", settleOrgId);
        long userId = UserServiceHelper.getCurrentUserId();
        QFilter qFilter = new QFilter("id", "=", (Object)userId);
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (QFilter[])new QFilter[]{qFilter});
        List<Long> union = this.getUserDeptAndOrgDeptUnion(user, applyOrgId);
        this.model.setValue("applyuser", (Object)user);
        if (CollectionUtils.isNotEmpty(union)) {
            this.model.setValue("applydept", (Object)union.get(0));
        } else {
            this.model.setValue("applydept", null);
        }
    }

    private List<Long> getUserDeptAndOrgDeptUnion(DynamicObject applyUser, Long applyOrgId) {
        List orgDepts = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(applyOrgId), (boolean)true);
        DynamicObjectCollection deptList = applyUser.getDynamicObjectCollection("entryentity");
        ArrayList<Long> deptId = new ArrayList<Long>();
        for (DynamicObject dept : deptList) {
            Boolean isPartJob = dept.getBoolean("ispartjob");
            DynamicObject dpt = dept.getDynamicObject("dpt");
            if (dpt == null) continue;
            Long id = dpt.getLong("id");
            if (!CollectionUtils.isEmpty((Collection)orgDepts) && !orgDepts.contains(id)) continue;
            if (isPartJob.booleanValue()) {
                deptId.add(id);
                continue;
            }
            deptId.add(0, id);
        }
        return deptId;
    }

    private void initCurrency() {
        DynamicObject org = (DynamicObject)this.model.getValue("org");
        if (org == null) {
            this.model.setValue("settlecurrency", null);
            return;
        }
        Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)org.getLong("id"));
        if (map == null) {
            this.model.setValue("settlecurrency", null);
            return;
        }
        this.model.setValue("settlecurrency", map.get("baseCurrencyID"));
    }

    private void setSupplyDefalut(int changeIndex) {
        String supplymode = (String)this.model.getValue("supplymode", changeIndex);
        DynamicObject invorg = (DynamicObject)this.model.getValue("invorg");
        if ("bos_org".equals(supplymode) && invorg != null) {
            Long orgId = (Long)invorg.getPkValue();
            List<Object> ownerArray = MdcApplyBillUtils.getOwners(orgId);
            if (!ownerArray.isEmpty()) {
                this.model.setValue("supplierid", ownerArray.get(0), changeIndex);
            } else if (((Boolean)invorg.get("fisaccounting")).booleanValue()) {
                this.model.setValue("supplierid", (Object)invorg, changeIndex);
            }
        }
    }

    private void setReworkFlag(Object obj, DynamicObjectCollection entrys, int changeIndex) {
        if (ObjectUtils.isEmpty((Object)obj)) {
            return;
        }
        DynamicObject material = (DynamicObject)obj;
        long reqMaterId = material.getDynamicObject("masterid").getLong("id");
        for (DynamicObject order : entrys) {
            if (!StringUtils.equals((CharSequence)"C", (CharSequence)order.getString("producttype")) || reqMaterId != order.getDynamicObject("material").getDynamicObject("masterid").getLong("id")) continue;
            this.model.setValue("rework", (Object)true);
        }
    }

    private void setBizQtyAndUnit(int changeIndex) {
        DynamicObject materialInvInfo = (DynamicObject)this.model.getValue("material", changeIndex);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        BigDecimal auditqty = (BigDecimal)this.model.getValue("auditqty", changeIndex);
        BigDecimal qty = (BigDecimal)this.model.getValue("qty", changeIndex);
        DynamicObject baseUnit = (DynamicObject)this.model.getValue("baseunit", changeIndex);
        BigDecimal auditbaseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)((DynamicObject)this.model.getValue("unit", changeIndex)), (BigDecimal)auditqty, (DynamicObject)baseUnit);
        BigDecimal baseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)((DynamicObject)this.model.getValue("unit", changeIndex)), (BigDecimal)qty, (DynamicObject)baseUnit);
        BigDecimalUtils.showBigDecimalErrorTip((IDataModel)this.model, (BigDecimal)auditbaseQty, (String)"auditbaseqty");
        BigDecimalUtils.showBigDecimalErrorTip((IDataModel)this.model, (BigDecimal)baseQty, (String)"auditbaseqty");
        this.model.beginInit();
        this.model.setValue("auditbaseqty", (Object)auditbaseQty, changeIndex);
        this.model.setValue("baseqty", (Object)baseQty, changeIndex);
        this.model.setValue("unpickqty", (Object)auditqty.subtract((BigDecimal)this.model.getValue("useoutqty", changeIndex)), changeIndex);
        this.model.setValue("unpickbaseqty", (Object)auditbaseQty.subtract((BigDecimal)this.model.getValue("useoutbaseqty", changeIndex)), changeIndex);
        this.model.endInit();
    }

    private boolean isLegalLocationInWarehouse(Long warehouseId, Long locationId) {
        if (MdcApplyBillImportHelper.isEmpty(locationId)) {
            return true;
        }
        if (MdcApplyBillImportHelper.isEmpty(warehouseId)) {
            return MdcApplyBillImportHelper.isEmpty(locationId);
        }
        Set<Long> locationList = this.warehouseLocationMap.get(warehouseId);
        return locationList != null && locationList.contains(locationId);
    }
}

