/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.common.mdc.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.common.mdc.helper.ImLockHelper;

public class OmOrderBookDateHelper {
    private Set<Long> orderids;
    private Set<Long> orderEntryids;
    private Map<Long, DynamicObject> orderBills;
    private Map<String, DLock> dLocks;
    private DynamicObject[] bizBills;
    private String orderEntity;
    private String bizEntryName;
    private String orderFiledName;
    private String orderEntryFiledName;

    public OmOrderBookDateHelper() {
    }

    public OmOrderBookDateHelper(DynamicObject[] bizBills, String orderEntity, String bizEntryName, String orderFiledName, String orderEntryFiledName) {
        this.bizBills = bizBills;
        this.orderEntity = orderEntity;
        this.bizEntryName = bizEntryName;
        this.orderFiledName = orderFiledName;
        this.orderEntryFiledName = orderEntryFiledName;
        this.orderids = new HashSet<Long>(16);
        this.orderEntryids = new HashSet<Long>(16);
        this.orderBills = new HashMap<Long, DynamicObject>(16);
        this.querOrderBill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOrderBookDateByBizBill() {
        try {
            if (this.orderBills == null || this.orderBills.size() < 1 || this.bizBills == null || this.bizBills.length < 1) {
                return;
            }
            HashSet<DynamicObject> updateData = new HashSet<DynamicObject>(this.bizBills.length);
            HashSet<Long> updateEntryids = new HashSet<Long>(this.bizBills.length);
            HashSet<Long> updateOrderids = new HashSet<Long>(this.bizBills.length);
            HashSet<Long> updateSplitEntryids = new HashSet<Long>(this.bizBills.length);
            HashSet<Long> updateSplitOrderids = new HashSet<Long>(this.bizBills.length);
            Map<Long, Date> minbookDateMap = this.getMinBeginBookDateMap();
            for (DynamicObject bizBill : this.bizBills) {
                Date bookdate = bizBill.getDate("bookdate");
                DynamicObjectCollection bizEntrys = bizBill.getDynamicObjectCollection(this.bizEntryName);
                for (DynamicObject bizEntry : bizEntrys) {
                    DynamicObject orderBill;
                    Object o = bizEntry.get(this.orderFiledName);
                    Long orderid = 0L;
                    if (o instanceof DynamicObject) {
                        orderid = ((DynamicObject)o).getLong("id");
                    } else if (o instanceof Long) {
                        orderid = (Long)o;
                    }
                    if (orderid == null || orderid.equals(0L) || (orderBill = this.orderBills.get(orderid)) == null) continue;
                    DynamicObjectCollection treeentryentitys = orderBill.getDynamicObjectCollection("treeentryentity");
                    for (DynamicObject treeentryentity : treeentryentitys) {
                        Date bookdateMin;
                        Long entryid = treeentryentity.getLong("id");
                        Long pid = treeentryentity.getLong("pid");
                        if (!this.orderEntryids.contains(entryid) && !this.orderEntryids.contains(pid)) continue;
                        Date beginbookdate = treeentryentity.getDate("beginbookdate");
                        if (beginbookdate == null && (bookdateMin = minbookDateMap.get(orderid)) != null) {
                            bookdate = bookdateMin;
                        }
                        if (beginbookdate != null && !beginbookdate.after(bookdate)) continue;
                        treeentryentity.set("beginbookdate", (Object)bookdate);
                        updateData.add(orderBill);
                        updateEntryids.add(entryid);
                        updateOrderids.add(orderid);
                        if (this.orderEntryids.contains(pid)) continue;
                        updateSplitEntryids.add(entryid);
                        updateSplitOrderids.add(orderid);
                    }
                }
            }
            if (updateData.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])updateData.toArray(new DynamicObject[updateData.size()]));
            }
            if (updateEntryids.size() > 0) {
                if (StringUtils.equals((CharSequence)"pom_mftorder", (CharSequence)this.getOrderEntity())) {
                    this.updateSplitLog(updateSplitEntryids, updateSplitOrderids);
                    this.updateChangeLog("pom_xmftorderlog", updateEntryids, updateOrderids);
                } else if (StringUtils.equals((CharSequence)"om_mftorder", (CharSequence)this.getOrderEntity())) {
                    this.updateChangeLog("om_xmftorderlog", updateEntryids, updateOrderids);
                }
            }
        }
        finally {
            if (this.dLocks != null && !this.dLocks.isEmpty()) {
                ArrayList<DLock> unLocks = new ArrayList<DLock>(this.dLocks.size());
                for (Map.Entry<String, DLock> stringDLockEntry : this.dLocks.entrySet()) {
                    if (stringDLockEntry.getValue() == null) continue;
                    unLocks.add(stringDLockEntry.getValue());
                }
                ImLockHelper.unDLocks(unLocks);
            }
        }
    }

    private void updateSplitLog(Set<Long> updateEntryids, Set<Long> updateOrderids) {
        DynamicObject[] splitlogs;
        if (updateEntryids == null || updateOrderids == null || updateEntryids.size() < 1 || updateOrderids.size() < 1) {
            return;
        }
        HashSet<DynamicObject> splitlogUpdateData = new HashSet<DynamicObject>(updateOrderids.size());
        QFilter qf = new QFilter("orderid", "in", updateOrderids);
        qf.and(new QFilter("orderentryid", "in", updateEntryids));
        for (DynamicObject splitlog : splitlogs = BusinessDataServiceHelper.load((String)"pom_mftorder_splitlog", (String)"orderid,orderentryid,billentry,billentry.beginbookdate", (QFilter[])qf.toArray())) {
            Date beginbookdate;
            long orderid = splitlog.getLong("orderid");
            DynamicObject orderBill = this.orderBills.get(orderid);
            if (orderBill == null) continue;
            Long odentryid = 0L;
            DynamicObject orderentryid = splitlog.getDynamicObject("orderentryid");
            if (orderentryid != null) {
                odentryid = Long.parseLong(orderentryid.getPkValue().toString());
            }
            if ((beginbookdate = this.getOrderBeginBookDate(orderBill, odentryid)) == null) continue;
            DynamicObjectCollection billentrys = splitlog.getDynamicObjectCollection("billentry");
            for (DynamicObject billentry : billentrys) {
                Object beginbookdate1 = billentry.get("beginbookdate");
                if (beginbookdate1 != null) continue;
                billentry.set("beginbookdate", (Object)beginbookdate);
                splitlogUpdateData.add(splitlog);
            }
        }
        if (splitlogUpdateData.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])splitlogUpdateData.toArray(new DynamicObject[splitlogUpdateData.size()]));
        }
    }

    private void updateChangeLog(String changeLongEntity, Set<Long> updateEntryids, Set<Long> updateOrderids) {
        DynamicObject[] changelogs;
        if (updateEntryids == null || updateOrderids == null || updateEntryids.size() < 1 || updateOrderids.size() < 1) {
            return;
        }
        HashSet<DynamicObject> changelogUpdateData = new HashSet<DynamicObject>(updateOrderids.size());
        QFilter qf = new QFilter("srcbillid", "in", updateOrderids);
        qf.and(new QFilter("srcbillentryid", "in", updateEntryids));
        for (DynamicObject changelog : changelogs = BusinessDataServiceHelper.load((String)changeLongEntity, (String)"srcbillid,srcbillentryid,beginbookdate", (QFilter[])qf.toArray())) {
            Object beginbookdateObj;
            Long odentryid;
            Date beginbookdate;
            long orderid = changelog.getLong("srcbillid");
            DynamicObject orderBill = this.orderBills.get(orderid);
            if (orderBill == null || (beginbookdate = this.getOrderBeginBookDate(orderBill, odentryid = Long.valueOf(changelog.getLong("srcbillentryid")))) == null || (beginbookdateObj = changelog.get("beginbookdate")) != null) continue;
            changelog.set("beginbookdate", (Object)beginbookdate);
            changelogUpdateData.add(changelog);
        }
        if (changelogUpdateData.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])changelogUpdateData.toArray(new DynamicObject[changelogUpdateData.size()]));
        }
    }

    private Date getOrderBeginBookDate(DynamicObject orderBill, Long odentryid) {
        if (orderBill == null || odentryid == null) {
            return null;
        }
        Date beginbookdate = null;
        DynamicObjectCollection treeentryentitys = orderBill.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject treeentryentity : treeentryentitys) {
            Long entryid = treeentryentity.getLong("id");
            if (!odentryid.equals(entryid)) continue;
            beginbookdate = treeentryentity.getDate("beginbookdate");
        }
        return beginbookdate;
    }

    private Map<Long, Date> getMinBeginBookDateMap() {
        HashMap<Long, Date> orderBeginDateMap = new HashMap<Long, Date>(16);
        for (DynamicObject bizBill : this.bizBills) {
            Date bookdate = bizBill.getDate("bookdate");
            DynamicObjectCollection bizEntrys = bizBill.getDynamicObjectCollection(this.bizEntryName);
            for (DynamicObject bizEntry : bizEntrys) {
                Date bookdateOld;
                Long orderid = 0L;
                Object o = bizEntry.get(this.orderFiledName);
                if (o instanceof DynamicObject) {
                    orderid = ((DynamicObject)o).getLong("id");
                } else if (o instanceof Long) {
                    orderid = (Long)o;
                }
                if (orderid == null || orderid.equals(0L) || (bookdateOld = (Date)orderBeginDateMap.get(orderid)) != null && !bookdateOld.after(bookdate)) continue;
                orderBeginDateMap.put(orderid, bookdate);
            }
        }
        return orderBeginDateMap;
    }

    private void querOrderBill() {
        String orderFiledName = this.getOrderFiledName();
        String orderEntryFiledName = this.getOrderEntryFiledName();
        if (this.bizBills == null || this.bizBills.length < 1 || StringUtils.isEmpty((CharSequence)orderFiledName) || StringUtils.isEmpty((CharSequence)orderEntryFiledName)) {
            return;
        }
        String orderEntityName = this.getOrderEntity();
        if (StringUtils.isEmpty((CharSequence)orderEntityName)) {
            return;
        }
        HashSet<Long> queryorderEntryids = new HashSet<Long>(10);
        for (DynamicObject bizBill : this.bizBills) {
            DynamicObjectCollection bizEntrys = bizBill.getDynamicObjectCollection(this.bizEntryName);
            for (DynamicObject bizEntry : bizEntrys) {
                String producttype;
                if (bizEntry.containsProperty("producttype") && !StringUtils.equals((CharSequence)"C", (CharSequence)(producttype = bizEntry.getString("producttype")))) continue;
                Object o = bizEntry.get(orderFiledName);
                Long orderid = 0L;
                if (o instanceof DynamicObject) {
                    orderid = ((DynamicObject)o).getLong("id");
                } else if (o instanceof Long) {
                    orderid = (Long)o;
                }
                if (orderid == null || orderid.equals(0L)) {
                    return;
                }
                this.orderids.add(orderid);
                Object orderEntry = bizEntry.get(orderEntryFiledName);
                Long orderEntryid = 0L;
                if (orderEntry instanceof DynamicObject) {
                    orderEntryid = ((DynamicObject)orderEntry).getLong("id");
                } else if (orderEntry instanceof Long) {
                    orderEntryid = (Long)orderEntry;
                }
                if (orderEntryid == null || orderEntryid.equals(0L)) {
                    return;
                }
                queryorderEntryids.add(orderEntryid);
            }
        }
        if (this.orderids != null && !this.orderids.isEmpty()) {
            HashSet<String> lockKeys = new HashSet<String>(this.bizBills.length);
            for (Long orderentryid : queryorderEntryids) {
                lockKeys.add("updateorderdbookdate/" + orderentryid.toString());
            }
            Map<String, DLock> createdLocks = ImLockHelper.createDLocks(lockKeys, false);
            try {
                this.dLocks = ImLockHelper.tryDLocks(createdLocks, 100L);
                if (this.dLocks != null && this.dLocks.size() > 0) {
                    DynamicObject[] orders;
                    for (String successdLock : this.dLocks.keySet()) {
                        String[] split = successdLock.split("/");
                        this.orderEntryids.add(Long.valueOf(split[1]));
                    }
                    QFilter filters = new QFilter("id", "in", this.orderids);
                    for (DynamicObject order : orders = BusinessDataServiceHelper.load((String)orderEntityName, (String)this.getOrderSelecors(), (QFilter[])filters.toArray())) {
                        this.orderBills.put(order.getLong("id"), order);
                    }
                }
            }
            catch (Exception e) {
                if (createdLocks != null && createdLocks.size() > 0) {
                    ImLockHelper.unDLocks(new ArrayList<DLock>(createdLocks.values()));
                }
                throw e;
            }
        }
    }

    private String getOrderSelecors() {
        StringBuilder fileds = new StringBuilder(200);
        fileds.append("billno");
        fileds.append(",treeentryentity");
        fileds.append(",treeentryentity.pid");
        fileds.append(",treeentryentity.beginbookdate");
        fileds.append(",treeentryentity.closebookdate");
        return fileds.toString();
    }

    public DynamicObject[] getBizBill() {
        return this.bizBills;
    }

    public void setBizBill(DynamicObject[] bizBills) {
        this.bizBills = bizBills;
    }

    public String getOrderEntity() {
        return this.orderEntity;
    }

    public void setOrderEntity(String orderEntity) {
        this.orderEntity = orderEntity;
    }

    public String getBizEntryName() {
        return this.bizEntryName;
    }

    public void setBizEntryName(String bizEntryName) {
        this.bizEntryName = bizEntryName;
    }

    public String getOrderFiledName() {
        return this.orderFiledName;
    }

    public void setOrderFiledName(String orderFiledName) {
        this.orderFiledName = orderFiledName;
    }

    public String getOrderEntryFiledName() {
        return this.orderEntryFiledName;
    }

    public void setOrderEntryFiledName(String orderEntryFiledName) {
        this.orderEntryFiledName = orderEntryFiledName;
    }
}

