/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.common.mdc.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.helper.api.InvRealAccQueryService;
import kd.scmc.im.business.mdc.backflush.TailDiffBackFlushHelper;
import kd.scmc.im.common.mdc.utils.StockBackFlushUtils;
import org.apache.commons.lang.StringUtils;

public class AutoBackFlushUtils {
    private static final String KEY_BILLENTITY = "billentity";
    private static Log logger = LogFactory.getLog(AutoBackFlushUtils.class);

    private AutoBackFlushUtils() {
    }

    public static Map<Long, String> backFlushbatchTX(List<Map<String, Object>> bfParam, boolean isOpenTX) {
        return AutoBackFlushUtils.backFlushbatch(bfParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, String> backFlushbatch(List<Map<String, Object>> bfParam) {
        HashMap<Long, String> bfRes = new HashMap<Long, String>(16);
        try {
            TailDiffBackFlushHelper.setSrcBillAutoBFHolderData(bfParam);
            for (Map<String, Object> objInfo : bfParam) {
                String backFlushRes;
                try {
                    backFlushRes = AutoBackFlushUtils.autoBackFlush(objInfo);
                }
                catch (KDBizException e1) {
                    logger.error((Throwable)e1);
                    backFlushRes = e1.getMessage();
                }
                String oldRes = (String)bfRes.get((Long)objInfo.get("id"));
                if (oldRes != null) {
                    bfRes.put((Long)objInfo.get("id"), oldRes + backFlushRes);
                    continue;
                }
                bfRes.put((Long)objInfo.get("id"), backFlushRes);
            }
        }
        finally {
            TailDiffBackFlushHelper.clearSrcBillAutoBFHolderData();
        }
        return bfRes;
    }

    private static void batchUpdateBFStatus(List<Map<String, Object>> bfParam) {
        ArrayList<Object> entryIdList = new ArrayList<Object>(10);
        String entityName = "";
        for (Map<String, Object> objInfo : bfParam) {
            entityName = (String)objInfo.get(KEY_BILLENTITY);
            Map objEntryInfo = (Map)objInfo.get("billentry");
            for (Map.Entry entry : objEntryInfo.entrySet()) {
                entryIdList.add(entry.getKey());
            }
        }
        AutoBackFlushUtils.updateBFStatusByEntryId(entryIdList, entityName);
    }

    public static void updateBFStatusByEntryId(List<Object> entryIdList, String entityName) {
        HashSet updateSet = Sets.newHashSet((Object[])new String[]{"im_mdc_mftmanuinbill", "pom_mftorderreport", "sfc_processreportbill", "im_mdc_mftreturnbill", "prop_mftorderreport", "prop_processreportbill"});
        if (!updateSet.contains(entityName)) {
            return;
        }
        String selectString = "id,billno";
        String sourcebill = "A";
        String baseqtyName = "billentry.baseqty";
        String entryIdName = "billentry.id";
        if (entityName.equals("im_mdc_mftmanuinbill")) {
            selectString = StockBackFlushUtils.getMftInBillSelects();
        } else if (entityName.equals("pom_mftorderreport")) {
            selectString = StockBackFlushUtils.getMftOrderReportSelects();
            entryIdName = "sumentry.id";
            sourcebill = "B";
            baseqtyName = "sumentry.completbsqty";
        } else if (entityName.equals("sfc_processreportbill")) {
            selectString = StockBackFlushUtils.getSfcReportSelects();
            entryIdName = "sumentry.id";
            sourcebill = "C";
            baseqtyName = "sumentry.completbaseqty";
        } else if (entityName.equals("im_mdc_mftreturnbill")) {
            sourcebill = "G";
            selectString = StockBackFlushUtils.getMftInBillSelects();
        } else if (entityName.equals("prop_mftorderreport")) {
            selectString = StockBackFlushUtils.getMftOrderReportSelects();
            entryIdName = "sumentry.id";
            sourcebill = "H";
            baseqtyName = "sumentry.completbsqty";
        } else if (entityName.equals("prop_processreportbill")) {
            selectString = StockBackFlushUtils.getSfcReportSelects();
            entryIdName = "sumentry.id";
            sourcebill = "I";
            baseqtyName = "sumentry.completbaseqty";
        }
        List<Long> entryIds = entryIdList.stream().map(e -> Long.parseLong(e.toString())).collect(Collectors.toList());
        QFilter q = new QFilter(entryIdName, "in", entryIds);
        DynamicObjectCollection bills = QueryServiceHelper.query((String)entityName, (String)selectString, (QFilter[])new QFilter[]{q});
        HashMap<Object, Set<String>> billInfo = new HashMap<Object, Set<String>>(16);
        HashMap<String, BigDecimal> bfQty = new HashMap<String, BigDecimal>(16);
        HashMap<String, DynamicObject> bfStockEntry = new HashMap<String, DynamicObject>(16);
        ArrayList<String> existEntryIds = new ArrayList<String>(10);
        AutoBackFlushUtils.getBFQty(billInfo, bfQty, bfStockEntry, existEntryIds, bills, sourcebill, baseqtyName, entryIdName, entityName);
        Map<String, List<Object>> unExistRes = StockBackFlushUtils.getUnExistBFInfo(existEntryIds);
        logger.info("------updateBFStatusByEntryId------unExistRes\uff1a" + unExistRes);
        HashMap<String, String> bfStatus = new HashMap<String, String>(16);
        AutoBackFlushUtils.updateStockBFStatus(unExistRes, bfQty, bfStockEntry, bfStatus);
        HashMap<Object, String> sourceBFStatus = new HashMap<Object, String>(16);
        AutoBackFlushUtils.updateSourceBFStatus(sourceBFStatus, billInfo, bfStatus);
        logger.info("------updateBFStatusByEntryId------bfStatus\uff1a" + bfStatus);
        AutoBackFlushUtils.updateSourceBFStatusById(entryIds, sourceBFStatus, entityName, entryIdName);
    }

    public static void updateSourceBFStatusById(List<Long> entryIds, Map<Object, String> sourceBFStatus, String entityName, String entryIdName) {
        DynamicObject[] loads;
        StringBuilder sels = new StringBuilder();
        String billEntryKey = "";
        if ("im_mdc_mftmanuinbill".equals(entityName) || "im_mdc_mftreturnbill".equals(entityName)) {
            sels.append("billno,billentry,billentry.backflushstatus");
            billEntryKey = "billentry";
        } else if ("pom_mftorderreport".equals(entityName) || "prop_mftorderreport".equals(entityName)) {
            sels.append("billno,sumentry,sumentry.backflushstatus");
            billEntryKey = "sumentry";
        } else if ("sfc_processreportbill".equals(entityName) || "prop_processreportbill".equals(entityName)) {
            sels.append("billno,sumentry,sumentry.backflushstatus");
            billEntryKey = "sumentry";
        }
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)entityName, (String)sels.toString(), (QFilter[])new QFilter[]{new QFilter(entryIdName, "in", entryIds)})) {
            DynamicObjectCollection billentrys = load.getDynamicObjectCollection(billEntryKey);
            for (DynamicObject billentry : billentrys) {
                String bfstatus = sourceBFStatus.get(billentry.getPkValue());
                if (bfstatus != null) {
                    billentry.set("backflushstatus", (Object)bfstatus);
                } else if (entryIds.contains((Long)billentry.getPkValue())) {
                    billentry.set("backflushstatus", (Object)"F");
                }
                logger.info("------AutoBackFlushUtils------\u5355\u636e[" + load.getString("billno") + "]\u6700\u7ec8\u8bbe\u7f6e\u5012\u51b2\u6807\u8bc6\u4e3a\uff1a" + billentry.getString("backflushstatus"));
            }
        }
        SaveServiceHelper.update((DynamicObject[])loads);
    }

    public static void updateSourceBFStatus(Map<Object, String> sourceBFStatus, Map<Object, Set<String>> billInfo, Map<String, String> bfStatus) {
        for (Map.Entry<Object, Set<String>> bill : billInfo.entrySet()) {
            Object key = bill.getKey();
            Set<String> values = bill.getValue();
            String sourceStatus = "B";
            int a = 0;
            int c = 0;
            int f = 0;
            int e = 0;
            for (String value : values) {
                String bfstatus = bfStatus.get(value);
                if ("A".equals(bfstatus)) {
                    ++a;
                    continue;
                }
                if ("C".equals(bfstatus)) {
                    ++c;
                    continue;
                }
                if ("F".equals(bfstatus)) {
                    ++f;
                    continue;
                }
                if (!"E".equals(bfstatus)) continue;
                ++e;
            }
            if (values.size() - f == 0) {
                sourceStatus = "F";
            } else if (values.size() - f == a) {
                sourceStatus = "A";
            } else if (values.size() - f == c) {
                sourceStatus = "C";
            } else if (values.size() - f == c + e) {
                sourceStatus = "E";
            }
            sourceBFStatus.put(key, sourceStatus);
            logger.info("------AutoBackFlushUtils------\u5012\u51b2\u6807\u8bc6\u7edf\u8ba1\uff1a\u672a\u5012\u51b2A." + a + " \u5168\u90e8\u5012\u51b2C." + c + " \u4e0d\u5012\u51b2F." + f + " \u8d85\u989d\u5012\u51b2E." + e);
        }
    }

    private static void updateStockBFStatus(Map<String, List<Object>> unExistRes, Map<String, BigDecimal> bfQty, Map<String, DynamicObject> bfStockEntry, Map<String, String> bfStatus) {
        for (Map.Entry<String, List<Object>> resInfo : unExistRes.entrySet()) {
            BigDecimal canbfqty;
            String key = resInfo.getKey();
            List<Object> list = resInfo.getValue();
            BigDecimal actissuebfqty = (BigDecimal)list.get(0);
            DynamicObject stockEntry = bfStockEntry.get(key);
            if (!bfStockEntry.containsKey(key)) continue;
            if ("B".equals(stockEntry.getString("qtytype"))) {
                actissuebfqty = stockEntry.getBigDecimal("actissueqty");
            }
            if ((canbfqty = bfQty.get(key)).compareTo(BigDecimal.ZERO) == 0 && actissuebfqty.compareTo(BigDecimal.ZERO) == 0) {
                bfStatus.put(key, "F");
                continue;
            }
            if (actissuebfqty.compareTo(BigDecimal.ZERO) == 0) {
                bfStatus.put(key, "A");
                continue;
            }
            if (actissuebfqty.compareTo(canbfqty) < 0) {
                bfStatus.put(key, "B");
                continue;
            }
            if (actissuebfqty.compareTo(canbfqty) == 0) {
                bfStatus.put(key, "C");
                continue;
            }
            if (actissuebfqty.compareTo(canbfqty) <= 0) continue;
            bfStatus.put(key, "E");
        }
    }

    private static void getBFQty(Map<Object, Set<String>> billInfo, Map<String, BigDecimal> bfQty, Map<String, DynamicObject> bfStockEntry, List<String> existEntryIds, DynamicObjectCollection bills, String sourcebill, String baseqtyName, String entryIdName, String entityName) {
        List<List<Object>> bfBillInfo = StockBackFlushUtils.getBFBillInfo(bills, sourcebill, null, entityName);
        logger.info("------AutoBackFlushUtils.getBFQty------bfBillInfo\u5927\u5c0f\u4e3a\uff1a" + bfBillInfo.size());
        for (List<Object> grid : bfBillInfo) {
            Object entryId;
            Set<String> set;
            DynamicObject stockDym;
            DynamicObject bill = (DynamicObject)grid.get(0);
            DynamicObject stockEntry = (DynamicObject)grid.get(1);
            BigDecimal canbfqty = StockBackFlushUtils.getCanBFQty(stockEntry, stockDym = (DynamicObject)grid.get(2), bill, baseqtyName, sourcebill);
            if (canbfqty.compareTo(BigDecimal.ZERO) <= 0) {
                canbfqty = BigDecimal.ZERO;
            }
            if ((set = billInfo.get(entryId = bill.get(entryIdName))) == null) {
                set = new HashSet<String>(10);
            }
            Object stockentryid = stockEntry.getPkValue();
            String idStr = sourcebill + "," + entryId.toString() + "," + stockentryid.toString();
            set.add(idStr);
            existEntryIds.add(idStr);
            bfQty.put(idStr, canbfqty);
            logger.info("------AutoBackFlushUtils------\u5e94\u5012\u51b2\u6570\u91cf\u4e3a\uff1a" + sourcebill + "+" + idStr + "+" + canbfqty);
            billInfo.put(entryId, set);
            bfStockEntry.put(idStr, stockEntry);
        }
    }

    public static Map<Object, DynamicObject> batchLoadStock(List<Map<String, Object>> bfParam) {
        HashSet<Object> orderEntryIdList = new HashSet<Object>(10);
        String stockName = "pom_mftstock";
        for (Map<String, Object> objInfo : bfParam) {
            stockName = (String)objInfo.get("stockname");
            Map objEntryInfo = (Map)objInfo.get("billentry");
            for (Map.Entry entry : objEntryInfo.entrySet()) {
                Map value = (Map)entry.getValue();
                orderEntryIdList.add(value.get("orderentryid"));
            }
        }
        return AutoBackFlushUtils.batchLoadStockByOrderEntryId(orderEntryIdList, stockName);
    }

    private static Map<Object, DynamicObject> batchLoadStockByOrderEntryId(Set<Object> orderEntryIdList, String stockName) {
        DynamicObject[] mftStock;
        HashMap<Object, DynamicObject> stockMap = new HashMap<Object, DynamicObject>(16);
        QFilter qfilter = new QFilter("orderentryid", "in", orderEntryIdList);
        for (DynamicObject stock : mftStock = BusinessDataServiceHelper.load((String)stockName, (String)"transactiontypeid,transactiontypeid.isbackflush,transactiontypeid.backflushmore,orderentryid,baseqty,stockentry,stockentry.cansendqty,stockentry.backflushtime,stockentry.materialid,stockentry.materialunitid,stockentry.feedingqty,stockentry.qtytype,stockentry.overissuecontrl,stockentry.demandqty,stockentry.fixscrap,stockentry.qtynumerator,stockentry.qtydenominator,stockentry.lackraitioqty,stockentry.rejectedqty,stockentry.actissueqty,stockentry.issuemode,stockentry.isbackflush,stockentry.iskeypart,stockentry.isbulkmaterial,stockentry.qtytype", (QFilter[])new QFilter[]{qfilter})) {
            DynamicObject orderEntry = stock.getDynamicObject("orderentryid");
            if (orderEntry == null) continue;
            stockMap.put(orderEntry.getPkValue(), stock);
        }
        return stockMap;
    }

    private static String autoBackFlush(Map<String, Object> objInfo) {
        ArrayList<String> backFlushErrList = new ArrayList<String>();
        HashMap<String, List<Integer>> backFlushParam = new HashMap<String, List<Integer>>();
        backFlushParam.put("backFlushErrList", new ArrayList());
        backFlushParam.put("backFlushSuccessList", new ArrayList());
        backFlushParam.put("successedList", new ArrayList());
        Map objEntryInfo = (Map)objInfo.get("billentry");
        for (Map.Entry entry : objEntryInfo.entrySet()) {
            String isSuccessToStock = "audit";
            Map<String, Object> entryBFInfo = AutoBackFlushUtils.getEntryBFInfo(objInfo, entry.getKey());
            if ("pom_mftorder".equals(objInfo.get("ordername")) || "prop_mftorder".equals(objInfo.get("ordername"))) {
                isSuccessToStock = AutoBackFlushUtils.autoBackFlushStock(entryBFInfo);
            }
            AutoBackFlushUtils.dealInfo(isSuccessToStock, backFlushErrList, null, (String)entryBFInfo.get("operationkey"), (Integer)entryBFInfo.get("seq"), backFlushParam);
        }
        AutoBackFlushUtils.dealbackFlushErrList(backFlushParam, backFlushErrList);
        if (backFlushErrList.isEmpty()) {
            return "";
        }
        return objInfo.get("billno") + "\uff1a" + AutoBackFlushUtils.getListString(backFlushErrList);
    }

    private static String getListString(List<String> backFlushErrList) {
        StringBuilder sb = new StringBuilder();
        for (String str : backFlushErrList) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static void dealbackFlushErrList(Map<String, List<Integer>> backFlushParam, List<String> backFlushErrList) {
        List<Integer> tempt;
        StringJoiner stringJoiner;
        if (!backFlushParam.get("backFlushErrList").isEmpty()) {
            stringJoiner = new StringJoiner("\u3001");
            tempt = backFlushParam.get("backFlushErrList");
            tempt.forEach(t -> stringJoiner.add(String.valueOf(t)));
            backFlushErrList.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u6ca1\u6709\u9700\u8981\u5012\u51b2\u7684\u6570\u636e\u3002", (String)"AutoBackFlushUtils_20", (String)"scmc-mm-mdc", (Object[])new Object[0]), stringJoiner));
        }
        if (!backFlushParam.get("successedList").isEmpty()) {
            stringJoiner = new StringJoiner("\u3001");
            tempt = backFlushParam.get("successedList");
            tempt.forEach(t -> stringJoiner.add(String.valueOf(t)));
            backFlushErrList.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u5df2\u7ecf\u5168\u90e8\u5012\u51b2\u3002", (String)"AutoBackFlushUtils_21", (String)"scmc-mm-mdc", (Object[])new Object[0]), stringJoiner));
        }
    }

    public static void dealInfo(String isSuccessToStock, List<String> backFlushErrList, DynamicObject entryObj, String operationKey, int seq, Map<String, List<Integer>> backFlushParam) {
        if ("".equals(isSuccessToStock)) {
            if (entryObj != null) {
                entryObj.set("backflushstatus", (Object)"C");
            }
            backFlushParam.get("backFlushSuccessList").add(seq);
        } else if ("F".equals(isSuccessToStock)) {
            if (entryObj != null) {
                entryObj.set("backflushstatus", (Object)"F");
            }
            if ("backflush".equals(operationKey)) {
                backFlushParam.get("backFlushErrList").add(seq);
            }
        } else if (!"audit".equals(isSuccessToStock)) {
            String errorString = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55 %2$s", (String)"AutoBackFlushUtils_4", (String)"scmc-mm-mdc", (Object[])new Object[0]), String.valueOf(seq), isSuccessToStock);
            backFlushErrList.add(errorString);
        }
    }

    public static Map<String, Object> getEntryBFInfo(Map<String, Object> objInfo, Object pkValue) {
        HashMap<String, Object> bfParamMap = new HashMap<String, Object>(16);
        Map objEntryInfo = (Map)objInfo.get("billentry");
        Map map = (Map)objEntryInfo.get(pkValue);
        bfParamMap.put("id", objInfo.get("id"));
        bfParamMap.put(KEY_BILLENTITY, objInfo.get(KEY_BILLENTITY));
        bfParamMap.put("billno", objInfo.get("billno"));
        bfParamMap.put("operationkey", objInfo.get("operationkey"));
        bfParamMap.put("biztime", objInfo.get("biztime"));
        bfParamMap.put("ordername", objInfo.get("ordername"));
        bfParamMap.put("orderentry", objInfo.get("orderentry"));
        bfParamMap.put("stockname", objInfo.get("stockname"));
        bfParamMap.put("targetname", objInfo.get("targetname"));
        bfParamMap.put("botpid", objInfo.get("botpid"));
        bfParamMap.put("entryid", pkValue);
        bfParamMap.put("seq", map.get("seq"));
        bfParamMap.put("orderid", map.get("orderid"));
        bfParamMap.put("orderentryid", map.get("orderentryid"));
        bfParamMap.put("baseqty", map.get("baseqty"));
        String processStr = AutoBackFlushUtils.getProcessStr();
        if (Arrays.asList(processStr.split(",")).contains(objInfo.get(KEY_BILLENTITY).toString())) {
            bfParamMap.put("processseq", objInfo.get("processseq"));
            bfParamMap.put("oprno", objInfo.get("oprno"));
        }
        return bfParamMap;
    }

    public static String autoBackFlushStock(Map<String, Object> backFlushBillParam) {
        QFilter qfilter = new QFilter("orderentryid", "=", backFlushBillParam.get("orderentryid"));
        DynamicObject[] mftStocks = BusinessDataServiceHelper.load((String)((String)backFlushBillParam.get("stockname")), (String)AutoBackFlushUtils.getSelectPro((String)backFlushBillParam.get("stockname")), (QFilter[])new QFilter[]{qfilter});
        if (mftStocks == null || mftStocks.length == 0) {
            return "audit";
        }
        DynamicObject mftStock = mftStocks[0];
        DynamicObject transactiontype = mftStock.getDynamicObject("transactiontypeid");
        boolean backflushmore = transactiontype.getBoolean("backflushmore");
        boolean isbackflush = transactiontype.getBoolean("isbackflush");
        ArrayList<DynamicObject> needPushList = new ArrayList<DynamicObject>();
        HashMap<Object, BigDecimal> defaultQtyList = new HashMap<Object, BigDecimal>();
        if ("audit".equals(backFlushBillParam.get("operationkey")) && !isbackflush) {
            return "audit";
        }
        String backInfo = "";
        if ("audit".equals(backFlushBillParam.get("operationkey"))) {
            backInfo = ResManager.loadKDString((String)"\u81ea\u52a8\u5012\u51b2\u5931\u8d25,", (String)"AutoBackFlushUtils_6", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        } else if ("backflush".equals(backFlushBillParam.get("operationkey"))) {
            backInfo = ResManager.loadKDString((String)"\u5012\u51b2\u5931\u8d25,", (String)"AutoBackFlushUtils_7", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        }
        AutoBackFlushUtils.dealStock(mftStock, backFlushBillParam, backflushmore, needPushList, defaultQtyList);
        if (!needPushList.isEmpty()) {
            String autoPushAndSubmitStr = AutoBackFlushUtils.autoPushAndSubmit(mftStock, needPushList, defaultQtyList, backFlushBillParam);
            if ("".equals(autoPushAndSubmitStr)) {
                return "";
            }
            return backInfo + autoPushAndSubmitStr;
        }
        return "F";
    }

    private static String getSelectPro(String name) {
        String fields = "org,transactiontypeid,transactiontypeid.isbackflush,transactiontypeid.backflushmore,orderentryid,baseqty,stockentry,stockentry.cansendqty,stockentry.backflushtime,stockentry.materialid,stockentry.materialunitid,stockentry.feedingqty,stockentry.qtytype,stockentry.overissuecontrl,stockentry.demandqty,stockentry.fixscrap,stockentry.qtynumerator,stockentry.qtydenominator,stockentry.lackraitioqty,stockentry.rejectedqty,stockentry.actissueqty,stockentry.issuemode,stockentry.isbackflush,stockentry.iskeypart,stockentry.isbulkmaterial,stockentry.qtytype,stockentry.processseq,stockentry.oprno";
        if ("pom_mftstock".equals(name) || "prop_mftstock".equals(name)) {
            return fields + ",stockentry.beginworkbf";
        }
        return fields;
    }

    private static void dealStock(DynamicObject mftStock, Map<String, Object> backFlushBillParam, boolean backflushmore, List<DynamicObject> needPushList, HashMap<Object, BigDecimal> defaultQtyList) {
        BigDecimal baseQty = mftStock.getBigDecimal("baseqty");
        DynamicObjectCollection stockEntry = mftStock.getDynamicObjectCollection("stockentry");
        String sourceEntryid = backFlushBillParam.get("entryid").toString();
        String sourcebillentry = AutoBackFlushUtils.getSourcebillStr(backFlushBillParam.get(KEY_BILLENTITY).toString());
        ArrayList<String> existEntryIds = new ArrayList<String>(10);
        for (int j = 0; j < stockEntry.size(); ++j) {
            existEntryIds.add(sourcebillentry + "," + sourceEntryid + "," + ((DynamicObject)stockEntry.get(j)).getPkValue().toString());
        }
        Map<String, List<Object>> unExistRes = StockBackFlushUtils.getUnExistBFInfo(existEntryIds);
        String processseqAndoprno = null;
        String processStr = AutoBackFlushUtils.getProcessStr();
        if (Arrays.asList(processStr.split(",")).contains(backFlushBillParam.get(KEY_BILLENTITY).toString())) {
            processseqAndoprno = backFlushBillParam.get("processseq") + "@@" + backFlushBillParam.get("oprno");
        }
        for (int j = 0; j < stockEntry.size(); ++j) {
            DynamicObject mftstockEntryObj = (DynamicObject)stockEntry.get(j);
            HashMap<String, Object> judgeParam = new HashMap<String, Object>();
            List<Object> list = unExistRes.get(sourcebillentry + "," + sourceEntryid + "," + ((DynamicObject)stockEntry.get(j)).getPkValue().toString());
            if (list == null) {
                judgeParam.put("baseBFQty", BigDecimal.ZERO);
            } else {
                judgeParam.put("baseBFQty", list.get(0));
            }
            judgeParam.put("mftstockEntryObj", mftstockEntryObj);
            judgeParam.put("accQty", (BigDecimal)backFlushBillParam.get("baseqty"));
            judgeParam.put("baseQty", baseQty);
            judgeParam.put("backflushmore", backflushmore);
            HashMap<String, Object> judgeResult = AutoBackFlushUtils.qualityJudge(judgeParam, backFlushBillParam);
            TailDiffBackFlushHelper.excuteAuto(judgeResult, judgeParam, backFlushBillParam);
            boolean isPass = (Boolean)judgeResult.get("isPass");
            if (!isPass) continue;
            if (Arrays.asList(processStr.split(",")).contains(backFlushBillParam.get(KEY_BILLENTITY).toString())) {
                String processseqAndoprno2 = mftstockEntryObj.get("processseq") + "@@" + mftstockEntryObj.get("oprno");
                if (processseqAndoprno2.equals(processseqAndoprno)) {
                    needPushList.add(mftstockEntryObj);
                }
            } else {
                needPushList.add(mftstockEntryObj);
            }
            BigDecimal qualitydefault = (BigDecimal)judgeResult.get("qualitydefault");
            defaultQtyList.put(mftstockEntryObj.getPkValue(), qualitydefault);
        }
    }

    private static String getProcessStr() {
        return "sfc_processreportbill,sfc_protransferbill,sfc_manftech";
    }

    private static String getSourcebillStr(String entityname) {
        String sourcebillStr = "A";
        if ("pom_mftorderreport".equals(entityname)) {
            sourcebillStr = "B";
        } else if ("sfc_processreportbill".equals(entityname)) {
            sourcebillStr = "C";
        } else if ("sfc_protransferbill".equals(entityname)) {
            sourcebillStr = "D";
        } else if ("sfc_manftech".equals(entityname)) {
            sourcebillStr = "F";
        } else if ("im_mdc_mftreturnbill".equals(entityname)) {
            sourcebillStr = "G";
        }
        return sourcebillStr;
    }

    private static String autoPushAndSubmit(DynamicObject mftStock, List<DynamicObject> needPushList, HashMap<Object, BigDecimal> defaultQtyList, Map<String, Object> backFlushBillParam) {
        String ruleRes;
        PushArgs pushArgs = new PushArgs();
        String targetBillName = (String)backFlushBillParam.get("targetname");
        pushArgs.setSourceEntityNumber((String)backFlushBillParam.get("stockname"));
        pushArgs.setTargetEntityNumber(targetBillName);
        pushArgs.setHasRight(false);
        pushArgs.setRuleId((String)backFlushBillParam.get("botpid"));
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(needPushList.size());
        for (DynamicObject purId : needPushList) {
            ListSelectedRow srcBill1 = new ListSelectedRow(mftStock.getPkValue());
            srcBill1.setEntryEntityKey("stockentry");
            srcBill1.setEntryPrimaryKeyValue(purId.getPkValue());
            needPushRows.add(srcBill1);
        }
        if (needPushRows.isEmpty()) {
            return ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355\u6ca1\u6709\u9700\u8981\u5012\u51b2\u7684\u6570\u636e\u3002", (String)"AutoBackFlushUtils_10", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        StringBuilder errMessage = new StringBuilder().append(pushResult.getMessage());
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            errMessage.append(billReport.getFailMessage());
        }
        if (null != errMessage && !"null".equals(errMessage.toString()) && !"".equals(errMessage.toString())) {
            if (StringUtils.equals((String)"im_mdc_mftreturnorder", (String)targetBillName)) {
                return String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u9000\u6599\u5355\u5931\u8d25\uff1a%s", (String)"AutoBackFlushUtils_26", (String)"scmc-mm-mdc", (Object[])new Object[0]), errMessage);
            }
            return String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u9886\u6599\u5355\u5931\u8d25\uff1a%s", (String)"AutoBackFlushUtils_11", (String)"scmc-mm-mdc", (Object[])new Object[0]), errMessage);
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)((String)backFlushBillParam.get("targetname")));
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        AutoBackFlushUtils.handleTarget(targetBillObjs, defaultQtyList, backFlushBillParam);
        ArrayList<DynamicObject> needBackFlushTargetBills = new ArrayList<DynamicObject>(16);
        for (Object targetBillObj : targetBillObjs) {
            boolean isAutoMatch = targetBillObj.getBoolean("isautomatch");
            if (!isAutoMatch) continue;
            needBackFlushTargetBills.add((DynamicObject)targetBillObj);
        }
        if (needBackFlushTargetBills != null && needBackFlushTargetBills.size() > 0 && !"".equals(ruleRes = StockBackFlushUtils.handleMatchingRule(needBackFlushTargetBills, "false", null, null))) {
            return ruleRes;
        }
        HashMap<String, BigDecimal> billCanbfqty = new HashMap<String, BigDecimal>(targetBillObjs.size());
        for (DynamicObject targetBillObj : targetBillObjs) {
            DynamicObjectCollection coll = targetBillObj.getDynamicObjectCollection("billentry");
            for (DynamicObject billentry : coll) {
                String billKey = billentry.getString("srcbillentryid") + "@" + billentry.getString("mainbillentryid");
                billCanbfqty.put(billKey, billentry.getBigDecimal("baseqty"));
            }
        }
        String billCanbfqtyStr = JSON.toJSONString(billCanbfqty);
        String billName = (String)backFlushBillParam.get("targetname");
        OperateOption saveOption = AutoBackFlushUtils.getOperateOption();
        saveOption.setVariableValue("billCanbfqtyStr", billCanbfqtyStr);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)billName, (DynamicObject[])targetBillObjs.toArray(new DynamicObject[0]), (OperateOption)saveOption);
        if (!saveResult.isSuccess()) {
            if ("im_mdc_mftreturnorder".equals(billName)) {
                return String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u9000\u6599\u5355\u5931\u8d25\uff1a%s", (String)"AutoBackFlushUtils_22", (String)"scmc-mm-mdc", (Object[])new Object[0]), AutoBackFlushUtils.getErrDetail(saveResult));
            }
            return String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u9886\u6599\u5355\u5931\u8d25\uff1a%s", (String)"AutoBackFlushUtils_12", (String)"scmc-mm-mdc", (Object[])new Object[0]), AutoBackFlushUtils.getErrDetail(saveResult));
        }
        List saveSuccessPkIds = saveResult.getSuccessPkIds();
        OperateOption submitOption = AutoBackFlushUtils.getOperateOption();
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)((String)backFlushBillParam.get("targetname")), (Object[])saveSuccessPkIds.toArray(), (OperateOption)submitOption);
        if (!submitResult.isSuccess()) {
            AutoBackFlushUtils.delFaildResult(saveSuccessPkIds, backFlushBillParam);
            if ("im_mdc_mftreturnorder".equals(billName)) {
                return String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u9000\u6599\u5355\u5931\u8d25\uff1a%s", (String)"AutoBackFlushUtils_23", (String)"scmc-mm-mdc", (Object[])new Object[0]), AutoBackFlushUtils.getErrDetail(submitResult));
            }
            return String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u9886\u6599\u5355\u5931\u8d25\uff1a%s", (String)"AutoBackFlushUtils_13", (String)"scmc-mm-mdc", (Object[])new Object[0]), AutoBackFlushUtils.getErrDetail(submitResult));
        }
        List successPkIds = submitResult.getSuccessPkIds();
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)((String)backFlushBillParam.get("targetname")), (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)submitOption);
        if (!auditResult.isSuccess()) {
            String res = AutoBackFlushUtils.delFaildResult(successPkIds, backFlushBillParam);
            if ("success".equals(res)) {
                return "";
            }
            if ("".equals(res)) {
                if ("im_mdc_mftreturnorder".equals(billName)) {
                    return String.format(ResManager.loadKDString((String)"\u5ba1\u6838\u9000\u6599\u5355\u5931\u8d25\uff1a%s", (String)"AutoBackFlushUtils_24", (String)"scmc-mm-mdc", (Object[])new Object[0]), AutoBackFlushUtils.getErrDetail(auditResult));
                }
                return String.format(ResManager.loadKDString((String)"\u5ba1\u6838\u9886\u6599\u5355\u5931\u8d25\uff1a%s", (String)"AutoBackFlushUtils_14", (String)"scmc-mm-mdc", (Object[])new Object[0]), AutoBackFlushUtils.getErrDetail(auditResult));
            }
            if ("im_mdc_mftreturnorder".equals(billName)) {
                return ResManager.loadKDString((String)"\u5ba1\u6838\u9000\u6599\u5355\u5931\u8d25\uff0c\u53ef\u80fd\u4f1a\u5b58\u5728\u672a\u5220\u9664\u7684\u9000\u6599\u5355\u3002", (String)"AutoBackFlushUtils_25", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u5ba1\u6838\u9886\u6599\u5355\u5931\u8d25\uff0c\u53ef\u80fd\u4f1a\u5b58\u5728\u672a\u5220\u9664\u7684\u9886\u6599\u5355\u3002", (String)"AutoBackFlushUtils_15", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        }
        return "";
    }

    private static String delFaildResult(List<Object> successPkIds, Map<String, Object> backFlushBillParam) {
        DynamicObject[] loads;
        ArrayList<Object> auditPkIds = new ArrayList<Object>(successPkIds.size());
        ArrayList<DynamicObject> purinBillDymList = new ArrayList<DynamicObject>(successPkIds.size());
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)((String)backFlushBillParam.get("targetname")), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", successPkIds)})) {
            purinBillDymList.add(load);
            if ("C".equals(load.getString("billstatus"))) continue;
            auditPkIds.add(load.getPkValue());
        }
        if (auditPkIds.isEmpty()) {
            return "success";
        }
        return AutoBackFlushUtils.delFaildResultDym(purinBillDymList, backFlushBillParam);
    }

    private static String delFaildResultDym(List<DynamicObject> purinBillDymList, Map<String, Object> backFlushBillParam) {
        OperationResult delResult;
        HashSet auditPkIds = Sets.newHashSetWithExpectedSize((int)purinBillDymList.size());
        HashSet submitPkIds = Sets.newHashSetWithExpectedSize((int)purinBillDymList.size());
        HashSet delPkIds = Sets.newHashSetWithExpectedSize((int)purinBillDymList.size());
        OperateOption option = AutoBackFlushUtils.getOperateOption();
        for (DynamicObject purinBillDym : purinBillDymList) {
            if ("C".equals(purinBillDym.getString("billstatus"))) {
                auditPkIds.add(purinBillDym.getPkValue());
                continue;
            }
            if ("B".equals(purinBillDym.getString("billstatus"))) {
                submitPkIds.add(purinBillDym.getPkValue());
                continue;
            }
            delPkIds.add(purinBillDym.getPkValue());
        }
        if (!auditPkIds.isEmpty()) {
            OperationResult unAuditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)((String)backFlushBillParam.get("targetname")), (Object[])auditPkIds.toArray(), (OperateOption)option);
            if (!unAuditResult.isSuccess()) {
                logger.info("unaudit\u5012\u51b2\u9886\u6599\u5355\u5931\u8d25\uff1a" + auditPkIds.toArray() + AutoBackFlushUtils.getErrDetail(unAuditResult));
                return ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5012\u51b2\u9886\u6599\u5355\u5931\u8d25\u3002", (String)"AutoBackFlushUtils_16", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            }
            delPkIds.addAll(auditPkIds);
        }
        if (!submitPkIds.isEmpty()) {
            OperationResult unSubmitResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)((String)backFlushBillParam.get("targetname")), (Object[])submitPkIds.toArray(), (OperateOption)option);
            if (!unSubmitResult.isSuccess()) {
                logger.info("unsubmit\u5012\u51b2\u9886\u6599\u5355\u5931\u8d25\uff1a" + submitPkIds.toArray() + AutoBackFlushUtils.getErrDetail(unSubmitResult));
                return ResManager.loadKDString((String)"\u64a4\u9500\u5012\u51b2\u9886\u6599\u5355\u5931\u8d25\u3002", (String)"AutoBackFlushUtils_17", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            }
            delPkIds.addAll(submitPkIds);
        }
        if (!(delResult = OperationServiceHelper.executeOperate((String)"delete", (String)((String)backFlushBillParam.get("targetname")), (Object[])delPkIds.toArray(), (OperateOption)option)).isSuccess()) {
            logger.info("delete\u5012\u51b2\u9886\u6599\u5355\u5931\u8d25\uff1a" + delPkIds.toArray() + AutoBackFlushUtils.getErrDetail(delResult));
            return ResManager.loadKDString((String)"\u5220\u9664\u5012\u51b2\u9886\u6599\u5355\u5931\u8d25\u3002", (String)"AutoBackFlushUtils_18", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        }
        return "";
    }

    private static OperateOption getOperateOption() {
        OperateOption saveOption = OperateOption.create();
        saveOption.setVariableValue("ignorewarn", String.valueOf(true));
        saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        saveOption.setVariableValue("strictvalidation", String.valueOf(true));
        saveOption.setVariableValue("ignoreValidation", String.valueOf(true));
        saveOption.setVariableValue("WF", "false");
        return saveOption;
    }

    private static void handleTarget(List<DynamicObject> targetBillObjs, HashMap<Object, BigDecimal> defaultQtyList, Map<String, Object> backFlushBillParam) {
        for (int j = 0; j < targetBillObjs.size(); ++j) {
            DynamicObject targetBillObj = targetBillObjs.get(j);
            targetBillObj.set("biztime", backFlushBillParam.get("biztime"));
            DynamicObjectCollection coll = targetBillObj.getDynamicObjectCollection("billentry");
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject mftorderEntryObj = (DynamicObject)coll.get(i);
                DynamicObject masterid = mftorderEntryObj.getDynamicObject("material").getDynamicObject("masterid");
                DynamicObject unit = mftorderEntryObj.getDynamicObject("unit");
                DynamicObject baseunit = mftorderEntryObj.getDynamicObject("baseunit");
                DynamicObject unit2nd = mftorderEntryObj.getDynamicObject("unit2nd");
                for (Map.Entry<Object, BigDecimal> entry : defaultQtyList.entrySet()) {
                    if (!entry.getKey().equals(mftorderEntryObj.get("srcbillentryid"))) continue;
                    mftorderEntryObj.set("qty", (Object)AutoBackFlushUtils.getQtyByUnit(masterid, baseunit, unit, entry.getValue()));
                    mftorderEntryObj.set("baseqty", (Object)AutoBackFlushUtils.processPrecision(entry.getValue(), baseunit));
                    mftorderEntryObj.set("qtyunit2nd", (Object)AutoBackFlushUtils.getQtyByUnit(masterid, baseunit, unit2nd, entry.getValue()));
                }
                mftorderEntryObj.set("srcbillnumber", backFlushBillParam.get("billno"));
                mftorderEntryObj.set("srcbillid", backFlushBillParam.get("id"));
                mftorderEntryObj.set("srcbillentryid", backFlushBillParam.get("entryid"));
                mftorderEntryObj.set("srcbillentity", backFlushBillParam.get(KEY_BILLENTITY));
            }
        }
        StockBackFlushUtils.initBookDate(targetBillObjs);
    }

    private static HashMap<String, Object> qualityJudge(HashMap<String, Object> judgeParam, Map<String, Object> backFlushBillParam) {
        BigDecimal qualitydefault;
        BigDecimal qualityA = (BigDecimal)judgeParam.get("accQty");
        HashMap<String, Object> result = new HashMap<String, Object>();
        DynamicObject mftstockEntryObj = (DynamicObject)judgeParam.get("mftstockEntryObj");
        BigDecimal baseQty = (BigDecimal)judgeParam.get("baseQty");
        boolean backflushmore = (Boolean)judgeParam.get("backflushmore");
        String backflushtime = mftstockEntryObj.getString("backflushtime");
        String overissuecontrl = mftstockEntryObj.getString("overissuecontrl");
        String isbackflush = mftstockEntryObj.getString("isbackflush");
        String issuemode = mftstockEntryObj.getString("issuemode");
        DynamicObject materialunitid = mftstockEntryObj.getDynamicObject("materialunitid");
        int precision = materialunitid.getInt("precision");
        String newBackFlushTime = "";
        String billName = (String)backFlushBillParam.get(KEY_BILLENTITY);
        String stockName = (String)backFlushBillParam.get("stockname");
        if ("im_mdc_mftmanuinbill".equals(billName) || "im_mdc_omcmplinbill".equals(billName) || "im_mdc_ominbill".equals(billName) || "im_mdc_mftreturnbill".equals(billName)) {
            newBackFlushTime = "A";
        } else if ("pom_mftorderreport".equals(billName) || "sfc_processreportbill".equals(billName) || "sfc_protransferbill".equals(billName) || "prop_mftorderreport".equals(billName)) {
            newBackFlushTime = "B";
        } else if ("sfc_manftech".equals(billName)) {
            newBackFlushTime = "C";
        }
        Boolean beginworkbf = Boolean.FALSE;
        if ("pom_mftstock".equals(stockName) || "prop_mftstock".equals(stockName)) {
            beginworkbf = mftstockEntryObj.getBoolean("beginworkbf");
        }
        if ("C".equals(newBackFlushTime)) {
            if (!("B".equals(isbackflush) && "A".equals(issuemode) && beginworkbf.booleanValue())) {
                result.put("isPass", Boolean.FALSE);
                return result;
            }
        } else if (!newBackFlushTime.equals(backflushtime) || !"B".equals(isbackflush) || "C".equals(issuemode) || beginworkbf.booleanValue()) {
            result.put("isPass", Boolean.FALSE);
            return result;
        }
        BigDecimal demandqty = mftstockEntryObj.getBigDecimal("demandqty");
        BigDecimal cansendqty = mftstockEntryObj.getBigDecimal("cansendqty");
        BigDecimal actissueqty = mftstockEntryObj.getBigDecimal("actissueqty");
        BigDecimal qualityT = qualityA.multiply(demandqty).divide(baseQty, precision, AutoBackFlushUtils.getRoundType(materialunitid));
        if ("B".equals(mftstockEntryObj.getString("qtytype"))) {
            qualityT = demandqty.subtract(actissueqty);
            if ("im_mdc_omreturnbill".equals(backFlushBillParam.get("targetname")) || "im_mdc_mftreturnorder".equals(backFlushBillParam.get("targetname"))) {
                result.put("isPass", Boolean.FALSE);
                return result;
            }
        }
        if ("im_mdc_omreturnbill".equals(backFlushBillParam.get("targetname")) || "im_mdc_mftreturnorder".equals(backFlushBillParam.get("targetname"))) {
            qualitydefault = qualityT;
        } else if (!backflushmore) {
            if (qualityT.compareTo(cansendqty) > 0) {
                if (cansendqty.compareTo(BigDecimal.ZERO) <= 0) {
                    result.put("isPass", Boolean.FALSE);
                    return result;
                }
                qualitydefault = cansendqty;
            } else {
                qualitydefault = qualityT;
            }
        } else if ("A".equals(overissuecontrl)) {
            qualitydefault = qualityT;
        } else if (qualityT.compareTo(cansendqty) > 0) {
            if (cansendqty.compareTo(BigDecimal.ZERO) <= 0) {
                result.put("isPass", Boolean.FALSE);
                return result;
            }
            qualitydefault = cansendqty;
        } else {
            qualitydefault = qualityT;
        }
        if (qualitydefault.compareTo(BigDecimal.ZERO) <= 0) {
            result.put("isPass", Boolean.FALSE);
            return result;
        }
        if (qualitydefault.compareTo((BigDecimal)judgeParam.get("baseBFQty")) <= 0) {
            result.put("isPass", Boolean.FALSE);
            return result;
        }
        result.put("qualitydefault", qualitydefault);
        result.put("isPass", Boolean.TRUE);
        return result;
    }

    public static BigDecimal getQtyByUnit(DynamicObject masterid, DynamicObject baseunit, DynamicObject unit, BigDecimal baseqty) {
        if (unit == null) {
            return BigDecimal.ZERO;
        }
        DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)masterid.getPkValue()), (Long)((Long)baseunit.getPkValue()), (Long)((Long)unit.getPkValue()));
        if (muConv == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal numerator = muConv.getBigDecimal("numerator");
        BigDecimal denominator = muConv.getBigDecimal("denominator");
        int precision = unit.getInt("precision");
        return baseqty.multiply(numerator).divide(denominator, precision, AutoBackFlushUtils.getRoundType(unit));
    }

    private static String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        errDetail.append(optResult.getMessage().replaceAll("</br>", ""));
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage().replaceAll("</br>", ""));
        }
        return errDetail.toString();
    }

    public static BigDecimal processPrecision(BigDecimal qty, DynamicObject unit) {
        int precision = unit.getInt("precision");
        return qty.setScale(precision, AutoBackFlushUtils.getRoundType(unit));
    }

    public static int getRoundType(DynamicObject unit) {
        String precisionAccount = unit.getString("precisionaccount");
        int roundType = 0;
        switch (precisionAccount) {
            case "1": {
                roundType = 4;
                break;
            }
            case "2": {
                roundType = 1;
                break;
            }
            case "3": {
                roundType = 0;
                break;
            }
        }
        return roundType;
    }

    private static boolean isFromSfcReportAudit(Map<String, Object> backFlushBillParam) {
        String sourcebillentry = AutoBackFlushUtils.getSourcebillStr(backFlushBillParam.get(KEY_BILLENTITY).toString());
        HashSet<String> cansourcebills = new HashSet<String>(2);
        cansourcebills.add("A");
        cansourcebills.add("C");
        return cansourcebills.contains(sourcebillentry) && "audit".equals(backFlushBillParam.get("operationkey"));
    }

    private static String getInvParamKeyString(Map<String, Object> params) {
        return params.get("data").toString();
    }

    private static void initTargetByInvQty(List<DynamicObject> targetBillObjs, Map<String, Object> backFlushBillParam) {
        List invQtys;
        DynamicObjectCollection coll;
        DynamicObject targetBillObj;
        int j;
        ArrayList<DynamicObject> removeList = new ArrayList<DynamicObject>(16);
        HashMap<String, List> invCacheMap = new HashMap<String, List>(16);
        for (j = 0; j < targetBillObjs.size(); ++j) {
            targetBillObj = targetBillObjs.get(j);
            coll = targetBillObj.getDynamicObjectCollection("billentry");
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject mftorderEntryObj = (DynamicObject)coll.get(i);
                Map<String, Object> params = StockBackFlushUtils.getInvQtyParams(mftorderEntryObj, targetBillObj.getDynamicObject("org"));
                String paramsKeyString = AutoBackFlushUtils.getInvParamKeyString(params);
                if (invCacheMap.containsKey(paramsKeyString)) continue;
                InvRealAccQueryService invReal = new InvRealAccQueryService();
                invQtys = invReal.invAccQueryExtForInner(params);
                DynamicObject material = mftorderEntryObj.getDynamicObject("material").getDynamicObject("masterid");
                String materialName = material.getString("name");
                String materialNumber = material.getString("number");
                logger.info("\u67e5\u8be2\u5373\u65f6\u5e93\u5b58" + materialName + materialNumber + params.toString() + "\u7ed3\u679c\uff1a" + invQtys.toString());
                invCacheMap.put(paramsKeyString, invQtys);
            }
        }
        for (j = 0; j < targetBillObjs.size(); ++j) {
            int i;
            targetBillObj = targetBillObjs.get(j);
            coll = targetBillObj.getDynamicObjectCollection("billentry");
            ArrayList<DynamicObject> removeEntryList = new ArrayList<DynamicObject>(16);
            for (i = 0; i < coll.size(); ++i) {
                DynamicObject mftorderEntryObj = (DynamicObject)coll.get(i);
                Map<String, Object> params = StockBackFlushUtils.getInvQtyParams(mftorderEntryObj, targetBillObj.getDynamicObject("org"));
                String paramsKeyString = AutoBackFlushUtils.getInvParamKeyString(params);
                invQtys = (List)invCacheMap.get(paramsKeyString);
                AutoBackFlushUtils.setInvQty(invQtys, mftorderEntryObj);
                if (mftorderEntryObj.getBigDecimal("qty").compareTo(BigDecimal.ZERO) != 0) continue;
                removeEntryList.add(mftorderEntryObj);
            }
            if (!removeEntryList.isEmpty()) {
                for (i = 0; i < removeEntryList.size(); ++i) {
                    coll.remove(removeEntryList.get(i));
                }
            }
            if (coll != null && !coll.isEmpty()) continue;
            removeList.add(targetBillObj);
        }
        if (!removeList.isEmpty()) {
            for (int i = 0; i < removeList.size(); ++i) {
                targetBillObjs.remove(removeList.get(i));
            }
        }
    }

    private static String setInvQty(List<Map<String, Object>> invQtys, DynamicObject entry) {
        BigDecimal avbbaseqty = BigDecimal.ZERO;
        Map<String, Object> map = null;
        if (invQtys != null && !invQtys.isEmpty()) {
            map = invQtys.get(0);
            avbbaseqty = new BigDecimal(map.get("avbbaseqty").toString());
        }
        BigDecimal baseqty = entry.getBigDecimal("baseqty");
        if (map == null || avbbaseqty.compareTo(BigDecimal.ZERO) <= 0) {
            entry.set("baseqty", (Object)BigDecimal.ZERO);
            entry.set("qtyunit2nd", (Object)BigDecimal.ZERO);
            entry.set("qty", (Object)BigDecimal.ZERO);
        } else {
            if (map != null && baseqty.compareTo(avbbaseqty) > 0 && avbbaseqty.compareTo(BigDecimal.ZERO) > 0) {
                entry.set("baseqty", map.get("avbbaseqty"));
                entry.set("qtyunit2nd", map.get("avbbtndqty"));
                entry.set("qty", map.get("avbbqty"));
            }
            if (map != null) {
                map.put("avbbaseqty", avbbaseqty.subtract(baseqty));
            }
        }
        return "";
    }
}

