/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.common.mdc.utils;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.ListUtils;

public class OMComponentBackFlushUtils {
    private static final Log logger = LogFactory.getLog(OMComponentBackFlushUtils.class);
    private static String entryIdName = "billentry.id";
    private static String sourcebill = "A";
    private static String baseqtyName = "billentry.baseqty";
    private static String orderEntryIdName = "billentry.mainbillentryid";
    private static String backFlushTimeName = "A";
    private static String stockName = "om_componentlist";
    private static String outBillName = "im_mdc_omproorder";

    public static void updateBFStatusByEntryId(final List<Object> entryIdLists, String entityName) {
        if (!Objects.equals("im_mdc_ominbill", entityName) || Objects.isNull(entryIdLists)) {
            return;
        }
        List<Object> partition = null;
        partition = entryIdLists.size() > 10000 ? ListUtils.partition(entryIdLists, (int)1000) : new ArrayList<List<Object>>(){
            {
                this.add(entryIdLists);
            }
        };
        for (List list : partition) {
            DynamicObjectCollection sourceBills = OMComponentBackFlushUtils.getSourceBills(list, entityName);
            HashMap<Object, Set<String>> billInfo = new HashMap<Object, Set<String>>(16);
            HashMap<String, BigDecimal> bfQty = new HashMap<String, BigDecimal>(16);
            HashMap<String, DynamicObject> bfStockEntry = new HashMap<String, DynamicObject>(16);
            ArrayList<String> existEntryIds = new ArrayList<String>(10);
            OMComponentBackFlushUtils.getBFQty(billInfo, bfQty, bfStockEntry, existEntryIds, sourceBills);
            Map<String, List<Object>> unExistRes = OMComponentBackFlushUtils.getUnExistBFInfo(existEntryIds);
            HashMap<String, String> bfStatus = new HashMap<String, String>(16);
            OMComponentBackFlushUtils.updateStockBFStatus(unExistRes, bfQty, bfStockEntry, bfStatus);
            HashMap<Object, String> sourceBFStatus = new HashMap<Object, String>(16);
            List<Long> entryIds = list.stream().map(e -> Long.parseLong(e.toString())).collect(Collectors.toList());
            OMComponentBackFlushUtils.updateSourceBFStatus(sourceBFStatus, billInfo, bfStatus);
            OMComponentBackFlushUtils.updateSourceBFStatusById(entryIds, sourceBFStatus, entityName, OMComponentBackFlushUtils.getEntryIdName());
        }
    }

    private static void updateSourceBFStatusById(List<Long> entryIds, Map<Object, String> sourceBFStatus, String entityName, String entryIdName) {
        DynamicObject[] loads;
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)entityName, (String)"billno,billentry,billentry.backflushstatus", (QFilter[])new QFilter[]{new QFilter(entryIdName, "in", entryIds)})) {
            DynamicObjectCollection billentrys = load.getDynamicObjectCollection("billentry");
            for (DynamicObject billentry : billentrys) {
                String bfstatus = sourceBFStatus.get(billentry.getPkValue());
                if (bfstatus != null) {
                    billentry.set("backflushstatus", (Object)bfstatus);
                } else if (entryIds.contains((Long)billentry.getPkValue())) {
                    billentry.set("backflushstatus", (Object)"F");
                }
                logger.info("------OMStockBackFlushUtils------\u5355\u636e[" + load.getString("billno") + "]\u6700\u7ec8\u8bbe\u7f6e\u5012\u51b2\u6807\u8bc6\u4e3a\uff1a" + billentry.getString("backflushstatus"));
            }
        }
        SaveServiceHelper.update((DynamicObject[])loads);
    }

    private static void updateSourceBFStatus(Map<Object, String> sourceBFStatus, Map<Object, Set<String>> billInfo, Map<String, String> bfStatus) {
        for (Map.Entry<Object, Set<String>> bill : billInfo.entrySet()) {
            Object key = bill.getKey();
            Set<String> values = bill.getValue();
            String sourceStatus = "B";
            int a = 0;
            int c = 0;
            int f = 0;
            int e = 0;
            for (String value : values) {
                String bfstatus = bfStatus.get(value);
                if ("A".equals(bfstatus)) {
                    ++a;
                    continue;
                }
                if ("C".equals(bfstatus)) {
                    ++c;
                    continue;
                }
                if ("F".equals(bfstatus)) {
                    ++f;
                    continue;
                }
                if (!"E".equals(bfstatus)) continue;
                ++e;
            }
            if (values.size() - f == 0) {
                sourceStatus = "F";
            } else if (values.size() - f == a) {
                sourceStatus = "A";
            } else if (values.size() - f == c) {
                sourceStatus = "C";
            } else if (values.size() - f == c + e) {
                sourceStatus = "E";
            }
            sourceBFStatus.put(key, sourceStatus);
            logger.info("------OMStockBackFlushUtils------\u5012\u51b2\u6807\u8bc6\u7edf\u8ba1\uff1a\u672a\u5012\u51b2A." + a + " \u5168\u90e8\u5012\u51b2C." + c + " \u4e0d\u5012\u51b2F." + f + " \u8d85\u989d\u5012\u51b2E." + e);
        }
    }

    private static void updateStockBFStatus(Map<String, List<Object>> unExistRes, Map<String, BigDecimal> bfQty, Map<String, DynamicObject> bfStockEntry, Map<String, String> bfStatus) {
        for (Map.Entry<String, List<Object>> resInfo : unExistRes.entrySet()) {
            BigDecimal canbfqty;
            String key = resInfo.getKey();
            List<Object> list = resInfo.getValue();
            BigDecimal actissuebfqty = (BigDecimal)list.get(0);
            DynamicObject stockEntry = bfStockEntry.get(key);
            if ("B".equals(stockEntry.getString("qtytype"))) {
                actissuebfqty = stockEntry.getBigDecimal("actissueqty");
            }
            if ((canbfqty = bfQty.get(key)).compareTo(BigDecimal.ZERO) == 0 && actissuebfqty.compareTo(BigDecimal.ZERO) == 0) {
                bfStatus.put(key, "D");
                continue;
            }
            if (actissuebfqty.compareTo(BigDecimal.ZERO) == 0) {
                bfStatus.put(key, "A");
                continue;
            }
            if (actissuebfqty.compareTo(canbfqty) < 0) {
                bfStatus.put(key, "B");
                continue;
            }
            if (actissuebfqty.compareTo(canbfqty) == 0) {
                bfStatus.put(key, "C");
                continue;
            }
            if (actissuebfqty.compareTo(canbfqty) <= 0) continue;
            bfStatus.put(key, "E");
        }
    }

    private static Map<String, List<Object>> getUnExistBFInfo(List<String> unExistEntryIds) {
        HashMap res = Maps.newHashMapWithExpectedSize((int)unExistEntryIds.size());
        HashSet<Long> sourceBillEntryidSet = new HashSet<Long>(16);
        HashSet<Long> stockEntryIdSet = new HashSet<Long>(16);
        for (int i = 0; i < unExistEntryIds.size(); ++i) {
            String unExistEntryId = unExistEntryIds.get(i);
            String[] split = unExistEntryId.split(",");
            sourceBillEntryidSet.add(Long.parseLong(split[1]));
            stockEntryIdSet.add(Long.parseLong(split[2]));
            ArrayList<Comparable<BigDecimal>> info = new ArrayList<Comparable<BigDecimal>>(2);
            info.add(BigDecimal.ZERO);
            info.add(Boolean.valueOf(false));
            res.put(unExistEntryId, info);
        }
        QFilter filter = new QFilter("billentry.srcbillentryid", "in", sourceBillEntryidSet);
        filter.and(new QFilter(OMComponentBackFlushUtils.getOrderEntryIdName(), "in", stockEntryIdSet));
        filter.and(new QFilter("ischargeoff", "=", (Object)Boolean.FALSE));
        filter.and(new QFilter("ischargeoffed", "=", (Object)Boolean.FALSE));
        DynamicObjectCollection bills = QueryServiceHelper.query((String)OMComponentBackFlushUtils.getOutBillName(), (String)"billentry.srcbillentity,billentry.srcbillentryid,billentry.mainbillentryid,billentry.remainreturnbaseqty", (QFilter[])new QFilter[]{filter});
        OMComponentBackFlushUtils.fillInfo(bills, res);
        return res;
    }

    private static void fillInfo(DynamicObjectCollection bills, Map<String, List<Object>> res) {
        HashMap qtyRes = new HashMap();
        for (DynamicObject bill : bills) {
            String sourcebillentry = "A";
            String sourcebillentryid = bill.getString("billentry.srcbillentryid");
            String stockentryid = bill.getString(OMComponentBackFlushUtils.getOrderEntryIdName());
            BigDecimal baseqty = bill.getBigDecimal("billentry.remainreturnbaseqty").abs();
            String idStr = sourcebillentry + "," + sourcebillentryid + "," + stockentryid;
            List info = qtyRes.get(idStr) == null ? new ArrayList() : (List)qtyRes.get(idStr);
            info.add(baseqty);
            qtyRes.put(idStr, info);
        }
        for (Map.Entry result : qtyRes.entrySet()) {
            String key = (String)result.getKey();
            List value = (List)result.getValue();
            BigDecimal qty = BigDecimal.ZERO;
            for (int i = 0; i < value.size(); ++i) {
                qty = qty.add((BigDecimal)value.get(i));
            }
            ArrayList<Comparable<BigDecimal>> info = new ArrayList<Comparable<BigDecimal>>(2);
            Boolean bfclose = false;
            info.add(qty);
            info.add(bfclose);
            res.put(key, info);
        }
    }

    private static void getBFQty(Map<Object, Set<String>> billInfo, Map<String, BigDecimal> bfQty, Map<String, DynamicObject> bfStockEntry, List<String> existEntryIds, DynamicObjectCollection bills) {
        List<List<Object>> bfBillInfo = OMComponentBackFlushUtils.getBFBillInfo(bills);
        logger.info("------OMStockBackFlushUtils.getBFQty------bfBillInfo\u5927\u5c0f\u4e3a\uff1a" + bfBillInfo.size());
        for (List<Object> grid : bfBillInfo) {
            Object entryId;
            Set<String> set;
            DynamicObject stockDym;
            DynamicObject bill = (DynamicObject)grid.get(0);
            DynamicObject stockEntry = (DynamicObject)grid.get(1);
            BigDecimal canbfqty = OMComponentBackFlushUtils.getCanBFQty(stockEntry, stockDym = (DynamicObject)grid.get(2), bill);
            if (canbfqty.compareTo(BigDecimal.ZERO) <= 0) {
                canbfqty = BigDecimal.ZERO;
            }
            if ((set = billInfo.get(entryId = bill.get(OMComponentBackFlushUtils.getEntryIdName()))) == null) {
                set = new HashSet<String>(10);
            }
            Object stockentryid = stockEntry.getPkValue();
            String idStr = OMComponentBackFlushUtils.getSourcebill() + "," + entryId.toString() + "," + stockentryid.toString();
            set.add(idStr);
            existEntryIds.add(idStr);
            bfQty.put(idStr, canbfqty);
            logger.info("------OMStockBackFlushUtils------\u5e94\u5012\u51b2\u6570\u91cf\u4e3a\uff1a" + OMComponentBackFlushUtils.getSourcebill() + "+" + idStr + "+" + canbfqty);
            billInfo.put(entryId, set);
            bfStockEntry.put(idStr, stockEntry);
        }
    }

    private static BigDecimal getCanBFQty(DynamicObject stockEntry, DynamicObject stockDym, DynamicObject bill) {
        BigDecimal qualityA = new BigDecimal(bill.getString(OMComponentBackFlushUtils.getBaseqtyName())).abs();
        DynamicObject mftstockEntryObj = stockEntry;
        BigDecimal baseQty = (BigDecimal)stockDym.get("baseqty");
        if (baseQty.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        DynamicObject materialunitid = mftstockEntryObj.getDynamicObject("materialunitid");
        int precision = materialunitid.getInt("precision");
        String qtyType = mftstockEntryObj.getString("qtytype");
        if ("B".equals(qtyType)) {
            return mftstockEntryObj.getBigDecimal("demandqty");
        }
        return qualityA.multiply(mftstockEntryObj.getBigDecimal("demandqty")).divide(baseQty, precision, OMComponentBackFlushUtils.getRoundType(materialunitid));
    }

    private static int getRoundType(DynamicObject unit) {
        String precisionAccount = unit.getString("precisionaccount");
        int roundType = 0;
        switch (precisionAccount) {
            case "1": {
                roundType = 4;
                break;
            }
            case "2": {
                roundType = 1;
                break;
            }
            case "3": {
                roundType = 0;
                break;
            }
        }
        return roundType;
    }

    private static List<List<Object>> getBFBillInfo(DynamicObjectCollection bills) {
        ArrayList<List<Object>> gridList = new ArrayList<List<Object>>(16);
        Set<Long> orderEntryId = bills.stream().map(t -> t.getLong(OMComponentBackFlushUtils.getOrderEntryIdName())).collect(Collectors.toSet());
        Map<Object, DynamicObject> stocks = OMComponentBackFlushUtils.getStockDym(orderEntryId);
        for (int i = 0; i < bills.size(); ++i) {
            DynamicObject stockDym = stocks.get(((DynamicObject)bills.get(i)).getLong(OMComponentBackFlushUtils.getOrderEntryIdName()));
            if (stockDym == null) continue;
            DynamicObjectCollection stockEntry = stockDym.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < stockEntry.size(); ++j) {
                String backflushtime = ((DynamicObject)stockEntry.get(j)).getString("backflushtime");
                String isbackflush = ((DynamicObject)stockEntry.get(j)).getString("isbackflush");
                String issuemode = ((DynamicObject)stockEntry.get(j)).getString("issuemode");
                if (!OMComponentBackFlushUtils.getBackFlushTimeName().equals(backflushtime) || !"B".equals(isbackflush) || "C".equals(issuemode) || !"A".equals(OMComponentBackFlushUtils.getSourcebill()) || !"0".equals(((DynamicObject)bills.get(i)).getString("invscheme.bizdirection"))) continue;
                ArrayList<Object> obj = new ArrayList<Object>(3);
                obj.add(bills.get(i));
                obj.add(stockEntry.get(j));
                obj.add(stockDym);
                gridList.add(obj);
            }
        }
        return gridList;
    }

    private static Map<Object, DynamicObject> getStockDym(Set<Long> orderEntryId) {
        QFilter qf = new QFilter("orderentryid", "in", orderEntryId);
        qf.and(new QFilter("stockentry.isbackflush", "in", (Object)new String[]{"B", "C"}));
        DynamicObject[] stockArray = BusinessDataServiceHelper.load((String)OMComponentBackFlushUtils.getStockName(), (String)OMComponentBackFlushUtils.getMftInBillSelects(OMComponentBackFlushUtils.getStockName()), (QFilter[])qf.toArray());
        HashMap<Object, DynamicObject> stockMap = new HashMap<Object, DynamicObject>(stockArray.length);
        for (int i = 0; i < stockArray.length; ++i) {
            stockMap.put(stockArray[i].getDynamicObject("orderentryid").getPkValue(), stockArray[i]);
        }
        return stockMap;
    }

    private static DynamicObjectCollection getSourceBills(List<Object> entryIdList, String entityName) {
        List entryIds = entryIdList.stream().map(e -> Long.parseLong(e.toString())).collect(Collectors.toList());
        QFilter q = new QFilter(OMComponentBackFlushUtils.getEntryIdName(), "in", entryIds);
        return QueryServiceHelper.query((String)entityName, (String)OMComponentBackFlushUtils.getMftInBillSelects(entityName), (QFilter[])new QFilter[]{q});
    }

    private static String getMftInBillSelects(String entityName) {
        String res = "";
        switch (entityName) {
            case "im_mdc_ominbill": {
                res = OMComponentBackFlushUtils.getOmCmplinSelect();
                break;
            }
            case "om_componentlist": {
                res = OMComponentBackFlushUtils.getOmCompomentSelect();
                break;
            }
        }
        return res;
    }

    private static String getOmCompomentSelect() {
        StringJoiner stringJoiner = new StringJoiner(",");
        stringJoiner.add("id");
        stringJoiner.add("billno");
        stringJoiner.add("backflushtime");
        stringJoiner.add("isbackflush");
        stringJoiner.add("issuemode");
        stringJoiner.add("orderentryid");
        stringJoiner.add("baseqty");
        stringJoiner.add("stockentry.demandqty");
        stringJoiner.add("stockentry.materialunitid");
        stringJoiner.add("stockentry.qtytype");
        stringJoiner.add("stockentry.actissueqty");
        return stringJoiner.toString();
    }

    private static String getOmCmplinSelect() {
        StringJoiner stringJoiner = new StringJoiner(",");
        stringJoiner.add("id");
        stringJoiner.add("billno");
        stringJoiner.add("invscheme.bizdirection");
        stringJoiner.add(OMComponentBackFlushUtils.getEntryIdName());
        stringJoiner.add(OMComponentBackFlushUtils.getOrderEntryIdName());
        stringJoiner.add("billentry.baseqty");
        return stringJoiner.toString();
    }

    public static String getStockName() {
        return stockName;
    }

    public static String getOrderEntryIdName() {
        return orderEntryIdName;
    }

    public static String getBackFlushTimeName() {
        return backFlushTimeName;
    }

    public static String getBaseqtyName() {
        return baseqtyName;
    }

    public static void setBaseqtyName(String baseqtyName) {
        OMComponentBackFlushUtils.baseqtyName = baseqtyName;
    }

    public static String getSourcebill() {
        return sourcebill;
    }

    public static void setSourcebill(String sourcebill) {
        OMComponentBackFlushUtils.sourcebill = sourcebill;
    }

    public static void setEntryIdName(String entryIdName) {
        OMComponentBackFlushUtils.entryIdName = entryIdName;
    }

    public static void setOrderEntryIdName(String orderEntryIdName) {
        OMComponentBackFlushUtils.orderEntryIdName = orderEntryIdName;
    }

    public static void setBackFlushTimeName(String backFlushTimeName) {
        OMComponentBackFlushUtils.backFlushTimeName = backFlushTimeName;
    }

    public static void setStockName(String stockName) {
        OMComponentBackFlushUtils.stockName = stockName;
    }

    public static String getOutBillName() {
        return outBillName;
    }

    public static void setOutBillName(String outBillName) {
        OMComponentBackFlushUtils.outBillName = outBillName;
    }

    public static String getEntryIdName() {
        return entryIdName;
    }

    private OMComponentBackFlushUtils() {
    }
}

