/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.applybill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.helper.BillViewHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.common.mdc.helper.MdcApplyBillImportHelper;
import kd.scmc.im.formplugin.mdc.mftreqbill.MdcApplyBillUtils;
import kd.scmc.im.utils.BigDecimalUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class MdcReturnApplyBillEditTplPlugin
extends AbstractBillPlugIn
implements ClickListener,
BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final String[] allkeys = new String[]{"billentry", "unit", "auditqty", "biztime", "applyuser", "settlecurrency", "comment", "accountorg", "applydept", "biztype", "invorg", "applyuser", "addrow", "deleterow", "fillbatch", "attachmentpanel", "billtype"};
    private static final String[] f7Keys = new String[]{"supplierid", "outwarehouseid", "outlocation", "warehouse", "location"};
    private static final List<String> reqtypes = Arrays.asList("A", "B", "E");
    private static final List<String> returntypes = Arrays.asList("C", "D");
    private static final Log logger = LogFactory.getLog(MdcReturnApplyBillEditTplPlugin.class);
    public static final String ENTITYID_MATERIALREPLACE_F7 = "im_mdc_mftstockf7";
    public static final String ENTITYID_OUTMATERIALREPLACE_F7 = "im_mdc_outmftstockf7";
    public static final String ENTITY_MATERIALREPLACE = "materialreplace";
    public static final String ENTITY_MATERIALREP = "materialrep";
    public static final String ENTITY_STOCKENTRYID = "stockentryid";
    public static final String ENTITY_STOCKENTRYSEQ = "stockentryseq";
    public static final String ENTITY_STOCKBILLNO = "stockbillno";
    public static final String KEY_OUTSTOCK_BILL = "om_mftstock";
    public static final String KEY_STOCK_BILL = "pom_mftstock";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"orderno"});
        for (String f7Key : f7Keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(f7Key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        String appId = this.getView().getFormShowParameter().getAppId();
        Object billType = this.getModel().getValue("billtype");
        if (StringUtils.equals((CharSequence)"om", (CharSequence)appId)) {
            model.setValue("materialtype", (Object)"C");
            if (!"A".equals((String)model.getValue("billstatus"))) {
                return;
            }
            QFilter qf = new QFilter("number", "=", (Object)"im_mdc_mftomreapplybill_BT_S");
            DynamicObject billTypeQuery = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billtype", (QFilter[])new QFilter[]{qf});
            DynamicObject billtype = (DynamicObject)model.getValue("billtype");
            if (ObjectUtils.isEmpty((Object)billtype) || !billTypeQuery.getPkValue().equals(billtype.getPkValue())) {
                model.beginInit();
                model.setValue("billtype", (Object)billTypeQuery);
                DynamicObject biztype = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_biztype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"WX110")});
                model.setValue("biztype", (Object)biztype);
                model.endInit();
            }
        } else if (StringUtils.equals((CharSequence)"pom", (CharSequence)appId)) {
            model.setValue("materialtype", (Object)"A");
            if (!"A".equals((String)model.getValue("billstatus"))) {
                return;
            }
            QFilter qf = new QFilter("number", "=", (Object)"im_mdc_mftreturnapplybill_BT_S");
            DynamicObject billTypeQuery = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billtype", (QFilter[])new QFilter[]{qf});
            DynamicObject billtype = (DynamicObject)model.getValue("billtype");
            if (ObjectUtils.isEmpty((Object)billtype) || !billTypeQuery.getPkValue().equals(billtype.getPkValue())) {
                model.beginInit();
                model.setValue("billtype", (Object)billTypeQuery);
                DynamicObject biztype = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_biztype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"WX110")});
                model.setValue("biztype", (Object)biztype);
                model.endInit();
            }
        } else {
            if (!"A".equals((String)model.getValue("billstatus"))) {
                return;
            }
            if (this.getView().getParentView() != null && this.getView().getParentView().getFormShowParameter().getCustomParam("billtype") != null) {
                String billtypeStr = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("billtype");
                String materialtype = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("materialtype");
                model.setValue("materialtype", (Object)materialtype);
                QFilter qf = new QFilter("number", "=", (Object)billtypeStr);
                DynamicObject billTypeQuery = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billtype", (QFilter[])new QFilter[]{qf});
                DynamicObject billtype = (DynamicObject)model.getValue("billtype");
                if (ObjectUtils.isEmpty((Object)billtype) || !billTypeQuery.getPkValue().equals(billtype.getPkValue())) {
                    model.beginInit();
                    model.setValue("billtype", (Object)billTypeQuery);
                    DynamicObject biztype = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_biztype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"WX110")});
                    model.setValue("biztype", (Object)biztype);
                    model.endInit();
                }
            }
        }
        this.applyUserInit();
        this.initInspectOrg();
    }

    public static boolean checkOrgWithFisqc(Long orgId, String orgRole) {
        boolean result = false;
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)orgRole);
        if (null != org) {
            result = org.getBoolean(orgRole);
        }
        return result;
    }

    private void initInspectOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.setInspectOrg(org, i);
        }
    }

    private void setInspectOrg(DynamicObject org, int i) {
        this.getModel().setValue("qcorg", null, i);
        DynamicObject entryReqOrg = (DynamicObject)this.getModel().getValue("invorg");
        if (entryReqOrg == null && org == null) {
            return;
        }
        Object invorg = this.getModel().getValue("invorg");
        Long invOrgId = MdcReturnApplyBillEditTplPlugin.getDyObjId(invorg);
        if (MdcReturnApplyBillEditTplPlugin.checkOrgWithFisqc(invOrgId, "fisqc")) {
            this.getModel().setValue("qcorg", (Object)invOrgId, i);
            logger.info("initOrgId:invOrgId");
        } else {
            List fromOrgs = OrgUnitServiceHelper.getAllToOrg((String)"", (String)"06", (Long)invOrgId, (boolean)true);
            if (fromOrgs.size() > 0) {
                this.getModel().setValue("qcorg", fromOrgs.get(0), i);
                logger.info("initOrgId:fromOrgs.get(0)");
            } else {
                List orgIds = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"06", (boolean)false);
                if (orgIds.size() > 0) {
                    this.getModel().setValue("qcorg", orgIds.get(0), i);
                    logger.info("initOrgId:orgIds.get(0)");
                }
            }
        }
    }

    public static Set<String> queryMaterialQCIsTrueInfo(Set<Object> materialIDSet, Long orgID) {
        if (materialIDSet == null || materialIDSet.size() < 1 || orgID == null || orgID == 0L) {
            return null;
        }
        QFilter qFilter = new QFilter("masterid", "in", materialIDSet);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_inspect_cfg", (Long)orgID));
        Map dyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_inspect_cfg", (String)"id,entryentity,entryentity.inspecttype,entryentity.nocheckflag,masterid", (QFilter[])qFilter.toArray());
        if (dyMap == null) {
            return null;
        }
        HashSet<String> returnMaterialIDSet = new HashSet<String>(10);
        for (Map.Entry entry : dyMap.entrySet()) {
            boolean isUpdateFlag = false;
            DynamicObject inspectObj = (DynamicObject)entry.getValue();
            DynamicObjectCollection entryeEntity = inspectObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject dyn : entryeEntity) {
                DynamicObject inspectType = dyn.getDynamicObject("inspecttype");
                Object number = inspectType.get("number");
                boolean nocheckflag = dyn.getBoolean("nocheckflag");
                if (!"qcpp-005_S".equals(number) || nocheckflag) continue;
                isUpdateFlag = true;
            }
            if (!isUpdateFlag) continue;
            returnMaterialIDSet.add(inspectObj.getDynamicObject("masterid").getPkValue() + "_" + orgID);
        }
        return returnMaterialIDSet;
    }

    public static Long getDyObjId(Object dyObj) {
        if (dyObj == null) {
            return null;
        }
        if (dyObj instanceof DynamicObject) {
            return ((DynamicObject)dyObj).getLong("id");
        }
        if (dyObj instanceof Long) {
            return (Long)dyObj;
        }
        return null;
    }

    private void applyUserInit() {
        DynamicObject applyOrg = (DynamicObject)this.getModel().getValue("org");
        if (applyOrg == null) {
            return;
        }
        Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)applyOrg.getLong("id"), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        Object settleOrgId = null;
        if (map != null) {
            settleOrgId = map.get("id");
        }
        this.getModel().setValue("accountorg", settleOrgId);
        long userId = UserServiceHelper.getCurrentUserId();
        QFilter qFilter = new QFilter("id", "=", (Object)userId);
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (QFilter[])new QFilter[]{qFilter});
        List<Long> union = this.getUserDeptAndOrgDeptUnion(user, applyOrg);
        this.getModel().setValue("applyuser", (Object)user);
        if (CollectionUtils.isNotEmpty(union)) {
            this.getModel().setValue("applydept", (Object)union.get(0));
        } else {
            this.getModel().setValue("applydept", null);
        }
    }

    private List<Long> getUserDeptAndOrgDeptUnion(DynamicObject applyUser, DynamicObject applyOrg) {
        List orgDepts = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList((Long)applyOrg.getPkValue()), (boolean)true);
        DynamicObjectCollection deptList = applyUser.getDynamicObjectCollection("entryentity");
        ArrayList<Long> deptId = new ArrayList<Long>();
        for (DynamicObject dept : deptList) {
            Boolean isPartJob = dept.getBoolean("ispartjob");
            DynamicObject dpt = dept.getDynamicObject("dpt");
            if (dpt == null) continue;
            Long id = dpt.getLong("id");
            if (!CollectionUtils.isEmpty((Collection)orgDepts) && !orgDepts.contains(id)) continue;
            if (isPartJob.booleanValue()) {
                deptId.add(id);
                continue;
            }
            deptId.add(0, id);
        }
        return deptId;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "supplierid": {
                this.supplierFieldBeforeF7Select(e);
                break;
            }
            case "outwarehouseid": {
                this.outwareHouseFieldBeforeF7Select(e);
                break;
            }
            case "outlocation": {
                this.outlocationFieldBeforeF7Select(e);
                break;
            }
            case "warehouse": {
                this.warehouseFieldBeforeF7Select(e);
                break;
            }
            case "location": {
                this.locationFieldBeforeF7Select(e);
                break;
            }
            case "backfeedreason": {
                this.backfeedreasonBeforeF7Select(e);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String status = (String)this.getModel().getValue("billstatus");
        if ("D".equals(status)) {
            this.disableAll();
        } else if ("A".equals(status)) {
            this.enableAll();
            this.setEntryEnable();
            this.setEntryEnable(this.getModel().getFilterEntryRowCount("billentry"));
        }
        String billcretype = (String)this.getModel().getValue("billcretype");
        if (StringUtils.equals((CharSequence)"4", (CharSequence)billcretype)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"billtype"});
        }
    }

    private void setEntryEnable(int size) {
        for (int i = 0; i < size; ++i) {
            if (this.getModel().getValue("outinvorg", i) == null) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"outwarehouseid"});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"outwarehouseid"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object invorg;
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        int[] selectRows = entryGrid.getSelectRows();
        if ("entryclose".equals(op.getOperateKey()) || "entryunclose".equals(op.getOperateKey())) {
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u884c\u5206\u5f55\u3002", (String)"MdcReturnApplyBillEditTplPlugin_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                StringBuilder sb = new StringBuilder();
                DynamicObjectCollection billentrys = this.getModel().getEntryEntity("billentry");
                for (int i = 0; i < selectRows.length; ++i) {
                    DynamicObject billentry = (DynamicObject)billentrys.get(selectRows[i]);
                    sb.append(billentry.getPkValue());
                    sb.append("@");
                }
                op.getOption().setVariableValue("entryids", sb.toString());
            }
        }
        if ("audit".equals(op.getOperateKey()) || "unaudit".equals(op.getOperateKey())) {
            String name = ((BillView)this.getView()).getRootControl().getKey();
            op.getOption().setVariableValue("layoutname", name);
        }
        if ("newentry".equals(op.getOperateKey()) && (invorg = this.getModel().getValue("invorg")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u65b0\u589e\u884c\u3002", (String)"MdcReturnApplyBillEditTplPlugin_1", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operate = e.getOperateKey();
        if ("entryclose".equals(operate) || "entryunclose".equals(operate)) {
            if (e.getOperationResult().isSuccess()) {
                this.getView().invokeOperation("refresh");
            }
        } else if ("unsubmit".equals(operate) || "unaudit".equals(operate)) {
            this.enableAll();
            this.setEntryEnable();
        }
        if ("newentry".equals(operate)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            this.getModel().setValue("isadd", (Object)"1", rowIndex);
        }
        if ("submit".equals(operate)) {
            this.setEntryEnable();
        }
    }

    private void setEntryEnable() {
        DynamicObjectCollection billEntrys = this.getModel().getDataEntity().getDynamicObjectCollection("billentry");
        for (int i = 0; i < billEntrys.size(); ++i) {
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"unit", "auditqty"});
        }
    }

    private void enableAll() {
        this.getView().setEnable(Boolean.valueOf(true), allkeys);
    }

    private void disableAll() {
        this.getView().setEnable(Boolean.valueOf(false), allkeys);
    }

    public void click(EventObject evt) {
        if (MdcApplyBillUtils.valOrgIsNull(this.getModel(), this.getView())) {
            return;
        }
        Control sourceField = (Control)evt.getSource();
        String key = sourceField.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"orderno")) {
            this.showBillList();
        }
    }

    private void showBillList() {
        QFilter extQFilter;
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)MdcApplyBillUtils.getEntityName(this.getModel(), 0), (boolean)true);
        List filters = showParameter.getListFilterParameter().getQFilters();
        filters.add(MdcApplyBillUtils.getOrderQFilter(this.getModel()));
        filters.add(new QFilter("treeentryentity.planstatus", "=", (Object)"C"));
        filters.add(new QFilter("transactiontype.isoffreqallowed", "=", (Object)true));
        DynamicObject productline = (DynamicObject)this.getModel().getValue("productline", this.getSelectEntryRowIndex());
        if (productline != null) {
            filters.add(new QFilter("treeentryentity.productline", "=", productline.getPkValue()));
        }
        if ((extQFilter = this.getExtQFilter()) != null) {
            filters.add(extQFilter);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "orderno");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public QFilter getExtQFilter() {
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String group;
        super.closedCallBack(closedCallBackEvent);
        this.getPageCache().put("flag", "1");
        int currentRowIndex = this.getSelectEntryRowIndex();
        if ("orderno".equals(closedCallBackEvent.getActionId())) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (rows != null && !rows.isEmpty()) {
                EntryGrid entryGrid;
                String field = "id,billtype,orderno,orderid,orderentryid,billno,bdproject,tracknumber";
                String entityName = MdcApplyBillUtils.getEntityName(this.getModel(), 1);
                if ("prop_mftstock".equals(entityName)) {
                    field = field + ",productline";
                }
                if ((entryGrid = (EntryGrid)this.getView().getControl("billentry")).getSelectRows().length == 0) {
                    return;
                }
                int rowIndex = entryGrid.getSelectRows()[0];
                DynamicObjectCollection billentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
                ArrayList pkValues = new ArrayList();
                rows.forEach(t -> pkValues.add(t.getEntryPrimaryKeyValue()));
                DynamicObject[] stock = BusinessDataServiceHelper.load((String)entityName, (String)field, (QFilter[])new QFilter[]{new QFilter("orderentryid", "in", pkValues)});
                HashMap<Long, DynamicObject> fieldMapping = new HashMap<Long, DynamicObject>(16);
                for (DynamicObject dynamicObject : stock) {
                    Long orderentryid = (Long)dynamicObject.getDynamicObject("orderentryid").getPkValue();
                    fieldMapping.put(orderentryid, dynamicObject);
                }
                boolean flag = true;
                this.getView().invokeOperation("newentry");
                DynamicObject tempt = (DynamicObject)billentry.get(billentry.size() - 1);
                billentry.remove((Object)tempt);
                DynamicObject dynamicObject = new DynamicObject();
                for (int i = 0; i < pkValues.size(); ++i) {
                    Long o = (Long)pkValues.get(i);
                    DynamicObject res = (DynamicObject)fieldMapping.get(o);
                    dynamicObject = flag ? (DynamicObject)billentry.get(rowIndex) : (DynamicObject)OrmUtils.clone((IDataEntityBase)tempt, (boolean)true, (boolean)true);
                    dynamicObject.set("orderno", (Object)res.getString("orderno"));
                    dynamicObject.set("orderid", res.get("orderid"));
                    DynamicObject orderEntryf7 = res.getDynamicObject("orderentryid");
                    dynamicObject.set("orderentryid", orderEntryf7.getPkValue());
                    dynamicObject.set("orderentryseq", orderEntryf7.get("entryseq"));
                    dynamicObject.set("srcbillnumber", res.get("billno"));
                    dynamicObject.set("mainbillnumber", res.get("billno"));
                    dynamicObject.set("mainbillid", res.getPkValue());
                    dynamicObject.set("mainbillentity", (Object)MdcApplyBillUtils.getEntityName(this.getModel(), 1));
                    if ("pom_mrostock".equals(entityName)) {
                        DynamicObject project = orderEntryf7.getDynamicObject("project");
                        dynamicObject.set("customer", orderEntryf7.get("customer"));
                        dynamicObject.set("project", (Object)project);
                        dynamicObject.set("headproject", (Object)project);
                        dynamicObject.set("workcard", orderEntryf7.get("workcard"));
                    } else {
                        dynamicObject.set("srcbilltype", res.get("billtype"));
                        dynamicObject.set("srcbillnumber", res.get("billno"));
                        dynamicObject.set("srcbillid", res.get("id"));
                        dynamicObject.set("tracknumber", res.get("tracknumber"));
                        dynamicObject.set("project", res.get("bdproject"));
                    }
                    if ("prop_mftstock".equals(entityName)) {
                        dynamicObject.set("productline", res.get("productline"));
                    }
                    if (flag) {
                        flag = false;
                        continue;
                    }
                    billentry.add(++rowIndex, dynamicObject);
                }
                this.getView().updateView("billentry");
            }
        } else if ("mftreqbind".equals(closedCallBackEvent.getActionId()) && !"0".equals(group = this.getPageCache().get("mftreqbindgroup"))) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
            int[] selectRows = entryGrid.getSelectRows();
            for (int i = 0; i < selectRows.length; ++i) {
                this.getModel().setValue("materialgroup", (Object)group, selectRows[i]);
            }
        }
    }

    public int getSelectEntryRowIndex() {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        int changeIndex = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "orderno": {
                String stockno = (String)this.getModel().getValue("orderno", changeIndex);
                if (!StringUtils.isBlank((CharSequence)stockno)) {
                    QFilter filter = new QFilter("billno", "=", (Object)stockno);
                    QFilter extQFilter = this.getExtQFilter();
                    if (extQFilter != null) {
                        filter.and(extQFilter);
                    }
                    filter.and(MdcApplyBillUtils.getOrderQFilter(this.getModel()));
                    DynamicObject order = BusinessDataServiceHelper.loadSingle((String)MdcApplyBillUtils.getEntityName(this.getModel(), 0), (String)"treeentryentity,treeentryentity.id,treeentryentity.producttype,treeentryentity.material", (QFilter[])new QFilter[]{filter});
                    if (order == null) {
                        MdcApplyBillUtils.setStockInfo(null, changeIndex, this.getModel());
                        String entityName = MdcApplyBillUtils.getEntityName(this.getModel(), 1);
                        if ("prop_mftstock".equals(entityName)) {
                            this.getModel().setValue("productline", null, this.getSelectEntryRowIndex());
                            this.getView().setEnable(Boolean.TRUE, this.getSelectEntryRowIndex(), new String[]{"productline"});
                        }
                    } else {
                        DynamicObjectCollection entrys = order.getDynamicObjectCollection("treeentryentity");
                        DynamicObject stockdym = BusinessDataServiceHelper.loadSingle((String)MdcApplyBillUtils.getEntityName(this.getModel(), 1), (String)"productline,orderno,orderid,orderentryid,billno,billtype,tracknumber,bdproject", (QFilter[])new QFilter[]{new QFilter("orderentryid", "=", ((DynamicObject)entrys.get(0)).getPkValue())});
                        MdcApplyBillUtils.setStockInfo(stockdym, changeIndex, this.getModel());
                        this.setReworkFlag(this.getModel().getValue("material", changeIndex), entrys, changeIndex);
                    }
                } else {
                    MdcApplyBillUtils.setStockInfo(null, changeIndex, this.getModel());
                    String entityName = MdcApplyBillUtils.getEntityName(this.getModel(), 1);
                    if ("prop_mftstock".equals(entityName)) {
                        this.getModel().setValue("productline", null, this.getSelectEntryRowIndex());
                        this.getView().setEnable(Boolean.TRUE, this.getSelectEntryRowIndex(), new String[]{"productline"});
                    }
                }
                Object outinvorg = this.getModel().getValue("outinvorg");
                if (null != outinvorg) {
                    this.getView().setEnable(Boolean.TRUE, changeIndex, new String[]{"outwarehouseid"});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, changeIndex, new String[]{"outwarehouseid"});
                break;
            }
            case "material": {
                this.setSupplyDefalut(changeIndex);
                Object orderentryid = this.getModel().getValue("orderentryid", changeIndex);
                if (ObjectUtils.isNotEmpty((Object)orderentryid)) {
                    QFilter filter = new QFilter("treeentryentity.id", "=", orderentryid);
                    DynamicObject order = BusinessDataServiceHelper.loadSingle((String)MdcApplyBillUtils.getEntityName(this.getModel(), 0), (String)"treeentryentity,treeentryentity.id,treeentryentity.producttype,treeentryentity.material", (QFilter[])new QFilter[]{filter});
                    if (null != order) {
                        DynamicObjectCollection entrys = order.getDynamicObjectCollection("treeentryentity");
                        this.setReworkFlag(e.getChangeSet()[0].getNewValue(), entrys, changeIndex);
                    }
                }
                this.getModel().setValue("mversion", null, changeIndex);
                DynamicObject invorg = (DynamicObject)this.getModel().getValue("invorg", changeIndex);
                this.setCheckBack(invorg, changeIndex);
                break;
            }
            case "supplymode": {
                this.setSupplyDefalut(changeIndex);
                break;
            }
            case "warehouse": {
                DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse", changeIndex);
                if (warehouse != null) {
                    boolean isOpenLocation = warehouse.getBoolean("isopenlocation");
                    this.getModel().setValue("location", null, changeIndex);
                    this.getView().setEnable(Boolean.valueOf(isOpenLocation), changeIndex, new String[]{"location"});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, changeIndex, new String[]{"location"});
                this.getModel().setValue("location", null, changeIndex);
                break;
            }
            case "outwarehouseid": {
                DynamicObject outwarehouseid = (DynamicObject)this.getModel().getValue("outwarehouseid", changeIndex);
                if (outwarehouseid != null) break;
                this.getModel().setValue("outlocation", null, changeIndex);
                break;
            }
            case "unit": 
            case "qty": 
            case "auditqty": {
                this.setBizQtyAndUnit(changeIndex);
                break;
            }
            case "qtyunit2nd": {
                if (!this.getModel().getValue("auditqty", changeIndex).equals(this.getModel().getValue("qty", changeIndex))) break;
                this.getModel().setValue("auditbaseqty", this.getModel().getValue("baseqty", changeIndex), changeIndex);
                break;
            }
            case "outinvorg": {
                DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (null != newValue) {
                    this.getView().setEnable(Boolean.TRUE, changeIndex, new String[]{"outwarehouseid"});
                    break;
                }
                this.getModel().setValue("outwarehouseid", null);
                this.getView().setEnable(Boolean.FALSE, changeIndex, new String[]{"outwarehouseid"});
                break;
            }
            case "invorg": {
                DynamicObject newObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
                DynamicObject oldObj = (DynamicObject)e.getChangeSet()[0].getOldValue();
                String newtran = "";
                String oldtran = "";
                if (newObj != null) {
                    newtran = newObj.getPkValue().toString();
                }
                if (oldObj != null) {
                    oldtran = oldObj.getPkValue().toString();
                }
                this.getPageCache().put("newheadinvorg", newtran);
                this.getPageCache().put("oldheadinvorg", oldtran);
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
                if (oldObj == null || newtran.equals(this.getPageCache().get("oldheadinvorg")) || entryEntity == null || entryEntity.isEmpty()) break;
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("headinvorgchange", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u5207\u6362\u5e93\u5b58\u7ec4\u7ec7\u5c06\u6e05\u9664\u7269\u6599\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"MdcReturnApplyBillEditTplPlugin_2", (String)"scmc-mm-mdc", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                break;
            }
            case "qcorg": {
                DynamicObject newOrg = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.setCheckBack(newOrg, changeIndex);
                break;
            }
        }
    }

    private void setCheckBack(DynamicObject newOrg, int changeIndex) {
        Object material = this.getModel().getValue("materialmasterid", changeIndex);
        Long materialMasterId = MdcReturnApplyBillEditTplPlugin.getDyObjId(material);
        Long invOrgId = MdcReturnApplyBillEditTplPlugin.getDyObjId(newOrg);
        HashSet<Object> materialMasterIds = new HashSet<Object>(16);
        materialMasterIds.add(materialMasterId);
        Set<String> materialQCIsTrueInfo = MdcReturnApplyBillEditTplPlugin.queryMaterialQCIsTrueInfo(materialMasterIds, invOrgId);
        if (materialQCIsTrueInfo != null && materialQCIsTrueInfo.size() > 0) {
            this.getModel().setValue("checkback", (Object)true, changeIndex);
        } else {
            this.getModel().setValue("checkback", (Object)false, changeIndex);
        }
    }

    private void setReworkFlag(Object obj, DynamicObjectCollection entrys, int changeIndex) {
        if (ObjectUtils.isEmpty((Object)obj)) {
            return;
        }
        DynamicObject material = (DynamicObject)obj;
        long reqMaterId = material.getDynamicObject("masterid").getLong("id");
        for (DynamicObject order : entrys) {
            if (!StringUtils.equals((CharSequence)"C", (CharSequence)order.getString("producttype")) || reqMaterId != order.getDynamicObject("material").getDynamicObject("masterid").getLong("id")) continue;
            this.getModel().setValue("rework", (Object)true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"headinvorgchange", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("billentry");
                this.setValueNoChange("invorg", this.getPageCache().get("newheadinvorg"));
            } else {
                this.setValueNoChange("invorg", this.getPageCache().get("oldheadinvorg"));
            }
        }
    }

    private void setValueNoChange(String keystr, Object oldObj) {
        this.getModel().beginInit();
        Long newOrg = "".equals((String)oldObj) ? null : Long.valueOf((String)oldObj);
        this.getModel().setValue(keystr, (Object)newOrg);
        this.getModel().endInit();
        this.getView().updateView(keystr);
    }

    private void setBizQtyAndUnit(int changeIndex) {
        IDataModel model = this.getModel();
        DynamicObject materialInvInfo = (DynamicObject)model.getValue("material", changeIndex);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        BigDecimal auditqty = (BigDecimal)model.getValue("auditqty", changeIndex);
        BigDecimal qty = (BigDecimal)model.getValue("qty", changeIndex);
        DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", changeIndex);
        BigDecimal auditbaseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)((DynamicObject)model.getValue("unit", changeIndex)), (BigDecimal)auditqty, (DynamicObject)baseUnit);
        BigDecimal baseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)((DynamicObject)model.getValue("unit", changeIndex)), (BigDecimal)qty, (DynamicObject)baseUnit);
        BigDecimalUtils.showBigDecimalErrorTip((IDataModel)model, (BigDecimal)auditbaseQty, (String)"auditbaseqty");
        BigDecimalUtils.showBigDecimalErrorTip((IDataModel)model, (BigDecimal)baseQty, (String)"auditbaseqty");
        model.beginInit();
        model.setValue("auditbaseqty", (Object)auditbaseQty, changeIndex);
        model.setValue("baseqty", (Object)baseQty, changeIndex);
        model.setValue("unpickqty", (Object)auditqty.subtract((BigDecimal)model.getValue("useoutqty", changeIndex)), changeIndex);
        model.setValue("unpickbaseqty", (Object)auditbaseQty.subtract((BigDecimal)model.getValue("useoutbaseqty", changeIndex)), changeIndex);
        model.endInit();
        BillViewHelper.updateViewRow((IFormView)this.getView(), (int)changeIndex, (String)"billentry");
    }

    private void setSupplyDefalut(int changeIndex) {
        String supplymode = (String)this.getModel().getValue("supplymode", changeIndex);
        DynamicObject invorg = (DynamicObject)this.getModel().getValue("invorg");
        if ("bos_org".equals(supplymode) && invorg != null) {
            Long orgId = (Long)invorg.getPkValue();
            List<Object> ownerArray = MdcApplyBillUtils.getOwners(orgId);
            if (!ownerArray.isEmpty()) {
                this.getModel().setValue("supplierid", ownerArray.get(0), changeIndex);
            } else if (((Boolean)invorg.get("fisaccounting")).booleanValue()) {
                this.getModel().setValue("supplierid", (Object)invorg, changeIndex);
            }
        }
    }

    private void outlocationFieldBeforeF7Select(BeforeF7SelectEvent e) {
        int seq = this.getSelectEntryRowIndex();
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("outwarehouseid", seq);
        if (warehouse == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u8c03\u51fa\u4ed3\u5e93\u3002", (String)"MdcReturnApplyBillEditTplPlugin_3", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        this.locationFilter(warehouse, e);
    }

    private void locationFilter(DynamicObject warehouseold, BeforeF7SelectEvent e) {
        ArrayList<Object> locationList = new ArrayList<Object>(16);
        DynamicObject warehouse = BusinessDataServiceHelper.loadSingle((Object)warehouseold.getPkValue(), (String)"bd_warehouse");
        DynamicObjectCollection col = warehouse.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject obj = (DynamicObject)col.get(i);
            DynamicObject location = (DynamicObject)obj.get("location");
            if (location == null) continue;
            locationList.add(location.getPkValue());
        }
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qfilter = new QFilter("id", "in", locationList);
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    private void backfeedreasonBeforeF7Select(BeforeF7SelectEvent e) {
        String reqtype = (String)this.getModel().getValue("reqtype");
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        if (reqtypes.contains(reqtype)) {
            QFilter qfilter = new QFilter("feedreasongroup.groupattribute", "=", (Object)"B");
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        } else if (returntypes.contains(reqtype)) {
            QFilter qfilter = new QFilter("feedreasongroup.groupattribute", "=", (Object)"A");
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        }
    }

    private void outwareHouseFieldBeforeF7Select(BeforeF7SelectEvent e) {
        int seq = this.getSelectEntryRowIndex();
        DynamicObject org = (DynamicObject)this.getModel().getValue("outinvorg", seq);
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u8c03\u51fa\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"MdcReturnApplyBillEditTplPlugin_4", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        this.warehouseFilter(org, e);
    }

    private void warehouseFilter(DynamicObject org, BeforeF7SelectEvent e) {
        ListShowParameter listShowParameter;
        Long[] warehouseids = MdcApplyBillUtils.getAllFinishInitWarehouseIDs(Long.parseLong(org.getPkValue().toString()));
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Long warehouseid : warehouseids) {
            if (warehouseid == null) continue;
            ids.add(warehouseid);
        }
        if (!ids.isEmpty()) {
            listShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter qfilter = new QFilter("id", "in", ids);
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        } else {
            listShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter qfilter = new QFilter("id", "=", (Object)Long.valueOf("0"));
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        }
    }

    private void locationFieldBeforeF7Select(BeforeF7SelectEvent e) {
        int seq = this.getSelectEntryRowIndex();
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse", seq);
        if (warehouse == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4ed3\u5e93\u3002", (String)"MdcReturnApplyBillEditTplPlugin_5", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        this.locationFilter(warehouse, e);
    }

    private void warehouseFieldBeforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("invorg");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"MdcReturnApplyBillEditTplPlugin_6", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        this.warehouseFilter(org, e);
    }

    private void supplierFieldBeforeF7Select(BeforeF7SelectEvent e) {
        int index = this.getSelectEntryRowIndex();
        String supplyfield = (String)this.getModel().getValue("supplymode", index);
        DynamicObject invorg = (DynamicObject)this.getModel().getValue("invorg");
        if ("bos_org".equals(supplyfield) && invorg != null) {
            ArrayList<Object> array = new ArrayList<Object>();
            Long orgId = (Long)invorg.getPkValue();
            List<Object> ownerArray = MdcApplyBillUtils.getOwners(orgId);
            array.addAll(ownerArray);
            if (((Boolean)invorg.get("fisaccounting")).booleanValue()) {
                array.add(invorg.get("id"));
            }
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", array));
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        MdcApplyBillImportHelper.afterImportData(e, model, view, (AbstractFormPlugin)this);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        this.applyUserInit();
        this.initCurrency();
        DynamicObjectCollection billentryColl = dataEntity.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : billentryColl) {
            DynamicObjectCollection entrys;
            DynamicObject order;
            QFilter filter;
            int changeIndex = entry.getInt("seq") - 1;
            Object materialObj = entry.get("material");
            Object orderno = entry.get("orderno");
            Object qtyunit2ndObj = entry.get("qtyunit2nd");
            if (materialObj != null) {
                this.setSupplyDefalut(changeIndex);
                Object orderentryid = this.getModel().getValue("orderentryid", changeIndex);
                if (ObjectUtils.isNotEmpty((Object)orderentryid)) {
                    filter = new QFilter("treeentryentity.id", "=", orderentryid);
                    order = BusinessDataServiceHelper.loadSingle((String)MdcApplyBillUtils.getEntityName(this.getModel(), 0), (String)"treeentryentity,treeentryentity.id,treeentryentity.producttype,treeentryentity.material", (QFilter[])new QFilter[]{filter});
                    if (null != order) {
                        entrys = order.getDynamicObjectCollection("treeentryentity");
                        this.setReworkFlag(materialObj, entrys, changeIndex);
                    }
                }
                this.getModel().setValue("mversion", null, changeIndex);
            }
            if (orderno != null) {
                String stockno = orderno.toString();
                if (!StringUtils.isBlank((CharSequence)stockno)) {
                    filter = new QFilter("billno", "=", (Object)stockno);
                    filter.and(MdcApplyBillUtils.getOrderQFilter(this.getModel()));
                    order = BusinessDataServiceHelper.loadSingle((String)MdcApplyBillUtils.getEntityName(this.getModel(), 0), (String)"treeentryentity,treeentryentity.id,treeentryentity.producttype,treeentryentity.material", (QFilter[])new QFilter[]{filter});
                    if (order == null) {
                        MdcApplyBillUtils.setStockInfo(null, changeIndex, this.getModel());
                    } else {
                        entrys = order.getDynamicObjectCollection("treeentryentity");
                        DynamicObject stockdym = BusinessDataServiceHelper.loadSingle((String)MdcApplyBillUtils.getEntityName(this.getModel(), 1), (String)"orderno,orderid,orderentryid,billno,billtype,tracknumber,bdproject", (QFilter[])new QFilter[]{new QFilter("orderentryid", "=", ((DynamicObject)entrys.get(0)).getPkValue())});
                        MdcApplyBillUtils.setStockInfo(stockdym, changeIndex, this.getModel());
                        this.setReworkFlag(this.getModel().getValue("material", changeIndex), entrys, changeIndex);
                    }
                } else {
                    MdcApplyBillUtils.setStockInfo(null, changeIndex, this.getModel());
                }
            }
            if (qtyunit2ndObj != null && this.getModel().getValue("auditqty", changeIndex).equals(this.getModel().getValue("qty", changeIndex))) {
                this.getModel().setValue("auditbaseqty", this.getModel().getValue("baseqty", changeIndex), changeIndex);
            }
            this.setBizQtyAndUnit(changeIndex);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List entities = e.getRows();
        entities.forEach(entry -> this.setEntryEnable((RowDataEntity)entry));
    }

    private void setEntryEnable(RowDataEntity row) {
        IFormView view = this.getView();
        if (!row.getDataEntity().getBoolean("isadd")) {
            view.setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"productline"});
        } else if (row.getDataEntity().getString("orderno") != null && row.getDataEntity().getString("orderno").length() > 0) {
            view.setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"productline"});
        } else {
            view.setEnable(Boolean.TRUE, row.getRowIndex(), new String[]{"productline"});
        }
        DynamicObject outinvorg = row.getDataEntity().getDynamicObject("outinvorg");
        if (null != outinvorg) {
            view.setEnable(Boolean.TRUE, row.getRowIndex(), new String[]{"outwarehouseid"});
        } else {
            view.setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"outwarehouseid"});
        }
    }

    private void initCurrency() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getModel().setValue("settlecurrency", null);
            return;
        }
        Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)org.getLong("id"));
        if (map == null) {
            this.getModel().setValue("settlecurrency", null);
            return;
        }
        this.getModel().setValue("settlecurrency", map.get("baseCurrencyID"));
    }
}

