/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.mftouttpl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.common.mdc.helper.InvDiffShareQueryDataHelper;
import kd.scmc.im.common.mdc.utils.ManuFactureTraceUtils;
import kd.scmc.im.common.mdc.utils.MftReqOutBillUtil;
import kd.scmc.im.formplugin.mdc.mftouttpl.BackDiffShareUtil;
import kd.scmc.im.formplugin.mdc.mftouttpl.ext.IMftBackDiffShareQueryExt;
import kd.scmc.im.opplugin.mdc.utils.BackDiffShareAuxMatchUtil;
import kd.scmc.im.utils.DateUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MftBackDiffShareEdit
extends AbstractBillPlugIn
implements ClickListener,
RowClickEventListener,
BeforeF7SelectListener,
HyperLinkClickListener,
EntryGridBindDataListener {
    private static final Log logger = LogFactory.getLog(MftBackDiffShareEdit.class);
    private static Map<String, Object> oldData = new HashMap<String, Object>(16);
    private static Set<String> fieldKeySet = new HashSet<String>(16);

    private static String getMftOrderSelects() {
        return "billno,id,org,transactiontype,treeentryentity.id,treeentryentity.bdproject,treeentryentity.producttype,treeentryentity.material,treeentryentity.unit,treeentryentity.producedept,treeentryentity.qty,treeentryentity.baseunit,treeentryentity.baseqty,treeentryentity.tracknumber,treeentryentity.configuredcode,treeentryentity.inwardept,treeentryentity.closebookdate,treeentryentity.closetime,treeentryentity.bizstatus";
    }

    public void registerListener(EventObject e) {
        BasedataEdit location2;
        BasedataEdit mullocation;
        BasedataEdit mulwarehouse;
        BasedataEdit warehouse;
        BasedataEdit material;
        BasedataEdit ematerial;
        BasedataEdit smaterial;
        BasedataEdit producedept;
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry1");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid billentry = (EntryGrid)this.getView().getControl("billentry");
        billentry.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"orderno"});
        BasedataEdit invorg = (BasedataEdit)this.getView().getControl("invorg");
        if (invorg != null) {
            invorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((producedept = (BasedataEdit)this.getView().getControl("producedept")) != null) {
            producedept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((smaterial = (BasedataEdit)this.getView().getControl("smaterial")) != null) {
            smaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((ematerial = (BasedataEdit)this.getView().getControl("ematerial")) != null) {
            ematerial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getView().getControl("material")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((warehouse = (BasedataEdit)this.getView().getControl("warehouse")) != null) {
            warehouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((mulwarehouse = (BasedataEdit)this.getView().getControl("mulwarehouse")) != null) {
            mulwarehouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((mullocation = (BasedataEdit)this.getView().getControl("mullocation")) != null) {
            mullocation.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((location2 = (BasedataEdit)this.getView().getControl("location2")) != null) {
            location2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity t;
        String entityName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        if ("billentry".equals(entityName) && this.isNull(model.getValue("materielmasterid", (t = e.getRowDataEntities()[0]).getRowIndex()))) {
            model.setValue("isadd", (Object)Boolean.TRUE, t.getRowIndex());
        }
    }

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Date dayStartTime = DateUtils.getDayStartTime((Date)new Date());
        this.getModel().setValue("indatestart", (Object)dayStartTime);
        this.getModel().setValue("indateend", (Object)dayStartTime);
        DynamicObject orgDym = (DynamicObject)this.getModel().getValue("org");
        if (orgDym == null) {
            this.getView().updateView("indatestart");
            this.getView().updateView("indateend");
            return;
        }
        Long orgid = (Long)orgDym.getPkValue();
        List<Long> inwareOrgFilter = this.getInwareOrgFilter(orgid);
        if (!inwareOrgFilter.isEmpty()) {
            if (inwareOrgFilter.contains(orgid)) {
                this.getModel().setValue("invorg", (Object)orgid);
            } else {
                this.getModel().setValue("invorg", (Object)inwareOrgFilter.get(0));
            }
        }
        this.getView().updateView("indatestart");
        this.getView().updateView("indateend");
        this.getView().updateView("invorg");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        DynamicObjectCollection entryEntity;
        OperationResult operationResult2;
        FormOperate op = (FormOperate)e.getSource();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)"newentryinv", (CharSequence)op.getOperateKey()) || StringUtils.equals((CharSequence)"deleteentryinv", (CharSequence)op.getOperateKey())) {
            // empty if block
        }
        if (StringUtils.equals((CharSequence)"shareandpush", (CharSequence)op.getOperateKey()) && (operationResult2 = e.getOperationResult()).isSuccess()) {
            this.getView().getPageCache().put("opKey", "shareandpush");
            this.getView().invokeOperation("bfshare");
        }
        if (StringUtils.equals((CharSequence)"unshareandpush", (CharSequence)op.getOperateKey()) && (operationResult2 = e.getOperationResult()).isSuccess()) {
            this.getView().getPageCache().put("opKey", "unshareandpush");
            this.getView().invokeOperation("ungenerate");
        }
        if (StringUtils.equals((CharSequence)"bfquery", (CharSequence)op.getOperateKey())) {
            Object value = this.getModel().getValue("org");
            if (value == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"MftBackDiffShareEdit_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                return;
            }
            OperationResult operationResult = e.getOperationResult();
            if (!operationResult.isSuccess()) {
                return;
            }
            Map<String, BigDecimal> repeatEntryId = this.getRepeatEntryId(model);
            model.deleteEntryData("billentry1");
            this.insertBillEntry(repeatEntryId);
            this.getView().getPageCache().put("operateBaseInfo", "0");
        }
        if (StringUtils.equals((CharSequence)"bfshare", (CharSequence)op.getOperateKey())) {
            // empty if block
        }
        if ("viewresult".equals(op.getOperateKey())) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"im_mdc_backdiffshare_f7");
            DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
            cacheManager.removeByDt();
            Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
            QFilter filter = new QFilter("diffshareid", "=", (Object)pkValue);
            DynamicObjectCollection bills = QueryServiceHelper.query((String)"im_mdc_backdiffshare_log", (String)"id,billno", (QFilter[])new QFilter[]{filter});
            HashSet<Object> idList = new HashSet<Object>(bills.size());
            for (int i = 0; i < bills.size(); ++i) {
                idList.add(((DynamicObject)bills.get(i)).get("id"));
            }
            if (idList.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5206\u644a\u8be6\u60c5\u4fe1\u606f\u3002", (String)"MftBackDiffShareEdit_1", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            } else {
                ArrayList<QFilter> billFilter = new ArrayList<QFilter>();
                billFilter.add(filter);
                ListShowParameter showParameter = ManuFactureTraceUtils.createShowParam("im_mdc_backdiffshare_log", billFilter);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
        if ("viewproorder".equals(op.getOperateKey())) {
            Boolean isassagin = (Boolean)model.getValue("isassagin");
            if (!isassagin.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0b\u63a8\u5206\u914d\u518d\u8054\u67e5\u3002", (String)"MftBackDiffShareEdit_42", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                return;
            }
            Object pkid = model.getValue("id");
            QFilter qfilter = new QFilter("diffshareid", "=", (Object)NumberUtils.toLong((String)pkid.toString()));
            DynamicObject detailOne = QueryServiceHelper.queryOne((String)"im_mdc_diffsharedetail", (String)"id", (QFilter[])new QFilter[]{qfilter});
            if (detailOne != null) {
                QFilter qfilter2 = new QFilter("billentry.srcbillid", "=", (Object)detailOne.getLong("id"));
                DynamicObject[] bills = BusinessDataServiceHelper.load((String)"im_mdc_mftproorder", (String)"id,billno,billtype", (QFilter[])new QFilter[]{qfilter2});
                HashSet<Long> proOrderSet = new HashSet<Long>();
                HashSet<Long> returnOrderSet = new HashSet<Long>();
                for (DynamicObject proDym : bills) {
                    Long proid = proDym.getLong("id");
                    DynamicObject billtype = proDym.getDynamicObject("billtype");
                    if (billtype.getString("number").indexOf("im_mdc_mftproorder") >= 0) {
                        proOrderSet.add(proid);
                        continue;
                    }
                    if (billtype.getString("number").indexOf("im_mdc_mftreturnorder") < 0) continue;
                    returnOrderSet.add(proid);
                }
                if (returnOrderSet.isEmpty() && proOrderSet.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4e0b\u6e38\u9886\u6599\u5355\u3002", (String)"MftBackDiffShareEdit_3", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, HashSet<Long>> findTargetBills = new HashMap<String, HashSet<Long>>();
                findTargetBills.put("im_mdc_mftproorder", proOrderSet);
                findTargetBills.put("im_mdc_mftreturnorder", returnOrderSet);
                HashMap<String, String> para = new HashMap<String, String>();
                para.put("formId", "im_mdc_proorderview");
                FormShowParameter fsParameter = FormShowParameter.createFormShowParameter(para);
                fsParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                fsParameter.setCustomParam("paramList", findTargetBills);
                this.getView().showForm(fsParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u644a\u660e\u7ec6\u672a\u5206\u914d\u3002", (String)"MftBackDiffShareEdit_43", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                return;
            }
        }
        String billstatus = (String)this.getModel().getValue("billstatus");
        if ("allselect".equals(op.getOperateKey()) && billstatus.equals("A")) {
            model.beginInit();
            entryEntity = model.getEntryEntity("billentry1");
            for (DynamicObject ecol : entryEntity) {
                ecol.set("difshare1", (Object)"1");
            }
            model.endInit();
            this.getView().updateView("billentry1");
        }
        if ("unallselect".equals(op.getOperateKey()) && billstatus.equals("A")) {
            model.beginInit();
            entryEntity = model.getEntryEntity("billentry1");
            for (DynamicObject ecol : entryEntity) {
                ecol.set("difshare1", (Object)"0");
            }
            model.endInit();
            this.getView().updateView("billentry1");
        }
    }

    private Map<String, BigDecimal> getDiffStockTotal(List<Map<String, Object>> diffStock, String[] splitkey, DynamicObject model, Map<Long, List<Map<String, Object>>> stockMap) {
        HashMap<String, BigDecimal> numTotals = new HashMap<String, BigDecimal>();
        numTotals.put("madebasenum", BigDecimal.ZERO);
        numTotals.put("pickbasenum", BigDecimal.ZERO);
        if (splitkey.length == 2) {
            Long materialId = NumberUtils.toLong((String)splitkey[1]);
            DynamicObject owner = model.getDynamicObject("owner");
            if (stockMap.containsKey(materialId)) {
                List<Map<String, Object>> mStock = stockMap.get(materialId);
                if (!stockMap.isEmpty() && mStock.size() > 0) {
                    boolean openAuxSet = BackDiffShareAuxMatchUtil.checkUserAuxSet();
                    for (Map<String, Object> stockentry : mStock) {
                        Object supplieridentry = stockentry.get("supplierid");
                        if ((owner != null || supplieridentry != null) && (owner == null || !owner.getPkValue().toString().equals(supplieridentry)) || openAuxSet && !BackDiffShareAuxMatchUtil.matchAuxStockGreaterOrder(model.getDynamicObject("auxpty"), (String)stockentry.get("childauxpropertyid"))) continue;
                        BigDecimal madebasenum = (BigDecimal)stockentry.get("madebasenum");
                        BigDecimal pickbasenum = (BigDecimal)stockentry.get("pickbasenum");
                        numTotals.put("madebasenum", ((BigDecimal)numTotals.get("madebasenum")).add(madebasenum));
                        numTotals.put("pickbasenum", ((BigDecimal)numTotals.get("pickbasenum")).add(pickbasenum));
                        diffStock.add(stockentry);
                    }
                }
            }
        }
        return numTotals;
    }

    private DataSet querydata(IDataModel model, List<QFilter> invQfilter, PluginProxy<IMftBackDiffShareQueryExt> newExtPlugin) {
        if (newExtPlugin != null) {
            List callReplaceIfPresent = newExtPlugin.callReplaceIfPresent(p -> p.queryImReport(invQfilter, model));
            if (callReplaceIfPresent != null && !callReplaceIfPresent.isEmpty()) {
                return (DataSet)callReplaceIfPresent.get(0);
            }
            return null;
        }
        return null;
    }

    private void insertBillEntry(Map<String, BigDecimal> repeatEntryId) {
        IDataModel model = this.getModel();
        Boolean flagindex1 = Boolean.FALSE;
        Boolean flagindex2 = Boolean.FALSE;
        DynamicObject invorg = (DynamicObject)model.getValue("invorg");
        if (invorg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MftBackDiffShareEdit_5", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return;
        }
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MftBackDiffShareEdit_6", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return;
        }
        List<QFilter> invQfilter = this.buildInvAccPartFilter(1);
        PluginProxy<IMftBackDiffShareQueryExt> newExtPlugin = InvDiffShareQueryDataHelper.genExtPluginxy();
        DataSet invbills = this.querydata(this.getModel(), invQfilter, newExtPlugin);
        if (invbills == null || invbills.isEmpty()) {
            flagindex1 = Boolean.TRUE;
        } else {
            if (!this.checkFiledUnExit(invbills.getRowMeta().getFieldNames()).booleanValue()) {
                this.getView().showTipNotification("PluginProxy----error");
                return;
            }
            this.getInvBillEntry2(invbills, repeatEntryId);
        }
        Date indatestart = (Date)model.getValue("indatestart");
        Date indateend = (Date)model.getValue("indateend");
        if (indatestart == null || indateend == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5165\u5e93\u65e5\u671f\u3002", (String)"MftBackDiffShareEdit_27", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return;
        }
        List<QFilter> mftQfilter = this.buildInvAccPartFilter(2);
        DynamicObject producedept = (DynamicObject)model.getValue("producedept");
        ArrayList<QFilter> mOrderQf = new ArrayList<QFilter>(10);
        mOrderQf.add(new QFilter("org", "=", org.getPkValue()));
        if (producedept != null) {
            mOrderQf.add(new QFilter("treeentryentity.producedept", "=", producedept.getPkValue()));
        }
        ArrayList<List<DynamicObject>> gridList = new ArrayList<List<DynamicObject>>(10);
        DynamicObjectCollection mftmanuinbills = QueryServiceHelper.query((String)"im_mdc_mftmanuinbill", (String)this.getMftInBillSelects(), (QFilter[])mftQfilter.toArray(new QFilter[mftQfilter.size()]));
        if (mftmanuinbills == null || mftmanuinbills.size() <= 0) {
            flagindex2 = Boolean.TRUE;
        } else {
            String orderEntryIdName = "billentry.mainbillentryid";
            HashSet<Long> orderEntryId = new HashSet<Long>(mftmanuinbills.size());
            HashMap<Long, BigDecimal> entryidMap = new HashMap<Long, BigDecimal>();
            for (int i = 0; i < mftmanuinbills.size(); ++i) {
                Long entryId = ((DynamicObject)mftmanuinbills.get(i)).getLong(orderEntryIdName);
                orderEntryId.add(entryId);
                BigDecimal baseq = ((DynamicObject)mftmanuinbills.get(i)).getBigDecimal("billentry.baseqty");
                if (entryidMap.containsKey(entryId)) {
                    ((DynamicObject)mftmanuinbills.get(i)).getLong(orderEntryIdName);
                    BigDecimal old = (BigDecimal)entryidMap.get(entryId);
                    entryidMap.put(entryId, old.add(baseq));
                    continue;
                }
                entryidMap.put(entryId, baseq);
            }
            QFilter stockqf = new QFilter("orderentryid", "in", orderEntryId);
            stockqf.and(this.getDynamicObjectFromToFilter(model, "stockentry.materielmasterid", "smaterial", "ematerial"));
            DynamicObjectCollection querystock = QueryServiceHelper.query((String)"pom_mftstock", (String)"id,orderentryid", (QFilter[])stockqf.toArray());
            HashSet<Long> orderEntryIdSet = new HashSet<Long>(mftmanuinbills.size());
            if (querystock.isEmpty() || querystock.size() <= 0) {
                flagindex2 = Boolean.TRUE;
            } else {
                for (DynamicObject stock : querystock) {
                    Long orderentryid = stock.getLong("orderentryid");
                    orderEntryIdSet.add(orderentryid);
                }
                mOrderQf.add(new QFilter("treeentryentity.id", "in", orderEntryIdSet));
                String bizstatus = (String)this.getModel().getValue("pombizstatus");
                String[] bizstatusArr = StringUtils.isEmpty((CharSequence)bizstatus) ? new String[]{"A", "B"} : bizstatus.substring(1, bizstatus.length() - 1).split(",");
                mOrderQf.add(new QFilter("treeentryentity.bizstatus", "in", (Object)bizstatusArr));
                mOrderQf.add(new QFilter("treeentryentity.producttype", "=", (Object)"C"));
                DynamicObjectCollection query = QueryServiceHelper.query((String)"pom_mftorder", (String)MftBackDiffShareEdit.getMftOrderSelects(), (QFilter[])mOrderQf.toArray(new QFilter[mOrderQf.size()]));
                if (query.isEmpty() || query.size() <= 0) {
                    flagindex2 = Boolean.TRUE;
                } else {
                    this.getmftBillEntry(gridList, query, entryidMap);
                }
            }
        }
        if (flagindex1.booleanValue() && flagindex2.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u627e\u5230\u6570\u636e\u3002", (String)"MftBackDiffShareEdit_38", (String)"scmc-mm-mdc", (Object[])new Object[0]));
        } else if (flagindex2.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u751f\u4ea7\u5de5\u5355\u6570\u636e\u3002", (String)"MftBackDiffShareEdit_28", (String)"scmc-mm-mdc", (Object[])new Object[0]));
        } else if (flagindex1.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u5373\u65f6\u5e93\u5b58\u6570\u636e\u3002", (String)"MftBackDiffShareEdit_26", (String)"scmc-mm-mdc", (Object[])new Object[0]));
        }
    }

    private Boolean checkFiledUnExit(String[] fieldNames) {
        Boolean isExit = Boolean.TRUE;
        List<String> invDataField = this.getInvDataField();
        HashSet<String> fieldSet = new HashSet<String>(Arrays.asList(fieldNames));
        for (String str : invDataField) {
            if (fieldSet.contains(str)) continue;
            logger.error((Object)("PluginProxy\u63a5\u53e3\u8fd4\u56de\u4e0d\u5305\u542b\u5b57\u6bb5\uff1a" + str));
            isExit = Boolean.FALSE;
            break;
        }
        return isExit;
    }

    private List<String> getInvDataField() {
        ArrayList<String> dataFiled = new ArrayList<String>(16);
        dataFiled.add("material");
        dataFiled.add("auxpty");
        dataFiled.add("warehouse");
        dataFiled.add("location");
        dataFiled.add("lotnumber");
        dataFiled.add("project");
        dataFiled.add("invtype");
        dataFiled.add("invstatus");
        dataFiled.add("ownertype");
        dataFiled.add("owner");
        dataFiled.add("keepertype");
        dataFiled.add("keeper");
        dataFiled.add("producedate");
        dataFiled.add("expirydate");
        dataFiled.add("unit");
        dataFiled.add("qty_bal");
        return dataFiled;
    }

    public List<QFilter> buildInvAccPartFilter(int type) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        IDataModel model = this.getModel();
        DynamicObject invorg = (DynamicObject)model.getValue("invorg");
        DynamicObjectCollection mulwarehouse = (DynamicObjectCollection)model.getValue("mulwarehouse");
        DynamicObjectCollection mullocation = (DynamicObjectCollection)model.getValue("mullocation");
        DynamicObjectCollection mulshift = (DynamicObjectCollection)model.getValue("mulshift");
        Date indatestart = (Date)model.getValue("indatestart");
        Date indateend = (Date)model.getValue("indateend");
        if (type == 1) {
            DynamicObject mob;
            if (invorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MftBackDiffShareEdit_5", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                return qFilters;
            }
            qFilters.add(new QFilter("org", "=", invorg.getPkValue()));
            if (!mulwarehouse.isEmpty()) {
                HashSet<Long> idSet = new HashSet<Long>();
                for (DynamicObject warehouse : mulwarehouse) {
                    mob = warehouse.getDynamicObject("fbasedataid");
                    idSet.add(mob.getLong("id"));
                }
                qFilters.add(new QFilter("warehouse.id", "in", idSet));
            }
            if (!mullocation.isEmpty()) {
                HashSet<Long> locationSet = new HashSet<Long>();
                for (DynamicObject location : mullocation) {
                    mob = location.getDynamicObject("fbasedataid");
                    locationSet.add(mob.getLong("id"));
                }
                qFilters.add(new QFilter("location.id", "in", locationSet));
            }
            qFilters.add(this.getDynamicObjectFromToFilter(model, "material", "smaterial", "ematerial"));
        } else if (type == 2) {
            qFilters.add(new QFilter("biztime", ">=", (Object)DateUtils.getDayStartTime((Date)indatestart)));
            qFilters.add(new QFilter("biztime", "<=", (Object)DateUtils.getDayEndTime((Date)indateend)));
            qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
            if (!mulshift.isEmpty()) {
                HashSet<Object> shiftidSet = new HashSet<Object>();
                for (DynamicObject shift : mulshift) {
                    DynamicObject mob = shift.getDynamicObject("fbasedataid");
                    shiftidSet.add(mob.get("id"));
                }
                qFilters.add(new QFilter("billentry.shift.id", "in", shiftidSet));
            }
        }
        return qFilters;
    }

    private Map<String, BigDecimal> getRepeatEntryId(IDataModel model) {
        int entryRowCount = model.getEntryRowCount("billentry");
        HashMap<String, BigDecimal> repeatEntry = new HashMap<String, BigDecimal>(16);
        SimpleDateFormat sdfhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (entryRowCount > 0) {
            DynamicObjectCollection entryEntity = model.getEntryEntity("billentry");
            ArrayList<Integer> rowI = new ArrayList<Integer>(entryEntity.size());
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject dentry = (DynamicObject)entryEntity.get(i);
                if (dentry.getBoolean("isadd")) continue;
                if (dentry.getBoolean("ischange")) {
                    StringBuilder sb = new StringBuilder();
                    Integer material = dentry.get("material") == null ? Integer.valueOf(0) : dentry.getDynamicObject("material").getPkValue();
                    Object auxpty = dentry.get("auxpty") == null ? Integer.valueOf(0) : dentry.get("auxpty");
                    Object lotnumber = dentry.get("lotnumber");
                    Integer warehouse = dentry.get("warehouse") == null ? Integer.valueOf(0) : dentry.getDynamicObject("warehouse").getPkValue();
                    Integer location2 = dentry.get("location2") == null ? Integer.valueOf(0) : dentry.getDynamicObject("location2").getPkValue();
                    Integer project = dentry.get("project") == null ? Integer.valueOf(0) : dentry.getDynamicObject("project").getPkValue();
                    Integer invtype = dentry.get("invtype") == null ? Integer.valueOf(0) : dentry.getDynamicObject("invtype").getPkValue();
                    Integer invstatus = dentry.get("invstatus") == null ? Integer.valueOf(0) : dentry.getDynamicObject("invstatus").getPkValue();
                    Object ownertype = dentry.get("ownertype");
                    Integer owner = dentry.get("owner") == null ? Integer.valueOf(0) : dentry.getDynamicObject("owner").getPkValue();
                    Object keepertype = dentry.get("keepertype");
                    Integer keeper = dentry.get("keeper") == null ? Integer.valueOf(0) : dentry.getDynamicObject("keeper").getPkValue();
                    BigDecimal inventorynum = (BigDecimal)dentry.get("inventorynum");
                    Date producedate = dentry.getDate("producedate");
                    Date expirydate = dentry.getDate("expirydate");
                    sb.append(material).append("-");
                    sb.append(auxpty).append("-");
                    sb.append(warehouse).append("-");
                    sb.append(location2).append("-");
                    sb.append(lotnumber).append("-");
                    sb.append(project).append("-");
                    sb.append(invtype).append("-");
                    sb.append(invstatus).append("-");
                    sb.append(ownertype).append("-");
                    sb.append(owner).append("-");
                    sb.append(keepertype).append("-");
                    sb.append(keeper).append("-");
                    if (producedate != null) {
                        sb.append(sdfhms.format(producedate)).append("-");
                    }
                    if (expirydate != null) {
                        sb.append(sdfhms.format(expirydate)).append("-");
                    }
                    repeatEntry.put(sb.toString(), inventorynum);
                }
                rowI.add(i);
            }
            if (!rowI.isEmpty()) {
                int[] array = rowI.stream().mapToInt(Integer::valueOf).toArray();
                model.deleteEntryRows("billentry", array);
            }
        }
        return repeatEntry;
    }

    private QFilter getDynamicObjectFromToFilter(IDataModel model, String queryFiled, String fromKey, String toKey) {
        DynamicObject to;
        QFilter bfilter = null;
        String querynumber = "number";
        DynamicObjectCollection froms = (DynamicObjectCollection)model.getValue(fromKey);
        if (froms != null && froms.size() != 0) {
            if (froms.size() > 1) {
                HashSet<Object> idSet = new HashSet<Object>();
                for (DynamicObject from : froms) {
                    DynamicObject mob = (DynamicObject)from.getDynamicObject("fbasedataid").get("masterid");
                    Object pkValue = mob.getPkValue();
                    idSet.add(pkValue);
                }
                return new QFilter(queryFiled, "in", idSet);
            }
            DynamicObject from = (DynamicObject)froms.get(0);
            DynamicObject mob = (DynamicObject)from.getDynamicObject("fbasedataid").get("masterid");
            bfilter = new QFilter(querynumber, ">=", mob.get(querynumber));
        }
        if ((to = (DynamicObject)model.getValue(toKey)) != null) {
            DynamicObject mob2 = (DynamicObject)to.get("masterid");
            QFilter toFilter = new QFilter(querynumber, "<=", mob2.get(querynumber));
            QFilter qFilter = bfilter = bfilter != null ? bfilter.and(toFilter) : toFilter;
        }
        if (bfilter == null) {
            return null;
        }
        Map materials = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id", (QFilter[])bfilter.toArray());
        ArrayList mlist = new ArrayList(materials.keySet());
        return new QFilter(queryFiled, "in", mlist);
    }

    private QFilter addInvAccNotZeroFilter() {
        QFilter qtyFilter = new QFilter("baseqty", "<>", (Object)0);
        qtyFilter.or(new QFilter("qty", "<>", (Object)0));
        qtyFilter.or(new QFilter("qty2nd", "<>", (Object)0));
        return qtyFilter;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateBaseInfo;
        Boolean isshare;
        Boolean value;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        HashMap<String, BigDecimal> shareMap = new HashMap<String, BigDecimal>(16);
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)"bfshare", (CharSequence)operateKey)) {
            value = (Boolean)this.getModel().getValue("isshare");
            String billstatus = (String)this.getModel().getValue("billstatus");
            if (!"C".equalsIgnoreCase(billstatus) || value.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u672a\u5206\u644a\u624d\u5141\u8bb8\u5206\u644a\u3002", (String)"MftBackDiffShareEdit_9", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                e.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
            DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
            StringBuilder sb = new StringBuilder();
            int shareLow = 0;
            for (int i = 0; i < dataEntitys.length; ++i) {
                DynamicObject griddata = dataEntitys[i];
                boolean difshare = griddata.getBoolean("difshare");
                if (!difshare) continue;
                int seq = griddata.getInt("seq");
                BigDecimal difnumval = griddata.getBigDecimal("difnum");
                if (BigDecimal.ZERO.compareTo(difnumval) == 0) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4fe1\u606f\u9875\u7b7e\u7b2c%s\u5206\u5f55\u5dee\u5f02\u6570\u91cf\u4e3a0\u3002", (String)"MftBackDiffShareEdit_60", (String)"scmc-mm-mdc", (Object[])new Object[0]), seq));
                    ++shareLow;
                    continue;
                }
                DynamicObject materielmasterid = griddata.getDynamicObject("materielmasterid");
                BigDecimal difnum = griddata.getBigDecimal("difnum");
                String key = seq + "@@" + materielmasterid.getPkValue();
                shareMap.put(key, difnum);
            }
            if (shareLow == dataEntitys.length) {
                this.getView().showTipNotification(sb.toString());
                e.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            Long pkid = (Long)this.getModel().getDataEntity().getPkValue();
            QFilter qf = new QFilter("id", "=", (Object)pkid);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"im_mdc_backdifshare", (String)"billentry1.orderentryid,billentry1.inbasenum,billentry1.difshare1", (QFilter[])new QFilter[]{qf});
            HashSet<Long> orderentryIdSet = new HashSet<Long>(query.size());
            HashMap<Long, BigDecimal> mftOrderBaseNum = new HashMap<Long, BigDecimal>(query.size());
            for (DynamicObject rowdata : query) {
                Boolean mftDiffshare = rowdata.getBoolean("billentry1.difshare1");
                if (!mftDiffshare.booleanValue()) continue;
                Long pkValue = rowdata.getLong("billentry1.orderentryid");
                BigDecimal inbasenum = rowdata.getBigDecimal("billentry1.inbasenum");
                orderentryIdSet.add(pkValue);
                mftOrderBaseNum.put(pkValue, inbasenum);
            }
            if (orderentryIdSet.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u5de5\u5355\u4fe1\u606f\u5206\u5f55\u3002", (String)"MftBackDiffShareEdit_12", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                e.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            if (shareMap.isEmpty() || shareMap.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u5e93\u5b58\u4fe1\u606f\u5206\u5f55\u3002", (String)"MftBackDiffShareEdit_13", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                e.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            DynamicObject invorg = (DynamicObject)model.getValue("invorg");
            QFilter filter = new QFilter("orderentryid", "in", orderentryIdSet);
            filter.and(new QFilter("stockentry.iscannegative", "=", (Object)Boolean.FALSE));
            Map<String, String> baseUnitData = this.getMeasureunitData();
            ArrayList<Integer> ss = new ArrayList<Integer>(shareMap.size());
            Map<Long, List<Map<String, Object>>> stockMap = this.getStockMap(filter, mftOrderBaseNum, invorg, baseUnitData);
            StringBuilder sb2 = new StringBuilder();
            boolean shareByReceived = BackDiffShareAuxMatchUtil.checkUserReceived();
            for (Map.Entry mape : shareMap.entrySet()) {
                String key = (String)mape.getKey();
                BigDecimal difnumval = (BigDecimal)mape.getValue();
                if (BigDecimal.ZERO.compareTo(difnumval) == 0) continue;
                String[] splitkey = key.split("@@");
                ArrayList<Map<String, Object>> diffStock = new ArrayList<Map<String, Object>>(10);
                int invIndex = NumberUtils.toInt((String)splitkey[0]);
                Map<String, BigDecimal> numTotals = this.getDiffStockTotal(diffStock, splitkey, dataEntitys[invIndex - 1], stockMap);
                if (shareByReceived && difnumval.compareTo(BigDecimal.ZERO) < 0) {
                    if (BigDecimal.ZERO.compareTo(numTotals.get("pickbasenum")) != 0) continue;
                    ss.add(invIndex);
                    continue;
                }
                if (BigDecimal.ZERO.compareTo(numTotals.get("madebasenum")) != 0) continue;
                ss.add(invIndex);
            }
            Boolean ismatchexect = (Boolean)this.getModel().getValue("ismatchexect");
            if (!ss.isEmpty() && (ismatchexect.booleanValue() && ss.size() == shareMap.size() || !ismatchexect.booleanValue())) {
                List collect = ss.stream().sorted(Comparator.comparing(Integer::intValue)).collect(Collectors.toList());
                StringBuilder sb3 = new StringBuilder();
                for (int i = 0; i < collect.size(); ++i) {
                    if (i == collect.size() - 1) {
                        sb3.append(collect.get(i));
                        continue;
                    }
                    sb3.append(collect.get(i));
                    sb3.append("\u3001");
                }
                sb2.append(String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4fe1\u606f\u9875\u7b7e\u7b2c%s\u884c\u672a\u627e\u5230\u751f\u4ea7\u5de5\u5355\u7ec4\u4ef6\u6e05\u5355\u5b50\u9879\u7269\u6599\u76f8\u5339\u914d\uff0c\u9886\u6599\u5dee\u5f02\u5206\u644a\u5931\u8d25\u3002", (String)"MftBackDiffShareEdit_62", (String)"scmc-mm-mdc", (Object[])new Object[0]), sb3.toString()));
                this.getView().showErrorNotification(sb2.toString());
                e.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            op.getOption().setVariableValue("opProgressCache", this.getView().getPageId());
            this.start(operateKey);
        } else if (StringUtils.equals((CharSequence)"unbfshare", (CharSequence)operateKey)) {
            value = (Boolean)this.getModel().getValue("isassagin");
            isshare = (Boolean)this.getModel().getValue("isshare");
            if (!isshare.booleanValue() || value.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5206\u644a\u672a\u5206\u914d\u624d\u5141\u8bb8\u53d6\u6d88\u5206\u644a\u3002", (String)"MftBackDiffShareEdit_39", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                e.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            op.getOption().setVariableValue("opProgressCache", this.getView().getPageId());
            this.start(operateKey);
        }
        if ("generate".equals(op.getOperateKey())) {
            value = (Boolean)this.getModel().getValue("isassagin");
            isshare = (Boolean)this.getModel().getValue("isshare");
            if (!isshare.booleanValue() || value.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5206\u644a\u672a\u5206\u914d\u7684\u624d\u5141\u8bb8\u5206\u914d\u3002", (String)"MftBackDiffShareEdit_45", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                e.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            op.getOption().setVariableValue("opProgressCache", this.getView().getPageId());
            this.start(operateKey);
        }
        if ("ungenerate".equals(op.getOperateKey())) {
            value = (Boolean)this.getModel().getValue("isassagin");
            if (!value.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5206\u914d\u7684\u624d\u5141\u8bb8\u53d6\u6d88\u5206\u914d\u3002", (String)"MftBackDiffShareEdit_46", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                e.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            op.getOption().setVariableValue("opProgressCache", this.getView().getPageId());
            this.start(operateKey);
        }
        if ("bfquery".equals(op.getOperateKey())) {
            Boolean isinvtime = (Boolean)model.getValue("isinvtime");
            Date invtime = (Date)model.getValue("invtime");
            if (isinvtime.booleanValue() && invtime == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6309\u5e93\u5b58\u65e5\u671f\u67e5\u8be2\u5e93\u5b58\u201d=\u662f\u65f6\uff0c\u5e93\u5b58\u65e5\u671f\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u3002", (String)"MftBackDiffShareEdit_97", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                e.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
        }
        if (("save".equals(op.getOperateKey()) || "submit".equals(op.getOperateKey())) && !"0".equals(operateBaseInfo = this.getView().getPageCache().get("operateBaseInfo")) && operateBaseInfo != null) {
            IDataEntityProperty operatebaseInfoProp = (IDataEntityProperty)this.getModel().getDataEntityType().getProperties().get((Object)operateBaseInfo);
            if (null != operatebaseInfoProp) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u4e2d\u201c%s\u201d\u503c\u5df2\u7ecf\u88ab\u4fee\u6539\uff0c\u8bf7\u5148\u67e5\u8be2\u518d\u64cd\u4f5c\u3002", (String)"MftBackDiffShareEdit_64", (String)"scmc-mm-mdc", (Object[])new Object[0]), operatebaseInfoProp.getDisplayName().getLocaleValue()));
                e.setCancel(Boolean.TRUE.booleanValue());
            }
            return;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (event.getResult() == MessageBoxResult.Yes) {
            this.getModel().setValue("smaterial", null);
            this.getModel().setValue("ematerial", null);
            this.getModel().setValue("mulwarehouse", null);
            this.getModel().setValue("mullocation", null);
            this.getModel().setValue("mulshift", null);
            Date dayStartTime = DateUtils.getDayStartTime((Date)new Date());
            this.getModel().setValue("indatestart", (Object)dayStartTime);
            this.getModel().setValue("indateend", (Object)dayStartTime);
            this.getModel().deleteEntryData("billentry1");
            this.getModel().deleteEntryData("billentry");
        } else {
            this.getModel().beginInit();
            this.getModel().setValue(callBackId, oldData.get(callBackId));
            this.getView().updateView(callBackId);
            this.getModel().endInit();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object smaterialinv = this.getModel().getValue("smaterial");
        if (smaterialinv != null) {
            DynamicObjectCollection materialNumberFrom = (DynamicObjectCollection)smaterialinv;
            if (materialNumberFrom.size() > 1) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"ematerial"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"ematerial"});
            }
        }
    }

    private void setContolData() {
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("billentry");
        if (entryRowCount > 0) {
            DynamicObjectCollection entryEntity = model.getEntryEntity("billentry");
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject dentry = (DynamicObject)entryEntity.get(i);
                if (!dentry.getBoolean("isadd")) {
                    this.setControlState(Boolean.FALSE, i);
                    continue;
                }
                DynamicObject materialInv = dentry.getDynamicObject("material");
                if (materialInv != null) {
                    Boolean enableshelflifemgr;
                    Boolean enablelot;
                    DynamicObject material = materialInv.getDynamicObject("masterid");
                    Boolean isuseauxpty = material.getBoolean("isuseauxpty");
                    if (!isuseauxpty.booleanValue()) {
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{"auxpty"});
                    }
                    if (!(enablelot = Boolean.valueOf(materialInv.getBoolean("enablelot"))).booleanValue()) {
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{"lotnumber"});
                    }
                    if (!(enableshelflifemgr = Boolean.valueOf(materialInv.getBoolean("enableshelflifemgr"))).booleanValue()) {
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{"producedate"});
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{"expirydate"});
                    }
                } else {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"auxpty"});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"lotnumber"});
                }
                DynamicObject warehouse = dentry.getDynamicObject("warehouse");
                if (warehouse != null) {
                    Boolean isopenlocation = warehouse.getBoolean("isopenlocation");
                    if (isopenlocation.booleanValue()) continue;
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"location2"});
                    continue;
                }
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"location2"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.getView().getModel().setDataChanged(false);
        String key = e.getProperty().getName();
        ChangeData cd = e.getChangeSet()[0];
        int rowIndex = cd.getRowIndex();
        Object oldValue = cd.getOldValue();
        IDataModel model = this.getModel();
        if (this.getPageCache().get("isIgnoreChangeListener") == "true") {
            return;
        }
        DynamicObject invorg = (DynamicObject)model.getValue("invorg");
        if (fieldKeySet.contains(key)) {
            this.getView().getPageCache().put("operateBaseInfo", key);
        }
        if ("invorg".equals(key)) {
            String emsg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"MftBackDiffShareEdit_40", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            oldData.put(key, oldValue);
            ConfirmCallBackListener listener = new ConfirmCallBackListener("invorg", (IFormPlugin)this);
            this.getView().showConfirm(emsg, MessageBoxOptions.YesNo, ConfirmTypes.Default, listener);
        }
        if ("smaterial".equals(key)) {
            DynamicObjectCollection materialNumberFrom = (DynamicObjectCollection)model.getValue("smaterial");
            model.setValue("ematerial", materialNumberFrom.size() == 1 ? ((DynamicObject)materialNumberFrom.get(0)).get("fbasedataid") : null);
            if (materialNumberFrom.size() > 1) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"ematerial"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"ematerial"});
            }
        }
        if ("mulwarehouse".equals(key)) {
            this.getModel().setValue("mullocation", null);
        }
        if ("inventorynum".equals(key)) {
            this.getPageCache().put("isIgnoreChangeListener", "true");
            Boolean isnegative = (Boolean)this.getModel().getValue("isnegative");
            BigDecimal newValue = (BigDecimal)e.getChangeSet()[0].getNewValue();
            BigDecimal oldNum = (BigDecimal)e.getChangeSet()[0].getOldValue();
            if (newValue.compareTo(BigDecimal.ZERO) < 0 && !isnegative.booleanValue()) {
                this.getModel().setValue("inventorynum", (Object)oldNum, rowIndex);
                this.getPageCache().put("isIgnoreChangeListener", "false");
                return;
            }
            BigDecimal invaccnum = (BigDecimal)this.getModel().getValue("invaccnum", rowIndex);
            BigDecimal difnum = invaccnum.subtract(newValue);
            this.getModel().setValue("difnum", (Object)difnum, rowIndex);
            this.getModel().setValue("waitsharenum", (Object)difnum, rowIndex);
            this.getModel().setValue("ischange", (Object)Boolean.TRUE, rowIndex);
            if (difnum.compareTo(BigDecimal.ZERO) == 0) {
                this.getModel().setValue("difshare", (Object)Boolean.FALSE, rowIndex);
            } else {
                this.getModel().setValue("difshare", (Object)Boolean.TRUE, rowIndex);
            }
            this.getPageCache().put("isIgnoreChangeListener", "false");
        }
        if ("difnum".equals(key)) {
            this.getPageCache().put("isIgnoreChangeListener", "true");
            BigDecimal newValue = (BigDecimal)e.getChangeSet()[0].getNewValue();
            BigDecimal oldNum = (BigDecimal)e.getChangeSet()[0].getOldValue();
            BigDecimal invaccnum = (BigDecimal)this.getModel().getValue("invaccnum", rowIndex);
            BigDecimal inventorynum = invaccnum.subtract(newValue);
            Boolean isnegative = (Boolean)this.getModel().getValue("isnegative");
            if (inventorynum.compareTo(BigDecimal.ZERO) < 0 && !isnegative.booleanValue()) {
                this.getModel().setValue("difnum", (Object)oldNum, rowIndex);
                this.getPageCache().put("isIgnoreChangeListener", "false");
                return;
            }
            this.getModel().setValue("inventorynum", (Object)inventorynum, rowIndex);
            this.getModel().setValue("waitsharenum", (Object)newValue, rowIndex);
            this.getModel().setValue("ischange", (Object)Boolean.TRUE, rowIndex);
            if (newValue.compareTo(BigDecimal.ZERO) == 0) {
                this.getModel().setValue("difshare", (Object)Boolean.FALSE, rowIndex);
            } else {
                this.getModel().setValue("difshare", (Object)Boolean.TRUE, rowIndex);
            }
            this.getPageCache().put("isIgnoreChangeListener", "false");
        }
    }

    private String getMftInBillSelects() {
        return "id,billno,billentry.id,billentry.mainbillnumber,billentry.mainbillid,billentry.mainbillentity,billentry.mainbillentryseq,billentry.mainbillentryid,billentry.baseqty,billentry.materialmasterid,billentry.backflushstatus,billentry.seq,biztime,billentry.baseunit";
    }

    private String getInvrealbalanceSelects() {
        return "id,org,warehouse,location,ownertype,owner,keepertype,keeper,invstatus,invtype,material,auxpty,lotnum,project,producedate,expirydate,baseunit,unit,baseqty,qty";
    }

    private void getInvBillEntry(DynamicObjectCollection invbills, Map<String, BigDecimal> repeatEntryId) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        SimpleDateFormat sdfhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashSet<Long> materialIdSet = new HashSet<Long>();
        HashMap<Long, Long> materialUnitMap = new HashMap<Long, Long>();
        for (DynamicObject invgrid : invbills) {
            Long material = (Long)invgrid.get("material");
            if (material == null || "0".equals(material.toString())) continue;
            materialIdSet.add(material);
            materialUnitMap.put(material, invgrid.getLong("unit"));
        }
        IDataModel datamodel = this.getModel();
        DynamicObject invorg = (DynamicObject)datamodel.getValue("invorg");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        HashMap<Long, String> masterIdMap = new HashMap<Long, String>();
        filters.add(new QFilter("masterid", "in", materialIdSet));
        QFilter materialInfoQfilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)invorg.getPkValue()));
        filters.add(materialInfoQfilter);
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("status", "=", (Object)"C"));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_materialinventoryinfo", (String)"id,masterid.id,inventoryunit", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        for (DynamicObject bdinv : query) {
            Long mid = (Long)bdinv.get("masterid.id");
            Long unitId = materialUnitMap.get(mid) == null ? Long.valueOf(0L) : (Long)materialUnitMap.get(mid);
            masterIdMap.put(mid, bdinv.get("id") + "@@" + unitId);
        }
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("material", new Object[0]);
        vs.addField("materielmasterid", new Object[0]);
        vs.addField("mversion", new Object[0]);
        vs.addField("auxpty", new Object[0]);
        vs.addField("lotnumber", new Object[0]);
        vs.addField("project", new Object[0]);
        vs.addField("warehouse", new Object[0]);
        vs.addField("location2", new Object[0]);
        vs.addField("invtype", new Object[0]);
        vs.addField("invstatus", new Object[0]);
        vs.addField("ownertype", new Object[0]);
        vs.addField("owner", new Object[0]);
        vs.addField("producedate", new Object[0]);
        vs.addField("expirydate", new Object[0]);
        vs.addField("keepertype", new Object[0]);
        vs.addField("keeper", new Object[0]);
        vs.addField("unit", new Object[0]);
        vs.addField("invaccnum", new Object[0]);
        vs.addField("inventorynum", new Object[0]);
        vs.addField("difnum", new Object[0]);
        vs.addField("waitsharenum", new Object[0]);
        vs.addField("assignnum", new Object[0]);
        vs.addField("sharestatus", new Object[0]);
        vs.addField("assignstauts", new Object[0]);
        vs.addField("difshare", new Object[0]);
        vs.addField("isadd", new Object[0]);
        vs.addField("ischange", new Object[0]);
        for (DynamicObject grid : invbills) {
            BigDecimal qty;
            Long material = (Long)grid.get("material");
            if (material == null || "0".equals(material.toString()) || !masterIdMap.containsKey(material)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(grid.get("material"));
            sb.append("-");
            sb.append(grid.get("auxpty"));
            sb.append("-");
            sb.append(grid.get("warehouse"));
            sb.append("-");
            sb.append(grid.get("location"));
            sb.append("-");
            sb.append(grid.get("lotnum"));
            sb.append("-");
            sb.append(grid.get("project"));
            sb.append("-");
            sb.append(grid.get("invtype"));
            sb.append("-");
            sb.append(grid.get("invstatus"));
            sb.append("-");
            sb.append(grid.get("ownertype"));
            sb.append("-");
            sb.append(grid.get("owner"));
            sb.append("-");
            sb.append(grid.get("keepertype"));
            sb.append("-");
            sb.append(grid.get("keeper"));
            sb.append("-");
            if (grid.getDate("producedate") != null) {
                sb.append(sdfhms.format(grid.getDate("producedate")));
                sb.append("-");
            }
            if (grid.getDate("expirydate") != null) {
                sb.append(sdfhms.format(grid.getDate("expirydate")));
                sb.append("-");
            }
            BigDecimal inventorynum = (qty = (BigDecimal)grid.get("qty")).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : qty;
            Boolean ischange = Boolean.FALSE;
            if (repeatEntryId.containsKey(sb.toString())) {
                inventorynum = repeatEntryId.get(sb.toString());
                ischange = Boolean.TRUE;
            }
            Boolean difshareFlag = Boolean.FALSE;
            BigDecimal difnum = qty.subtract(inventorynum);
            if (difnum.compareTo(BigDecimal.ZERO) != 0) {
                difshareFlag = Boolean.TRUE;
            }
            String mkey = (String)masterIdMap.get(material);
            String[] split = mkey.split("@@");
            vs.addRow(new Object[]{split[0], material, null, grid.get("auxpty"), grid.get("lotnum"), grid.get("project"), grid.get("warehouse"), grid.get("location"), grid.get("invtype"), grid.get("invstatus"), grid.get("ownertype"), grid.get("owner"), grid.get("producedate"), grid.get("expirydate"), grid.get("keepertype"), grid.get("keeper"), grid.get("unit"), grid.get("qty"), inventorynum, difnum, difnum, 0, "A", "A", difshareFlag, Boolean.FALSE, ischange});
        }
        model.batchCreateNewEntryRow("billentry", vs);
        model.endInit();
        this.getView().updateView("billentry");
    }

    private void getInvBillEntry2(DataSet invbills, Map<String, BigDecimal> repeatEntryId) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        SimpleDateFormat sdfhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashSet<Long> materialIdSet = new HashSet<Long>();
        HashMap<Long, Long> materialUnitMap = new HashMap<Long, Long>();
        for (Row row : invbills.copy()) {
            Long material = row.getLong("material");
            if (material == null || "0".equals(material.toString())) continue;
            materialIdSet.add(material);
            materialUnitMap.put(material, row.getLong("unit"));
        }
        IDataModel datamodel = this.getModel();
        DynamicObject invorg = (DynamicObject)datamodel.getValue("invorg");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        HashMap<Long, String> masterIdMap = new HashMap<Long, String>();
        filters.add(new QFilter("masterid", "in", materialIdSet));
        QFilter materialInfoQfilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)invorg.getPkValue()));
        filters.add(materialInfoQfilter);
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("status", "=", (Object)"C"));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_materialinventoryinfo", (String)"id,masterid.id,inventoryunit", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        for (DynamicObject bdinv : query) {
            Long mid = (Long)bdinv.get("masterid.id");
            Long unitId = materialUnitMap.get(mid) == null ? Long.valueOf(0L) : (Long)materialUnitMap.get(mid);
            masterIdMap.put(mid, bdinv.get("id") + "@@" + unitId);
        }
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("material", new Object[0]);
        vs.addField("materielmasterid", new Object[0]);
        vs.addField("mversion", new Object[0]);
        vs.addField("auxpty", new Object[0]);
        vs.addField("lotnumber", new Object[0]);
        vs.addField("project", new Object[0]);
        vs.addField("warehouse", new Object[0]);
        vs.addField("location2", new Object[0]);
        vs.addField("invtype", new Object[0]);
        vs.addField("invstatus", new Object[0]);
        vs.addField("ownertype", new Object[0]);
        vs.addField("owner", new Object[0]);
        vs.addField("producedate", new Object[0]);
        vs.addField("expirydate", new Object[0]);
        vs.addField("keepertype", new Object[0]);
        vs.addField("keeper", new Object[0]);
        vs.addField("unit", new Object[0]);
        vs.addField("invaccnum", new Object[0]);
        vs.addField("inventorynum", new Object[0]);
        vs.addField("difnum", new Object[0]);
        vs.addField("waitsharenum", new Object[0]);
        vs.addField("assignnum", new Object[0]);
        vs.addField("sharestatus", new Object[0]);
        vs.addField("assignstauts", new Object[0]);
        vs.addField("difshare", new Object[0]);
        vs.addField("isadd", new Object[0]);
        vs.addField("ischange", new Object[0]);
        for (Row grid : invbills) {
            BigDecimal qty;
            Long material = grid.getLong("material");
            if (material == null || "0".equals(material.toString()) || !masterIdMap.containsKey(material)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(grid.get("material"));
            sb.append("-");
            sb.append(grid.get("auxpty"));
            sb.append("-");
            sb.append(grid.get("warehouse"));
            sb.append("-");
            sb.append(grid.get("location"));
            sb.append("-");
            sb.append(grid.get("lotnumber"));
            sb.append("-");
            sb.append(grid.get("project"));
            sb.append("-");
            sb.append(grid.get("invtype"));
            sb.append("-");
            sb.append(grid.get("invstatus"));
            sb.append("-");
            sb.append(grid.get("ownertype"));
            sb.append("-");
            sb.append(grid.get("owner"));
            sb.append("-");
            sb.append(grid.get("keepertype"));
            sb.append("-");
            sb.append(grid.get("keeper"));
            sb.append("-");
            if (grid.getDate("producedate") != null) {
                sb.append(sdfhms.format(grid.getDate("producedate")));
                sb.append("-");
            }
            if (grid.getDate("expirydate") != null) {
                sb.append(sdfhms.format(grid.getDate("expirydate")));
                sb.append("-");
            }
            BigDecimal inventorynum = (qty = grid.getBigDecimal("qty_bal")).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : qty;
            Boolean ischange = Boolean.FALSE;
            if (repeatEntryId.containsKey(sb.toString())) {
                inventorynum = repeatEntryId.get(sb.toString());
                ischange = Boolean.TRUE;
            }
            Boolean difshareFlag = Boolean.FALSE;
            BigDecimal difnum = qty.subtract(inventorynum);
            if (difnum.compareTo(BigDecimal.ZERO) != 0) {
                difshareFlag = Boolean.TRUE;
            }
            String mkey = (String)masterIdMap.get(material);
            String[] split = mkey.split("@@");
            vs.addRow(new Object[]{split[0], material, null, grid.get("auxpty"), grid.get("lotnumber"), grid.get("project"), grid.get("warehouse"), grid.get("location"), grid.get("invtype"), grid.get("invstatus"), grid.get("ownertype"), grid.get("owner"), grid.get("producedate"), grid.get("expirydate"), grid.get("keepertype"), grid.get("keeper"), grid.get("unit"), grid.get("qty_bal"), inventorynum, difnum, difnum, 0, "A", "A", difshareFlag, Boolean.FALSE, ischange});
        }
        model.batchCreateNewEntryRow("billentry", vs);
        model.endInit();
        this.getView().updateView("billentry");
    }

    private void getmftBillEntry(List<List<DynamicObject>> gridList, DynamicObjectCollection query, Map<Long, BigDecimal> entryidMap) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("orderno", new Object[0]);
        vs.addField("transactiontype", new Object[0]);
        vs.addField("orderentryid", new Object[0]);
        vs.addField("bdproject", new Object[0]);
        vs.addField("tracknumber", new Object[0]);
        vs.addField("configuredcode", new Object[0]);
        vs.addField("ordermaterial", new Object[0]);
        vs.addField("orderunit", new Object[0]);
        vs.addField("ordernum", new Object[0]);
        vs.addField("orderbaseunit", new Object[0]);
        vs.addField("basenum", new Object[0]);
        vs.addField("inbasenum", new Object[0]);
        vs.addField("difshare1", new Object[0]);
        HashSet<Long> invOrgs = new HashSet<Long>(16);
        for (DynamicObject colorder : query) {
            Object inwardept = colorder.get("treeentryentity.inwardept");
            if (inwardept == null) continue;
            invOrgs.add((Long)inwardept);
        }
        Map acctOrgCloseDateMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCloseService", (String)"getAcctOrgCloseDate", (Object[])new Object[]{invOrgs});
        for (DynamicObject morder : query) {
            Long orderEntryid = morder.getLong("treeentryentity.id");
            BigDecimal inqty = entryidMap.get(orderEntryid) == null ? BigDecimal.ZERO : entryidMap.get(orderEntryid);
            if (BigDecimal.ZERO.compareTo(inqty) >= 0) continue;
            Boolean checkCloseOrderBookDate = BackDiffShareUtil.checkCloseOrderBookDate(morder, acctOrgCloseDateMap);
            if (!checkCloseOrderBookDate.booleanValue()) {
                logger.info((Object)("checkCloseOrderBookDate--\u8de8\u671f--" + morder.get("billno")));
                continue;
            }
            vs.addRow(new Object[]{morder.get("billno"), morder.get("transactiontype"), morder.get("treeentryentity.id"), morder.get("treeentryentity.bdproject"), morder.get("treeentryentity.tracknumber"), morder.get("treeentryentity.configuredcode"), morder.get("treeentryentity.material"), morder.get("treeentryentity.unit"), morder.get("treeentryentity.qty"), morder.get("treeentryentity.baseunit"), morder.get("treeentryentity.baseqty"), inqty, Boolean.TRUE});
        }
        model.batchCreateNewEntryRow("billentry1", vs);
        this.getView().updateView("billentry1");
        model.endInit();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        QFilter materialInfoQfilter;
        DynamicObject invorg;
        ListShowParameter listShowParameter;
        ListShowParameter listShowParameter2;
        DynamicObject org;
        Control con = (Control)evt.getSource();
        String source = con.getKey();
        if ("mulwarehouse".equals(source)) {
            org = (DynamicObject)this.getModel().getValue("invorg");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"MftBackDiffShareEdit_29", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long[] warehouseids = WarehouseHelper.getAllWarehouseIDs((Long)((Long)org.getPkValue()));
            listShowParameter2 = (ListShowParameter)evt.getFormShowParameter();
            QFilter qfilter = new QFilter("id", "in", (Object)warehouseids);
            listShowParameter2.getListFilterParameter().getQFilters().add(qfilter);
        }
        if ("mullocation".equals(source)) {
            org = (DynamicObject)this.getModel().getValue("invorg");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"MftBackDiffShareEdit_29", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection mulwarehouse = (DynamicObjectCollection)this.getModel().getValue("mulwarehouse");
            HashSet<Long> idSet = new HashSet<Long>();
            if (mulwarehouse != null && mulwarehouse.size() != 0) {
                for (DynamicObject warehouse : mulwarehouse) {
                    DynamicObject mob = warehouse.getDynamicObject("fbasedataid");
                    idSet.add(mob.getLong("id"));
                }
            }
            listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            if (!idSet.isEmpty()) {
                QFilter qfilter;
                Set<Long> wareHouseId = this.getWareHouseId(idSet, "bd_warehouse");
                if (wareHouseId.isEmpty()) {
                    qfilter = new QFilter("id", "in", (Object)0L);
                    listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
                } else {
                    qfilter = new QFilter("id", "in", wareHouseId);
                    listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
                }
            }
        }
        if ("producedept".equals(source)) {
            org = (DynamicObject)this.getModel().getValue("org");
            Long orgId = 0L;
            if (org != null) {
                orgId = (Long)org.getPkValue();
            }
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_workshopsetup", (Long)orgId);
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObjectCollection col = QueryServiceHelper.query((String)"mpdm_workshopsetup", (String)"workshoporg", (QFilter[])new QFilter[]{qFilter});
            if (!col.isEmpty()) {
                HashSet<Long> idSet = new HashSet<Long>(col.size());
                for (int i = 0; i < col.size(); ++i) {
                    DynamicObject obj = (DynamicObject)col.get(i);
                    idSet.add(NumberUtils.toLong((String)obj.getString("workshoporg")));
                }
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", idSet));
            } else {
                List toOrg = OrgUnitServiceHelper.getAllToOrg((String)"15", (String)"01", (Long)orgId);
                if (!toOrg.isEmpty()) {
                    listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)toOrg));
                }
            }
            listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            listShowParameter.setMultiSelect(false);
        } else if ("material".equals(source)) {
            invorg = (DynamicObject)this.getModel().getValue("invorg");
            if (invorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"MftBackDiffShareEdit_19", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        } else if ("warehouse".equals(source)) {
            ListShowParameter listShowParameter3;
            int row = evt.getRow();
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", row);
            if (material == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7269\u6599\u3002", (String)"MftBackDiffShareEdit_30", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject org2 = (DynamicObject)this.getModel().getValue("invorg");
            if (org2 == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"MftBackDiffShareEdit_29", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long[] warehouseids = WarehouseHelper.getAllWarehouseIDs((Long)((Long)org2.getPkValue()));
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Long warehouseid : warehouseids) {
                if (warehouseid == null) continue;
                ids.add(warehouseid);
            }
            if (!ids.isEmpty()) {
                listShowParameter3 = (ListShowParameter)evt.getFormShowParameter();
                QFilter qfilter = new QFilter("id", "in", ids);
                listShowParameter3.getListFilterParameter().getQFilters().add(qfilter);
            } else {
                listShowParameter3 = (ListShowParameter)evt.getFormShowParameter();
                QFilter qfilter = new QFilter("id", "=", (Object)0L);
                listShowParameter3.getListFilterParameter().getQFilters().add(qfilter);
            }
        } else if ("invorg".equals(source)) {
            org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"MftBackDiffShareEdit_41", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListShowParameter listShowParameter4 = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter4.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            List<Long> inwareOrgFilter = this.getInwareOrgFilter((Long)org.getPkValue());
            if (!inwareOrgFilter.isEmpty()) {
                listShowParameter4.getListFilterParameter().getQFilters().add(new QFilter("id", "in", inwareOrgFilter));
            }
        } else if ("smaterial".equals(source)) {
            invorg = (DynamicObject)this.getModel().getValue("invorg");
            if (invorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"MftBackDiffShareEdit_29", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            materialInfoQfilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)invorg.getPkValue()));
            materialInfoQfilter.and(new QFilter("status", "=", (Object)"C"));
            listShowParameter2 = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter2.getListFilterParameter().getQFilters().add(materialInfoQfilter);
        } else if ("ematerial".equals(source)) {
            invorg = (DynamicObject)this.getModel().getValue("invorg");
            if (invorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"MftBackDiffShareEdit_29", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            materialInfoQfilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)invorg.getPkValue()));
            materialInfoQfilter.and(new QFilter("status", "=", (Object)"C"));
            listShowParameter2 = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter2.getListFilterParameter().getQFilters().add(materialInfoQfilter);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String billno;
        String entity;
        DynamicObject[] bills;
        String key = arg0.getFieldName();
        if ("orderno".equals(key) && (bills = BusinessDataServiceHelper.load((String)(entity = "pom_mftorder"), (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)(billno = (String)this.getModel().getValue(key, arg0.getRowIndex())))})) != null && bills.length > 0) {
            BillShowParameter showParameter = ManuFactureTraceUtils.createBillShowParam(entity, bills[0].getPkValue());
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void start(String operateKey) {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "im_mdc_backdiffsharepro");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "progressbarap");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("operateKey", (Object)operateKey);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionKey = e.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)"progressbarap", (CharSequence)actionKey)) {
            String total = this.getView().getPageCache().get("backflushnum");
            int number = NumberUtils.toInt((String)total);
            String success = this.getView().getPageCache().get("backflushlog");
            String operateKey = this.getView().getPageCache().get("operateKey");
            if (operateKey == null) {
                return;
            }
            String strMsg = null;
            switch (operateKey) {
                case "bfshare": {
                    strMsg = String.format(ResManager.loadKDString((String)"\u5206\u644a\u6210\u529f%s\u6761\u3002", (String)"MftBackDiffShareEdit_65", (String)"scmc-mm-mdc", (Object[])new Object[0]), number);
                    this.getView().showSuccessNotification(strMsg);
                    break;
                }
                case "unbfshare": {
                    strMsg = String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u644a\u6210\u529f%s\u6761\u3002", (String)"MftBackDiffShareEdit_66", (String)"scmc-mm-mdc", (Object[])new Object[0]), number);
                    this.getView().showSuccessNotification(strMsg);
                    break;
                }
                case "generate": {
                    int suc1 = success == null ? 0 : NumberUtils.toInt((String)success);
                    strMsg = String.format(ResManager.loadKDString((String)"\u5206\u644a\u660e\u7ec6\u5206\u914d\u201c\u751f\u4ea7\u9000\u6599\u5355/\u751f\u4ea7\u9886\u6599\u5355\u201d\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761,\u5177\u4f53\u8bf7\u67e5\u770b\u5206\u644a\u660e\u7ec6\u3002", (String)"MftBackDiffShareEdit_69", (String)"scmc-mm-mdc", (Object[])new Object[0]), suc1, number - suc1);
                    this.getView().showSuccessNotification(strMsg);
                    break;
                }
                case "ungenerate": {
                    DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ungenerate");
                    String sucess2 = (String)cache.get("backflushlog");
                    int suc2 = sucess2 == null ? 0 : NumberUtils.toInt((String)sucess2);
                    strMsg = String.format(ResManager.loadKDString((String)"\u5220\u9664\u201c\u751f\u4ea7\u9000\u6599\u5355/\u751f\u4ea7\u9886\u6599\u5355\u201d\u6210\u529f%1$s\u5f20\uff0c\u5931\u8d25%2$s\u5f20\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u5206\u644a\u660e\u7ec6\u3002", (String)"MftBackDiffShareEdit_70", (String)"scmc-mm-mdc", (Object[])new Object[0]), suc2, number - suc2);
                    this.getView().showSuccessNotification(strMsg);
                }
            }
            this.getView().invokeOperation("refresh");
            String opKey = this.getView().getPageCache().get("opKey");
            if (opKey == null || opKey.length() <= 0) {
                return;
            }
            if ("shareandpush".equals(opKey)) {
                this.getView().getPageCache().put("opKey", null);
                this.getView().invokeOperation("generate");
                this.getView().invokeOperation("refresh");
            } else if ("unshareandpush".equals(opKey)) {
                this.getView().getPageCache().put("opKey", null);
                this.getView().invokeOperation("unbfshare");
                this.getView().invokeOperation("refresh");
            }
            return;
        }
    }

    private void setControlState(boolean flag, int index) {
        this.getView().setEnable(Boolean.valueOf(flag), index, new String[]{"material", "mversion", "auxpty", "lotnumber", "warehouse", "location2", "project", "invtype", "invstatus", "ownertype", "owner", "producedate", "expirydate", "keepertype", "keeper", "unit", "invaccnum"});
    }

    private Map<Long, List<Map<String, Object>>> getStockMap(QFilter filter, Map<Long, BigDecimal> mftOrderBaseNum, DynamicObject invorg, Map<String, String> baseUnitData) {
        HashMap<Long, List<Map<String, Object>>> stockMap = new HashMap<Long, List<Map<String, Object>>>();
        boolean shareByReceived = BackDiffShareAuxMatchUtil.checkUserReceived();
        try (DataSet stockData = QueryServiceHelper.queryDataSet((String)"query_stockdata", (String)"pom_mftstock", (String)this.selectStockProperties(), (QFilter[])new QFilter[]{filter}, (String)" orderno,orderentryid");){
            for (Row row : stockData) {
                Map<Object, Object> rowMap = new HashMap(16);
                List rowList = new ArrayList(16);
                BigDecimal standqty = row.getBigDecimal("stockentry.standqty");
                if (!shareByReceived && BigDecimal.ZERO.compareTo(standqty) == 0) continue;
                Long masteridKey = row.getLong("stockentry.materielmasterid");
                Long supplyorgid = row.getLong("stockentry.supplyorgid");
                if (!supplyorgid.toString().equals(invorg.getPkValue().toString())) continue;
                if (stockMap.containsKey(masteridKey)) {
                    rowList = (List)stockMap.get(masteridKey);
                    rowMap = this.getrowMap(row, mftOrderBaseNum, baseUnitData);
                    rowList.add(rowMap);
                    continue;
                }
                rowList = new ArrayList();
                rowMap = this.getrowMap(row, mftOrderBaseNum, baseUnitData);
                rowList.add(rowMap);
                stockMap.put(masteridKey, rowList);
            }
        }
        return stockMap;
    }

    private String selectStockProperties() {
        StringBuilder selector = new StringBuilder();
        selector.append("id,orderno,orderentryid,baseqty,stockentry.qtytype,stockentry.wipqty,");
        selector.append("stockentry.id,stockentry.actissueqty,stockentry.feedingqty,stockentry.rejectedqty,");
        selector.append("stockentry.materialid,stockentry.materielmasterid,");
        selector.append("stockentry.supplierid,stockentry.supplyorgid,stockentry.childauxpropertyid,");
        selector.append("stockentry.materialunitid,stockentry.standqty,stockentry.isbackflush,");
        selector.append("stockentry.fixscrap,stockentry.demandqty");
        return selector.toString();
    }

    private Map<String, Object> getrowMap(Row row, Map<Long, BigDecimal> mftOrderBaseNum, Map<String, String> baseUnitData) {
        HashMap<String, Object> rowMap = new HashMap<String, Object>();
        BigDecimal actissueqty = row.getBigDecimal("stockentry.actissueqty");
        BigDecimal feedingqty = row.getBigDecimal("stockentry.feedingqty");
        BigDecimal rejectedqty = row.getBigDecimal("stockentry.rejectedqty");
        BigDecimal demandqty = row.getBigDecimal("stockentry.demandqty");
        BigDecimal baseqty = row.getBigDecimal("baseqty");
        BigDecimal fixscrap = row.get("stockentry.fixscrap") == null ? BigDecimal.ZERO : row.getBigDecimal("stockentry.fixscrap");
        Long orderentryid = row.getLong("orderentryid");
        String qtytype = row.getString("stockentry.qtytype");
        BigDecimal pickbasenum = actissueqty.subtract(rejectedqty).add(feedingqty);
        String materialunitid = row.getString("stockentry.materialunitid");
        String measure = baseUnitData.get(materialunitid);
        String[] split = measure.split("@@");
        int precision = Integer.parseInt(split[0]);
        int person = MftReqOutBillUtil.getPrecisionaccount(split[1]);
        BigDecimal madebasenum = demandqty;
        if ("C".equals(qtytype) || "A".equals(qtytype)) {
            BigDecimal mftBaseNum = mftOrderBaseNum.get(orderentryid);
            madebasenum = mftBaseNum.multiply(demandqty.subtract(fixscrap)).divide(baseqty, precision, person);
        }
        rowMap.put("madebasenum", madebasenum);
        rowMap.put("pickbasenum", pickbasenum);
        rowMap.put("qtytype", qtytype);
        rowMap.put("materialunitid", materialunitid);
        rowMap.put("isbackflush", row.getString("stockentry.isbackflush"));
        rowMap.put("supplierid", row.getString("stockentry.supplierid"));
        rowMap.put("supplyorgid", row.getString("stockentry.supplyorgid"));
        rowMap.put("childauxpropertyid", row.getString("stockentry.childauxpropertyid"));
        rowMap.put("materialid", row.getLong("stockentry.materialid"));
        rowMap.put("materielmasterid", row.getLong("stockentry.materielmasterid"));
        rowMap.put("orderentryid", row.getLong("orderentryid"));
        rowMap.put("orderno", row.getString("orderno"));
        return rowMap;
    }

    private Map<String, String> getMeasureunitData() {
        HashMap<String, String> map = new HashMap<String, String>();
        String queryMainSql = "select fid,fprecision,fprecisiontype from T_bd_Measureunit ";
        try (DataSet queryMainData = DB.queryDataSet((String)"queryMeasureunitData", (DBRoute)DBRoute.base, (String)queryMainSql);){
            for (Row row : queryMainData) {
                String fid = row.getString("fid");
                String precision = row.getString("fprecision");
                String precisiontype = row.getString("fprecisiontype");
                map.put(fid, precision + "@@" + precisiontype);
            }
        }
        return map;
    }

    private boolean isNull(Object obj) {
        if (obj instanceof String) {
            return obj == null || obj.toString().trim().length() == 0;
        }
        return obj == null;
    }

    private List<Long> getInwareOrgFilter(Long mftOrg) {
        ArrayList<Long> filterList = new ArrayList<Long>();
        if (this.checkOrgIsAccount(mftOrg)) {
            List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)mftOrg);
            if (!allToOrg.isEmpty()) {
                filterList.addAll(allToOrg);
            }
        } else {
            List fromOrgs = OrgUnitServiceHelper.getFromOrgs((String)"04", (Long)mftOrg, (String)"10");
            if (fromOrgs.isEmpty()) {
                Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)mftOrg, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                Integer fromOrg = map == null || map.isEmpty() ? Integer.valueOf(0) : map.get("id");
                Long longFromOrg = (Long)((Object)fromOrg);
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)longFromOrg);
                if (!allToOrg.isEmpty()) {
                    filterList.addAll(allToOrg);
                }
            } else {
                Long fromOrg = (Long)fromOrgs.get(0);
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)fromOrg);
                if (!allToOrg.isEmpty()) {
                    filterList.addAll(allToOrg);
                }
            }
        }
        return filterList;
    }

    private boolean checkOrgIsAccount(Long orgid) {
        DynamicObject dyOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgid, (String)"bos_org");
        return dyOrg.getBoolean("fisaccounting");
    }

    private Set<Long> getWareHouseId(Set<Long> ids, String entityName) {
        String algoKey = "queryWareHouseId";
        QFilter qFilter = new QFilter("id", "in", ids);
        qFilter.and(new QFilter("isopenlocation", "=", (Object)Boolean.TRUE));
        HashSet<Long> houseSet = new HashSet<Long>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id,entryentity.location", (QFilter[])new QFilter[]{qFilter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long loaction = row.getLong("entryentity.location");
                if (loaction <= 0L) continue;
                houseSet.add(loaction);
            }
        }
        return houseSet;
    }

    static {
        fieldKeySet.add("producedept");
        fieldKeySet.add("indatestart");
        fieldKeySet.add("indateend");
        fieldKeySet.add("invorg");
        fieldKeySet.add("smaterialinv");
        fieldKeySet.add("ematerialinv");
        fieldKeySet.add("mulshift");
        fieldKeySet.add("mulwarehouse");
        fieldKeySet.add("mullocation");
        fieldKeySet.add("isinvtime");
        fieldKeySet.add("invtime");
    }
}

