/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.mftouttpl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.sbd.enums.UnitConvertDirEnum;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.helper.BillViewHelper;
import kd.scmc.im.common.mdc.utils.BackFlushCatchUtils;
import kd.scmc.im.common.mdc.utils.ManuFactureTraceUtils;
import kd.scmc.im.common.mdc.utils.OMStockBackFlushUtils;
import kd.scmc.im.common.mdc.utils.StockBackFlushUtils;
import kd.scmc.im.formplugin.mdc.mftouttpl.ext.IBackFlushFormProvideQueryMapper;
import kd.scmc.im.utils.BigDecimalUtils;

public class MftBackFlushEdit
extends AbstractBillPlugIn
implements ClickListener,
BeforeF7SelectListener,
HyperLinkClickListener,
EntryGridBindDataListener {
    private static final Log logger = LogFactory.getLog(MftBackFlushEdit.class);
    private DistributeSessionlessCache backflushquery = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("backflushedit");
    private static final int CACHE_TIMELONG = 7200;
    private static final String[] keyStrs = new String[]{"orderno", "orderentryid", "transactiontypeid", "isbackflush", "productid", "sourcebillno", "billseq", "biztime", "backflushtime", "unitid", "productqty", "materialid", "stockentryid", "stockid", "sourcebillid", "sourcebillentryid", "sourcebillentry", "materielmasterid", "materialunitid", "supplyorgid", "warehouseid", "location", "qtytype", "supplymode", "supplierid", "canbfqty", "bfclose", "childauxpropertyid", "unissueqty", "actissueqty", "cansendqty", "actissuebfqty", "unbfqty", "nowbfqty", "bfratio", "bfflag", "entryconfiguredcode", "unit2nd", "qtyunit2nd", "entrytracknumber", "project", "batchno", "orgsc"};
    private static final String[] buttons = new String[]{"query", "generate", "baritemap2", "baritemap3", "bar_close"};

    public void registerListener(EventObject e) {
        BasedataEdit tracknumber;
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"sourcebillnomain"});
        this.addClickListeners(new String[]{"orderbillno"});
        BasedataEdit producedept = (BasedataEdit)this.getView().getControl("producedept");
        if (producedept != null) {
            producedept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((tracknumber = (BasedataEdit)this.getView().getControl("tracknumber")) != null) {
            tracknumber.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        this.getModel().beginInit();
        List rows = e.getRows();
        this.setNowBFRows(rows);
        this.selectDefaultRows(rows);
        this.getModel().endInit();
    }

    private Map<Long, Boolean> getInBIllID_bizdirectionMap(Set<Long> inBIllIDs) {
        HashMap<Long, Boolean> inBIllID_bizdirection = new HashMap<Long, Boolean>(16);
        String algoKey = "query-ominbill";
        String selects = "id,invscheme.bizdirection";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", inBIllIDs)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_mdc_omcmplinbill", (String)selects, (QFilter[])qFilters, null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                Long id = next.getLong("id");
                String bizdirection = next.getString("invscheme.bizdirection");
                if ("1".equals(bizdirection)) {
                    inBIllID_bizdirection.put(id, Boolean.FALSE);
                    continue;
                }
                inBIllID_bizdirection.put(id, Boolean.TRUE);
            }
        }
        return inBIllID_bizdirection;
    }

    private void selectDefaultRows(List<RowDataEntity> rows) {
        EntryGrid control = (EntryGrid)this.getView().getControl("billentry");
        ArrayList<Integer> select = new ArrayList<Integer>();
        for (RowDataEntity row : rows) {
            int i = row.getRowIndex();
            DynamicObject orderEntry = (DynamicObject)this.getModel().getValue("orderentryid", i);
            if (orderEntry == null) continue;
            String bizStatus = orderEntry.getString("bizstatus");
            BigDecimal actissueBFQty = (BigDecimal)this.getModel().getValue("actissuebfqty", i);
            BigDecimal canBFQty = (BigDecimal)this.getModel().getValue("canbfqty", i);
            if (!"A".equals(bizStatus) || canBFQty.compareTo(actissueBFQty) <= 0) continue;
            select.add(i);
        }
        if (!select.isEmpty()) {
            int[] selectRows = new int[select.size()];
            for (int i = 0; i < select.size(); ++i) {
                selectRows[i] = (Integer)select.get(i);
            }
            control.selectRows(selectRows, selectRows[0]);
        }
    }

    private void setNowBFRows(List<RowDataEntity> rows) {
        for (RowDataEntity row : rows) {
            int i = row.getRowIndex();
            this.setNowBFnable(i);
        }
    }

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        EntryGrid control;
        FormOperate op = (FormOperate)e.getSource();
        IDataModel model = this.getModel();
        String entityType_name = this.getModel().getDataEntityType().getName();
        if (StringUtils.equals((CharSequence)"bfquery", (CharSequence)op.getOperateKey())) {
            Object value = this.getModel().getValue("org");
            if (value == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"MftBackFlushEdit_8", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                return;
            }
            OperationResult operationResult = e.getOperationResult();
            if (!operationResult.isSuccess()) {
                return;
            }
            long start = System.currentTimeMillis();
            model.deleteEntryData("billentry");
            logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u6e05\u7a7a\u5355\u636e\u4f53,\uff0c\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            long start1 = System.currentTimeMillis();
            this.insertBillEntry();
            logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u586b\u5145\u5355\u636e\u4f53,\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start1));
            this.setBatchNoEnable();
            long currentUserId = UserServiceHelper.getCurrentUserId();
            this.backflushquery.put("query" + currentUserId, (Object)"1");
        }
        if ("unbackflush".equals(op.getOperateKey())) {
            String bfLogId = op.getOption().getVariableValue("backflushlog", "0");
            if ("0".equals(bfLogId)) {
                return;
            }
            ArrayList<QFilter> qfilterList = new ArrayList<QFilter>();
            QFilter qfilter = new QFilter("id", "=", (Object)Long.parseLong(bfLogId));
            qfilterList.add(qfilter);
            ListShowParameter showParameter = ManuFactureTraceUtils.createShowParam("im_mdc_backflushlog", qfilterList);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        if ("viewproorder".equals(op.getOperateKey())) {
            ListShowParameter showParameter;
            QFilter qfilter;
            int i;
            HashSet<Object> idList;
            DynamicObjectCollection bills;
            String entityKey;
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
            int[] selectRows = entryGrid.getSelectRows();
            HashSet<Long> sourceBillEntryidSet = new HashSet<Long>(16);
            HashSet<Long> stockEntryIdSet = new HashSet<Long>(16);
            HashSet<Long> sourcebillIds = new HashSet<Long>(16);
            for (int i2 = 0; i2 < selectRows.length; ++i2) {
                String sourcebill = (String)model.getValue("sourcebill", selectRows[i2]);
                if ("im_mdc_ombackflushform".equals(entityType_name) && "A".equals(sourcebill)) {
                    Long sourcebillId = (Long)model.getValue("sourcebillid", selectRows[i2]);
                    sourcebillIds.add(sourcebillId);
                    continue;
                }
                sourceBillEntryidSet.add((Long)model.getValue("sourcebillentryid", selectRows[i2]));
                stockEntryIdSet.add((Long)model.getValue("stockentryid", selectRows[i2]));
            }
            HashSet<Long> wwrk_sourceBillEntryidSet = new HashSet<Long>(16);
            HashSet<Long> wwrk_stockEntryIdSet = new HashSet<Long>(16);
            HashSet<Long> wwtk_sourceBillEntryidSet = new HashSet<Long>(16);
            HashSet<Long> wwtk_stockEntryIdSet = new HashSet<Long>(16);
            if (!sourcebillIds.isEmpty()) {
                Map<Long, Boolean> inBIllID_bizdirectionMap = this.getInBIllID_bizdirectionMap(sourcebillIds);
                for (int i3 = 0; i3 < selectRows.length; ++i3) {
                    Long sourcebillId;
                    Boolean isrk;
                    String sourcebill = (String)model.getValue("sourcebill", selectRows[i3]);
                    if (!"im_mdc_ombackflushform".equals(entityType_name) || !"A".equals(sourcebill) || (isrk = inBIllID_bizdirectionMap.get(sourcebillId = (Long)model.getValue("sourcebillid", selectRows[i3]))) == null) continue;
                    if (isrk.booleanValue()) {
                        wwrk_sourceBillEntryidSet.add((Long)model.getValue("sourcebillentryid", selectRows[i3]));
                        wwrk_stockEntryIdSet.add((Long)model.getValue("stockentryid", selectRows[i3]));
                        continue;
                    }
                    wwtk_sourceBillEntryidSet.add((Long)model.getValue("sourcebillentryid", selectRows[i3]));
                    wwtk_stockEntryIdSet.add((Long)model.getValue("stockentryid", selectRows[i3]));
                }
            }
            boolean isAllEmpty = true;
            if (!sourceBillEntryidSet.isEmpty()) {
                QFilter filter = new QFilter("billentry.srcbillentryid", "in", sourceBillEntryidSet);
                filter.and(new QFilter("billentry.mainbillentryid", "in", stockEntryIdSet));
                entityKey = "im_mdc_mftproorder";
                if ("G".equals(model.getValue("sourcebill"))) {
                    entityKey = "im_mdc_mftreturnorder";
                }
                if ("im_mdc_ombackflushform".equals(entityType_name)) {
                    entityKey = "im_mdc_omoutbill";
                }
                bills = QueryServiceHelper.query((String)entityKey, (String)"id,billno", (QFilter[])new QFilter[]{filter});
                idList = new HashSet(bills.size());
                for (i = 0; i < bills.size(); ++i) {
                    idList.add(((DynamicObject)bills.get(i)).get("id"));
                }
                if (idList.size() != 0) {
                    if (idList.size() == 1) {
                        isAllEmpty = false;
                        if ("im_mdc_propbackflushform".equals(entityType_name)) {
                            entityKey = "im_mdc_propproorder";
                            if ("G".equals(model.getValue("sourcebill"))) {
                                entityKey = "im_mdc_propmftreturnorder";
                            }
                        }
                        BillShowParameter showParameter2 = ManuFactureTraceUtils.createBillShowParam(entityKey, ((DynamicObject)bills.get(0)).get("id"));
                        this.getView().showForm((FormShowParameter)showParameter2);
                    } else {
                        isAllEmpty = false;
                        if ("im_mdc_propbackflushform".equals(entityType_name)) {
                            entityKey = "im_mdc_propproorder";
                            if ("G".equals(model.getValue("sourcebill"))) {
                                entityKey = "im_mdc_propmftreturnorder";
                            }
                        }
                        ArrayList<QFilter> qfilterList = new ArrayList<QFilter>();
                        qfilter = new QFilter("id", "in", idList);
                        qfilterList.add(qfilter);
                        showParameter = ManuFactureTraceUtils.createShowParam(entityKey, qfilterList);
                        this.getView().showForm((FormShowParameter)showParameter);
                    }
                }
            }
            if (!wwrk_sourceBillEntryidSet.isEmpty()) {
                QFilter filter = new QFilter("billentry.srcbillentryid", "in", wwrk_sourceBillEntryidSet);
                filter.and(new QFilter("billentry.mainbillentryid", "in", wwrk_stockEntryIdSet));
                entityKey = "im_mdc_mftproorder";
                if ("im_mdc_ombackflushform".equals(entityType_name)) {
                    entityKey = "im_mdc_omoutbill";
                }
                bills = QueryServiceHelper.query((String)entityKey, (String)"id,billno", (QFilter[])new QFilter[]{filter});
                idList = new HashSet<Object>(bills.size());
                for (i = 0; i < bills.size(); ++i) {
                    idList.add(((DynamicObject)bills.get(i)).get("id"));
                }
                if (idList.size() != 0) {
                    if (idList.size() == 1) {
                        isAllEmpty = false;
                        BillShowParameter showParameter3 = ManuFactureTraceUtils.createBillShowParam(entityKey, ((DynamicObject)bills.get(0)).get("id"));
                        this.getView().showForm((FormShowParameter)showParameter3);
                    } else {
                        isAllEmpty = false;
                        ArrayList<QFilter> qfilterList = new ArrayList<QFilter>();
                        qfilter = new QFilter("id", "in", idList);
                        qfilterList.add(qfilter);
                        showParameter = ManuFactureTraceUtils.createShowParam(entityKey, qfilterList);
                        this.getView().showForm((FormShowParameter)showParameter);
                    }
                }
            }
            if (!wwtk_sourceBillEntryidSet.isEmpty()) {
                QFilter filter = new QFilter("billentry.srcbillentryid", "in", wwtk_sourceBillEntryidSet);
                filter.and(new QFilter("billentry.mainbillentryid", "in", wwtk_stockEntryIdSet));
                entityKey = "im_mdc_mftproorder";
                if ("im_mdc_ombackflushform".equals(entityType_name)) {
                    entityKey = "im_mdc_omreturnbill";
                }
                bills = QueryServiceHelper.query((String)entityKey, (String)"id,billno", (QFilter[])new QFilter[]{filter});
                idList = new HashSet(bills.size());
                for (int i4 = 0; i4 < bills.size(); ++i4) {
                    idList.add(((DynamicObject)bills.get(i4)).get("id"));
                }
                if (idList.size() != 0) {
                    if (idList.size() == 1) {
                        isAllEmpty = false;
                        BillShowParameter showParameter4 = ManuFactureTraceUtils.createBillShowParam(entityKey, ((DynamicObject)bills.get(0)).get("id"));
                        this.getView().showForm((FormShowParameter)showParameter4);
                    } else {
                        isAllEmpty = false;
                        ArrayList<QFilter> qfilterList = new ArrayList<QFilter>();
                        qfilter = new QFilter("id", "in", idList);
                        qfilterList.add(qfilter);
                        showParameter = ManuFactureTraceUtils.createShowParam(entityKey, qfilterList);
                        this.getView().showForm((FormShowParameter)showParameter);
                    }
                }
            }
            if (isAllEmpty) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5012\u51b2\u9886/\u9000\u6599\u5355\u3002", (String)"MftBackFlushEdit_9", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
        }
        if ("allselect".equals(op.getOperateKey())) {
            control = (EntryGrid)this.getView().getControl("billentry");
            int num = this.getModel().getEntryRowCount("billentry");
            if (num > 0) {
                int[] rows = new int[num];
                for (int i = 0; i < num; ++i) {
                    rows[i] = i;
                }
                control.selectRows(rows, 0);
            }
        }
        if ("cancelselect".equals(op.getOperateKey())) {
            control = (EntryGrid)this.getView().getControl("billentry");
            int num = this.getModel().getEntryRowCount("billentry");
            if (num > 0) {
                control.clearEntryState();
            }
        }
    }

    private void setBatchNoEnable() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("billentry");
        Map<Long, Boolean> materialidAndEnableLot = this.getMaterialidAndEnableLot(entrys);
        for (int i = 0; i < entrys.size(); ++i) {
            Long materialid = ((DynamicObject)entrys.get(i)).getLong("materialid.masterid.id");
            if (materialidAndEnableLot.get(materialid) != null && materialidAndEnableLot.get(materialid).booleanValue()) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"batchno"});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"batchno"});
        }
    }

    private Map<Long, Boolean> getMaterialidAndEnableLot(DynamicObjectCollection entrys) {
        HashSet materialids = Sets.newHashSetWithExpectedSize((int)entrys.size());
        HashMap materialidAndEnableLot = Maps.newHashMapWithExpectedSize((int)entrys.size());
        for (DynamicObject entry : entrys) {
            materialids.add(entry.getLong("materialid.masterid.id"));
        }
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"getMaterialidAndEnableLot", (String)"bd_materialinventoryinfo", (String)"masterid,enablelot", (QFilter[])new QFilter("masterid", "in", (Object)materialids).toArray(), null);){
            for (Row row : dataset) {
                materialidAndEnableLot.put(row.getLong("masterid"), row.getBoolean("enablelot"));
            }
        }
        return materialidAndEnableLot;
    }

    private void insertBillEntry() {
        IDataModel model = this.getModel();
        String entityKey = model.getDataEntityType().getName();
        String sourcebill = (String)model.getValue("sourcebill");
        if ("E".equals(sourcebill)) {
            QFilter bfqFilterG;
            QFilter bfqFilterA;
            DynamicObjectCollection mftmanuinbills = null;
            DynamicObjectCollection mftreturnbills = null;
            DynamicObjectCollection mftorderreportbills = null;
            DynamicObjectCollection sfcprocessreportbills = null;
            DynamicObjectCollection sfcprotransferbills = null;
            DynamicObjectCollection sfcmanftechbills = null;
            if ("im_mdc_ombackflushform".equals(entityKey)) {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                QFilter filter = new QFilter("billentry.entryreqorg", "=", org.getPkValue());
                filter.and(new QFilter("ischargeoffed", "=", (Object)Boolean.FALSE));
                filter.and(new QFilter("ischargeoff", "=", (Object)Boolean.FALSE));
                Object supplier = this.getModel().getValue("supplier");
                if (supplier instanceof DynamicObject) {
                    DynamicObject supObj = (DynamicObject)supplier;
                    filter.and(new QFilter("supplier", "=", supObj.getPkValue()));
                }
                String orderbillno = (String)this.getModel().getValue("orderbillno");
                String sourceBillnoMain = (String)this.getModel().getValue("sourcebillnomain");
                List<String> orderbillnos = this.getBillnoList(orderbillno);
                List<String> sourceBillnoMains = this.getBillnoList(sourceBillnoMain);
                DynamicObject productidmain = (DynamicObject)this.getModel().getValue("productidmain");
                Date startdate = (Date)this.getModel().getValue("biztimemain_startdate");
                Date enddate = (Date)this.getModel().getValue("biztimemain_enddate");
                filter.and(new QFilter("billstatus", "=", (Object)"C"));
                if (!orderbillnos.isEmpty()) {
                    filter.and(new QFilter("billentry.manubill", "in", orderbillnos));
                }
                if (!sourceBillnoMains.isEmpty()) {
                    filter.and(new QFilter("billno", "in", sourceBillnoMains));
                }
                if (startdate != null && enddate != null) {
                    filter.and(new QFilter("biztime", "<=", (Object)this.addTime(enddate, 1)));
                    filter.and(new QFilter("biztime", ">=", (Object)startdate));
                }
                if (productidmain != null) {
                    filter.and(new QFilter("billentry.materialmasterid", "=", productidmain.getPkValue()));
                }
                filter.and(new QFilter("isvirtualbill", "=", (Object)Boolean.FALSE));
                QFilter[] omQfs = new QFilter[]{filter};
                String rkSels = "id,billno,billentry.id,billentry.manubill billentry.mainbillnumber,billentry.manubillid billentry.mainbillid,billentry.manuentry billentry.mainbillentryseq,billentry.manuentryid billentry.mainbillentryid,billentry.baseqty,billentry.manuentryid,billentry.remainreturnbaseqty,billentry.returnbaseqty,billentry.materialmasterid,billentry.backflushstatus,billentry.seq,biztime,billentry.baseunit,invscheme,invscheme.bizdirection";
                mftmanuinbills = QueryServiceHelper.query((String)"im_mdc_omcmplinbill", (String)rkSels, (QFilter[])omQfs);
                String sels = "id,billno,sumentry.id,sumentry.manufacturenun,sumentry.manufacturerow,sumentry.manufactureentryid sumentry.mftentryid,sumentry.completqty sumentry.completbsqty,sumentry.seq,reportdate,sumentry.oprunit sumentry.baseunit";
                mftorderreportbills = QueryServiceHelper.query((String)"om_processreport", (String)sels, (QFilter[])new QFilter[]{this.getBFQFilter("B")});
            } else if ("im_mdc_propbackflushform".equals(entityKey)) {
                bfqFilterA = this.getBFQFilter("A");
                bfqFilterG = this.getBFQFilter("G");
                bfqFilterA.and(new QFilter("productiondomain", "=", (Object)"E"));
                bfqFilterA.and(new QFilter("billentry.mainbillentity", "=", (Object)"prop_mftorder"));
                bfqFilterG.and(new QFilter("productiondomain", "=", (Object)"E"));
                mftmanuinbills = QueryServiceHelper.query((String)"im_mdc_mftmanuinbill", (String)StockBackFlushUtils.getMftInBillSelects(), (QFilter[])new QFilter[]{bfqFilterA});
                mftreturnbills = QueryServiceHelper.query((String)"im_mdc_mftreturnbill", (String)StockBackFlushUtils.getMftInBillSelects(), (QFilter[])new QFilter[]{bfqFilterG});
                mftorderreportbills = QueryServiceHelper.query((String)"prop_mftorderreport", (String)StockBackFlushUtils.getMftOrderReportSelects(), (QFilter[])new QFilter[]{this.getBFQFilter("H")});
                sfcprocessreportbills = QueryServiceHelper.query((String)"prop_processreportbill", (String)StockBackFlushUtils.getSfcReportSelects(), (QFilter[])new QFilter[]{this.getBFQFilter("C")});
            } else {
                bfqFilterA = this.getBFQFilter("A");
                bfqFilterG = this.getBFQFilter("G");
                bfqFilterA.and(new QFilter("productiondomain", "=", (Object)"A"));
                bfqFilterA.and(new QFilter("billentry.mainbillentity", "=", (Object)"pom_mftorder"));
                bfqFilterG.and(new QFilter("productiondomain", "=", (Object)"A"));
                mftmanuinbills = QueryServiceHelper.query((String)"im_mdc_mftmanuinbill", (String)StockBackFlushUtils.getMftInBillSelects(), (QFilter[])new QFilter[]{bfqFilterA});
                mftreturnbills = QueryServiceHelper.query((String)"im_mdc_mftreturnbill", (String)StockBackFlushUtils.getMftInBillSelects(), (QFilter[])new QFilter[]{bfqFilterG});
                mftorderreportbills = QueryServiceHelper.query((String)"pom_mftorderreport", (String)StockBackFlushUtils.getMftOrderReportSelects(), (QFilter[])new QFilter[]{this.getBFQFilter("B")});
                sfcprocessreportbills = QueryServiceHelper.query((String)"sfc_processreportbill", (String)StockBackFlushUtils.getSfcReportSelects(), (QFilter[])new QFilter[]{this.getBFQFilter("C")});
                sfcprotransferbills = QueryServiceHelper.query((String)"sfc_protransferbill", (String)StockBackFlushUtils.getSfcProtransSelects(), (QFilter[])new QFilter[]{this.getBFQFilter("D")});
                sfcmanftechbills = QueryServiceHelper.query((String)"sfc_manftech", (String)StockBackFlushUtils.getSfcManftechSelects(), (QFilter[])new QFilter[]{this.getBFQFilter("F")});
            }
            if (!(mftmanuinbills != null && !mftmanuinbills.isEmpty() || mftorderreportbills != null && !mftorderreportbills.isEmpty() || sfcprocessreportbills != null && !sfcprocessreportbills.isEmpty() || sfcmanftechbills != null && !sfcmanftechbills.isEmpty() || sfcprotransferbills != null && !sfcprotransferbills.isEmpty() || mftreturnbills != null && !mftreturnbills.isEmpty())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u3002", (String)"MftBackFlushEdit_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            } else {
                List<List<Object>> gridListB2;
                List<List<Object>> gridList = this.getBillEntry(mftmanuinbills, "A");
                String reportsourceB = "B";
                String reportsourceC = "C";
                if ("im_mdc_propbackflushform".equals(entityKey)) {
                    reportsourceB = "H";
                    reportsourceC = "I";
                }
                List<List<Object>> gridListB = this.getBillEntry(mftorderreportbills, reportsourceB);
                if (sfcprocessreportbills != null && !sfcprocessreportbills.isEmpty()) {
                    gridListB2 = this.getBillEntry(sfcprocessreportbills, reportsourceC);
                    gridList.addAll(gridListB2);
                }
                if (sfcprotransferbills != null && !sfcprotransferbills.isEmpty()) {
                    gridListB2 = this.getBillEntry(sfcprotransferbills, "D");
                    gridList.addAll(gridListB2);
                }
                if (sfcmanftechbills != null && !sfcmanftechbills.isEmpty()) {
                    gridListB2 = this.getBillEntry(sfcmanftechbills, "F");
                    gridList.addAll(gridListB2);
                }
                if (mftreturnbills != null && !mftreturnbills.isEmpty()) {
                    gridListB2 = this.getBillEntry(mftreturnbills, "G");
                    gridList.addAll(gridListB2);
                }
                gridList.addAll(gridListB);
                this.handleBillEntry(gridList);
            }
        } else if ("A".equals(sourcebill)) {
            DynamicObjectCollection bills = null;
            if ("im_mdc_ombackflushform".equals(entityKey)) {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                QFilter filter = new QFilter("billentry.entryreqorg", "=", org.getPkValue());
                filter.and(new QFilter("ischargeoffed", "=", (Object)Boolean.FALSE));
                filter.and(new QFilter("ischargeoff", "=", (Object)Boolean.FALSE));
                Object supplier = this.getModel().getValue("supplier");
                if (supplier instanceof DynamicObject) {
                    DynamicObject supObj = (DynamicObject)supplier;
                    filter.and(new QFilter("supplier", "=", supObj.getPkValue()));
                }
                String orderbillno = (String)this.getModel().getValue("orderbillno");
                String sourceBillnoMain = (String)this.getModel().getValue("sourcebillnomain");
                List<String> orderbillnos = this.getBillnoList(orderbillno);
                List<String> sourceBillnoMains = this.getBillnoList(sourceBillnoMain);
                DynamicObject productidmain = (DynamicObject)this.getModel().getValue("productidmain");
                Date startdate = (Date)this.getModel().getValue("biztimemain_startdate");
                Date enddate = (Date)this.getModel().getValue("biztimemain_enddate");
                filter.and(new QFilter("billstatus", "=", (Object)"C"));
                if (!orderbillnos.isEmpty()) {
                    filter.and(new QFilter("billentry.manubill", "in", orderbillnos));
                }
                if (!sourceBillnoMains.isEmpty()) {
                    filter.and(new QFilter("billno", "in", sourceBillnoMains));
                }
                if (startdate != null && enddate != null) {
                    filter.and(new QFilter("biztime", "<=", (Object)this.addTime(enddate, 1)));
                    filter.and(new QFilter("biztime", ">=", (Object)startdate));
                }
                if (productidmain != null) {
                    filter.and(new QFilter("billentry.materialmasterid", "=", productidmain.getPkValue()));
                }
                QFilter[] omQfs = new QFilter[]{filter};
                String rkSels = "id,billno,billentry.id,billentry.manubill billentry.mainbillnumber,billentry.manubillid billentry.mainbillid,billentry.manuentry billentry.mainbillentryseq,billentry.manuentryid billentry.mainbillentryid,billentry.baseqty,billentry.manuentryid,billentry.remainreturnbaseqty,billentry.returnbaseqty,billentry.materialmasterid,billentry.backflushstatus,billentry.seq,biztime,billentry.baseunit,invscheme,invscheme.bizdirection";
                bills = QueryServiceHelper.query((String)"im_mdc_omcmplinbill", (String)rkSels, (QFilter[])omQfs);
            } else if ("im_mdc_propbackflushform".equals(entityKey)) {
                QFilter sourcebillqf = this.getBFQFilter(sourcebill);
                sourcebillqf.and(new QFilter("productiondomain", "=", (Object)"E"));
                sourcebillqf.and(new QFilter("billentry.mainbillentity", "=", (Object)"prop_mftorder"));
                bills = QueryServiceHelper.query((String)"im_mdc_mftmanuinbill", (String)StockBackFlushUtils.getMftInBillSelects(), (QFilter[])new QFilter[]{sourcebillqf});
            } else {
                QFilter sourcebillqf2 = this.getBFQFilter(sourcebill);
                sourcebillqf2.and(new QFilter("productiondomain", "=", (Object)"A"));
                sourcebillqf2.and(new QFilter("billentry.mainbillentity", "=", (Object)"pom_mftorder"));
                bills = QueryServiceHelper.query((String)"im_mdc_mftmanuinbill", (String)StockBackFlushUtils.getMftInBillSelects(), (QFilter[])new QFilter[]{sourcebillqf2});
            }
            if (bills == null || bills.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u3002", (String)"MftBackFlushEdit_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            } else {
                List<List<Object>> billEntry = this.getBillEntry(bills, sourcebill);
                this.handleBillEntry(billEntry);
            }
        } else if ("B".equals(sourcebill) || "H".equals(sourcebill)) {
            DynamicObjectCollection bills = null;
            if (!"im_mdc_ombackflushform".equals(entityKey)) {
                if ("im_mdc_propbackflushform".equals(entityKey)) {
                    QFilter sourcebillqf = this.getBFQFilter(sourcebill);
                    bills = QueryServiceHelper.query((String)"prop_mftorderreport", (String)StockBackFlushUtils.getMftOrderReportSelects(), (QFilter[])new QFilter[]{sourcebillqf});
                } else {
                    QFilter sourcebillqf2 = this.getBFQFilter(sourcebill);
                    bills = QueryServiceHelper.query((String)"pom_mftorderreport", (String)StockBackFlushUtils.getMftOrderReportSelects(), (QFilter[])new QFilter[]{sourcebillqf2});
                }
            }
            if (bills == null || bills.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u3002", (String)"MftBackFlushEdit_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            } else {
                List<List<Object>> billEntry = this.getBillEntry(bills, sourcebill);
                this.handleBillEntry(billEntry);
            }
        } else if ("C".equals(sourcebill) || "I".equals(sourcebill)) {
            DynamicObjectCollection bills = null;
            if ("im_mdc_ombackflushform".equals(entityKey)) {
                String sels = "id,billno,sumentry.id,sumentry.manufacturenun,sumentry.manufacturerow,sumentry.manufactureentryid sumentry.mftentryid,sumentry.completqty sumentry.completbsqty,sumentry.seq,reportdate,sumentry.oprunit sumentry.baseunit";
                bills = QueryServiceHelper.query((String)"om_processreport", (String)sels, (QFilter[])new QFilter[]{this.getBFQFilter("B")});
                sourcebill = "B";
            } else if ("im_mdc_propbackflushform".equals(entityKey)) {
                QFilter sourcebillqf = this.getBFQFilter(sourcebill);
                bills = QueryServiceHelper.query((String)"prop_processreportbill", (String)StockBackFlushUtils.getSfcReportSelects(), (QFilter[])new QFilter[]{sourcebillqf});
            } else {
                QFilter sourcebillqf2 = this.getBFQFilter("C");
                bills = QueryServiceHelper.query((String)"sfc_processreportbill", (String)StockBackFlushUtils.getSfcReportSelects(), (QFilter[])new QFilter[]{sourcebillqf2});
            }
            if (bills == null || bills.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u3002", (String)"MftBackFlushEdit_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            } else {
                List<List<Object>> billEntry = this.getBillEntry(bills, sourcebill);
                this.handleBillEntry(billEntry);
            }
        } else if ("D".equals(sourcebill)) {
            DynamicObjectCollection bills = null;
            if (!"im_mdc_ombackflushform".equals(entityKey)) {
                bills = QueryServiceHelper.query((String)"sfc_protransferbill", (String)StockBackFlushUtils.getSfcProtransSelects(), (QFilter[])new QFilter[]{this.getBFQFilter("D")});
            }
            if (bills == null || bills.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u3002", (String)"MftBackFlushEdit_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            } else {
                List<List<Object>> billEntry = this.getBillEntry(bills, sourcebill);
                this.handleBillEntry(billEntry);
            }
        } else if ("F".equals(sourcebill)) {
            DynamicObjectCollection bills = null;
            if (!"im_mdc_ombackflushform".equals(entityKey)) {
                bills = QueryServiceHelper.query((String)"sfc_manftech", (String)StockBackFlushUtils.getSfcManftechSelects(), (QFilter[])new QFilter[]{this.getBFQFilter("F")});
            }
            if (bills == null || bills.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u3002", (String)"MftBackFlushEdit_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            } else {
                List<List<Object>> billEntry = this.getBillEntry(bills, sourcebill);
                this.handleBillEntry(billEntry);
            }
        } else if ("G".equals(sourcebill)) {
            DynamicObjectCollection bills = null;
            QFilter sourcebillqf = this.getBFQFilter(sourcebill);
            String productiondomain = "A";
            if ("im_mdc_propbackflushform".equals(entityKey)) {
                productiondomain = "E";
            }
            sourcebillqf.and(new QFilter("productiondomain", "=", (Object)productiondomain));
            bills = QueryServiceHelper.query((String)"im_mdc_mftreturnbill", (String)StockBackFlushUtils.getMftInBillSelects(), (QFilter[])new QFilter[]{sourcebillqf});
            if (bills == null || bills.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u3002", (String)"MftBackFlushEdit_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            } else {
                List<List<Object>> billEntry = this.getBillEntry(bills, sourcebill);
                this.handleBillEntry(billEntry);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        int[] selectRows = entryGrid.getSelectRows();
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        if (("generate".equals(operateKey) || "unbackflush".equals(operateKey) || "viewproorder".equals(operateKey) || "bfclose".equals(operateKey) || "bfunclose".equals(operateKey) || "scmcinvquery".equals(operateKey)) && selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MftBackFlushEdit_3", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if ("generate".equals(op.getOperateKey())) {
            StringBuilder sb;
            Boolean isPassed = false;
            for (int i = 0; i < selectRows.length; ++i) {
                String bfflag = (String)this.getModel().getValue("bfflag", selectRows[i]);
                boolean bfCloseEntry = (Boolean)this.getModel().getValue("bfclose", selectRows[i]);
                if (bfCloseEntry || !"A".equals(bfflag) && !"B".equals(bfflag)) continue;
                isPassed = true;
                break;
            }
            if (!isPassed.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6570\u636e\u884c\u90fd\u5df2\u5012\u51b2\u5b8c\u6210\u6216\u5012\u51b2\u5173\u95ed\u3002", (String)"MftBackFlushEdit_4", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            ArrayList<DynamicObject> selectDym = new ArrayList<DynamicObject>(selectRows.length);
            for (int i = 0; i < selectRows.length; ++i) {
                selectDym.add(this.getModel().getEntryRowEntity("billentry", selectRows[i]));
            }
            Map<String, DynamicObject> addBatchCache = BackFlushCatchUtils.addBatchCache(selectDym);
            Boolean checkBatchCacheExit = BackFlushCatchUtils.checkBatchCacheExit(addBatchCache, sb = new StringBuilder());
            if (checkBatchCacheExit.booleanValue()) {
                String error = sb.toString();
                logger.info("\u5206\u5e03\u5f0f\u9501\u7b49\u5f85\u3002" + error);
                String msg = ResManager.loadKDString((String)"\u91cd\u65b0\u67e5\u8be2\u6216\u8005\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"MftBackFlushEdit_19", (String)"scmc-mm-mdc", (Object[])new Object[0]);
                if (error.length() > 1000) {
                    error = error.substring(0, 1000) + "...";
                }
                this.getView().showTipNotification(msg + "\n\r" + error);
                e.setCancel(true);
                return;
            }
            long currentUserId = UserServiceHelper.getCurrentUserId();
            String cathckey = "query" + currentUserId;
            if (this.backflushquery != null && this.backflushquery.contains(cathckey)) {
                String queryvalue = (String)this.backflushquery.get(cathckey);
                if ("1".equals(queryvalue)) {
                    this.backflushquery.put(cathckey, (Object)"0");
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u67e5\u8be2\u6216\u8005\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"MftBackFlushEdit_19", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
            }
            BackFlushCatchUtils.catchBackFlush(addBatchCache);
            op.getOption().setVariableValue("opProgressCache", this.getView().getPageId());
            this.start(op.getOperateKey());
        }
        if ("unbackflush".equals(op.getOperateKey())) {
            this.start(op.getOperateKey());
        }
        if ("bfclose".equals(op.getOperateKey()) || "bfunclose".equals(op.getOperateKey())) {
            this.bfClose(selectRows, e);
        }
        if ("generate".equals(op.getOperateKey()) || "unbackflush".equals(op.getOperateKey())) {
            this.setButtonEnable(Boolean.FALSE);
        }
    }

    private void bfClose(int[] selectRows, BeforeDoOperationEventArgs e) {
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        boolean bfclose = false;
        String str = ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u65e0\u9700\u53d6\u6d88\u5173\u95ed\u64cd\u4f5c\u3002", (String)"MftBackFlushEdit_5", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        if ("bfunclose".equals(operateKey)) {
            bfclose = true;
            str = ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u65e0\u9700\u53d6\u6d88\u5173\u95ed\u64cd\u4f5c\u3002", (String)"MftBackFlushEdit_5", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        } else if ("bfclose".equals(operateKey)) {
            bfclose = false;
            str = ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u65e0\u9700\u5012\u51b2\u5173\u95ed\u64cd\u4f5c\u3002", (String)"MftBackFlushEdit_6", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        }
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (int rowIndex : selectRows) {
            boolean bfCloseEntry = (Boolean)this.getModel().getValue("bfclose", rowIndex);
            if (bfclose != bfCloseEntry) continue;
            rows.add(rowIndex);
        }
        if (rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)str, (String)"MftBackFlushEdit_8", (String)"MftBackFlushEdit_7", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        this.doClose(rows, bfclose);
    }

    private void doClose(List<Integer> rows, boolean bfclose) {
        String name;
        ArrayList<String> unExistEntryIds = new ArrayList<String>(rows.size());
        for (Integer row : rows) {
            this.getModel().setValue("bfclose", (Object)(!bfclose ? 1 : 0), row.intValue());
            String sourcebillentry = this.getModel().getValue("sourcebillentry", row.intValue()).toString();
            String sourcebillentryid = this.getModel().getValue("sourcebillentryid", row.intValue()).toString();
            String stockentryid = this.getModel().getValue("stockentryid", row.intValue()).toString();
            unExistEntryIds.add(sourcebillentry + "," + sourcebillentryid + "," + stockentryid);
            this.setNowBFnable(row);
        }
        String str = "A";
        if (bfclose) {
            str = "B";
        }
        if ("im_mdc_ombackflushform".equals(name = this.getModel().getDataEntityType().getName())) {
            OMStockBackFlushUtils.updateStockBFInfo(unExistEntryIds, str);
        } else {
            StockBackFlushUtils.updateStockBFInfo(unExistEntryIds, str);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        List bfBillnosList = (List)this.getView().getFormShowParameter().getCustomParam("bfBillnosList");
        Object productionOrg = this.getView().getFormShowParameter().getCustomParam("productionOrg");
        String billType = (String)this.getView().getFormShowParameter().getCustomParam("billType");
        String sourceBill = "E";
        if (StringUtils.equals((CharSequence)"im_mdc_mftreturnbill", (CharSequence)billType)) {
            sourceBill = "G";
        } else if (StringUtils.equals((CharSequence)"im_mdc_mftmanuinbill", (CharSequence)billType) || StringUtils.equals((CharSequence)"im_mdc_omcmplinbill", (CharSequence)billType)) {
            sourceBill = "A";
        }
        if (bfBillnosList != null && productionOrg != null) {
            StringBuilder sb = new StringBuilder();
            for (String bfBillnos : bfBillnosList) {
                sb.append(bfBillnos);
                sb.append(";");
            }
            this.getModel().setValue("backflushflag", (Object)"E");
            this.getModel().setValue("sourcebill", (Object)sourceBill);
            this.getModel().setValue("sourcebillnomain", (Object)sb.substring(0, sb.length() - 1));
            this.getModel().setValue("org", productionOrg);
            this.getModel().setValue("closeorder", (Object)true);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"sourcebillnomain"});
            this.getView().invokeOperation("bfquery");
        } else {
            this.setSourceBillEnable();
        }
    }

    private void setSourceBillEnable() {
        if ("E".equals((String)this.getModel().getValue("sourcebill"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"sourcebillnomain"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"sourcebillnomain"});
        }
        this.getModel().setValue("sourcebillnomain", (Object)"");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.getView().getModel().setDataChanged(false);
        String key = e.getProperty().getName();
        if ("sourcebill".equals(key)) {
            this.setSourceBillEnable();
        } else if ("nowbfqty".equals(key)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            BigDecimal newValue = (BigDecimal)e.getChangeSet()[0].getNewValue();
            DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("materialunitid", rowIndex);
            DynamicObject material = (DynamicObject)this.getModel().getValue("materielmasterid", rowIndex);
            String unitConvertDir = material.getString("unitconvertdir");
            boolean isConvert = UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
            DynamicObject auxptyUnit = (DynamicObject)this.getModel().getValue("unit2nd", rowIndex);
            if (!isConvert || auxptyUnit == null) {
                return;
            }
            if (BigDecimal.ZERO.compareTo(newValue) == 0) {
                this.getModel().beginInit();
                this.getModel().setValue("qtyunit2nd", (Object)BigDecimal.ZERO, rowIndex);
                this.getModel().endInit();
                return;
            }
            BigDecimal qtyUnit2nd = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)baseUnit, (BigDecimal)newValue, (DynamicObject)auxptyUnit);
            BigDecimalUtils.showBigDecimalErrorTip((IDataModel)this.getModel(), (BigDecimal)qtyUnit2nd, (String)"qtyunit2nd");
            this.getModel().beginInit();
            this.getModel().setValue("qtyunit2nd", (Object)qtyUnit2nd, rowIndex);
            this.getModel().endInit();
            BillViewHelper.updateViewRow((IFormView)this.getView(), (int)rowIndex, (String)"billentry");
        } else if ("autobackflush".equals(key)) {
            this.setNowBF();
        } else if ("qtyunit2nd".equals(key)) {
            boolean isConvert;
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            BigDecimal newValue = (BigDecimal)e.getChangeSet()[0].getNewValue();
            DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("materialunitid", rowIndex);
            DynamicObject material = (DynamicObject)this.getModel().getValue("materielmasterid", rowIndex);
            String unitConvertDir = material.getString("unitconvertdir");
            boolean bl = isConvert = UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
            if (!isConvert) {
                return;
            }
            DynamicObject auxptyUnit = (DynamicObject)this.getModel().getValue("unit2nd", rowIndex);
            BigDecimal baseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)auxptyUnit, (BigDecimal)newValue, (DynamicObject)baseUnit);
            BigDecimalUtils.showBigDecimalErrorTip((IDataModel)this.getModel(), (BigDecimal)baseQty, (String)"nowbfqty");
            this.getModel().beginInit();
            this.getModel().setValue("nowbfqty", (Object)baseQty, rowIndex);
            this.getModel().endInit();
            BillViewHelper.updateViewRow((IFormView)this.getView(), (int)rowIndex, (String)"billentry");
        }
    }

    public void click(EventObject evt) {
        Control sourceField = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)sourceField.getKey(), (CharSequence)"sourcebillnomain")) {
            this.showBillList("sourcebill");
        } else if (StringUtils.equals((CharSequence)sourceField.getKey(), (CharSequence)"orderbillno")) {
            this.showBillList("orderbillno");
        }
    }

    private void showBillList(String sourcekey) {
        String entityKey = this.getModel().getDataEntityType().getName();
        if ("sourcebill".equals(sourcekey)) {
            String entityNumber = null;
            String sourcebill = (String)this.getModel().getValue(sourcekey);
            if (StringUtils.equalsIgnoreCase((CharSequence)sourcebill, (CharSequence)"A")) {
                entityNumber = "im_mdc_mftmanuinbill";
                if ("im_mdc_ombackflushform".equals(entityKey)) {
                    entityNumber = "im_mdc_omcmplinbill";
                } else if ("im_mdc_propbackflushform".equals(entityKey)) {
                    entityNumber = "im_mdc_propmanuinbill";
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)sourcebill, (CharSequence)"B")) {
                entityNumber = "pom_mftorderreport";
                if ("im_mdc_ombackflushform".equals(entityKey)) {
                    entityNumber = "om_processreport";
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)sourcebill, (CharSequence)"C")) {
                entityNumber = "sfc_processreportbill";
            } else if (StringUtils.equalsIgnoreCase((CharSequence)sourcebill, (CharSequence)"F")) {
                entityNumber = "sfc_manftech";
            } else if (StringUtils.equalsIgnoreCase((CharSequence)sourcebill, (CharSequence)"G")) {
                entityNumber = "im_mdc_mftreturnbill";
                if ("im_mdc_propbackflushform".equals(entityKey)) {
                    entityNumber = "im_mdc_propreturnbill";
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)sourcebill, (CharSequence)"H")) {
                entityNumber = "prop_mftorderreport";
            } else if (StringUtils.equalsIgnoreCase((CharSequence)sourcebill, (CharSequence)"I")) {
                entityNumber = "prop_processreportbill";
            }
            if (!StringUtils.isEmpty((CharSequence)entityNumber)) {
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(this.getSourceBillFilter(entityNumber));
                this.openList(filters, entityNumber, sourcekey);
            }
        } else if ("orderbillno".equals(sourcekey)) {
            String entityNumber = "pom_mftorder";
            if ("im_mdc_ombackflushform".equals(entityKey)) {
                entityNumber = "om_mftorder";
            } else if ("im_mdc_propbackflushform".equals(entityKey)) {
                entityNumber = "prop_mftorder";
            }
            List<QFilter> filters = this.getBillFilter();
            this.openList(filters, entityNumber, sourcekey);
        }
    }

    private QFilter getSourceBillFilter(String entityNumber) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if ("im_mdc_mftmanuinbill".equals(entityNumber) || "im_mdc_mftreturnbill".equals(entityNumber)) {
            String entityKey = this.getModel().getDataEntityType().getName();
            String biztype = "330";
            if ("im_mdc_mftreturnbill".equals(entityNumber)) {
                biztype = "3301";
            }
            filter.and(new QFilter("biztype.number", "=", (Object)biztype));
            String orderEntity = "pom_mftorder";
            if ("im_mdc_propbackflushform".equals(entityKey)) {
                orderEntity = "prop_mftorder";
            }
            filter.and(new QFilter("billentry.mainbillentity", "=", (Object)orderEntity));
            if (org != null) {
                filter.and(new QFilter("productionorg", "=", org.getPkValue()));
            }
        } else if (("sfc_manftech".equals(entityNumber) || "pom_mftorderreport".equals(entityNumber) || "sfc_processreportbill".equals(entityNumber) || "prop_mftorderreport".equals(entityNumber) || "prop_processreportbill".equals(entityNumber)) && org != null) {
            filter.and(new QFilter("org", "=", org.getPkValue()));
        }
        return filter;
    }

    private void openList(List<QFilter> filters, String entityNumber, String sourcekey) {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)false);
        showParameter.getListFilterParameter().setQFilters(filters);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, sourcekey);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setMultiSelect(true);
        showParameter.setSelectedRows(this.getSelectedPk(entityNumber, sourcekey));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private Object[] getSelectedPk(String entityNumber, String sourcekey) {
        if ("sourcebill".equals(sourcekey)) {
            QFilter filter = this.getSourceBillFilter(entityNumber);
            List<String> billnos = this.getBillnoList((String)this.getModel().getValue("sourcebillnomain"));
            filter.and(new QFilter("billno", "in", billnos));
            if ("im_mdc_propmanuinbill".equals(entityNumber)) {
                entityNumber = "im_mdc_mftmanuinbill";
            } else if ("im_mdc_propreturnbill".equals(entityNumber)) {
                entityNumber = "im_mdc_mftreturnbill";
            }
            DynamicObject[] load = BusinessDataServiceHelper.load((String)entityNumber, (String)"id", (QFilter[])new QFilter[]{filter});
            Object[] pks = new Object[load.length];
            for (int i = 0; i < load.length; ++i) {
                pks[i] = load[i].getPkValue();
            }
            return pks;
        }
        if ("orderbillno".equals(sourcekey)) {
            List<QFilter> filters = this.getBillFilter();
            List<String> billnos = this.getBillnoList((String)this.getModel().getValue("orderbillno"));
            filters.add(new QFilter("billno", "in", billnos));
            DynamicObject[] load = BusinessDataServiceHelper.load((String)entityNumber, (String)"id", (QFilter[])filters.toArray(new QFilter[filters.size()]));
            Object[] pks = new Object[load.length];
            for (int i = 0; i < load.length; ++i) {
                pks[i] = load[i].getPkValue();
            }
            return pks;
        }
        return new Object[]{0};
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionKey = e.getActionId();
        if (e.getReturnData() != null) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
            String billno = this.getRowsBillno(rows);
            if (StringUtils.equalsIgnoreCase((CharSequence)"sourcebill", (CharSequence)actionKey)) {
                this.getModel().setValue("sourcebillnomain", (Object)billno);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"orderbillno", (CharSequence)actionKey)) {
                this.getModel().setValue("orderbillno", (Object)billno);
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"progressbarap", (CharSequence)actionKey)) {
            String bfLogId;
            long start1 = System.currentTimeMillis();
            String string = bfLogId = this.getPageCache().get("backflushlog") == null ? "0" : this.getPageCache().get("backflushlog");
            if ("0".equals(bfLogId)) {
                this.setButtonEnable(Boolean.TRUE);
                return;
            }
            long start4 = System.currentTimeMillis();
            ArrayList<QFilter> qfilterList = new ArrayList<QFilter>();
            QFilter qfilter = new QFilter("id", "=", (Object)Long.parseLong(bfLogId));
            qfilterList.add(qfilter);
            ListShowParameter showParameter = ManuFactureTraceUtils.createShowParam("im_mdc_backflushlog", qfilterList);
            this.getView().showForm((FormShowParameter)showParameter);
            this.getView().invokeOperation("bfquery");
            logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u8fdb\u5ea6\u6761\u6253\u5f00\u5012\u51b2\u65e5\u5fd7\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start4));
            logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u8fdb\u5ea6\u6761\u6253\u5f00\u5012\u51b2\u65e5\u5fd7\uff0c\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start1));
            this.setButtonEnable(Boolean.TRUE);
        }
    }

    private String getRowsBillno(ListSelectedRowCollection rows) {
        HashSet<String> billnos = new HashSet<String>(rows.size());
        for (ListSelectedRow row : rows) {
            billnos.add(row.getBillNo());
        }
        StringBuilder sb = new StringBuilder();
        for (String billno : billnos) {
            sb.append(billno);
            sb.append(";");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private List<List<Object>> getBillEntry(DynamicObjectCollection bills, String sourcebill) {
        List<List<Object>> gridList;
        long start = System.currentTimeMillis();
        String name = this.getModel().getDataEntityType().getName();
        if ("im_mdc_ombackflushform".equals(name)) {
            gridList = OMStockBackFlushUtils.getBFBillInfo(bills, sourcebill, this.getModel());
            this.omBatchGetEntry(this.sortByBillno(gridList), sourcebill);
        } else {
            long start1 = System.currentTimeMillis();
            String entityName = "";
            if ("im_mdc_propbackflushform".equals(name)) {
                entityName = "prop_mftorderreport";
            }
            gridList = StockBackFlushUtils.getBFBillInfo(bills, sourcebill, this.getModel(), entityName);
            logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u67e5\u8be2\u7ec4\u4ef6\u6e05\u5355\u7ed3\u675f\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start1));
            this.batchGetEntry(this.sortByBillno(gridList), sourcebill);
        }
        logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u83b7\u53d6\u5e94\u5012\u51b2\u6570\u91cf,\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return gridList;
    }

    private void batchGetEntry(List<List<Object>> gridList, String sourcebill) {
        String baseqtyName = "billentry.baseqty";
        if ("A".equals(sourcebill) || "G".equals(sourcebill)) {
            baseqtyName = "billentry.baseqty";
        } else if ("B".equals(sourcebill) || "H".equals(sourcebill)) {
            baseqtyName = "sumentry.completbsqty";
        } else if ("C".equals(sourcebill) || "I".equals(sourcebill)) {
            baseqtyName = "sumentry.completbaseqty";
        } else if ("D".equals(sourcebill)) {
            baseqtyName = "outentryentity.transferbaseqty";
        } else if ("F".equals(sourcebill)) {
            baseqtyName = "baseqty";
        }
        String tempBaseqty = baseqtyName;
        for (List<Object> grid : gridList) {
            boolean isReturnBackFlush;
            DynamicObject stockDym;
            DynamicObject bill = (DynamicObject)grid.get(0);
            DynamicObject stockEntry = (DynamicObject)grid.get(1);
            BigDecimal canbfqty = StockBackFlushUtils.getCanBFQty(stockEntry, stockDym, bill, baseqtyName = !(isReturnBackFlush = (stockDym = (DynamicObject)grid.get(2)).getBoolean("transactiontypeid.returnbackflush")) && "A".equals(sourcebill) ? "billentry.remainreturnbaseqty" : tempBaseqty, sourcebill);
            if (canbfqty.compareTo(BigDecimal.ZERO) <= 0) {
                canbfqty = BigDecimal.ZERO;
            }
            grid.add(canbfqty);
            grid.add(sourcebill);
        }
    }

    private void omBatchGetEntry(List<List<Object>> gridList, String sourcebill) {
        for (List<Object> grid : gridList) {
            boolean isReturnBackFlush;
            String baseqtyName;
            DynamicObject stockDym;
            DynamicObject bill = (DynamicObject)grid.get(0);
            DynamicObject stockEntry = (DynamicObject)grid.get(1);
            BigDecimal canbfqty = OMStockBackFlushUtils.getCanBFQty(stockEntry, stockDym, bill, baseqtyName = !(isReturnBackFlush = (stockDym = (DynamicObject)grid.get(2)).getBoolean("transactiontypeid.returnbackflush")) && "A".equals(sourcebill) && "0".equals(bill.getString("invscheme.bizdirection")) ? "billentry.remainreturnbaseqty" : "billentry.baseqty", sourcebill);
            if (canbfqty.compareTo(BigDecimal.ZERO) <= 0) {
                canbfqty = BigDecimal.ZERO;
            }
            grid.add(canbfqty);
            grid.add(sourcebill);
        }
    }

    private void handleBillEntry(List<List<Object>> gridList) {
        long start = System.currentTimeMillis();
        List<List<Object>> newGridList = this.getStockBFInfo(gridList);
        logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u5355\u636e\u4f53\u8fc7\u6ee4,\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        long start1 = System.currentTimeMillis();
        this.batchInsertEntry(newGridList);
        logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u5355\u636e\u4f53\u63d2\u5165,\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start1));
        int num = this.getModel().getEntryRowCount("billentry");
        EntryGrid grid = (EntryGrid)this.getView().getControl("billentry");
        if (num > grid.getPageRow()) {
            grid.setPageRows(grid.getPageRow());
        } else {
            this.setNowBF();
        }
        this.selectDefault();
        logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u5355\u636e\u4f53\u8fc7\u6ee4,\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        if (num == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u3002", (String)"MftBackFlushEdit_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
        }
    }

    private List<List<Object>> sortByBillno(List<List<Object>> gridList) {
        ArrayList<List<Object>> newGridList = new ArrayList<List<Object>>(gridList.size());
        HashMap<Integer, String> map = new HashMap<Integer, String>(gridList.size());
        for (int i = 0; i < gridList.size(); ++i) {
            List<Object> grid = gridList.get(i);
            DynamicObject bill = (DynamicObject)grid.get(0);
            map.put(i, bill.getString("billno"));
        }
        LinkedHashMap finalOut = new LinkedHashMap(gridList.size());
        map.entrySet().stream().sorted((p1, p2) -> ((String)p1.getValue()).compareTo((String)p2.getValue())).collect(Collectors.toList()).forEach(ele -> {
            String cfr_ignored_0 = (String)finalOut.put(ele.getKey(), ele.getValue());
        });
        for (Map.Entry entry : ((HashMap)finalOut).entrySet()) {
            newGridList.add(gridList.get((Integer)entry.getKey()));
        }
        return newGridList;
    }

    private void batchInsertEntry(List<List<Object>> gridList) {
        String baseqtyName = "billentry.baseqty";
        String sourcebillEntryName = "billentry";
        String biztimeName = "biztime";
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (String keyStr : keyStrs) {
            vs.addField(keyStr, new Object[0]);
        }
        if ("im_mdc_ombackflushform".equals(this.getModel().getDataEntityType().getName())) {
            vs.addField("invscheme", new Object[0]);
        }
        DistributeSessionlessCache sCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("backflush");
        for (List<Object> grid : gridList) {
            BigDecimal returnBaseQty;
            BigDecimal baseQty;
            DynamicObject bill = (DynamicObject)grid.get(0);
            DynamicObject stockEntry = (DynamicObject)grid.get(1);
            DynamicObject stockDym = (DynamicObject)grid.get(2);
            String sourcebill = (String)grid.get(4);
            boolean isReturnBackFlush = stockDym.getBoolean("transactiontypeid.returnbackflush");
            if (!isReturnBackFlush && StringUtils.equals((CharSequence)"A", (CharSequence)sourcebill) && (baseQty = bill.getBigDecimal("billentry.baseqty")).compareTo(returnBaseQty = bill.getBigDecimal("billentry.returnbaseqty")) <= 0) continue;
            BigDecimal canbfqty = (BigDecimal)grid.get(3);
            BigDecimal actissueBFQty = (BigDecimal)grid.get(5);
            boolean bfclose = (Boolean)grid.get(6);
            BigDecimal unBFQty = (BigDecimal)grid.get(7);
            BigDecimal useratio = (BigDecimal)grid.get(8);
            String bfflag = (String)grid.get(9);
            String billseq = "";
            if ("B".equals(sourcebill) || "H".equals(sourcebill)) {
                baseqtyName = "sumentry.completbsqty";
                sourcebillEntryName = "sumentry";
                biztimeName = "reportdate";
                billseq = bill.get(sourcebillEntryName + ".seq").toString();
            } else if ("C".equals(sourcebill) || "I".equals(sourcebill)) {
                baseqtyName = "sumentry.completbaseqty";
                sourcebillEntryName = "sumentry";
                biztimeName = "reportdate";
                billseq = bill.get(sourcebillEntryName + ".seq").toString();
            } else if ("D".equals(sourcebill)) {
                baseqtyName = "outentryentity.transferbaseqty";
                sourcebillEntryName = "outentryentity";
                biztimeName = "bizdate";
                billseq = bill.get(sourcebillEntryName + ".seq").toString();
            } else if ("F".equals(sourcebill)) {
                baseqtyName = "baseqty";
                sourcebillEntryName = "oprentryentity";
                biztimeName = "createtime";
                billseq = bill.get(sourcebillEntryName + ".oprparent") + "," + bill.get(sourcebillEntryName + ".oprno");
            } else if ("A".equals(sourcebill) || "G".equals(sourcebill)) {
                billseq = bill.get("billentry.seq").toString();
            }
            String exitCatchKey = "backflush_" + bill.get("id") + "_" + bill.get(sourcebillEntryName + ".id") + "_" + stockEntry.getPkValue();
            if (sCache != null && sCache.contains(exitCatchKey)) continue;
            if ("im_mdc_ombackflushform".equals(this.getModel().getDataEntityType().getName())) {
                vs.addRow(new Object[]{stockDym.get("orderno"), this.getId(stockDym, "orderentryid"), this.getId(stockDym, "transactiontypeid"), stockDym.getDynamicObject("transactiontypeid").getBoolean("isbackflush"), this.getId(stockDym.getDynamicObject("productid"), "masterid"), bill.get("billno"), billseq, bill.get(biztimeName), bill.get(biztimeName), this.getId(stockDym, "baseunitid"), new BigDecimal(bill.getString(baseqtyName)).abs(), this.getId(stockEntry, "materialid"), stockEntry.getPkValue(), stockDym.getPkValue(), bill.get("id"), bill.get(sourcebillEntryName + ".id"), sourcebill, this.getId(stockEntry, "materielmasterid"), this.getId(stockEntry, "materialunitid"), this.getId(stockEntry, "supplyorgid"), this.getId(stockEntry, "warehouseid"), this.getId(stockEntry, "location"), stockEntry.get("qtytype"), stockEntry.get("supplymode"), this.getId(stockEntry, "supplierid"), canbfqty, bfclose, this.getId(stockEntry, "childauxpropertyid"), stockEntry.get("unissueqty"), stockEntry.get("actissueqty"), stockEntry.get("cansendqty"), actissueBFQty, unBFQty, unBFQty.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : unBFQty, useratio, bfflag, this.getId(stockEntry, "entryconfiguredcode"), this.getId(stockEntry.getDynamicObject("materielmasterid"), "auxptyunit"), this.getAuxQty(stockEntry.getDynamicObject("materielmasterid"), unBFQty), this.getId(stockDym.getDynamicObject("orderentryid"), "tracknumber"), this.getId(stockDym, "bdproject"), stockEntry.getString("batchno"), this.getId(stockDym, "org"), bill.get("invscheme")});
                continue;
            }
            vs.addRow(new Object[]{stockDym.get("orderno"), this.getId(stockDym, "orderentryid"), this.getId(stockDym, "transactiontypeid"), stockDym.getDynamicObject("transactiontypeid").getBoolean("isbackflush"), this.getId(stockDym.getDynamicObject("productid"), "masterid"), bill.get("billno"), billseq, bill.get(biztimeName), bill.get(biztimeName), this.getId(stockDym, "baseunitid"), new BigDecimal(bill.getString(baseqtyName)).abs(), this.getId(stockEntry, "materialid"), stockEntry.getPkValue(), stockDym.getPkValue(), bill.get("id"), bill.get(sourcebillEntryName + ".id"), sourcebill, this.getId(stockEntry, "materielmasterid"), this.getId(stockEntry, "materialunitid"), this.getId(stockEntry, "supplyorgid"), this.getId(stockEntry, "warehouseid"), this.getId(stockEntry, "location"), stockEntry.get("qtytype"), stockEntry.get("supplymode"), this.getId(stockEntry, "supplierid"), canbfqty, bfclose, this.getId(stockEntry, "childauxpropertyid"), stockEntry.get("unissueqty"), stockEntry.get("actissueqty"), stockEntry.get("cansendqty"), actissueBFQty, unBFQty, unBFQty.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : unBFQty, useratio, bfflag, this.getId(stockEntry, "entryconfiguredcode"), this.getId(stockEntry.getDynamicObject("materielmasterid"), "auxptyunit"), this.getAuxQty(stockEntry.getDynamicObject("materielmasterid"), unBFQty), this.getId(stockDym.getDynamicObject("orderentryid"), "tracknumber"), this.getId(stockDym, "bdproject"), stockEntry.getString("batchno"), this.getId(stockDym, "org")});
        }
        model.batchCreateNewEntryRow("billentry", vs);
        PluginProxy extPlugin = PluginProxy.create(null, IBackFlushFormProvideQueryMapper.class, (String)"POM_BACKFLUSHFORM_PROVIDEQUERYMAPPER_EXT", null);
        extPlugin.callReplace(p -> {
            p.provideQueryMapper(model);
            return null;
        });
        model.endInit();
        this.getView().updateView("billentry");
    }

    private Object getAuxQty(DynamicObject masterMaterial, BigDecimal unBFQty) {
        if (masterMaterial != null) {
            DynamicObject baseUnit = masterMaterial.getDynamicObject("baseunit");
            DynamicObject auxptyUnit = masterMaterial.getDynamicObject("auxptyunit");
            Boolean isUseAuxptyUnit = auxptyUnit != null;
            if (isUseAuxptyUnit.booleanValue()) {
                return BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)masterMaterial, (DynamicObject)baseUnit, (BigDecimal)unBFQty, (DynamicObject)auxptyUnit);
            }
        }
        return BigDecimal.ZERO;
    }

    private Object getId(DynamicObject stockDym, String keyName) {
        if (stockDym == null) {
            return 0L;
        }
        return stockDym.getDynamicObject(keyName) == null ? Long.valueOf(0L) : stockDym.getDynamicObject(keyName).getPkValue();
    }

    private void selectDefault() {
        int num = this.getModel().getEntryRowCount("billentry");
        EntryGrid control = (EntryGrid)this.getView().getControl("billentry");
        ArrayList<Integer> select = new ArrayList<Integer>();
        for (int i = 0; i < num; ++i) {
            DynamicObject orderEntry = (DynamicObject)this.getModel().getValue("orderentryid", i);
            if (orderEntry == null) continue;
            String bizStatus = orderEntry.getString("bizstatus");
            BigDecimal actissueBFQty = (BigDecimal)this.getModel().getValue("actissuebfqty", i);
            BigDecimal canBFQty = (BigDecimal)this.getModel().getValue("canbfqty", i);
            if (!"A".equals(bizStatus) || canBFQty.compareTo(actissueBFQty) <= 0) continue;
            select.add(i);
        }
        if (!select.isEmpty()) {
            int[] rows = new int[select.size()];
            for (int i = 0; i < select.size(); ++i) {
                rows[i] = (Integer)select.get(i);
            }
            control.selectRows(rows, rows[0]);
        }
    }

    private String getBFClose(boolean bfClose) {
        String bfCloseStr = "";
        bfCloseStr = bfClose ? "B" : "C";
        return bfCloseStr;
    }

    private List<List<Object>> getStockBFInfo(List<List<Object>> gridList) {
        ArrayList<List<Object>> newGridList = new ArrayList<List<Object>>(16);
        logger.info("---1145--- gridList size: " + gridList.size());
        HashMap<String, List<Object>> res = new HashMap<String, List<Object>>(gridList.size());
        HashSet<String> sourceBillEntrySet = new HashSet<String>(16);
        HashSet<Long> sourceBillEntryidSet = new HashSet<Long>(16);
        HashSet<Long> stockEntryIdSet = new HashSet<Long>(16);
        String sourcebillEntryName = "billentry";
        for (List<Object> grid : gridList) {
            DynamicObject bill = (DynamicObject)grid.get(0);
            DynamicObject stockEntry = (DynamicObject)grid.get(1);
            String sourcebill = (String)grid.get(4);
            ArrayList<Object> info = new ArrayList<Object>(3);
            sourcebillEntryName = "B".equals(sourcebill) || "C".equals(sourcebill) || "H".equals(sourcebill) || "I".equals(sourcebill) ? "sumentry" : ("D".equals(sourcebill) ? "outentryentity" : ("F".equals(sourcebill) ? "oprentryentity" : "billentry"));
            String sourcebillentry = sourcebill;
            Object sourcebillentryid = bill.get(sourcebillEntryName + ".id");
            Object stockentryid = stockEntry.getPkValue();
            info.add(sourcebillentry);
            info.add(sourcebillentryid);
            info.add(stockentryid);
            sourceBillEntrySet.add(sourcebillentry);
            sourceBillEntryidSet.add((Long)sourcebillentryid);
            stockEntryIdSet.add((Long)stockentryid);
            String idStr = sourcebillentry + "," + sourcebillentryid.toString() + "," + stockentryid.toString();
            res.put(idStr, null);
        }
        this.getBFResById(sourceBillEntrySet, sourceBillEntryidSet, stockEntryIdSet, res);
        IDataModel model = this.getModel();
        String backflushflag = (String)model.getValue("backflushflag");
        String bfClose = (String)model.getValue("backflushclose");
        Integer querynum = (Integer)model.getValue("querynum");
        for (List<Object> grid : gridList) {
            String entityKey;
            DynamicObject bill = (DynamicObject)grid.get(0);
            DynamicObject stockEntry = (DynamicObject)grid.get(1);
            DynamicObject stockDyObj = (DynamicObject)grid.get(2);
            BigDecimal canbfqty = (BigDecimal)grid.get(3);
            String sourcebill = (String)grid.get(4);
            sourcebillEntryName = "B".equals(sourcebill) || "C".equals(sourcebill) || "H".equals(sourcebill) || "I".equals(sourcebill) ? "sumentry" : ("D".equals(sourcebill) ? "outentryentity" : ("F".equals(sourcebill) ? "oprentryentity" : "billentry"));
            String sourcebillentry = sourcebill;
            Object sourcebillentryid = bill.get(sourcebillEntryName + ".id");
            Object stockentryid = stockEntry.getPkValue();
            String idStr = sourcebillentry + "," + sourcebillentryid.toString() + "," + stockentryid.toString();
            List list = (List)res.get(idStr);
            BigDecimal actissueBFQty = (BigDecimal)list.get(0);
            if ("B".equals(stockEntry.getString("qtytype"))) {
                actissueBFQty = stockEntry.getBigDecimal("actissueqty");
            }
            grid.add(actissueBFQty);
            BigDecimal unbfqty = canbfqty.subtract(actissueBFQty);
            if (actissueBFQty.compareTo(canbfqty) >= 0) {
                grid.add(true);
            } else {
                grid.add(list.get(1));
            }
            grid.add(unbfqty);
            if (BigDecimal.ZERO.compareTo(canbfqty) == 0) {
                grid.add(BigDecimal.ZERO);
            } else {
                grid.add(actissueBFQty.divide(canbfqty, 4, 4).multiply(new BigDecimal(100)));
            }
            String bfflag = "";
            if (actissueBFQty.compareTo(BigDecimal.ZERO) == 0) {
                bfflag = "A";
            } else if (actissueBFQty.compareTo(canbfqty) < 0) {
                bfflag = "B";
            } else if (actissueBFQty.compareTo(canbfqty) == 0) {
                bfflag = "C";
            } else if (actissueBFQty.compareTo(canbfqty) > 0) {
                bfflag = "EE";
            }
            grid.add(bfflag);
            String bfCloseEntry = this.getBFClose((Boolean)list.get(1));
            boolean isDel = false;
            if (!"E".equals(backflushflag) && !backflushflag.equals(bfflag) || !"A".equals(bfClose) && "B".equals(bfClose) && canbfqty.compareTo(actissueBFQty) > 0 || !"A".equals(bfClose) && "C".equals(bfClose) && canbfqty.compareTo(actissueBFQty) <= 0 || canbfqty.compareTo(BigDecimal.ZERO) <= 0 && actissueBFQty.compareTo(BigDecimal.ZERO) <= 0) {
                isDel = true;
                logger.info("1231---canbfqty:" + canbfqty);
            }
            if ("im_mdc_ombackflushform".equals(entityKey = model.getDataEntityType().getName()) && "A".equals(sourcebill)) {
                String bizdirection = bill.getString("invscheme.bizdirection");
                if ("1".equals(bizdirection)) {
                    isDel = this.isDelByTransReturnBackFlushParam(stockDyObj, stockEntry, isDel);
                }
            } else if ("G".equals(sourcebill)) {
                isDel = this.isDelByTransReturnBackFlushParam(stockDyObj, stockEntry, isDel);
            }
            if (!isDel && newGridList.size() < querynum) {
                newGridList.add(grid);
                logger.info("1258---newGridList add");
            }
            if (newGridList.size() != querynum.intValue()) continue;
            break;
        }
        logger.info("---1263--- newGridList size:" + newGridList.size());
        return newGridList;
    }

    private boolean isDelByTransReturnBackFlushParam(DynamicObject stockDyObj, DynamicObject stockEntry, boolean isDel) {
        DynamicObject trans = stockDyObj.getDynamicObject("transactiontypeid");
        if (trans != null && trans.containsProperty("returnbackflush") && trans.getBoolean("returnbackflush")) {
            String qtytype = stockEntry.getString("qtytype");
            if ("B".equals(qtytype)) {
                isDel = true;
                logger.info("1246---\u7ec4\u4ef6\u6e05\u5355\u7ec4\u4ef6\u660e\u7ec6.\u7528\u91cf\u7c7b\u578b=\u56fa\u5b9a");
            }
        } else {
            isDel = true;
            logger.info("1250---\u7ec4\u4ef6\u6e05\u5355.\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u4e0d\u6ee1\u8db3\u6761\u4ef6");
        }
        return isDel;
    }

    private void getBFResById(Set<String> sourceBillEntrySet, Set<Long> sourceBillEntryidSet, Set<Long> stockEntryIdSet, Map<String, List<Object>> res) {
        QFilter filter = new QFilter("sourcebillentry", "in", sourceBillEntrySet);
        filter.and(new QFilter("sourcebillentryid", "in", sourceBillEntryidSet));
        filter.and(new QFilter("stockentryid", "in", stockEntryIdSet));
        long start = System.currentTimeMillis();
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"im_mdc_backflushstock", (String)"sourcebillentry,sourcebillentryid,stockentryid,bfclose", (QFilter[])new QFilter[]{filter});
        logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u6839\u636e\u8fc7\u6ee4\u6761\u4ef6\u67e5\u8be2\u7ec4\u4ef6\u5012\u51b2\u4fe1\u606f\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        for (Object bill : bills) {
            String string = bill.getString("sourcebillentry");
            String sourcebillentryid = bill.getString("sourcebillentryid");
            String stockentryid = bill.getString("stockentryid");
            Object bfclose = bill.get("bfclose");
            String idStr = string + "," + sourcebillentryid + "," + stockentryid;
            ArrayList<Object> info = new ArrayList<Object>(2);
            info.add(BigDecimal.ZERO);
            info.add(bfclose);
            res.put(idStr, info);
        }
        ArrayList<String> entryIds = new ArrayList<String>(16);
        for (Map.Entry entry : res.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            entryIds.add(key);
            if (value != null) continue;
            ArrayList<Comparable<BigDecimal>> info = new ArrayList<Comparable<BigDecimal>>(2);
            info.add(BigDecimal.ZERO);
            info.add(Boolean.valueOf(false));
            res.put(key, info);
        }
        String name = this.getModel().getDataEntityType().getName();
        if ("im_mdc_ombackflushform".equals(name)) {
            Map<String, List<Object>> map = OMStockBackFlushUtils.getUnExistBFInfo(entryIds);
            this.updateResClose(map, res);
        } else {
            Map<String, List<Object>> map = StockBackFlushUtils.getUnExistBFInfo(entryIds);
            this.updateResClose(map, res);
        }
    }

    private void updateResClose(Map<String, List<Object>> existRes, Map<String, List<Object>> res) {
        for (Map.Entry<String, List<Object>> resInfo : existRes.entrySet()) {
            String key = resInfo.getKey();
            List<Object> value = resInfo.getValue();
            List<Object> list = res.get(key);
            if (res.get(key) != null && value != null) {
                list.set(0, value.get(0));
            }
            res.put(key, list);
        }
    }

    private void setNowBF() {
        this.getModel().beginInit();
        int num = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < num; ++i) {
            this.setNowBFnable(i);
        }
        this.getModel().endInit();
    }

    private void setNowBFnable(int index) {
        String bfflag = (String)this.getModel().getValue("bfflag", index);
        boolean bfclose = (Boolean)this.getModel().getValue("bfclose", index);
        boolean isbackflush = (Boolean)this.getModel().getValue("isbackflush", index);
        boolean autobackflush = (Boolean)this.getModel().getValue("autobackflush");
        if ("C".equals(bfflag) || bfclose) {
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"nowbfqty", "qtyunit2nd"});
        } else if (!autobackflush && isbackflush) {
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"nowbfqty", "qtyunit2nd"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"nowbfqty"});
            if (this.getModel().getValue("unit2nd", index) != null) {
                this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"qtyunit2nd"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"qtyunit2nd"});
            }
        }
    }

    private List<QFilter> getBillFilter() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter filter = new QFilter("org", "=", org.getPkValue());
        filter.and(new QFilter("treeentryentity.planstatus", "=", (Object)"C"));
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        filters.add(filter);
        QFilter bizFilter = new QFilter("treeentryentity.bizstatus", "=", (Object)"C");
        bizFilter.or(new QFilter("treeentryentity.bizstatus", "=", (Object)"A"));
        filters.add(bizFilter);
        return filters;
    }

    private QFilter getBFQFilter(String sourcebill) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String orderbillno = (String)this.getModel().getValue("orderbillno");
        String sourceBillnoMain = (String)this.getModel().getValue("sourcebillnomain");
        List<String> orderbillnos = this.getBillnoList(orderbillno);
        List<String> sourceBillnoMains = this.getBillnoList(sourceBillnoMain);
        DynamicObject productidmain = (DynamicObject)this.getModel().getValue("productidmain");
        Date startdate = (Date)this.getModel().getValue("biztimemain_startdate");
        Date enddate = (Date)this.getModel().getValue("biztimemain_enddate");
        String proOrgName = "";
        String orderName = "";
        String biztimeName = "biztime";
        if ("A".equals(sourcebill) || "G".equals(sourcebill)) {
            proOrgName = "productionorg";
            orderName = "billentry.mainbillnumber";
        } else if ("B".equals(sourcebill) || "C".equals(sourcebill) || "H".equals(sourcebill) || "I".equals(sourcebill)) {
            proOrgName = "org";
            orderName = "sumentry.manufacturenun";
            biztimeName = "reportdate";
        } else if ("D".equals(sourcebill)) {
            proOrgName = "org";
            orderName = "outentryentity.manufacturenun";
            biztimeName = "bizdate";
        } else if ("F".equals(sourcebill)) {
            proOrgName = "org";
            orderName = "mftentryseq.headbillno";
            biztimeName = "createtime";
        }
        QFilter filter = new QFilter(proOrgName, "=", org.getPkValue());
        if ("A".equals(sourcebill)) {
            filter.and(new QFilter("biztype.number", "=", (Object)"330"));
            filter.and(new QFilter("ischargeoffed", "=", (Object)Boolean.FALSE));
            filter.and(new QFilter("ischargeoff", "=", (Object)Boolean.FALSE));
            filter.and(new QFilter("isvirtualbill", "=", (Object)Boolean.FALSE));
        } else if ("B".equals(sourcebill) || "C".equals(sourcebill) || "H".equals(sourcebill) || "I".equals(sourcebill)) {
            filter.and(new QFilter("sumentry.ischargeoffed", "=", (Object)Boolean.FALSE));
            filter.and(new QFilter("ischargeoff", "=", (Object)Boolean.FALSE));
        } else if ("D".equals(sourcebill)) {
            filter.and(new QFilter("outentryentity.biztype", "=", (Object)"1"));
            HashSet<String> ferType = new HashSet<String>(6);
            ferType.add("31");
            ferType.add("33");
            ferType.add("32");
            ferType.add("21");
            ferType.add("22");
            ferType.add("23");
            filter.and(new QFilter("outentryentity.transfertype", "in", ferType));
        } else if ("F".equals(sourcebill)) {
            filter.and(new QFilter("oprentryentity.oprstatus", "in", (Object)new String[]{"E", "F", "G"}));
        } else if ("G".equals(sourcebill)) {
            filter.and(new QFilter("biztype.number", "=", (Object)"3301"));
            filter.and(new QFilter("ischargeoffed", "=", (Object)Boolean.FALSE));
            filter.and(new QFilter("ischargeoff", "=", (Object)Boolean.FALSE));
            filter.and(new QFilter("isvirtualbill", "=", (Object)Boolean.FALSE));
        }
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        if (!orderbillnos.isEmpty()) {
            filter.and(new QFilter(orderName, "in", orderbillnos));
        }
        if (!sourceBillnoMains.isEmpty()) {
            filter.and(new QFilter("billno", "in", sourceBillnoMains));
        }
        if (startdate != null && enddate != null) {
            filter.and(new QFilter(biztimeName, "<", (Object)this.addTime(enddate, 1)));
            filter.and(new QFilter(biztimeName, ">=", (Object)startdate));
        }
        if (productidmain != null) {
            if ("A".equals(sourcebill)) {
                filter.and(new QFilter("billentry.materialmasterid", "=", productidmain.getPkValue()));
            } else if ("B".equals(sourcebill) || "C".equals(sourcebill) || "H".equals(sourcebill) || "I".equals(sourcebill)) {
                filter.and(new QFilter("sumentry.materielmasterid", "=", productidmain.getPkValue()));
            } else if ("D".equals(sourcebill)) {
                filter.and(new QFilter("outentryentity.outprocessplan.material", "=", productidmain.getPkValue()));
            } else if ("F".equals(sourcebill)) {
                filter.and(new QFilter("material", "=", productidmain.getPkValue()));
            }
        }
        PluginProxy extPlugin = PluginProxy.create(null, IBackFlushFormProvideQueryMapper.class, (String)"POM_BACKFLUSHFORM_PROVIDEQUERYMAPPER_EXT", null);
        extPlugin.callReplace(p -> {
            p.provideQueryQFilter(this.getModel(), filter, sourcebill);
            return null;
        });
        return filter;
    }

    private List<String> getBillnoList(String orderbillno) {
        String[] splits = orderbillno.split(";");
        ArrayList<String> orderbillnos = new ArrayList<String>(splits.length);
        for (String split : splits) {
            if ("".equals(split)) continue;
            orderbillnos.add(split);
        }
        return orderbillnos;
    }

    private Date addTime(Date enddate, int i) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(enddate);
        ((Calendar)calendar).add(5, i);
        return calendar.getTime();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control con = (Control)evt.getSource();
        String source = con.getKey();
        if ("producedept".equals(source)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            Long orgId = 0L;
            if (org != null) {
                orgId = (Long)org.getPkValue();
            }
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_workshopsetup", (Long)orgId);
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObjectCollection col = QueryServiceHelper.query((String)"mpdm_workshopsetup", (String)"workshoporg", (QFilter[])new QFilter[]{qFilter});
            if (!col.isEmpty()) {
                HashSet<Long> idSet = new HashSet<Long>(col.size());
                for (int i = 0; i < col.size(); ++i) {
                    DynamicObject obj = (DynamicObject)col.get(i);
                    idSet.add(Long.valueOf(obj.getString("workshoporg")));
                }
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", idSet));
            } else {
                List toOrg = OrgUnitServiceHelper.getAllToOrg((String)"15", (String)"01", (Long)orgId);
                if (!toOrg.isEmpty()) {
                    listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)toOrg));
                }
            }
            listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            listShowParameter.setMultiSelect(false);
        } else if ("tracknumber".equals(source)) {
            QFilter qFilter = new QFilter("trackstatus", "=", (Object)"0");
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            listShowParameter.setMultiSelect(false);
            listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String key = arg0.getFieldName();
        String entityKey = this.getModel().getDataEntityType().getName();
        if ("orderno".equals(key) || "sourcebillno".equals(key)) {
            String entity = "";
            String sourcebillType = (String)this.getModel().getValue("sourcebillentry", arg0.getRowIndex());
            String billno = (String)this.getModel().getValue(key, arg0.getRowIndex());
            if ("orderno".equals(key)) {
                entity = "im_mdc_ombackflushform".equals(entityKey) ? "om_mftorder" : ("im_mdc_propbackflushform".equals(entityKey) ? "prop_mftorder" : "pom_mftorder");
            } else if ("sourcebillno".equals(key) && "A".equals(sourcebillType)) {
                entity = "im_mdc_ombackflushform".equals(entityKey) ? "im_mdc_omcmplinbill" : "im_mdc_mftmanuinbill";
            } else if ("sourcebillno".equals(key) && "B".equals(sourcebillType)) {
                entity = "im_mdc_ombackflushform".equals(entityKey) ? "om_processreport" : ("im_mdc_propbackflushform".equals(entityKey) ? "prop_mftorderreport" : "pom_mftorderreport");
            } else if ("sourcebillno".equals(key) && "C".equals(sourcebillType)) {
                entity = "im_mdc_ombackflushform".equals(entityKey) ? "om_processreport" : ("im_mdc_propbackflushform".equals(entityKey) ? "prop_processreportbill" : "sfc_processreportbill");
            } else if ("sourcebillno".equals(key) && "D".equals(sourcebillType) && !"im_mdc_ombackflushform".equals(entityKey)) {
                entity = "sfc_protransferbill";
            } else if ("sourcebillno".equals(key) && "F".equals(sourcebillType) && !"im_mdc_ombackflushform".equals(entityKey)) {
                entity = "sfc_manftech";
            } else if ("sourcebillno".equals(key) && "G".equals(sourcebillType) && !"im_mdc_ombackflushform".equals(entityKey)) {
                entity = "im_mdc_mftreturnbill";
            }
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)entity, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
            if (bills != null && bills.length > 0) {
                BillShowParameter showParameter = ManuFactureTraceUtils.createBillShowParam(entity, bills[0].getPkValue());
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    private void start(String opKey) {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "im_mdc_backflushpro");
        para.put("opKey", opKey);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "progressbarap");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm(showParameter);
    }

    private void setButtonEnable(Boolean lock) {
        Arrays.stream(buttons).forEach(button -> this.getView().setEnable(lock, new String[]{button}));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }
}

