/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.mftouttpl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCalcWriteValueEventArgs;
import kd.bos.entity.botp.plugin.args.AfterCloseRowEventArgs;
import kd.bos.entity.botp.plugin.args.AfterCommitAmountEventArgs;
import kd.bos.entity.botp.plugin.args.AfterExcessCheckEventArgs;
import kd.bos.entity.botp.plugin.args.AfterReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeCloseRowEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeCreateArticulationRowEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeExcessCheckEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeExecWriteBackRuleEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeTrackEventArgs;
import kd.bos.entity.botp.plugin.args.FinishWriteBackEventArgs;
import kd.bos.entity.botp.plugin.args.PreparePropertysEventArgs;
import kd.bos.entity.botp.plugin.args.RollbackSaveEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.common.mdc.utils.OmOrderCalMaterialUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class OmOutBackWrite
extends AbstractWriteBackPlugIn {
    public static final String KEY_TRANSACTIONTYPE = "transactiontype";
    public static final String KEY_TRANSACTPRODUCT = "mpdm_transactout";
    private static final String POM_MFTORDER = "pm_om_purorderbill";
    private static final String srcName = "om_componentlist";

    public LinkSetItemElement getCurrLinkSetItem() {
        return super.getCurrLinkSetItem();
    }

    public String getOpType() {
        return super.getOpType();
    }

    public BillEntityType getTargetSubMainType() {
        return super.getTargetSubMainType();
    }

    public void setContext(BillEntityType targetSubMainType, String opType, LinkSetItemElement linkSetItem) {
        super.setContext(targetSubMainType, opType, linkSetItem);
    }

    public void preparePropertys(PreparePropertysEventArgs e) {
        super.preparePropertys(e);
    }

    public void beforeTrack(BeforeTrackEventArgs e) {
        super.beforeTrack(e);
    }

    public void beforeCreateArticulationRow(BeforeCreateArticulationRowEventArgs e) {
        super.beforeCreateArticulationRow(e);
    }

    public void beforeExecWriteBackRule(BeforeExecWriteBackRuleEventArgs e) {
        super.beforeExecWriteBackRule(e);
    }

    public void afterCalcWriteValue(AfterCalcWriteValueEventArgs e) {
        super.afterCalcWriteValue(e);
    }

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        e.getFieldKeys().add("demandqty");
        e.getFieldKeys().add("extraratioqty");
        e.getFieldKeys().add("actissueqty");
        e.getFieldKeys().add("rejectedqty");
        e.getFieldKeys().add("wipqty");
        e.getFieldKeys().add("feedingqty");
        e.getFieldKeys().add("scrapqty");
        e.getFieldKeys().add("feedingqty");
        e.getFieldKeys().add("useqty");
        e.getFieldKeys().add("cansendqty");
        e.getFieldKeys().add("unissueqty");
        e.getFieldKeys().add("orderno");
        e.getFieldKeys().add("orderentryid");
        e.getFieldKeys().add("orderid");
        e.getFieldKeys().add("fixscrap");
        e.getFieldKeys().add("qtytype");
        e.getFieldKeys().add("isbackflush");
        e.getFieldKeys().add("iskeypart");
        e.getFieldKeys().add("issuemode");
    }

    public void afterReadSourceBill(AfterReadSourceBillEventArgs e) {
        super.afterReadSourceBill(e);
    }

    public void afterCommitAmount(AfterCommitAmountEventArgs e) {
        super.afterCommitAmount(e);
    }

    public void beforeExcessCheck(BeforeExcessCheckEventArgs e) {
        super.beforeExcessCheck(e);
    }

    public void afterExcessCheck(AfterExcessCheckEventArgs e) {
        super.afterExcessCheck(e);
    }

    public void beforeCloseRow(BeforeCloseRowEventArgs e) {
        super.beforeCloseRow(e);
    }

    public void afterCloseRow(AfterCloseRowEventArgs e) {
        super.afterCloseRow(e);
    }

    public void beforeSaveSourceBill(BeforeSaveSourceBillEventArgs e) {
        super.beforeSaveSourceBill(e);
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        if (srcName.equals(srcSubMainType.getName())) {
            if ("save".equalsIgnoreCase(this.getOpType())) {
                return;
            }
            DynamicObject[] srcDataEntities = e.getSrcDataEntities();
            HashMap srcMap = Maps.newHashMap();
            HashSet orderidList = Sets.newHashSetWithExpectedSize((int)srcDataEntities.length);
            HashSet orderEntryidList = Sets.newHashSetWithExpectedSize((int)srcDataEntities.length);
            HashSet transactiontypeList = Sets.newHashSet();
            Set<Object> basunitList = Sets.newHashSet();
            Map<Object, Object> measureunitData = Maps.newHashMap();
            HashMap transactiontypeMap = Maps.newHashMap();
            for (DynamicObject dob : srcDataEntities) {
                String orderid = dob.getString("orderid");
                Object orderentryid = dob.getDynamicObject("orderentryid").getPkValue();
                orderidList.add(orderid);
                orderEntryidList.add(orderentryid);
            }
            if (CollectionUtils.isNotEmpty((Collection)orderidList)) {
                DynamicObject[] loadList;
                basunitList = this.getMaterialUnitData(orderidList);
                if (CollectionUtils.isNotEmpty((Collection)basunitList)) {
                    measureunitData = this.getMeasureunitData(basunitList);
                }
                QFilter[] filters = new QFilter[]{new QFilter("id", "in", orderidList.stream().map(NumberUtils::toLong).collect(Collectors.toList())), new QFilter("billstatus", "=", (Object)"C")};
                for (DynamicObject morder : loadList = BusinessDataServiceHelper.load((String)POM_MFTORDER, (String)this.selectMftOrderColumn(), (QFilter[])filters)) {
                    srcMap.put(morder.getString("billno"), morder);
                    Long transactiontype = morder.getLong(KEY_TRANSACTIONTYPE);
                    if (transactiontype == null) continue;
                    transactiontypeList.add(transactiontype);
                }
                if (CollectionUtils.isNotEmpty((Collection)transactiontypeList)) {
                    DynamicObject[] transList;
                    for (DynamicObject trans : transList = BusinessDataServiceHelper.load((String)KEY_TRANSACTPRODUCT, (String)"isvolcal,controlscope", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)transactiontypeList)})) {
                        transactiontypeMap.put(trans.getPkValue().toString(), trans);
                    }
                }
            }
            OmOrderCalMaterialUtils.calMaterial(measureunitData, transactiontypeMap, orderidList, orderEntryidList, srcMap, false);
        }
        if (srcName.equals(e.getSrcSubMainType().getName())) {
            // empty if block
        }
    }

    public void finishWriteBack(FinishWriteBackEventArgs e) {
        super.finishWriteBack(e);
    }

    public void rollbackSave(RollbackSaveEventArgs e) {
        super.rollbackSave(e);
    }

    private Set<String> getMaterialUnitData(Set<String> orderidList) {
        HashSet<String> unitList = new HashSet<String>();
        StringBuilder msb = new StringBuilder();
        int index = 0;
        for (String materialId : orderidList) {
            if (++index == orderidList.size()) {
                msb.append(materialId);
                continue;
            }
            msb.append(materialId);
            msb.append(",");
        }
        String queryMainSql = "select fid,funitid from t_pm_om_purbillentry where fid in (" + msb + ") ";
        try (DataSet queryMainData = DB.queryDataSet((String)"queryunitData", (DBRoute)new DBRoute("scm"), (String)queryMainSql);){
            for (Row row : queryMainData) {
                String baseunit = row.getString("funitid");
                unitList.add(baseunit);
            }
        }
        return unitList;
    }

    private Map<String, String> getMeasureunitData(Set<String> unitList) {
        HashMap<String, String> map = new HashMap<String, String>();
        int index = 0;
        StringBuilder msb = new StringBuilder();
        for (String unitId : unitList) {
            if (++index == unitList.size()) {
                msb.append(unitId);
                continue;
            }
            msb.append(unitId);
            msb.append(",");
        }
        String queryMainSql = "select fid,fprecision,fprecisiontype from T_bd_Measureunit where  fid in (" + msb + ") ";
        try (DataSet queryMainData = DB.queryDataSet((String)"queryMeasureunitData", (DBRoute)DBRoute.base, (String)queryMainSql);){
            for (Row row : queryMainData) {
                String fid = row.getString("fid");
                String precision = row.getString("fprecision");
                String precisiontype = row.getString("fprecisiontype");
                map.put(fid, precision + "@@" + precisiontype);
            }
        }
        return map;
    }

    private String selectMftOrderColumn() {
        return "billno,transactiontype,billentry.producttype,billentry.qty,billentry.baseqty,billentry.baseunit,billentry.unit,billentry.pickstatus,billentry.pickingpairs";
    }
}

