/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.mftreqbill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.formplugin.mdc.mftreqbill.MdcApplyBillUtils;

public class MdcApplyReplaceBillEditPlugin
extends AbstractBillPlugIn
implements ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"orderno"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate op = (FormOperate)e.getSource();
        if (StringUtils.equals((CharSequence)"delete", (CharSequence)op.getOperateKey())) {
            this.valDelete(e);
        }
        if (StringUtils.equals((CharSequence)"replacedelbtn", (CharSequence)op.getOperateKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
            int[] selectRows = entryGrid.getSelectRows();
            ArrayList<Integer> errReplaceList = new ArrayList<Integer>(selectRows.length);
            ArrayList<Integer> errMuchList = new ArrayList<Integer>(selectRows.length);
            for (int j = 0; j < selectRows.length; ++j) {
                DynamicObject firstDym;
                int i = selectRows[j];
                if (this.getModel().getValue("replaceplan", i) == null) {
                    errReplaceList.add(i + 1);
                    continue;
                }
                if (selectRows.length <= 1 || (firstDym = (DynamicObject)this.getModel().getValue("replaceplan", selectRows[0])) == null) continue;
                DynamicObject currentDym = (DynamicObject)this.getModel().getValue("replaceplan", i);
                if (firstDym.getPkValue().equals(currentDym.getPkValue())) continue;
                errMuchList.clear();
                errMuchList.add(selectRows[0]);
                errMuchList.add(i);
            }
            if (!errReplaceList.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e0d\u5b58\u5728\u7ec4\u4ef6\u66ff\u4ee3\u5173\u7cfb\u3002", (String)"MdcApplyReplaceBillEditPlugin_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), ((Object)errReplaceList).toString()));
                e.cancel = true;
                return;
            }
            if (!errMuchList.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7ec4\u4ef6\u66ff\u4ee3\u5173\u7cfb\u4e0d\u4e00\u81f4\u3002", (String)"MdcApplyReplaceBillEditPlugin_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), ((Object)errMuchList).toString()));
                e.cancel = true;
                return;
            }
            if (selectRows.length > 0) {
                DynamicObject firstDym = (DynamicObject)this.getModel().getValue("replaceplan", selectRows[0]);
                int[] replaceRows = this.getSameReplaceRows(firstDym);
                this.clearReplaceInfo(firstDym);
                this.getModel().deleteEntryRows("billentry", replaceRows);
                e.cancel = true;
                return;
            }
        }
    }

    private void valDelete(BeforeDoOperationEventArgs e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList<Integer> errReplaceList = new ArrayList<Integer>(selectRows.length);
        for (int j = 0; j < selectRows.length; ++j) {
            int i = selectRows[j];
            if (this.getModel().getValue("replaceplan", i) == null) continue;
            errReplaceList.add(i + 1);
        }
        if (!errReplaceList.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5b58\u5728\u7ec4\u4ef6\u66ff\u4ee3\u5173\u7cfb\u3002", (String)"MdcApplyReplaceBillEditPlugin_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), ((Object)errReplaceList).toString()));
            e.cancel = true;
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        if (StringUtils.equals((CharSequence)"replacesetbtn", (CharSequence)e.getOperateKey())) {
            this.showReplaceList();
        }
    }

    private int[] getSameReplaceRows(DynamicObject firstDym) {
        ArrayList<String> errExistList = new ArrayList<String>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            if (replacePlan == null || !replacePlan.getPkValue().equals(firstDym.getPkValue()) || "0".equals(entry.getString("pid"))) continue;
            errExistList.add(Integer.toString(i));
        }
        int[] replaceRows = new int[errExistList.size()];
        for (int i = 0; i < errExistList.size(); ++i) {
            replaceRows[i] = Integer.parseInt((String)errExistList.get(i));
        }
        return replaceRows;
    }

    private void clearReplaceInfo(DynamicObject firstDym) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            if (replacePlan == null || !replacePlan.getPkValue().equals(firstDym.getPkValue()) || !"0".equals(entry.getString("pid"))) continue;
            this.getModel().setValue("priority", (Object)0, i);
            this.getModel().setValue("ismainreplace", (Object)false, i);
            this.getModel().setValue("replaceplan", null, i);
        }
    }

    private void showReplaceList() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        if (entryGrid.getSelectRows().length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5206\u5f55\u3002", (String)"MdcApplyReplaceBillEditPlugin_3", (String)"scmc-mm-mdc", (Object[])new Object[0]));
        } else if (entryGrid.getSelectRows().length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u66ff\u4ee3\uff0c\u8bf7\u9009\u62e9\u4e00\u884c\u5206\u5f55\u3002", (String)"MdcApplyReplaceBillEditPlugin_4", (String)"scmc-mm-mdc", (Object[])new Object[0]));
        } else {
            int selectSize = entryGrid.getSelectRows().length;
            ArrayList<String> infoList = new ArrayList<String>(selectSize);
            int seq = entryGrid.getSelectRows()[0] + 1;
            DynamicObject entry = this.getModel().getEntryRowEntity("billentry", entryGrid.getSelectRows()[0]);
            final DynamicObject material = entry.getDynamicObject("material");
            if (material == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7ec4\u4ef6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MdcApplyReplaceBillEditPlugin_5", (String)"scmc-mm-mdc", (Object[])new Object[0]), seq));
                return;
            }
            if (entry.getDynamicObject("replaceplan") != null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5df2\u7ecf\u505a\u8fc7\u7ec4\u4ef6\u66ff\u4ee3\u3002", (String)"MdcApplyReplaceBillEditPlugin_6", (String)"scmc-mm-mdc", (Object[])new Object[0]), seq));
                return;
            }
            DynamicObject[] loadSingles = null;
            DynamicObject mtfOrg = (DynamicObject)this.getModel().getValue("org");
            if (mtfOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"MdcApplyReplaceBillEditPlugin_7", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            } else {
                Long materialIdFind = (Long)material.getPkValue();
                this.getMaterialBizInfo(mtfOrg, new HashSet<Long>(1){
                    {
                        super(x0);
                        this.add((Long)material.getDynamicObject("masterid").getPkValue());
                    }
                }, "bd_materialmftinfo");
                String stockCompareString = this.getStockCompareString(entry);
                infoList.add(stockCompareString);
                QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_replaceplan", (Long)((Long)mtfOrg.getPkValue()));
                orgFilter.and(MdcApplyBillUtils.getBaseSatusQFilter());
                orgFilter.and(new QFilter("mainmaterentry.material", "=", (Object)materialIdFind));
                loadSingles = BusinessDataServiceHelper.load((String)"mpdm_replaceplan", (String)"mainmaterentry,mainmaterentry.material,mainmaterentry.bomversion,mainmaterentry.mole,mainmaterentry.deno,mainmaterentry.auxpty,mainmaterentry.unit", (QFilter[])new QFilter[]{orgFilter});
            }
            if (loadSingles != null) {
                List<Long> ids = this.getReplaceId(infoList, loadSingles);
                ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"mpdm_replaceplan", (boolean)false);
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(new QFilter("id", "in", ids));
                showParameter.getListFilterParameter().setQFilters(filters);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "replacesetbtn");
                showParameter.setCloseCallBack(closeCallBack);
                showParameter.setCustomParam("showFrequent", (Object)true);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    private void getMaterialBizInfo(DynamicObject mtfOrg, HashSet hashSet, String name) {
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)name, (Long)((Long)mtfOrg.getPkValue()));
        orgFilter.and(MdcApplyBillUtils.getBaseSatusQFilter());
        orgFilter.and("masterid", "in", (Object)hashSet);
    }

    private String getStockCompareString(DynamicObject entry) {
        StringBuilder info = new StringBuilder();
        String materialId = entry.getDynamicObject("material").getPkValue().toString();
        String auxPropertyId = "0";
        DynamicObject auxProperty = entry.getDynamicObject("auxpty");
        if (auxProperty != null) {
            auxPropertyId = auxProperty.getPkValue().toString();
        }
        info.append(materialId);
        info.append(auxPropertyId);
        return info.toString();
    }

    private List<Long> getReplaceId(List<String> infoList, DynamicObject[] loadSingles) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (DynamicObject loadSingle : loadSingles) {
            DynamicObjectCollection dymCol = loadSingle.getDynamicObjectCollection("mainmaterentry");
            ArrayList<String> replaceInfoList = new ArrayList<String>();
            for (DynamicObject dym : dymCol) {
                String replaceCompareString = this.getReplaceCompareString(dym);
                replaceInfoList.add(replaceCompareString);
            }
            if (!MdcApplyReplaceBillEditPlugin.isListEqual(infoList, replaceInfoList)) continue;
            ids.add((Long)loadSingle.getPkValue());
        }
        return ids;
    }

    private String getReplaceCompareString(DynamicObject dym) {
        StringBuilder info = new StringBuilder();
        String materialId = dym.getDynamicObject("material").getPkValue().toString();
        String auxPropertyId = "0";
        info.append(materialId);
        info.append(auxPropertyId);
        return info.toString();
    }

    public static boolean isListEqual(List<String> list1, List<String> list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        return list1.containsAll(list2);
    }
}

