/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.mftreqbill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.formplugin.mdc.mftreqbill.MdcApplyBillUtils;

public class MdcApplyReplaceEditPlugin
extends AbstractBillPlugIn
implements ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"orderno"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("replacelog".equals(actionId) && e.getReturnData() != null) {
            this.setReplacceInfo(e);
        }
        if ("reqreplace".equals(actionId) || "replacelog".equals(actionId)) {
            this.setReplacceEnable();
        }
    }

    private void setReplacceInfo(ClosedCallBackEvent e) {
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        HashSet<Object> subEntryIdSet = new HashSet<Object>(16);
        Object pk = rows.get(0).getPrimaryKeyValue();
        for (ListSelectedRow row : rows) {
            if (!pk.equals(row.getPrimaryKeyValue())) continue;
            subEntryIdSet.add(row.getSubEntryPrimaryKeyValue());
        }
        DynamicObject reqLog = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"im_mdc_replacelog");
        if (reqLog != null) {
            DynamicObjectCollection billentrys = reqLog.getDynamicObjectCollection("billentry");
            for (DynamicObject billentry : billentrys) {
                DynamicObjectCollection subbillentrys = billentry.getDynamicObjectCollection("subbillentry");
                if (subbillentrys == null) continue;
                this.insertReplaceDym(subEntryIdSet, subbillentrys, billentry.getDynamicObject("materielmasterid"), billentry);
            }
        }
    }

    private void insertReplaceDym(Set<Object> subEntryIdSet, DynamicObjectCollection subbillentrys, DynamicObject materielmasterid, DynamicObject billentry2) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String replacegroup = MdcApplyBillUtils.getRandomStr();
        int mainIndex = this.getMainIndexAndSetValue(materielmasterid, replacegroup);
        model.setValue("qty", billentry2.get("qty"), mainIndex);
        model.setValue("auditqty", billentry2.get("qty"), mainIndex);
        model.setValue("baseqty", billentry2.get("baseqty"), mainIndex);
        model.setValue("auditbaseqty", billentry2.get("baseqty"), mainIndex);
        model.beginInit();
        for (int i = subbillentrys.size() - 1; i >= 0; --i) {
            DynamicObject billentry = (DynamicObject)subbillentrys.get(i);
            DynamicObject material = billentry.getDynamicObject("materialc");
            if (material == null || !subEntryIdSet.contains(billentry.getPkValue())) continue;
            DynamicObject masterid = material.getDynamicObject("masterid");
            int insertEntryRow = model.insertEntryRow("billentry", mainIndex + 1);
            model.setValue("unit", billentry.get("unitc"), insertEntryRow);
            model.setValue("baseunit", masterid.get("baseunit"), insertEntryRow);
            model.setValue("qty", billentry.get("qtyc"), insertEntryRow);
            model.setValue("auditqty", billentry.get("qtyc"), insertEntryRow);
            model.setValue("baseqty", billentry.get("baseqtyc"), insertEntryRow);
            model.setValue("auditbaseqty", billentry.get("baseqtyc"), insertEntryRow);
            MdcApplyBillUtils.setValueByStr(model, insertEntryRow, mainIndex);
            model.setValue("material", (Object)material, insertEntryRow);
            model.setValue("materielmasterid", (Object)masterid, insertEntryRow);
            model.setValue("materialname", (Object)masterid.getString("name"), insertEntryRow);
            model.setValue("lengthunit", masterid.get("lengthunit"), insertEntryRow);
            model.setValue("length", masterid.get("length"), insertEntryRow);
            model.setValue("width", masterid.get("width"), insertEntryRow);
            model.setValue("height", masterid.get("height"), insertEntryRow);
            model.setValue("unit2nd", masterid.get("auxptyunit"), insertEntryRow);
            model.setValue("isreplace", (Object)true, insertEntryRow);
            model.setValue("replacegroup", (Object)replacegroup, insertEntryRow);
            model.setValue("ismainreplace", billentry.get("ismainreplacec"), insertEntryRow);
            model.setValue("priority", billentry.get("priorityc"), insertEntryRow);
        }
        model.endInit();
        this.getView().updateView("billentry");
    }

    private int getMainIndexAndSetValue(DynamicObject materielmasterid, String replacegroup) {
        int[] selectRows;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        for (int i : selectRows = entryGrid.getSelectRows()) {
            this.getModel().setValue("replacegroup", (Object)replacegroup, i);
            DynamicObject value = (DynamicObject)this.getModel().getValue("materielmasterid", i);
            if (value == null || materielmasterid == null || !value.getPkValue().equals(materielmasterid.getPkValue())) continue;
            this.getModel().setValue("ismainreplace", (Object)true, i);
            return i;
        }
        return selectRows[0];
    }

    private void setReplacceEnable() {
        DynamicObjectCollection billentrys = this.getModel().getEntryEntity("billentry");
        int i = 0;
        for (DynamicObject billentry : billentrys) {
            if (!billentry.getBoolean("isreplace") && !"".equals(billentry.getString("replacegroup"))) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"material"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"material"});
            }
            if (!"".equals(billentry.getString("replacegroup"))) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"orderno"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"orderno"});
            }
            ++i;
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String status = (String)this.getModel().getValue("billstatus");
        if ("A".equals(status)) {
            this.setReplacceEnable();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate op = (FormOperate)e.getSource();
        if (StringUtils.equals((CharSequence)"deleteentry", (CharSequence)op.getOperateKey())) {
            this.valDelete(e);
        }
        if (StringUtils.equals((CharSequence)"replacesetbtn", (CharSequence)op.getOperateKey())) {
            this.valReplace(e);
        }
        if (StringUtils.equals((CharSequence)"replacelorbtn", (CharSequence)op.getOperateKey())) {
            this.valDelete(e);
            this.valReplace(e);
        }
        if (StringUtils.equals((CharSequence)"replacedelbtn", (CharSequence)op.getOperateKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MdcApplyReplaceEditPlugin_5", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            ArrayList<Integer> errReplaceList = new ArrayList<Integer>(selectRows.length);
            ArrayList<Integer> errMuchList = new ArrayList<Integer>(selectRows.length);
            for (int j = 0; j < selectRows.length; ++j) {
                String firstGroup;
                int i = selectRows[j];
                String group = this.getModel().getValue("replacegroup", i).toString();
                if ("".equals(this.getModel().getValue("replacegroup", i).toString())) {
                    errReplaceList.add(i + 1);
                    continue;
                }
                if (selectRows.length <= 1 || (firstGroup = this.getModel().getValue("replacegroup", selectRows[0]).toString()).equals(group)) continue;
                errMuchList.clear();
                errMuchList.add(selectRows[0]);
                errMuchList.add(i);
            }
            if (!errReplaceList.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e0d\u5b58\u5728\u7ec4\u4ef6\u66ff\u4ee3\u3002", (String)"MdcApplyReplaceEditPlugin_6", (String)"scmc-mm-mdc", (Object[])new Object[0]), MdcApplyBillUtils.stripStr(((Object)errReplaceList).toString())));
                e.cancel = true;
                return;
            }
            if (!errMuchList.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7ec4\u4ef6\u66ff\u4ee3\u7ec4\u4e0d\u4e00\u81f4\u3002", (String)"MdcApplyReplaceEditPlugin_7", (String)"scmc-mm-mdc", (Object[])new Object[0]), MdcApplyBillUtils.stripStr(((Object)errMuchList).toString())));
                e.cancel = true;
                return;
            }
            if (selectRows.length > 0) {
                String firstGroup = this.getModel().getValue("replacegroup", selectRows[0]).toString();
                int[] replaceRows = this.getSameReplaceRows(firstGroup);
                this.clearReplaceInfo(firstGroup);
                this.getModel().deleteEntryRows("billentry", replaceRows);
                return;
            }
        }
    }

    private void valReplace(BeforeDoOperationEventArgs e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        int[] selectRows = entryGrid.getSelectRows();
        StringJoiner errList = new StringJoiner("\uff1b");
        if (selectRows.length == 0) {
            errList.add(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MdcApplyReplaceEditPlugin_5", (String)"scmc-mm-mdc", (Object[])new Object[0]));
        } else {
            ArrayList<Integer> materialList = new ArrayList<Integer>(16);
            ArrayList<Integer> unitList = new ArrayList<Integer>(16);
            ArrayList<Integer> orderList = new ArrayList<Integer>(16);
            ArrayList<Integer> replaceGroupList = new ArrayList<Integer>(16);
            String replaceGroupStr = (String)this.getModel().getValue("replacegroup", selectRows[0]);
            replaceGroupList.add(selectRows[0] + 1);
            for (int j = 0; j < selectRows.length; ++j) {
                int i = selectRows[j];
                if (this.getModel().getValue("material", i) == null) {
                    materialList.add(i + 1);
                }
                if (this.getModel().getValue("unit", i) == null) {
                    unitList.add(i + 1);
                }
                if ("".equals(this.getModel().getValue("orderno", i).toString())) {
                    orderList.add(i + 1);
                }
                if (replaceGroupStr.equals((String)this.getModel().getValue("replacegroup", i)) || replaceGroupList.size() != 1) continue;
                replaceGroupList.add(i + 1);
            }
            if (!materialList.isEmpty()) {
                errList.add(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%s\u884c\u7269\u6599\u7f16\u7801\u3002", (String)"MdcApplyReplaceEditPlugin_8", (String)"scmc-mm-mdc", (Object[])new Object[0]), MdcApplyBillUtils.stripStr(((Object)materialList).toString())));
            }
            if (!unitList.isEmpty()) {
                errList.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (String)"MdcApplyReplaceEditPlugin_9", (String)"scmc-mm-mdc", (Object[])new Object[0]), MdcApplyBillUtils.stripStr(((Object)unitList).toString())));
            }
            if (replaceGroupList.size() > 1) {
                errList.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u548c\u7b2c%2$s\u884c\u66ff\u4ee3\u7ec4\u4e0d\u4e00\u81f4\u3002", (String)"MdcApplyReplaceEditPlugin_14", (String)"scmc-mm-mdc", (Object[])new Object[0]), replaceGroupList.get(0), replaceGroupList.get(1)));
            }
            if (!orderList.isEmpty()) {
                errList.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5de5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MdcApplyReplaceEditPlugin_11", (String)"scmc-mm-mdc", (Object[])new Object[0]), MdcApplyBillUtils.stripStr(((Object)orderList).toString())));
            }
        }
        if (errList.length() != 0) {
            String msg = errList.toString() + "\u3002";
            this.getView().showTipNotification(msg);
            e.setCancel(true);
        }
    }

    private void valDelete(BeforeDoOperationEventArgs e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList<Integer> errReplaceList = new ArrayList<Integer>(selectRows.length);
        for (int j = 0; j < selectRows.length; ++j) {
            int i = selectRows[j];
            if ("".equals((String)this.getModel().getValue("replacegroup", i))) continue;
            errReplaceList.add(i + 1);
        }
        if (!errReplaceList.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5b58\u5728\u7ec4\u4ef6\u66ff\u4ee3\u3002", (String)"MdcApplyReplaceEditPlugin_12", (String)"scmc-mm-mdc", (Object[])new Object[0]), MdcApplyBillUtils.stripStr(((Object)errReplaceList).toString())));
            e.cancel = true;
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        if (StringUtils.equals((CharSequence)"replacesetbtn", (CharSequence)e.getOperateKey())) {
            this.showReplaceList();
        }
        if (StringUtils.equals((CharSequence)"replacedelbtn", (CharSequence)e.getOperateKey())) {
            this.setReplacceEnable();
        }
        if (StringUtils.equals((CharSequence)"replacelorbtn", (CharSequence)e.getOperateKey())) {
            this.showReplaceLorList();
        }
    }

    private void showReplaceLorList() {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"im_mdc_replacelog", (boolean)false);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "replacelog");
        showParameter.setCloseCallBack(closeCallBack);
        ArrayList<QFilter> qfilterList = this.getReplaceLorQFilter();
        showParameter.getListFilterParameter().setQFilters(qfilterList);
        showParameter.setSelectedEntity("subbillentry");
        showParameter.setMultiSelect(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private ArrayList<QFilter> getReplaceLorQFilter() {
        ArrayList<QFilter> qfilterList = new ArrayList<QFilter>(16);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        int[] selectRows = entryGrid.getSelectRows();
        HashSet<Long> masterIdSet = new HashSet<Long>(16);
        for (int i : selectRows) {
            DynamicObject value = (DynamicObject)this.getModel().getValue("materielmasterid", i);
            masterIdSet.add((Long)value.getPkValue());
        }
        QFilter q = new QFilter("billentry.materielmasterid", "in", masterIdSet);
        qfilterList.add(q);
        return qfilterList;
    }

    private int[] getSameReplaceRows(String firstGroup) {
        ArrayList<String> errExistList = new ArrayList<String>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            String group = entry.getString("replacegroup");
            if (!group.equals(firstGroup) || !entry.getBoolean("isreplace")) continue;
            errExistList.add(Integer.toString(i));
        }
        int[] replaceRows = new int[errExistList.size()];
        for (int i = 0; i < errExistList.size(); ++i) {
            replaceRows[i] = Integer.parseInt((String)errExistList.get(i));
        }
        return replaceRows;
    }

    private void clearReplaceInfo(String firstGroup) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            String group = entry.getString("replacegroup");
            if (!group.equals(firstGroup) || entry.getBoolean("isreplace")) continue;
            this.getModel().setValue("priority", (Object)0, i);
            this.getModel().setValue("ismainreplace", (Object)false, i);
            this.getModel().setValue("replacegroup", null, i);
        }
    }

    private void showReplaceList() {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "im_mdc_reqreplace");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "reqreplace");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }
}

