/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.mftreqbill;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class MdcReqBillAuditReplaceLogOp
extends AbstractOperationServicePlugIn {
    private static String[] entryFields = new String[]{"materielmasterid", "material", "unit", "qty", "baseunit", "baseqty", "priority", "ismainreplace"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("billentry");
        keys.add("material");
        keys.add("baseqty");
        keys.add("qty");
        keys.add("auditqty");
        keys.add("rowstatus");
        keys.add("orderno");
        keys.add("project");
        keys.add("customer");
        keys.add("replacegroup");
        keys.add("isreplace");
        for (String entryField : entryFields) {
            keys.add(entryField);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String name = this.billEntityType.getName();
        if (!"im_mdc_mftreqbill".equals(name)) {
            return;
        }
        DynamicObject[] bills = e.getDataEntities();
        DynamicObject org = bills[0].getDynamicObject("org");
        HashSet<String> repGroupSet = new HashSet<String>(16);
        HashSet<Long> reqIdSet = new HashSet<Long>(16);
        HashSet<String> reqIdGroupSet = new HashSet<String>(16);
        HashMap<String, List<DynamicObject>> repDymMap = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject bill : bills) {
            this.setRepInfo(repGroupSet, reqIdSet, reqIdGroupSet, repDymMap, bill);
        }
        if (!repGroupSet.isEmpty()) {
            this.deleteRepLog(repGroupSet, reqIdSet, reqIdGroupSet);
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"im_mdc_replacelog");
            DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)"id");
            Date now = TimeServiceHelper.now();
            ArrayList<DynamicObject> saveRepLog = new ArrayList<DynamicObject>(16);
            for (Map.Entry m : repDymMap.entrySet()) {
                String key = (String)m.getKey();
                List value = (List)m.getValue();
                String[] split = key.split(",");
                Long reqId = Long.parseLong(split[0]);
                String repGroup = split[1];
                DynamicObject replacelog = (DynamicObject)dt.createInstance();
                saveRepLog.add(replacelog);
                replacelog.set("srcbillid", (Object)reqId);
                replacelog.set("replacegroup", (Object)repGroup);
                replacelog.set("creator", (Object)currentUser);
                replacelog.set("createtime", (Object)now);
                replacelog.set("billno", (Object)key);
                replacelog.set("billstatus", (Object)"C");
                replacelog.set("org", (Object)org);
                DynamicObjectCollection entrys = replacelog.getDynamicObjectCollection("billentry");
                ArrayList<DynamicObject> mainDymList = new ArrayList<DynamicObject>(16);
                ArrayList<DynamicObject> subDymList = new ArrayList<DynamicObject>(16);
                this.setDymList(mainDymList, subDymList, value);
                for (DynamicObject mainDym : mainDymList) {
                    DynamicObject addNew = entrys.addNew();
                    replacelog.set("orderno", mainDym.get("orderno"));
                    replacelog.set("project", mainDym.get("project"));
                    replacelog.set("customer", mainDym.get("customer"));
                    for (String field : entryFields) {
                        addNew.set(field, mainDym.get(field));
                    }
                    if (!mainDym.getBoolean("ismainreplace") && mainDymList.size() != 1) continue;
                    DynamicObjectCollection subbillentry = addNew.getDynamicObjectCollection("subbillentry");
                    for (DynamicObject subDym : subDymList) {
                        DynamicObject addNewSub = subbillentry.addNew();
                        for (String field : entryFields) {
                            addNewSub.set(field + "c", subDym.get(field));
                        }
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])saveRepLog.toArray(new DynamicObject[0]));
        }
    }

    private void deleteRepLog(Set<String> repGroupSet, Set<Long> reqIdSet, Set<String> reqIdGroupSet) {
        HashMap<String, Long> repLogMap = new HashMap<String, Long>(16);
        QFilter q = new QFilter("replacegroup", "in", repGroupSet);
        q.and(new QFilter("srcbillid", "in", reqIdSet));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"im_mdc_replacelog", (String)"id,replacegroup,srcbillid", (QFilter[])new QFilter[]{q});
        for (DynamicObject obj : query) {
            String srcbillid = obj.get("srcbillid").toString();
            String replaceGroup = obj.get("replacegroup").toString();
            repLogMap.put(this.getStr(srcbillid, replaceGroup), obj.getLong("id"));
        }
        HashSet repLogIdSet = new HashSet(16);
        for (String reqIdGroup : reqIdGroupSet) {
            if (repLogMap.get(reqIdGroup) == null) continue;
            repLogIdSet.add(repLogMap.get(reqIdGroup));
        }
        if (!repLogIdSet.isEmpty()) {
            DeleteServiceHelper.delete((String)"im_mdc_replacelog", (QFilter[])new QFilter[]{new QFilter("id", "in", repLogIdSet)});
        }
    }

    private void setRepInfo(Set<String> repGroupSet, Set<Long> reqIdSet, Set<String> reqIdGroupSet, Map<String, List<DynamicObject>> repDymMap, DynamicObject bill) {
        Object pkValue = bill.getPkValue();
        reqIdSet.add((Long)pkValue);
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entrys) {
            String repGroup = entry.getString("replacegroup");
            if ("".equals(repGroup)) continue;
            repGroupSet.add(repGroup);
            reqIdGroupSet.add(this.getStr(pkValue.toString(), repGroup));
            List<DynamicObject> list = repDymMap.get(this.getStr(pkValue.toString(), repGroup));
            if (list == null) {
                list = new ArrayList<DynamicObject>(16);
            }
            list.add(entry);
            repDymMap.put(this.getStr(pkValue.toString(), repGroup), list);
        }
    }

    private void setDymList(List<DynamicObject> mainDymList, List<DynamicObject> subDymList, List<DynamicObject> value) {
        for (DynamicObject dym : value) {
            if (dym.getBoolean("isreplace")) {
                subDymList.add(dym);
                continue;
            }
            mainDymList.add(dym);
        }
    }

    private String getStr(String srcbillid, String replaceGroup) {
        return srcbillid + "," + replaceGroup;
    }
}

