/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.mftreqbill;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.formplugin.mdc.mftreqbill.TimeWarehousePojo;

public class WorkcenterWarehouseUtils {
    private static final Log logger = LogFactory.getLog(WorkcenterWarehouseUtils.class);

    private WorkcenterWarehouseUtils() {
    }

    static void updateBillByProject(Set<Long> projectIdSet, DynamicObject[] bills, String opKey) throws ParseException {
        Object value;
        QFilter q = new QFilter("entry_project.projcet", "in", projectIdSet);
        q.and(new QFilter("billstatus", "=", (Object)"C"));
        q.and(new QFilter("pulishstatus", "=", (Object)"1"));
        DynamicObject[] resourceplans = BusinessDataServiceHelper.load((String)"pmpd_resourceplan", (String)"billno,sectionresource,sectionstarttime,sectionendtime,projcet", (QFilter[])new QFilter[]{q});
        logger.info("\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u6761\u6570\uff1a" + resourceplans.length);
        logger.info("\u68c0\u4fee\u4e3b\u8d44\u6e90\u9879\u76ee\u4fe1\u606f\uff1a" + projectIdSet);
        HashMap<Long, List<TimeWarehousePojo>> projectWarehouse = new HashMap<Long, List<TimeWarehousePojo>>(16);
        HashMap<Long, TimeWarehousePojo> workcenterWarehouse = new HashMap<Long, TimeWarehousePojo>(16);
        WorkcenterWarehouseUtils.setWarehouseMapInfo(projectWarehouse, workcenterWarehouse, resourceplans);
        logger.info("\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u4ed3\u5e931\uff1a" + projectWarehouse);
        logger.info("\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u4ed3\u5e932\uff1a" + workcenterWarehouse);
        for (Map.Entry mpojo : projectWarehouse.entrySet()) {
            value = (List)mpojo.getValue();
            if (value == null) continue;
            Iterator iterator = value.iterator();
            while (iterator.hasNext()) {
                TimeWarehousePojo pojo = (TimeWarehousePojo)iterator.next();
                logger.info("\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u9879\u76ee\u4ed3\u5e93\u4fe1\u606f\uff1a" + mpojo.getKey() + "--" + pojo.toString());
            }
        }
        for (Map.Entry mpojo : workcenterWarehouse.entrySet()) {
            value = (TimeWarehousePojo)mpojo.getValue();
            if (value == null) continue;
            logger.info("\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u5de5\u4f5c\u4e2d\u5fc3\u4ed3\u5e93\u4fe1\u606f\uff1a" + mpojo.getKey() + "--" + ((TimeWarehousePojo)value).toString());
        }
        WorkcenterWarehouseUtils.setWarehouseInfo(bills, projectWarehouse, workcenterWarehouse, opKey);
    }

    private static void setWarehouseInfo(DynamicObject[] bills, Map<Long, List<TimeWarehousePojo>> projectWarehouse, Map<Long, TimeWarehousePojo> workcenterWarehouse, String opKey) throws ParseException {
        for (DynamicObject bill : bills) {
            List<TimeWarehousePojo> timeWarehousePojoList;
            DynamicObject headproject = bill.getDynamicObject("headproject");
            DynamicObject professiona = bill.getDynamicObject("professiona");
            if (headproject == null || professiona == null || !professiona.getBoolean("supplywhupdate") || (timeWarehousePojoList = projectWarehouse.get(headproject.getPkValue())) == null) continue;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject billentry : entrys) {
                TimeWarehousePojo po = WorkcenterWarehouseUtils.getTimeWarehousePojo(timeWarehousePojoList, billentry, workcenterWarehouse);
                if (billentry.getBoolean("warehousechange") && !professiona.getBoolean("supplywhmup") || po == null) continue;
                if ("save".equals(opKey)) {
                    billentry.set("warehouse", po.getWarehouse());
                    billentry.set("location", po.getLocation());
                    billentry.set("warehousechange", (Object)false);
                    continue;
                }
                if (!"C".equals(billentry.getString("rowstatus")) || !"A".equals(billentry.getString("wmssstatus")) && !"B".equals(billentry.getString("wmssstatus"))) continue;
                billentry.set("warehouse", po.getWarehouse());
                billentry.set("location", po.getLocation());
                billentry.set("warehousechange", (Object)false);
            }
        }
    }

    private static void setWarehouseMapInfo(Map<Long, List<TimeWarehousePojo>> projectWarehouse, Map<Long, TimeWarehousePojo> workcenterWarehouse, DynamicObject[] resourceplans) {
        DynamicObject[] workcemterDyms;
        for (DynamicObject resourceplan : resourceplans) {
            DynamicObjectCollection projects = resourceplan.getDynamicObjectCollection("entry_project");
            DynamicObjectCollection repairs = resourceplan.getDynamicObjectCollection("entry_repair");
            ArrayList<TimeWarehousePojo> timeWarehousePojoList = new ArrayList<TimeWarehousePojo>(16);
            for (DynamicObject repair : repairs) {
                TimeWarehousePojo pojo = new TimeWarehousePojo();
                DynamicObject sectionresource = repair.getDynamicObject("sectionresource");
                logger.info("\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u4ed3\u5e93\u5de5\u4f5c\u4e2d\u5fc3\uff1a" + sectionresource);
                if (sectionresource != null) {
                    pojo.setBegintime(repair.getDate("sectionstarttime").getTime());
                    pojo.setEndtime(repair.getDate("sectionendtime").getTime());
                    pojo.setWorkcenter((Long)sectionresource.getPkValue());
                    workcenterWarehouse.put((Long)sectionresource.getPkValue(), new TimeWarehousePojo());
                }
                timeWarehousePojoList.add(pojo);
            }
            for (DynamicObject projectEntry : projects) {
                projectWarehouse.put((Long)projectEntry.getDynamicObject("projcet").getPkValue(), timeWarehousePojoList);
            }
        }
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"mpdm_workcenter_info", (String)"masterid,warehouse", (QFilter[])new QFilter[]{new QFilter("id", "in", workcenterWarehouse.keySet())});
        HashMap<Object, DynamicObject> workcenterMap = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject load : loads) {
            workcenterMap.put(load.getDynamicObject("masterid").getPkValue(), null);
        }
        for (DynamicObject workcemterDym : workcemterDyms = BusinessDataServiceHelper.load((String)"mpdm_workcentre", (String)"number,warehouse,location", (QFilter[])new QFilter[]{new QFilter("id", "in", workcenterMap.keySet())})) {
            workcenterMap.put(workcemterDym.getPkValue(), workcemterDym);
        }
        for (DynamicObject load : loads) {
            TimeWarehousePojo timeWarehousePojo = workcenterWarehouse.get((Long)load.getPkValue());
            DynamicObject workcemterDym = (DynamicObject)workcenterMap.get(load.getDynamicObject("masterid").getPkValue());
            if (workcemterDym == null) continue;
            timeWarehousePojo.setWarehouse(workcemterDym.get("warehouse"));
            timeWarehousePojo.setLocation(workcemterDym.get("location"));
        }
    }

    static Set<Long> getProjectIdSet(DynamicObject[] bills) {
        HashSet<Long> projectIdSet = new HashSet<Long>(16);
        for (DynamicObject bill : bills) {
            DynamicObject headproject = bill.getDynamicObject("headproject");
            DynamicObject professiona = bill.getDynamicObject("professiona");
            if (headproject == null || professiona == null || !professiona.getBoolean("supplywhupdate")) continue;
            projectIdSet.add((Long)headproject.getPkValue());
        }
        return projectIdSet;
    }

    private static TimeWarehousePojo getTimeWarehousePojo(List<TimeWarehousePojo> timeWarehousePojoList, DynamicObject billentry, Map<Long, TimeWarehousePojo> workcenterWarehouse) throws ParseException {
        Date deliverdate = billentry.getDate("deliverdate");
        DynamicObject delivercycle = billentry.getDynamicObject("delivercycle");
        if (deliverdate != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String format = simpleDateFormat.format(new Date(deliverdate.getTime()));
            Long parse = simpleDateFormat.parse(format).getTime();
            BigDecimal timeDate = new BigDecimal(parse.toString()).divide(new BigDecimal("1000"));
            if (delivercycle != null) {
                BigDecimal times = new BigDecimal(delivercycle.get("deliverytime").toString());
                timeDate = timeDate.add(times);
            }
            logger.info("\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u4ed3\u5e93\u5de5\u4f5c\u4e2d\u5fc3\u5355\u636e\u65e5\u671f\uff1a" + timeDate);
            for (TimeWarehousePojo timeWarehousePojo : timeWarehousePojoList) {
                if (timeWarehousePojo.getBegintime() == null || timeWarehousePojo.getEndtime() == null) continue;
                BigDecimal begintime = new BigDecimal(timeWarehousePojo.getBegintime().toString()).divide(new BigDecimal("1000"));
                BigDecimal endtime = new BigDecimal(timeWarehousePojo.getEndtime().toString()).divide(new BigDecimal("1000"));
                if (timeDate.compareTo(begintime) < 0 || timeDate.compareTo(endtime) >= 0) continue;
                TimeWarehousePojo timeWarehousePojo2 = workcenterWarehouse.get(timeWarehousePojo.getWorkcenter());
                timeWarehousePojo.setWarehouse(timeWarehousePojo2.getWarehouse());
                timeWarehousePojo.setLocation(timeWarehousePojo2.getLocation());
                return timeWarehousePojo;
            }
        }
        return null;
    }

    public static void updateReqWarehouseInfo(Set<Long> projectIdSet, Long orgId) throws ParseException {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and(new QFilter("headproject", "in", projectIdSet));
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"im_mdc_mftreqbill", (String)"org,orderno,billno,headproject,professiona,deliverdate,warehouse,location,warehousechange,delivercycle,wmssstatus,rowstatus", (QFilter[])new QFilter[]{qFilter});
        if (bills != null && bills.length > 0) {
            WorkcenterWarehouseUtils.updateBillByProject(projectIdSet, bills, "update");
            SaveServiceHelper.save((DynamicObject[])bills);
        }
    }
}

