/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.mftreqoutbill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.UnitEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.common.mdc.enums.BillTypeEnum;
import kd.scmc.im.common.mdc.helper.AccountOrgHelper;
import kd.scmc.im.common.mdc.utils.MeasureUnitUtils;
import kd.scmc.im.formplugin.mdc.mftreqbill.MdcApplyBillUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MftReqOutBillEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener,
ClickListener {
    private static Log logger = LogFactory.getLog(MftReqOutBillEdit.class);
    public static final String KEY_QTY = "qty";
    public static final String KEY_BIZTYPR = "biztype";
    public static final String KEY_WORKSHOP = "workshop";
    public static final String KEY_WORKSHOPID = "workshopid";
    public static final String KEY_MANUBILL = "manubill";
    public static final String KEY_MANUBILLID = "manubillid";
    public static final String KEY_MANUENTRY = "manuentry";
    public static final String KEY_MANUENTRYID = "manuentryid";
    public static final String KEY_OPERATION = "operation";
    public static final String KEY_OPERATIONID = "operationid";
    public static final String KEY_WORKCENTER = "workcenter";
    public static final String KEY_WORKCENTERID = "workcenterid";
    public static final String ENTITYID_WORKSHOPSETUP = "mpdm_workshopsetup";
    public static final String ENTITYID_MANUFACTUREBILL = "pom_mftorder";
    public static final String ENTITYID_WORKPROCEDURE = "mpdm_workprocedure";
    public static final String ENTITYID_WORKCENTRE = "mpdm_workcentre";
    public static final String KEY_WAREHOUSE = "warehouse";
    public static final String KEY_ORG = "org";
    public static final String KEY_BIZORG = "bizorg";
    public static final String KEY_ENTRY = "billentry";
    public static final String KEY_MANUFACTUREBILLENTRY = "treeentryentity";
    private static final String KEY_BOS_ORG = "bos_org";
    public String isinital = "false";

    public void initialize() {
        super.initialize();
        String isinital = this.getPageCache().get("isinital");
    }

    public void registerListener(EventObject e) {
        TextEdit workshop = (TextEdit)this.getView().getControl(KEY_WORKSHOP);
        workshop.addClickListener((ClickListener)this);
        UnitEdit unitEdit = (UnitEdit)this.getView().getControl("unit");
        unitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl(KEY_BIZORG);
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialEdit = (BasedataEdit)this.getView().getControl("material");
        materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{KEY_MANUBILL});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String formId;
        boolean isMftReqOut;
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (StringUtils.equals((CharSequence)KEY_WAREHOUSE, (CharSequence)fieldKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(KEY_ORG);
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"MftReqOutBillEdit_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            Long[] warehouseids = WarehouseHelper.getAllWarehouseIDs((Long)((Long)org.getPkValue()));
            QFilter qfilter = new QFilter("id", "in", (Object)warehouseids);
            showParameter.getListFilterParameter().getQFilters().add(qfilter);
        } else if (StringUtils.equals((CharSequence)KEY_BIZORG, (CharSequence)fieldKey)) {
            DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue(KEY_ORG);
            if (supplyOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"MftReqOutBillEdit_1", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            List idList = OrgUnitServiceHelper.getFromOrgs((String)"05", (Long)((Long)supplyOrg.getPkValue()), (String)"04", (boolean)true);
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)idList));
        } else if (StringUtils.equals((CharSequence)"unit", (CharSequence)fieldKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY);
            if (entryGrid.getSelectRows().length == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u5206\u5f55\u3002", (String)"MftReqOutBillEdit_2", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
            if (null == material) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u3002", (String)"MftReqOutBillEdit_4", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            DynamicObject[] ids = MeasureUnitUtils.getMeasureUnit(material.getLong("id"));
            ArrayList<Long> idList = new ArrayList<Long>();
            if (ids != null && ids.length > 0) {
                for (int i = 0; i < ids.length; ++i) {
                    idList.add(ids[i].getDynamicObject("measureunitid").getLong("id"));
                }
            }
            if (CollectionUtils.isNotEmpty(idList)) {
                List qFilters = showParameter.getListFilterParameter().getQFilters();
                List collect = qFilters.stream().filter(var -> "in".equals(var.getCP()) && "id".equals(var.getProperty())).collect(Collectors.toList());
                qFilters.addAll(collect);
            }
        } else if (StringUtils.equals((CharSequence)"material", (CharSequence)fieldKey) && (isMftReqOut = "im_mdc_mftfeedorder".equals(formId = this.getModel().getDataEntityType().getName()))) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY);
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            boolean isadd = (Boolean)this.getModel().getValue("isadd", rowIndex);
            if (isadd) {
                DynamicObject org = (DynamicObject)this.getModel().getValue(KEY_BIZORG);
                if (null == org) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"MftReqOutBillEdit_5", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                QFilter mftmaterialFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)Long.parseLong(org.getPkValue().toString()));
                ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
                listShowParameter.getListFilterParameter().getQFilters().add(mftmaterialFilter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String str;
        String key = e.getProperty().getName();
        if ("true".equals(this.getPageCache().get("isIgnoreChangeListener"))) {
            return;
        }
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (KEY_WORKSHOP.equals(key)) {
            if ("".equals(newValue) || newValue == null) {
                this.getModel().setValue(KEY_WORKSHOPID, null);
            }
            if (this.getPageCache().get(KEY_MANUBILL) == null) {
                this.getModel().setValue(KEY_WORKSHOPID, null);
            } else {
                String str2 = this.getPageCache().get(KEY_MANUBILL);
                if (!newValue.toString().equals(str2)) {
                    this.getModel().setValue(KEY_WORKSHOP, (Object)str2);
                }
            }
        }
        ChangeData cd = e.getChangeSet()[0];
        int rowIndex = cd.getRowIndex();
        DynamicObject entryDyn = this.getModel().getEntryRowEntity(KEY_ENTRY, rowIndex);
        String entityName = this.getModel().getDataEntityType().getName();
        boolean isFeed = BillTypeEnum.FEED_ORDER.getName().equals(entityName);
        boolean isReturn = BillTypeEnum.RETURN_ORDER.getName().equals(entityName);
        if ((isFeed || isReturn) && KEY_MANUBILL.equals(key)) {
            String orderno = (String)this.getModel().getValue(KEY_MANUBILL, rowIndex);
            if (StringUtils.isBlank((CharSequence)orderno)) {
                this.getModel().setValue(KEY_MANUBILL, null, rowIndex);
                this.getModel().setValue(KEY_MANUBILLID, null, rowIndex);
                this.getModel().setValue(KEY_MANUENTRYID, null, rowIndex);
                this.getModel().setValue("srcbillnumber", null, rowIndex);
                this.getModel().setValue("mainbillnumber", null, rowIndex);
                this.getModel().setValue("mainbillid", null, rowIndex);
                this.getModel().setValue("mainbillentity", null, rowIndex);
                this.getModel().setValue(KEY_MANUENTRY, null, rowIndex);
                String type = (String)this.getModel().getValue("productiondomain");
                if ("E".equals(type)) {
                    this.getModel().setValue("productline", null, rowIndex);
                }
            } else {
                String manuentry = (String)this.getModel().getValue(KEY_MANUENTRY, rowIndex);
                String setOrderInfo = this.setOrderInfo(rowIndex, orderno, manuentry);
                if (!StringUtils.isBlank((CharSequence)setOrderInfo)) {
                    this.getView().showTipNotification(setOrderInfo);
                    this.getModel().setValue(KEY_MANUBILL, null, rowIndex);
                } else {
                    this.setIsRework(entryDyn);
                }
            }
            this.getPageCache().put("isIgnoreChangeListener", "false");
        }
        if (isFeed && KEY_MANUENTRY.equals(key)) {
            String isIgnoreEntrySeqChange = this.getPageCache().get("isIgnoreEntrySeqChange");
            if (!"true".equals(isIgnoreEntrySeqChange)) {
                String manuentry;
                String orderno = (String)this.getModel().getValue(KEY_MANUBILL, rowIndex);
                String setOrderInfo = this.setOrderInfo(rowIndex, orderno, manuentry = (String)this.getModel().getValue(KEY_MANUENTRY, rowIndex));
                if (!StringUtils.isBlank((CharSequence)setOrderInfo)) {
                    this.getView().showTipNotification(setOrderInfo);
                    this.getModel().setValue(KEY_MANUBILL, null, rowIndex);
                } else {
                    this.setIsRework(entryDyn);
                }
            }
            this.getPageCache().put("isIgnoreChangeListener", "false");
        }
        if (KEY_OPERATION.equals(key)) {
            if ("".equals(newValue) || newValue == null) {
                this.getModel().setValue(KEY_OPERATIONID, null, rowIndex);
            }
            if (this.getPageCache().get(KEY_OPERATION) == null) {
                this.getModel().setValue(KEY_OPERATIONID, null, rowIndex);
            } else {
                str = this.getPageCache().get(KEY_OPERATION);
                if (!"".equals(newValue) && !newValue.toString().equals(str)) {
                    this.getModel().setValue(KEY_OPERATION, (Object)str, rowIndex);
                }
            }
        }
        if (KEY_WORKCENTER.equals(key)) {
            if ("".equals(newValue) || newValue == null) {
                this.getModel().setValue(KEY_WORKCENTERID, null, rowIndex);
            }
            if (this.getPageCache().get(KEY_WORKCENTER) == null) {
                this.getModel().setValue(KEY_WORKCENTERID, null, rowIndex);
            } else {
                str = this.getPageCache().get(KEY_WORKCENTER);
                if (!"".equals(newValue) && !newValue.toString().equals(str)) {
                    this.getModel().setValue(KEY_WORKCENTER, (Object)str, rowIndex);
                }
            }
        }
        if ("material".equals(key)) {
            this.setIsRework(entryDyn);
        }
        if ("outinvtype".equals(key)) {
            Object outinvType = this.getModel().getValue("outinvtype", rowIndex);
            Long outinvTypeId = MftReqOutBillEdit.getDyObjId(outinvType);
            DynamicObject invScheme = (DynamicObject)this.getModel().getValue("invscheme");
            if (invScheme != null) {
                DynamicObjectCollection outInvTypeEntry = invScheme.getDynamicObjectCollection("outinvtypeentry");
                for (DynamicObject dyn : outInvTypeEntry) {
                    Object outinvtype = dyn.get("outinvtype");
                    Long dyObjId = MftReqOutBillEdit.getDyObjId(outinvtype);
                    String outOwnerType = dyn.getString("outownertype1");
                    String outKeeperType = dyn.getString("outkeepertype1");
                    if (dyObjId == null || !dyObjId.equals(outinvTypeId) || "".equals(outOwnerType) || "".equals(outKeeperType)) continue;
                    this.getModel().setValue("outownertype", (Object)outOwnerType, rowIndex);
                    this.getModel().setValue("outkeepertype", (Object)outKeeperType, rowIndex);
                }
            }
        }
    }

    public static Long getDyObjId(Object dyObj) {
        if (dyObj == null) {
            return null;
        }
        if (dyObj instanceof DynamicObject) {
            return ((DynamicObject)dyObj).getLong("id");
        }
        if (dyObj instanceof Long) {
            return (Long)dyObj;
        }
        return null;
    }

    private String setOrderInfo(int rowIndex, String orderno, String manuentryStr) {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)orderno)) {
            QFilter filter = new QFilter("billno", "=", (Object)orderno);
            String seqInfo = ResManager.loadKDString((String)"\u5206\u5f55", (String)"MftReqOutBillEdit_10", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)manuentryStr)) {
                int manuentry = Integer.parseInt(manuentryStr);
                filter.and(new QFilter("treeentryentity.seq", "=", (Object)manuentry));
                seqInfo = String.format(ResManager.loadKDString((String)"\u7b2c%1$s", (String)"MftReqOutBillEdit_13", (String)"scmc-mm-mdc", (Object[])new Object[0]), manuentryStr);
            }
            filter.and(new QFilter("billstatus", "=", (Object)"C"));
            filter.and(new QFilter("transactiontype.isoffreqallowed", "=", (Object)true));
            filter.and(new QFilter("treeentryentity.planstatus", "in", (Object)new Object[]{"C"}));
            filter.and(new QFilter("treeentryentity.bizstatus", "=", (Object)"A"));
            filter.and(new QFilter("treeentryentity.producttype", "=", (Object)"C"));
            DynamicObject org = (DynamicObject)this.getModel().getValue(KEY_BIZORG);
            QFilter orgFilter = org != null ? new QFilter(KEY_ORG, "=", org.getPkValue()) : new QFilter(KEY_ORG, "=", (Object)0L);
            filter.and(orgFilter);
            String mftOrderName = ENTITYID_MANUFACTUREBILL;
            String mftStockName = "pom_mftstock";
            String selectProperties = "billno,treeentryentity.seq,treeentryentity.id,treeentryentity.producttype,treeentryentity.tracknumber,treeentryentity.bdproject";
            boolean isExistDomain = this.getModel().getDataEntity().containsProperty("productiondomain");
            if (isExistDomain && "E".equals(this.getModel().getValue("productiondomain"))) {
                mftOrderName = "prop_mftorder";
                mftStockName = "prop_mftstock";
                selectProperties = selectProperties + ",treeentryentity.productline";
            }
            DynamicObject orderBill = BusinessDataServiceHelper.loadSingle((String)mftOrderName, (String)selectProperties, (QFilter[])filter.toArray());
            DynamicObject orderEntry = null;
            if (null != orderBill) {
                DynamicObjectCollection orderEntrys = orderBill.getDynamicObjectCollection(KEY_MANUFACTUREBILLENTRY);
                for (DynamicObject temp : orderEntrys) {
                    long seq = temp.getInt("seq");
                    String producttype = temp.getString("producttype");
                    if ((!StringUtils.isBlank((CharSequence)manuentryStr) || !StringUtils.equals((CharSequence)"C", (CharSequence)producttype)) && (!StringUtils.isNotBlank((CharSequence)manuentryStr) || (long)Integer.parseInt(manuentryStr) != seq)) continue;
                    orderEntry = temp;
                    break;
                }
            }
            if (null != orderEntry) {
                long orderentryid = orderEntry.getLong("id");
                QFilter qf = new QFilter("orderentryid.id", "=", (Object)orderentryid);
                DynamicObject stockObj = BusinessDataServiceHelper.loadSingle((String)mftStockName, (String)"billno,billstatus,stockentry,stockentry.id", (QFilter[])qf.toArray());
                if (stockObj != null) {
                    if (!"C".equals(stockObj.getString("billstatus"))) {
                        result = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355%s\u672a\u5ba1\u6838\u3002", (String)"MftReqOutBillEdit_15", (String)"scmc-mm-mdc", (Object[])new Object[0]), stockObj.getString("billno"));
                    } else {
                        this.getModel().setValue(KEY_MANUBILL, (Object)orderBill.getString("billno"), rowIndex);
                        this.getModel().setValue(KEY_MANUBILLID, orderBill.getPkValue(), rowIndex);
                        this.getModel().setValue(KEY_MANUENTRYID, orderEntry.getPkValue(), rowIndex);
                        this.getModel().setValue("srcbillnumber", (Object)stockObj.getString("billno"), rowIndex);
                        this.getModel().setValue("mainbillnumber", (Object)stockObj.getString("billno"), rowIndex);
                        this.getModel().setValue("mainbillid", (Object)stockObj.getString("id"), rowIndex);
                        this.getModel().setValue("mainbillentity", (Object)mftStockName, rowIndex);
                        this.getModel().setValue(KEY_MANUENTRY, orderEntry.get("seq"), rowIndex);
                        this.getModel().setValue("tracknumber", orderEntry.get("tracknumber"), rowIndex);
                        this.getModel().setValue("project", orderEntry.get("bdproject"), rowIndex);
                        if (isExistDomain && "E".equals(this.getModel().getValue("productiondomain"))) {
                            this.getModel().setValue("productline", orderEntry.get("productline"), rowIndex);
                        }
                    }
                } else {
                    result = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355%1$s\u7b2c%2$s\u884c\u65e0\u5bf9\u5e94\u7ec4\u4ef6\u6e05\u5355\u3002", (String)"MftReqOutBillEdit_7", (String)"scmc-mm-mdc", (Object[])new Object[0]), orderno, orderEntry.getInt("seq"));
                }
            } else {
                result = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u201c%1$s\u201d%2$s\u884c\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff08\u751f\u4ea7\u5de5\u5355\u5355\u636e\u5df2\u5ba1\u6838\uff0c\u5206\u5f55\u4ea7\u54c1\u7c7b\u578b\u4e3a\u4e3b\u4ea7\u54c1\uff0c\u8ba1\u5212\u72b6\u6001\u5df2\u4e0b\u8fbe\uff0c\u4e1a\u52a1\u72b6\u6001\u6b63\u5e38\uff0c\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b.\u5141\u8bb8\u7ec4\u4ef6\u6e05\u5355\u5916\u9886\u9000\u6599=\u662f\uff09\u6216\u8005\u65e0\u5206\u5f55\u6570\u636e\u3002", (String)"MftReqOutBillEdit_12", (String)"scmc-mm-mdc", (Object[])new Object[0]), orderno, seqInfo);
            }
        }
        return result;
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        if (key.equals(KEY_WORKSHOP)) {
            DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue(KEY_BIZORG);
            if (supplyOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"MftReqOutBillEdit_3", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ArrayList<QFilter> qfList = new ArrayList<QFilter>();
            QFilter auditFilter = new QFilter("status", "=", (Object)"C");
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter orgFilter = new QFilter("createorg", "=", supplyOrg.get("id")).or("ctrlstrategy", "=", (Object)"5");
            qfList.add(auditFilter);
            qfList.add(enableFilter);
            qfList.add(orgFilter);
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)ENTITYID_WORKSHOPSETUP, (boolean)false);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_WORKSHOP);
            showParameter.setCloseCallBack(closeCallBack);
            showParameter.getListFilterParameter().setQFilters(qfList);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObject obj;
        EntryGrid entryGrid;
        ListSelectedRowCollection rows;
        super.closedCallBack(closedCallBackEvent);
        if (KEY_WORKSHOP.equals(closedCallBackEvent.getActionId()) && (rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && !rows.isEmpty()) {
            Object pkValue = rows.get(0).getPrimaryKeyValue();
            DynamicObject obj2 = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)ENTITYID_WORKSHOPSETUP);
            if (obj2 == null) {
                return;
            }
            this.getPageCache().put(KEY_WORKSHOP, obj2.getString("workshoporg.name"));
            this.getModel().setValue(KEY_WORKSHOP, (Object)obj2.getString("workshoporg.name"));
            this.getModel().setValue(KEY_WORKSHOPID, obj2.getPkValue());
        }
        if (KEY_MANUBILL.equals(closedCallBackEvent.getActionId()) && (rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && !rows.isEmpty()) {
            StringBuilder errMessage = new StringBuilder();
            EntryGrid entryGrid2 = (EntryGrid)this.getView().getControl(KEY_ENTRY);
            if (entryGrid2.getSelectRows().length == 0) {
                return;
            }
            int rowIndex = entryGrid2.getSelectRows()[0];
            DynamicObjectCollection billentry = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ENTRY);
            ArrayList pkValues = new ArrayList();
            rows.forEach(t -> pkValues.add(t.getEntryPrimaryKeyValue()));
            String type = (String)this.getModel().getValue("productiondomain");
            String orderEntity = ENTITYID_MANUFACTUREBILL;
            String stockEntity = "pom_mftstock";
            String stockFiled = "billno as stockbillno,billstatus,id as stockid,orderentryid.id";
            if ("E".equals(type)) {
                orderEntity = "prop_mftorder";
                stockEntity = "prop_mftstock";
                stockFiled = stockFiled + ",productline.id";
            }
            try (DataSet order = QueryServiceHelper.queryDataSet((String)"query_mftorder", (String)orderEntity, (String)"id,billno,treeentryentity.seq as seq,treeentryentity.id as entryid", (QFilter[])new QFilter[]{new QFilter("treeentryentity.id", "in", pkValues)}, (String)"");
                 DataSet stock = QueryServiceHelper.queryDataSet((String)"query_mftstock", (String)stockEntity, (String)stockFiled, (QFilter[])new QFilter[]{new QFilter("orderentryid.id", "in", pkValues)}, (String)"");){
                DataSet res = !"E".equals(type) ? order.join(stock).select(new String[]{"id", "seq", "billno", "stockid", "billstatus", "stockbillno", "entryid"}).on("entryid", "orderentryid.id").finish() : order.join(stock).select(new String[]{"id", "seq", "billno", "stockid", "billstatus", "stockbillno", "entryid", "productline.id"}).on("entryid", "orderentryid.id").finish();
                boolean flag = true;
                this.getView().invokeOperation("newentry");
                DynamicObject tempt = (DynamicObject)billentry.get(billentry.size() - 1);
                billentry.remove((Object)tempt);
                DynamicObject dynamicObject = new DynamicObject();
                for (int i = 0; i < pkValues.size(); ++i) {
                    Object o = pkValues.get(i);
                    DataSet select = res.copy().where("entryid =" + o);
                    if (!select.hasNext()) continue;
                    Row next = select.next();
                    String stockbillno = next.getString("stockbillno");
                    if (StringUtils.isEmpty((CharSequence)stockbillno)) {
                        if (!"E".equals(type)) {
                            errMessage.append(String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355[%1$s]\u7b2c[%2$s]\u884c\u65e0\u76f8\u5e94\u7ec4\u4ef6\u6e05\u5355\u3002", (String)"MftReqOutBillEdit_9", (String)"scmc-mm-mdc", (Object[])new Object[0]), next.getString("billno"), next.get("seq")));
                            continue;
                        }
                        errMessage.append(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u751f\u4ea7\u5de5\u5355[%1$s]\u7b2c[%2$s]\u884c\u65e0\u76f8\u5e94\u6d41\u7a0b\u7528\u6599\u6e05\u5355\u3002", (String)"MftReqOutBillEdit_16", (String)"scmc-mm-mdc", (Object[])new Object[0]), next.getString("billno"), next.get("seq")));
                        continue;
                    }
                    String billstatus = next.getString("billstatus");
                    if (!"C".equals(billstatus)) {
                        if (!"E".equals(type)) {
                            errMessage.append(String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355[%1$s]\u6240\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355[%2$s]\u672a\u5ba1\u6838\u3002", (String)"MftReqOutBillEdit_6", (String)"scmc-mm-mdc", (Object[])new Object[0]), next.get("billno"), next.get("stockbillno")));
                            continue;
                        }
                        errMessage.append(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u751f\u4ea7\u5de5\u5355[%1$s]\u6240\u5bf9\u5e94\u7684\u6d41\u7a0b\u7528\u6599\u6e05\u5355[%2$s]\u672a\u5ba1\u6838\u3002", (String)"MftReqOutBillEdit_17", (String)"scmc-mm-mdc", (Object[])new Object[0]), next.get("billno"), next.get("stockbillno")));
                        continue;
                    }
                    dynamicObject = flag ? (DynamicObject)billentry.get(rowIndex) : (DynamicObject)OrmUtils.clone((IDataEntityBase)tempt, (boolean)true, (boolean)true);
                    this.getPageCache().put("isIgnoreEntrySeqChange", "false");
                    dynamicObject.set(KEY_MANUBILL, (Object)next.getString("billno"));
                    dynamicObject.set(KEY_MANUBILLID, next.get("id"));
                    dynamicObject.set(KEY_MANUENTRYID, next.get("entryid"));
                    dynamicObject.set(KEY_MANUENTRY, next.get("seq"));
                    dynamicObject.set("srcbillnumber", next.get("stockbillno"));
                    dynamicObject.set("mainbillnumber", next.get("stockbillno"));
                    dynamicObject.set("mainbillid", next.get("stockid"));
                    if ("E".equals(type)) {
                        dynamicObject.set("mainbillentity", (Object)"prop_mftstock");
                        dynamicObject.set("productline", (Object)this.getWorkCenter(next.get("productline.id")));
                    } else {
                        dynamicObject.set("mainbillentity", (Object)"pom_mftstock");
                    }
                    this.setReWorkByDynamicObject(dynamicObject);
                    if (flag) {
                        flag = false;
                        continue;
                    }
                    billentry.add(++rowIndex, dynamicObject);
                }
            }
            this.getView().updateView(KEY_ENTRY);
            if (!StringUtils.isBlank((CharSequence)errMessage)) {
                this.getView().showTipNotification(errMessage.toString());
            }
        }
        if (KEY_OPERATION.equals(closedCallBackEvent.getActionId()) && (rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && !rows.isEmpty()) {
            entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY);
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            Object pkValue = rows.get(0).getPrimaryKeyValue();
            obj = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)ENTITYID_WORKPROCEDURE);
            if (obj == null) {
                return;
            }
            this.getPageCache().put(KEY_OPERATION, obj.getString("number"));
            this.getModel().setValue(KEY_OPERATION, (Object)obj.getString("number"), rowIndex);
            this.getModel().setValue(KEY_OPERATIONID, obj.getPkValue(), rowIndex);
        }
        if (KEY_WORKCENTER.equals(closedCallBackEvent.getActionId()) && (rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && !rows.isEmpty()) {
            entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY);
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            Object pkValue = rows.get(0).getPrimaryKeyValue();
            obj = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)ENTITYID_WORKCENTRE);
            if (obj == null) {
                return;
            }
            this.getPageCache().put(KEY_WORKCENTER, obj.getString("name"));
            this.getModel().setValue(KEY_WORKCENTER, (Object)obj.getString("name"), rowIndex);
            this.getModel().setValue(KEY_WORKCENTERID, obj.getPkValue(), rowIndex);
        }
    }

    private DynamicObject getWorkCenter(Object id) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)ENTITYID_WORKCENTRE, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
    }

    private void setReWorkByDynamicObject(DynamicObject billEntry) {
        if (null != billEntry) {
            boolean existsFlag = false;
            DynamicObject invMaterial = billEntry.getDynamicObject("material");
            if (null != invMaterial) {
                DynamicObject master = invMaterial.getDynamicObject("masterid");
                long masterid = master.getLong("id");
                long orderEntryId = billEntry.getLong(KEY_MANUENTRYID);
                if (masterid != 0L && orderEntryId != 0L) {
                    QFilter qFilter = new QFilter("treeentryentity.material.masterid", "=", (Object)masterid);
                    qFilter.and("treeentryentity.id", "=", (Object)orderEntryId);
                    existsFlag = QueryServiceHelper.exists((String)ENTITYID_MANUFACTUREBILL, (QFilter[])qFilter.toArray());
                }
            }
            billEntry.set("isrework", (Object)existsFlag);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("isIgnoreChangeListener", "true");
        this.setSupplyOwner();
        this.getPageCache().put("isIgnoreChangeListener", "false");
        String billEntityName = this.getModel().getDataEntity().getDataEntityType().getName();
        this.getModel().setValue("billentity", (Object)billEntityName);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getPageCache().put("isIgnoreChangeListener", "true");
        this.getPageCache().put("isIgnoreChangeListener", "false");
        String formId = this.getModel().getDataEntityType().getName();
        boolean isMftReqOut = "im_mdc_mftfeedorder".equals(formId);
        boolean isMftReqReturn = "im_mdc_mftreturnorder".equals(formId);
        IFormView view = this.getView();
        if (isMftReqOut || isMftReqReturn) {
            DynamicObject supplyOrg;
            view.setEnable(Boolean.valueOf(true), new String[]{"addrow"});
            DynamicObject bizorg = (DynamicObject)this.getModel().getValue(KEY_BIZORG);
            if (null == bizorg && (supplyOrg = (DynamicObject)this.getModel().getValue(KEY_ORG)) != null) {
                List idList = OrgUnitServiceHelper.getFromOrgs((String)"05", (Long)((Long)supplyOrg.getPkValue()), (String)"04", (boolean)true);
                if (null != idList && idList.size() > 0) {
                    Long supplyIrgId = supplyOrg.getLong("id");
                    if (idList.contains(supplyIrgId)) {
                        this.getModel().setValue(KEY_BIZORG, (Object)supplyIrgId);
                    } else {
                        this.getModel().setValue(KEY_BIZORG, idList.get(0));
                    }
                } else {
                    List orgIds = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"04", (boolean)false);
                    if (orgIds.size() > 0) {
                        this.getModel().setValue(KEY_BIZORG, orgIds.get(0));
                    }
                }
            }
        }
        String[] fields = new String[]{"material"};
        if (isMftReqOut && "A".equals(this.getModel().getValue("billstatus"))) {
            DynamicObjectCollection billentrys = this.getModel().getEntryEntity(KEY_ENTRY);
            for (DynamicObject billentry : billentrys) {
                int index = billentry.getInt("seq") - 1;
                for (String field : fields) {
                    view.setEnable(Boolean.valueOf(true), index, new String[]{field});
                }
            }
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection billEntities = dataEntity.getDynamicObjectCollection(KEY_ENTRY);
        for (DynamicObject billEntity : billEntities) {
            Boolean isAdd = billEntity.getBoolean("isadd");
            if (isAdd.booleanValue()) continue;
            view.setEnable(Boolean.valueOf(false), new String[]{"addrow"});
        }
    }

    private void setSupplyOwner() {
        DynamicObject org = (DynamicObject)this.getModel().getValue(KEY_ORG);
        DynamicObject supplyowner = (DynamicObject)this.getModel().getValue("supplyowner");
        if (!this.isNull(org) && this.isNull(supplyowner)) {
            supplyowner = AccountOrgHelper.getAccountByOrg(org.getLong("id"), "05");
            this.getModel().setValue("supplyowner", (Object)supplyowner);
        }
    }

    private boolean isNull(Object obj) {
        if (obj instanceof String) {
            return obj == null || obj.toString().trim().length() == 0;
        }
        return obj == null;
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.getPageCache().put("isinital", Boolean.TRUE.toString());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        EntryGrid entryGrid;
        super.beforeDoOperation(e);
        FormOperate source = (FormOperate)e.getSource();
        String operateKey = source.getOperateKey();
        if ("unaudit".equals(operateKey)) {
            source.getOption().setVariableValue("ismanual", "true");
        }
        if ("copyentryrow".equals(operateKey)) {
            this.getPageCache().put("isIgnoreChangeEntryIsAdd", "true");
        }
        if ("batchfillorderinfo".equals(operateKey) && (entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY)).getSelectRows().length != 1) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u5206\u5f55\u3002", (String)"MftReqOutBillEdit_14", (String)"scmc-mm-mdc", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("newentry".equals(e.getOperateKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY);
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            this.getModel().setValue("isadd", (Object)"1", rowIndex);
        }
        if ("audit".equals(e.getOperateKey()) || "unaudit".equals(e.getOperateKey()) || "unsubmit".equals(e.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        }
        boolean isMftReqOut = "im_mdc_mftfeedorder".equals(this.getModel().getDataEntityType().getName());
        IFormView view = this.getView();
        String[] fields = new String[]{"material"};
        if (isMftReqOut && "A".equals(this.getModel().getValue("billstatus"))) {
            DynamicObjectCollection billentrys = this.getModel().getEntryEntity(KEY_ENTRY);
            for (DynamicObject billentry : billentrys) {
                int index = billentry.getInt("seq") - 1;
                for (String field : fields) {
                    view.setEnable(Boolean.valueOf(true), index, new String[]{field});
                }
            }
        }
        if ("copyentryrow".equals(e.getOperateKey())) {
            this.getPageCache().put("isIgnoreChangeEntryIsAdd", "false");
        }
        if ("batchfillorderinfo".equals(e.getOperateKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY);
            int index = entryGrid.getSelectRows()[0];
            DynamicObject orderEntryDym = this.getModel().getEntryRowEntity(KEY_ENTRY, index);
            if (null != orderEntryDym) {
                DynamicObjectCollection billEntrys = this.getModel().getEntryEntity(KEY_ENTRY);
                for (DynamicObject billEntry : billEntrys) {
                    String orderBillNo = billEntry.getString(KEY_MANUBILL);
                    if (!StringUtils.isBlank((CharSequence)orderBillNo)) continue;
                    int entryIndex = billEntry.getInt("seq") - 1;
                    this.getModel().setValue(KEY_MANUBILL, orderEntryDym.get(KEY_MANUBILL), entryIndex);
                    this.getModel().setValue(KEY_MANUBILLID, orderEntryDym.get(KEY_MANUBILLID), entryIndex);
                    this.getModel().setValue(KEY_MANUENTRYID, orderEntryDym.get(KEY_MANUENTRYID), entryIndex);
                    this.getModel().setValue("srcbillnumber", orderEntryDym.get("srcbillnumber"), entryIndex);
                    this.getModel().setValue("mainbillnumber", orderEntryDym.get("mainbillnumber"), entryIndex);
                    this.getModel().setValue("mainbillid", orderEntryDym.get("mainbillid"), entryIndex);
                    this.getModel().setValue("mainbillentity", orderEntryDym.get("mainbillentity"), entryIndex);
                    this.getModel().setValue(KEY_MANUENTRY, orderEntryDym.get(KEY_MANUENTRY), entryIndex);
                    this.getModel().setValue("tracknumber", orderEntryDym.get("tracknumber"), entryIndex);
                    this.getModel().setValue("project", orderEntryDym.get("project"), entryIndex);
                    this.getModel().setValue("productline", orderEntryDym.get("productline"), entryIndex);
                }
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        Object manubillid;
        if (StringUtils.equals((CharSequence)KEY_MANUBILL, (CharSequence)arg0.getFieldName()) && (manubillid = this.getModel().getValue(KEY_MANUBILLID, arg0.getRowIndex())) != null) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(ENTITYID_MANUFACTUREBILL);
            showParameter.setPkId(manubillid);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void click(EventObject evt) {
        Control sourceField = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)sourceField.getKey(), (CharSequence)KEY_MANUBILL)) {
            this.showBillList(sourceField.getKey());
        }
    }

    private void showBillList(String sourcekey) {
        if (!StringUtils.isEmpty((CharSequence)sourcekey)) {
            DynamicObject org;
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
            qFilters.add(new QFilter("transactiontype.isoffreqallowed", "=", (Object)true));
            qFilters.add(new QFilter("treeentryentity.planstatus", "in", (Object)new Object[]{"C"}));
            qFilters.add(new QFilter("treeentryentity.bizstatus", "=", (Object)"A"));
            qFilters.add(new QFilter("treeentryentity.producttype", "=", (Object)"C"));
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY);
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            DynamicObject productline = (DynamicObject)this.getModel().getValue("productline", rowIndex);
            if (productline != null) {
                qFilters.add(new QFilter("treeentryentity.productline", "=", productline.getPkValue()));
            }
            QFilter orgFilter = (org = (DynamicObject)this.getModel().getValue(KEY_BIZORG)) != null ? new QFilter(KEY_ORG, "=", org.getPkValue()) : new QFilter(KEY_ORG, "=", (Object)0L);
            qFilters.add(orgFilter);
            DynamicObject bizdept = (DynamicObject)this.getModel().getValue("bizdept");
            if (null != bizdept) {
                HashSet<Long> bizdeptIds = new HashSet<Long>(16);
                bizdeptIds.add(0L);
                bizdeptIds.add(bizdept.getLong("id"));
                QFilter bizdeptFilter = new QFilter("treeentryentity.producedept", "in", bizdeptIds);
                qFilters.add(bizdeptFilter);
            }
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)MdcApplyBillUtils.getEntityName("productiondomain", this.getModel(), 0), (boolean)false);
            showParameter.getListFilterParameter().setQFilters(qFilters);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, sourcekey);
            showParameter.setMultiSelect(true);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void setIsRework(DynamicObject billEntry) {
        if (null != billEntry) {
            boolean existsFlag = false;
            DynamicObject invMaterial = billEntry.getDynamicObject("material");
            if (null != invMaterial) {
                DynamicObject master = invMaterial.getDynamicObject("masterid");
                long masterid = master.getLong("id");
                long orderEntryId = billEntry.getLong(KEY_MANUENTRYID);
                if (masterid != 0L && orderEntryId != 0L) {
                    QFilter qFilter = new QFilter("treeentryentity.material.masterid", "=", (Object)masterid);
                    qFilter.and("treeentryentity.id", "=", (Object)orderEntryId);
                    existsFlag = QueryServiceHelper.exists((String)ENTITYID_MANUFACTUREBILL, (QFilter[])qFilter.toArray());
                }
            }
            this.getModel().setValue("isrework", (Object)existsFlag, billEntry.getInt("seq") - 1);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if (!"true".equals(this.getPageCache().get("isIgnoreChangeEntryIsAdd")) && KEY_ENTRY.equals(entryName)) {
            RowDataEntity[] rows;
            for (RowDataEntity row : rows = e.getRowDataEntities()) {
                int rowIndex = row.getRowIndex();
                DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity(KEY_ENTRY).get(rowIndex);
                DynamicObjectCollection linkColl = entry.getDynamicObjectCollection("billentry_lk");
                if (linkColl != null && linkColl.size() != 0) continue;
                this.getModel().setValue("isadd", (Object)"1", rowIndex);
            }
        }
    }
}

