/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.mftreqoutbill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.UnitEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.common.mdc.utils.MeasureUnitUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OmReqOutBillEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(OmReqOutBillEdit.class);
    public static final String KEY_QTY = "qty";
    public static final String KEY_BIZTYPR = "biztype";
    public static final String KEY_WORKSHOP = "workshop";
    public static final String KEY_WORKSHOPID = "workshopid";
    public static final String KEY_MANUBILL = "manubill";
    public static final String KEY_MANUBILLID = "manubillid";
    public static final String KEY_MANUENTRY = "manuentry";
    public static final String KEY_MANUENTRYID = "manuentryid";
    public static final String KEY_OPERATION = "operation";
    public static final String KEY_OPERATIONID = "operationid";
    public static final String KEY_WORKCENTER = "workcenter";
    public static final String KEY_WORKCENTERID = "workcenterid";
    public static final String ENTITYID_WORKSHOPSETUP = "mpdm_workshopsetup";
    public static final String ENTITYID_MANUFACTUREBILL = "pm_om_purorderbill";
    public static final String ENTITYID_WORKPROCEDURE = "mpdm_workprocedure";
    public static final String ENTITYID_WORKCENTRE = "mpdm_workcentre";
    public static final String KEY_WAREHOUSE = "warehosue";
    public static final String KEY_ORG = "org";
    public static final String KEY_BIZORG = "bizorg";
    public static final String KEY_ENTRY = "billentry";
    public static final String KEY_MANUFACTUREBILLENTRY = "treeentryentity";
    private static final String IM_MDC_OM_RETURN_ORDER = "im_mdc_omreturnorder";
    private static final String IM_MDC_OM_PRO_ORDER = "im_mdc_omproorder";
    public String isinital = "false";
    private static final String KEY_BOS_ORG = "bos_org";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        TextEdit manuBill = (TextEdit)this.getView().getControl(KEY_MANUBILL);
        manuBill.addClickListener((ClickListener)this);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl(KEY_BIZORG);
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        UnitEdit unitEdit = (UnitEdit)this.getView().getControl("unit");
        unitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (StringUtils.equals((CharSequence)KEY_WAREHOUSE, (CharSequence)fieldKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(KEY_ORG);
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"Om_OmReqOutBillEdit_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            Long[] warehouseids = WarehouseHelper.getAllWarehouseIDs((Long)((Long)org.getPkValue()));
            QFilter qfilter = new QFilter("id", "in", (Object)warehouseids);
            showParameter.getListFilterParameter().getQFilters().add(qfilter);
        } else if (StringUtils.equals((CharSequence)KEY_BIZORG, (CharSequence)fieldKey)) {
            DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue(KEY_ORG);
            if (supplyOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"Om_OmReqOutBillEdit_1", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            List idList = OrgUnitServiceHelper.getFromOrgs((String)"05", (Long)((Long)supplyOrg.getPkValue()), (String)"02", (boolean)true);
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)idList));
        } else if (StringUtils.equals((CharSequence)"unit", (CharSequence)fieldKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY);
            if (entryGrid.getSelectRows().length == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u5206\u5f55\u3002", (String)"Om_OmReqOutBillEdit_2", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
            DynamicObject[] ids = MeasureUnitUtils.getMeasureUnit(material.getLong("id"));
            ArrayList<Long> idList = new ArrayList<Long>();
            if (ids != null && ids.length > 0) {
                for (int i = 0; i < ids.length; ++i) {
                    idList.add(ids[i].getDynamicObject("measureunitid").getLong("id"));
                }
            }
            if (CollectionUtils.isNotEmpty(idList)) {
                List qFilters = showParameter.getListFilterParameter().getQFilters();
                List collect = qFilters.stream().filter(var -> "in".equals(var.getCP()) && "id".equals(var.getProperty())).collect(Collectors.toList());
                for (QFilter qFilter : collect) {
                    Object value1 = qFilter.getValue();
                    if (!(value1 instanceof List)) continue;
                    List value = (List)value1;
                    value.addAll(idList);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        EntryGrid entryGrid;
        String key = e.getProperty().getName();
        if ("true".equals(this.getPageCache().get("isIgnoreChangeListener"))) {
            return;
        }
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("materialmasterid".equals(key) || "material".equals(key)) {
            DynamicObject value = (DynamicObject)this.getModel().getValue("material");
            DynamicObject masterId = value.getDynamicObject("masterid");
            DynamicObjectCollection invBillEntryList = (DynamicObjectCollection)this.getModel().getValue(KEY_ENTRY);
            if (masterId == null) {
                return;
            }
            boolean b = masterId.getBoolean("isenablematerialversion");
            if (!b) {
                this.getView().setEnable(Boolean.FALSE, invBillEntryList.size() - 1, new String[]{"mversion"});
            }
        }
        if ((entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY)).getSelectRows().length == 0) {
            return;
        }
        int rowIndex = entryGrid.getSelectRows()[0];
        if (KEY_MANUBILL.equals(key)) {
            if ("".equals(newValue) || newValue == null) {
                this.getModel().setValue(KEY_MANUBILLID, null, rowIndex);
                this.getModel().setValue(KEY_MANUENTRY, null, rowIndex);
                this.getModel().setValue(KEY_MANUENTRYID, null, rowIndex);
            }
            if (this.getPageCache().get(KEY_MANUBILL) != null) {
                String str = this.getPageCache().get(KEY_MANUBILL);
                if (newValue != null && !newValue.toString().equals(str)) {
                    this.getModel().setValue(KEY_MANUBILL, (Object)str, rowIndex);
                }
            }
        }
        if ("outinvtype".equals(key)) {
            Object outinvType = this.getModel().getValue("outinvtype", rowIndex);
            Long outinvTypeId = OmReqOutBillEdit.getDyObjId(outinvType);
            DynamicObject invScheme = (DynamicObject)this.getModel().getValue("invscheme");
            DynamicObjectCollection outInvTypeEntry = invScheme.getDynamicObjectCollection("outinvtypeentry");
            for (DynamicObject dyn : outInvTypeEntry) {
                Object outinvtype = dyn.get("outinvtype");
                Long dyObjId = OmReqOutBillEdit.getDyObjId(outinvtype);
                String outOwnerType = dyn.getString("outownertype1");
                String outKeeperType = dyn.getString("outkeepertype1");
                if (dyObjId == null || !dyObjId.equals(outinvTypeId) || "".equals(outOwnerType) || "".equals(outKeeperType)) continue;
                this.getModel().setValue("outownertype", (Object)outOwnerType, rowIndex);
                this.getModel().setValue("outkeepertype", (Object)outKeeperType, rowIndex);
            }
        }
    }

    public static Long getDyObjId(Object dyObj) {
        if (dyObj == null) {
            return null;
        }
        if (dyObj instanceof DynamicObject) {
            return ((DynamicObject)dyObj).getLong("id");
        }
        if (dyObj instanceof Long) {
            return (Long)dyObj;
        }
        return null;
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObject obj;
        Object pkValue;
        int rowIndex;
        EntryGrid entryGrid;
        ListSelectedRowCollection rows;
        super.closedCallBack(closedCallBackEvent);
        if (KEY_MANUBILL.equals(closedCallBackEvent.getActionId()) && (rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && !rows.isEmpty()) {
            entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY);
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            rowIndex = entryGrid.getSelectRows()[0];
            pkValue = rows.get(0).getPrimaryKeyValue();
            obj = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)ENTITYID_MANUFACTUREBILL, (String)"id,billno,billentry,billentry.seq,billentry.material");
            if (obj == null) {
                return;
            }
            Object entryPkValue = rows.get(0).getEntryPrimaryKeyValue();
            for (int i = 0; i < obj.getDynamicObjectCollection(KEY_ENTRY).size(); ++i) {
                DynamicObject entry = (DynamicObject)obj.getDynamicObjectCollection(KEY_ENTRY).get(i);
                if (!entry.getPkValue().equals(entryPkValue)) continue;
                this.getModel().setValue(KEY_MANUENTRY, entry.get("seq"), rowIndex);
            }
            this.getPageCache().put(KEY_MANUBILL, obj.getString("billno"));
            this.getModel().setValue(KEY_MANUBILL, (Object)obj.getString("billno"), rowIndex);
            this.getModel().setValue(KEY_MANUBILLID, obj.getPkValue(), rowIndex);
            this.getModel().setValue(KEY_MANUENTRYID, entryPkValue, rowIndex);
        }
        if (KEY_OPERATION.equals(closedCallBackEvent.getActionId()) && (rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && !rows.isEmpty()) {
            entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY);
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            rowIndex = entryGrid.getSelectRows()[0];
            pkValue = rows.get(0).getPrimaryKeyValue();
            obj = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)ENTITYID_WORKPROCEDURE);
            if (obj == null) {
                return;
            }
            this.getPageCache().put(KEY_OPERATION, obj.getString("number"));
            this.getModel().setValue(KEY_OPERATION, (Object)obj.getString("number"), rowIndex);
            this.getModel().setValue(KEY_OPERATIONID, obj.getPkValue(), rowIndex);
        }
        if (KEY_WORKCENTER.equals(closedCallBackEvent.getActionId()) && (rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && !rows.isEmpty()) {
            entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY);
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            rowIndex = entryGrid.getSelectRows()[0];
            pkValue = rows.get(0).getPrimaryKeyValue();
            obj = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)ENTITYID_WORKCENTRE);
            if (obj == null) {
                return;
            }
            this.getPageCache().put(KEY_WORKCENTER, obj.getString("name"));
            this.getModel().setValue(KEY_WORKCENTER, (Object)obj.getString("name"), rowIndex);
            this.getModel().setValue(KEY_WORKCENTERID, obj.getPkValue(), rowIndex);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("isIgnoreChangeListener", "true");
        this.setSupplyOwner();
        this.getPageCache().put("isIgnoreChangeListener", "false");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void setSupplyOwner() {
        DynamicObject org = (DynamicObject)this.getModel().getValue(KEY_ORG);
        DynamicObject supplyowner = (DynamicObject)this.getModel().getValue("supplyowner");
        if (!this.isNull(org) && this.isNull(supplyowner)) {
            supplyowner = OmReqOutBillEdit.getAccountByOrg(org.getLong("id"), "05");
            this.getModel().setValue("supplyowner", (Object)supplyowner);
        }
    }

    private boolean isNull(Object obj) {
        if (obj instanceof String) {
            return obj == null || obj.toString().trim().length() == 0;
        }
        return obj == null;
    }

    private static DynamicObject getAccountByOrg(Long orgId, String orgType) {
        if (orgId == null) {
            return null;
        }
        List idList = OrgUnitServiceHelper.getFromOrgs((String)orgType, (Long)orgId, (String)"10");
        Object settleOrgId = null;
        DynamicObject account = null;
        if (idList != null && idList.size() > 0) {
            settleOrgId = idList.get(0);
            account = BusinessDataServiceHelper.loadSingleFromCache(settleOrgId, (String)KEY_BOS_ORG);
        }
        return account;
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.getPageCache().put("isinital", Boolean.TRUE.toString());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String parentFormId = formShowParameter.getParentFormId();
        IDataModel bill = this.getModel();
        DynamicObjectCollection invBillEntryList = (DynamicObjectCollection)bill.getValue(KEY_ENTRY);
        int entrySize = invBillEntryList.size();
        for (int i = 0; i < entrySize; ++i) {
            String name;
            DynamicObject masterId;
            this.setEnableByMaterial((DynamicObject)invBillEntryList.get(i), i, this.getView());
            DynamicObject object = ((DynamicObject)invBillEntryList.get(i)).getDynamicObject("material");
            if (object == null || (masterId = object.getDynamicObject("masterid")) == null) continue;
            boolean b = masterId.getBoolean("isenablematerialversion");
            if (!b) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"mversion"});
            }
            if (IM_MDC_OM_PRO_ORDER.equals(name = this.getModel().getDataEntityType().getName())) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"unit"});
            }
            if (!IM_MDC_OM_RETURN_ORDER.equals(name)) continue;
            if (IM_MDC_OM_PRO_ORDER.equals(parentFormId)) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"unit"});
                continue;
            }
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"unit"});
        }
    }

    private void setEnableByMaterial(DynamicObject entry, int index, IFormView view) {
        DynamicObject stockMaterial = entry.getDynamicObject("material");
        if (stockMaterial == null) {
            return;
        }
        DynamicObject material = null;
        if (!"bd_material".equals(stockMaterial.getDataEntityType().getName())) {
            material = stockMaterial.getDynamicObject("masterid");
        }
        if (material == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5143\u6570\u636e\u914d\u7f6e\u6709\u8bef\uff1a\u7269\u6599\u7b56\u7565\u9700\u5f15\u7528\u7269\u6599\u3010\u542f\u7528\u8f85\u52a9\u5c5e\u6027 /isuseauxpty\u3011\u5c5e\u6027", (String)"Om_OmReqOutBillEdit_3", (String)"scmc-mm-mdc", (Object[])new Object[0]));
        }
        boolean b = material.getBoolean("isenablematerialversion");
        this.getView().setEnable(Boolean.valueOf(b), index, new String[]{"mversion"});
        boolean isUseAuxpty = material.getBoolean("isuseauxpty");
        view.setEnable(Boolean.valueOf(isUseAuxpty), index, new String[]{"auxpty"});
        DynamicObject unit2nd = material.getDynamicObject("auxptyunit");
        view.setEnable(Boolean.valueOf(unit2nd != null), index, new String[]{"qtyunit2nd"});
        boolean enableLot = stockMaterial.getBoolean("enablelot");
        view.setEnable(Boolean.valueOf(enableLot), index, new String[]{"lotnumber"});
        DynamicObject warehouse = entry.getDynamicObject("warehouse");
        boolean isopenlocation = warehouse != null && warehouse.getBoolean("isopenlocation");
        view.setEnable(Boolean.valueOf(isopenlocation), index, new String[]{"location"});
        boolean isEnableShelfLife = stockMaterial.getBoolean("enableshelflifemgr");
        view.setEnable(Boolean.valueOf(isEnableShelfLife), index, new String[]{"producedate"});
        view.setEnable(Boolean.valueOf(isEnableShelfLife), index, new String[]{"expirydate"});
    }
}

