/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.omcmplinbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.common.mdc.consts.PrecisionAccountEnum;
import kd.scmc.im.common.mdc.utils.EntityNameUtils;
import org.apache.commons.collections.CollectionUtils;

public class OMManufactureInWarehsListPlugin
extends AbstractListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if ("backflushout".equals(operateKey)) {
            ListSelectedRowCollection selects = e.getListSelectedData();
            Object[] entryPrimaryKeyValues = selects.getPrimaryKeyValues();
            QFilter qFilter = new QFilter("id", "in", (Object)entryPrimaryKeyValues);
            BillShowParameter load = BusinessDataServiceHelper.load((String)"im_mdc_omcmplinbill", (String)"billno,billstatus,billentry.entryreqorg", (QFilter[])new QFilter[]{qFilter});
            if (load != null && ((DynamicObject[])load).length == 1) {
                ArrayList<String> billnos = new ArrayList<String>(1);
                billnos.add(load[0].getString("billno"));
                Object entryreqorg = ((DynamicObject)load[0].getDynamicObjectCollection("billentry").get(0)).getDynamicObject("entryreqorg").getPkValue();
                BillShowParameter showParameter = this.createAddNewBillShowParam(billnos, entryreqorg);
                this.getView().showForm((FormShowParameter)showParameter);
            } else if (load != null && ((DynamicObject[])load).length > 1) {
                ArrayList<String> billnos = new ArrayList<String>(((DynamicObject[])load).length);
                Object proOrg = ((DynamicObject)load[0].getDynamicObjectCollection("billentry").get(0)).getDynamicObject("entryreqorg").getPkValue();
                for (DynamicObject bill : load) {
                    billnos.add(bill.getString("billno"));
                    if (proOrg.toString().equals(((DynamicObject)bill.getDynamicObjectCollection("billentry").get(0)).getDynamicObject("entryreqorg").getPkValue().toString())) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u201c\u5012\u51b2\u9886\u6599\u201d\u65f6\uff0c\u8bf7\u786e\u4fdd\u751f\u4ea7\u7ec4\u7ec7\u4e00\u81f4\u3002", (String)"OMManufactureInWarehsListPlugin_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                    e.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                BillShowParameter showParameter = this.createAddNewBillShowParam(billnos, proOrg);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        } else if ("chargeagainst".equals(operateKey)) {
            String formId = this.getView().getFormShowParameter().getFormName();
            OperateOption option = operate.getOption();
            if (ResManager.loadKDString((String)"\u5de5\u5e8f\u59d4\u5916\u63a5\u6536\u5904\u7406", (String)"OMManufactureInWarehsListPlugin_1", (String)"scmc-mm-mdc", (Object[])new Object[0]).equals(formId)) {
                option.setVariableValue("fromid", "im_mdc_omcmplinbil_opm");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        if ("updatebfstatus".equals(e.getOperateKey()) || "unbackflush".equals(e.getOperateKey()) || "unaudit".equals(e.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        }
        if ("audit".equals(e.getOperateKey()) && e.getOperationResult() != null && e.getOperationResult().getValidateResult() != null && e.getOperationResult().getValidateResult().isSuccess()) {
            FormOperate formOperate = (FormOperate)e.getSource();
            String backflushInfo = formOperate.getOption().getVariableValue("backflushInfo", "");
            if (StringUtils.isNotEmpty((CharSequence)backflushInfo)) {
                this.getView().showTipNotification(backflushInfo);
            }
            this.getView().invokeOperation("refresh");
        }
        if ("chargeagainst".equals(e.getOperateKey())) {
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
            ArrayList<Long> manuentryids = new ArrayList<Long>();
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"im_mdc_omcmplinbill", (String)"billno,billstatus,billentry.entryreqorg,billentry.manuentryid", (QFilter[])new QFilter[]{qFilter});
            if (load != null && load.length == 1) {
                DynamicObjectCollection billentry = load[0].getDynamicObjectCollection("billentry");
                for (DynamicObject dynamicObject : billentry) {
                    long manuentryid = dynamicObject.getLong("manuentryid");
                    manuentryids.add(manuentryid);
                }
            }
            if (CollectionUtils.isNotEmpty(manuentryids)) {
                this.aculUseQtyByOrderEntryId(manuentryids);
            }
        }
    }

    private void aculUseQtyByOrderEntryId(List<Long> orderEntryIdList) {
        this.batchCulUseQtyByOrderEntryId(orderEntryIdList, "om_mftorder");
    }

    private void batchCulUseQtyByOrderEntryId(List<Long> orderEntryIdList, String orderName) {
        QFilter qf = new QFilter("orderentryid", "in", orderEntryIdList);
        DynamicObject[] stockDymList = BusinessDataServiceHelper.load((String)EntityNameUtils.getEntityName(0, 1, orderName), (String)"transactiontypeid,orderentryid,baseqty,stockentry,stockentry.demandqty,stockentry.wipqty,stockentry.useqty,stockentry.iscannegative,stockentry.qtytype,stockentry.actissueqty,stockentry.feedingqty,stockentry.rejectedqty,stockentry.processseq,stockentry.oprno,stockentry.materialunitid", (QFilter[])new QFilter[]{qf});
        if (stockDymList == null) {
            return;
        }
        ArrayList<DynamicObject> updateStockDymList = new ArrayList<DynamicObject>(orderEntryIdList.size());
        HashSet<Long> updateStockIDSet = new HashSet<Long>(orderEntryIdList.size());
        for (int i = 0; i < stockDymList.length; ++i) {
            DynamicObject stockDy = stockDymList[i];
            DynamicObjectCollection stockEntryDym = stockDy.getDynamicObjectCollection("stockentry");
            if (stockEntryDym == null || stockEntryDym.isEmpty()) continue;
            for (int j = 0; j < stockEntryDym.size(); ++j) {
                DynamicObject stockEntry = (DynamicObject)stockEntryDym.get(j);
                BigDecimal actissueQty = stockEntry.getBigDecimal("actissueqty");
                BigDecimal feedingQty = stockEntry.getBigDecimal("feedingqty");
                BigDecimal rejectedQty = stockEntry.getBigDecimal("rejectedqty");
                BigDecimal oldwipqty = stockEntry.getBigDecimal("wipqty");
                BigDecimal olduseqty = stockEntry.getBigDecimal("useqty");
                BigDecimal outsQty = actissueQty.add(feedingQty).subtract(rejectedQty);
                if (oldwipqty == null) {
                    oldwipqty = BigDecimal.ZERO;
                }
                if (olduseqty == null) {
                    olduseqty = BigDecimal.ZERO;
                }
                DynamicObject transactionType = stockDymList[i].getDynamicObject("transactiontypeid");
                BigDecimal useQty = this.culUseQty(stockEntry, stockDymList[i].getDynamicObject("orderentryid").getPkValue(), transactionType, orderName);
                BigDecimal newWipQty = outsQty.subtract(useQty);
                if (oldwipqty.compareTo(newWipQty) == 0 && olduseqty.compareTo(useQty) == 0) continue;
                stockEntry.set("wipqty", (Object)newWipQty);
                stockEntry.set("useqty", (Object)useQty);
                this.caleQtyPrecision(stockEntry, "materialunitid", "wipqty", "useqty");
                if (updateStockIDSet.contains(stockDy.getLong("id"))) continue;
                updateStockDymList.add(stockDy);
                updateStockIDSet.add(stockDy.getLong("id"));
            }
        }
        if (!updateStockDymList.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateStockDymList.toArray(new DynamicObject[updateStockDymList.size()]));
        }
    }

    private void caleQtyPrecision(DynamicObject dynamicObject, String unitKey, String ... qtyFieldKeys) {
        for (String qtyKey : qtyFieldKeys) {
            BigDecimal srcQty = dynamicObject.getBigDecimal(qtyKey);
            if (srcQty == null) continue;
            DynamicObject unitObj = dynamicObject.getDynamicObject(unitKey);
            DynamicObject unit = null;
            if (unitObj instanceof DynamicObject) {
                unit = unitObj;
            } else if (unitObj instanceof Long) {
                Long unitL = (Long)unitObj;
                QFilter qfilters = new QFilter("id", "=", (Object)unitL);
                unit = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_measureunits", (String)"id,precision,precisionaccount", (QFilter[])qfilters.toArray());
            }
            if (unit == null) continue;
            BigDecimal precisQty = srcQty.setScale(unit.getInt("precision"), PrecisionAccountEnum.getEnumByVal(unit.getInt("precisionaccount")));
            dynamicObject.set(qtyKey, (Object)precisQty);
        }
    }

    public BigDecimal culUseQty(DynamicObject stockEntry, Object orderEntryId, DynamicObject transactiontype, String orderName) {
        if (stockEntry.getBoolean("iscannegative")) {
            return BigDecimal.ZERO;
        }
        String deduction = transactiontype.getString("deduction");
        if ("A".equals(deduction)) {
            return this.aculUseQtyA(stockEntry, orderEntryId, orderName);
        }
        if ("B".equals(deduction)) {
            return this.aculUseQtyB(stockEntry, orderEntryId, transactiontype, orderName);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal aculUseQtyA(DynamicObject stockEntry, Object orderEntryId, String orderName) {
        Map<String, Object> orderMap = this.getOrderQtyMap(orderEntryId, orderName);
        if (orderMap.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal orderBaseQty = BigDecimal.ONE;
        BigDecimal stockqty = BigDecimal.ZERO;
        BigDecimal quainwaqty = (BigDecimal)orderMap.get("quainwaqty");
        BigDecimal unquainwaqty = (BigDecimal)orderMap.get("unquainwaqty");
        BigDecimal scrinwaqty = (BigDecimal)orderMap.get("scrinwaqty");
        stockqty = quainwaqty.add(unquainwaqty).add(scrinwaqty);
        orderBaseQty = (BigDecimal)orderMap.get("baseqty");
        String qtytype = stockEntry.getString("qtytype");
        BigDecimal useQty = BigDecimal.ZERO;
        if (orderBaseQty.compareTo(BigDecimal.ZERO) == 0) {
            orderBaseQty = BigDecimal.ONE;
        }
        if ("A".equals(qtytype) || "C".equals(qtytype)) {
            BigDecimal demandBaseQty = stockEntry.getBigDecimal("demandqty");
            useQty = stockqty.multiply(demandBaseQty).divide(orderBaseQty, 8, 4);
        }
        if ("B".equals(qtytype)) {
            useQty = stockqty.compareTo(orderBaseQty) >= 0 ? stockEntry.getBigDecimal("demandqty") : BigDecimal.ZERO;
        }
        return useQty;
    }

    private Map<String, Object> getOrderQtyMap(Object orderEntryId, String orderName) {
        String orderKeys = String.valueOf(orderEntryId) + orderName;
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        QFilter qfilter = new QFilter("treeentryentity.id", "=", orderEntryId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-StockCulUtils-getOrderQtyMap", (String)orderName, (String)"treeentryentity.baseqty baseqty ,treeentryentity.qty qty,treeentryentity.reportqty reportqty,treeentryentity.quainwaqty quainwaqty,treeentryentity.unquainwaqty unquainwaqty ,treeentryentity.scrinwaqty scrinwaqty ", (QFilter[])new QFilter[]{qfilter}, (String)"");){
            while (ds.hasNext()) {
                Row dsRow = ds.next();
                dataMap.put("baseqty", "0E-10".equals(dsRow.getString("baseqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("baseqty"));
                dataMap.put("quainwaqty", "0E-10".equals(dsRow.getString("quainwaqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("quainwaqty"));
                dataMap.put("unquainwaqty", "0E-10".equals(dsRow.getString("unquainwaqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("unquainwaqty"));
                dataMap.put("scrinwaqty", "0E-10".equals(dsRow.getString("scrinwaqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("scrinwaqty"));
                dataMap.put("qty", "0E-10".equals(dsRow.getString("qty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("qty"));
                dataMap.put("reportqty", "0E-10".equals(dsRow.getString("reportqty")) ? BigDecimal.ZERO : dsRow.getBigDecimal("reportqty"));
            }
        }
        return dataMap;
    }

    public BigDecimal aculUseQtyB(DynamicObject stockEntry, Object orderEntryId, DynamicObject transactiontype, String orderName) {
        BigDecimal useQty = BigDecimal.ZERO;
        if (transactiontype.getBoolean("isprocedure")) {
            useQty = this.aculUseQtyC(stockEntry, orderEntryId, orderName);
        } else {
            Map<String, Object> orderMap = this.getOrderQtyMap(orderEntryId, orderName);
            if (orderMap.isEmpty()) {
                return BigDecimal.ZERO;
            }
            BigDecimal orderBaseQty = BigDecimal.ONE;
            BigDecimal reportQty = BigDecimal.ZERO;
            orderBaseQty = (BigDecimal)orderMap.get("qty");
            reportQty = (BigDecimal)orderMap.get("reportqty");
            if (orderBaseQty.compareTo(BigDecimal.ZERO) == 0) {
                orderBaseQty = BigDecimal.ONE;
            }
            BigDecimal demandBaseQty = stockEntry.getBigDecimal("demandqty");
            String qtytype = stockEntry.getString("qtytype");
            if ("A".equals(qtytype) || "C".equals(qtytype)) {
                useQty = reportQty.multiply(demandBaseQty).divide(orderBaseQty, 8, 4);
            }
            if ("B".equals(qtytype)) {
                useQty = reportQty.compareTo(orderBaseQty) >= 0 ? demandBaseQty : BigDecimal.ZERO;
            }
        }
        return useQty;
    }

    public BigDecimal aculUseQtyC(DynamicObject stockEntry, Object orderEntryId, String orderName) {
        BigDecimal useQty = BigDecimal.ZERO;
        BigDecimal demandBaseQty = stockEntry.getBigDecimal("demandqty");
        DynamicObject manftechDym = this.getManufTechDy(orderEntryId, orderName);
        if (manftechDym == null) {
            return useQty;
        }
        String processseq = stockEntry.getString("processseq");
        String oprno = stockEntry.getString("oprno");
        DynamicObjectCollection workPlanEntrys = manftechDym.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject workPlanEntry : workPlanEntrys) {
            if (!processseq.equals(workPlanEntry.getString("oprparent")) || !oprno.equals(workPlanEntry.getString("oprno"))) continue;
            BigDecimal orderBaseQty = this.getOrderBaseQty(orderEntryId, orderName);
            BigDecimal oprtotalReportQty = workPlanEntry.getBigDecimal("oprtotalreportbaseqty");
            String qtytype = stockEntry.getString("qtytype");
            if ("A".equals(qtytype) || "C".equals(qtytype)) {
                useQty = oprtotalReportQty.multiply(demandBaseQty).divide(orderBaseQty, 8, 4);
            }
            if (!"B".equals(qtytype)) continue;
            if (oprtotalReportQty.compareTo(orderBaseQty) >= 0) {
                useQty = demandBaseQty;
                continue;
            }
            useQty = BigDecimal.ZERO;
        }
        return useQty;
    }

    private DynamicObject getManufTechDy(Object orderEntryId, String orderName) {
        String orderKeys = String.valueOf(orderEntryId) + orderName;
        HashMap<String, DynamicObject> techMap = new HashMap<String, DynamicObject>();
        DynamicObject manftechDym = (DynamicObject)techMap.get(orderKeys);
        QFilter filter = new QFilter("mftentryseq", "=", orderEntryId);
        manftechDym = BusinessDataServiceHelper.loadSingle((String)EntityNameUtils.getEntityName(0, 2, orderName), (String)"baseqty,oprentryentity.oprtotalreportqty,oprentryentity.oprtotalreportbaseqty,oprentryentity.oprparent,oprentryentity.oprno", (QFilter[])new QFilter[]{filter});
        techMap.put(orderKeys, manftechDym);
        return manftechDym;
    }

    public BigDecimal getOrderBaseQty(Object orderEntryId, String orderName) {
        Map<String, Object> orderMap = this.getOrderQtyMap(orderEntryId, orderName);
        if (orderMap.isEmpty()) {
            return BigDecimal.ONE;
        }
        BigDecimal orderBaseQty = BigDecimal.ONE;
        orderBaseQty = (BigDecimal)orderMap.get("baseqty");
        if (orderBaseQty.compareTo(BigDecimal.ZERO) == 0) {
            orderBaseQty = BigDecimal.ONE;
        }
        return orderBaseQty;
    }

    private BillShowParameter createAddNewBillShowParam(List<String> billnos, Object pkID) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("im_mdc_ombackflushform");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCustomParam("bfBillnosList", billnos);
        showParameter.setCustomParam("productionOrg", pkID);
        showParameter.setCustomParam("billType", (Object)"im_mdc_omcmplinbill");
        return showParameter;
    }
}

