/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.xmftreqbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.formplugin.mdc.xmftreqbill.ChangeObject;

public class XMftReqUtils {
    private static final Log logger = LogFactory.getLog(XMftReqUtils.class);

    private XMftReqUtils() {
    }

    public static List<String> getChangeEntryFields() {
        ArrayList<String> keys = new ArrayList<String>(16);
        QFilter q = new QFilter("number", "=", (Object)"1_S");
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"im_mdc_xmftreqconfig", (String)"propertytype,propertyname,propertyid", (QFilter[])new QFilter[]{q});
        for (Map.Entry m : loadFromCache.entrySet()) {
            DynamicObject value = (DynamicObject)m.getValue();
            DynamicObjectCollection billentry = value.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billentry) {
                keys.add(entry.getString("propertyid"));
            }
        }
        return keys;
    }

    public static void afterLog(AfterOperationArgs e) {
        DynamicObject[] reqChangeBills = e.getDataEntities();
        XMftReqUtils.validateLogIsExistAndDelete(reqChangeBills);
        ArrayList<DynamicObject> saveLogList = new ArrayList<DynamicObject>(16);
        List<String> changeEntryFields = XMftReqUtils.getChangeEntryFields();
        Map<Long, DynamicObject> reqIdDymMap = XMftReqUtils.getReqIdDymMap(reqChangeBills, changeEntryFields);
        for (int i = 0; i < reqChangeBills.length; ++i) {
            DynamicObject reqChangeBill = reqChangeBills[i];
            DynamicObjectCollection entryCol = reqChangeBill.getDynamicObjectCollection("billentry");
            for (int j = 0; j < entryCol.size(); ++j) {
                DynamicObject reqChangeEntry = (DynamicObject)entryCol.get(j);
                DynamicObject reqLog = XMftReqUtils.getChangeLog(reqChangeBill, reqChangeEntry, reqIdDymMap, changeEntryFields);
                if (null == reqLog) continue;
                saveLogList.add(reqLog);
            }
        }
        if (!saveLogList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveLogList.toArray(new DynamicObject[saveLogList.size()]));
        }
    }

    private static DynamicObject getChangeLog(DynamicObject reqChangeBill, DynamicObject reqChangeEntry, Map<Long, DynamicObject> reqIdDymMap, List<String> changeEntryFields) {
        String changeType = reqChangeEntry.getString("entrychangetype");
        DynamicObject reqBill = reqIdDymMap.get(reqChangeBill.getLong("reqbillid"));
        if (reqBill != null) {
            DynamicObjectCollection reqEntrys = reqBill.getDynamicObjectCollection("billentry");
            List<Object> changeFieldList = new ArrayList();
            if (StringUtils.equals((CharSequence)"B", (CharSequence)changeType)) {
                Long reqEntryId = reqChangeEntry.getLong("srcbillentryid");
                DynamicObject reqEntry = XMftReqUtils.getReqEntry(reqEntrys, reqEntryId);
                if (reqEntry != null) {
                    changeFieldList = XMftReqUtils.getChangeFieldList(reqEntry, reqChangeEntry, changeEntryFields);
                }
            } else {
                changeFieldList = XMftReqUtils.getChangeFieldList(null, reqChangeEntry, changeEntryFields);
            }
            return XMftReqUtils.addChangeLog(changeFieldList, reqChangeEntry, reqChangeBill);
        }
        return null;
    }

    private static DynamicObject addChangeLog(List<ChangeObject> changeFieldList, DynamicObject reqChangeEntry, DynamicObject reqChangeBill) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"im_mdc_mrbchangelog");
        DynamicObject xmftreqlog = (DynamicObject)dt.createInstance();
        xmftreqlog.set("org", reqChangeBill.get("org"));
        xmftreqlog.set("reqbillno", reqChangeBill.get("reqbillno"));
        xmftreqlog.set("mftreqentryf7", reqChangeEntry.get("srcbillentryid"));
        xmftreqlog.set("xreqbillno", reqChangeBill.get("billno"));
        xmftreqlog.set("creator", reqChangeBill.get("creator"));
        xmftreqlog.set("createtime", reqChangeBill.get("createtime"));
        xmftreqlog.set("changestatus", (Object)"A");
        xmftreqlog.set("reason", reqChangeBill.get("reason"));
        xmftreqlog.set("xreqentryid", reqChangeEntry.getPkValue());
        xmftreqlog.set("reqbillid", reqChangeBill.get("reqbillid"));
        xmftreqlog.set("xreqbillid", reqChangeBill.getPkValue());
        String entrychangetype = reqChangeEntry.getString("entrychangetype");
        DynamicObjectCollection entryentity = xmftreqlog.getDynamicObjectCollection("billentry");
        DynamicObject addNew = entryentity.addNew();
        XMftReqUtils.createReqChangeLogEntry(reqChangeEntry, changeFieldList, entrychangetype, addNew);
        return xmftreqlog;
    }

    private static void createReqChangeLogEntry(DynamicObject reqChangeEntry, List<ChangeObject> changeFieldList, String entrychangetype, DynamicObject addNew) {
        addNew.set("entrychangetype", reqChangeEntry.get("entrychangetype"));
        addNew.set("reqentryf7", reqChangeEntry.getPkValue());
        DynamicObject materialUnitid = reqChangeEntry.getDynamicObject("unit");
        int precision = materialUnitid == null ? 4 : materialUnitid.getInt("precision");
        for (ChangeObject changeObject : changeFieldList) {
            String colName;
            DataEntityPropertyCollection properties = addNew.getDynamicObjectType().getProperties();
            boolean containsKey = properties.containsKey((Object)(colName = changeObject.getColName()));
            if (!containsKey) continue;
            Object newValue = changeObject.getNewValue();
            Object oldValue = changeObject.getOldValue();
            XMftReqUtils.repalce(oldValue, newValue, colName, addNew, precision);
        }
    }

    public static void repalce(Object oldValue, Object newValue, String colName, DynamicObject addNew, int precision) {
        String oldValueAndNewValue = XMftReqUtils.getOldValueAndNewValue(oldValue, newValue, colName, precision);
        String[] split = oldValueAndNewValue.split(",");
        String oldValueString = "";
        String newValueString = "";
        if (split.length == 1) {
            oldValueString = oldValueAndNewValue.substring(0, oldValueAndNewValue.indexOf(44));
            newValueString = oldValueAndNewValue.substring(oldValueAndNewValue.indexOf(44) + 1, oldValueAndNewValue.length());
        } else if (split.length == 2) {
            oldValueString = split[0];
            newValueString = split[1];
        }
        if (StringUtils.isBlank((CharSequence)oldValueString)) {
            oldValueString = ResManager.loadKDString((String)"\u65e0", (String)"XMftReqUtils_0", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)newValueString)) {
            newValueString = ResManager.loadKDString((String)"\u65e0", (String)"XMftReqUtils_0", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        }
        String colValue = oldValueString + "->" + newValueString;
        if (StringUtils.equals((CharSequence)oldValueString, (CharSequence)newValueString)) {
            addNew.set(colName, (Object)newValueString);
        } else {
            if (oldValue instanceof BigDecimal) {
                if (new BigDecimal(oldValueString).compareTo(new BigDecimal(newValueString)) < 0) {
                    colValue = colValue + " \u2191";
                } else if (new BigDecimal(newValueString).compareTo(new BigDecimal(oldValueString)) < 0) {
                    colValue = colValue + " \u2193";
                }
            }
            try {
                addNew.set(colName, (Object)colValue);
            }
            catch (Exception e) {
                logger.info("\u53d8\u66f4\u65e5\u5fd7colName:" + colName + "--" + colValue);
                throw e;
            }
        }
    }

    public static String getOldValueAndNewValue(Object oldValue, Object newValue, String colName, int precision) {
        String oldValueString = "";
        String newValueString = "";
        if (oldValue instanceof BigDecimal) {
            int scale = ((BigDecimal)newValue).scale();
            int scalePrecision = scale > precision ? precision : scale;
            BigDecimal newValueBigDecimal = ((BigDecimal)newValue).setScale(scalePrecision, 4);
            BigDecimal oldValueBigDecimal = ((BigDecimal)oldValue).setScale(scalePrecision, 4);
            oldValueString = oldValueBigDecimal.toEngineeringString();
            newValueString = newValueBigDecimal.toEngineeringString();
        } else {
            oldValueString = oldValue.toString();
            newValueString = newValue.toString();
        }
        return oldValueString + "," + newValueString;
    }

    private static List<ChangeObject> getChangeFieldList(DynamicObject reqEntry, DynamicObject reqChangeEntry, List<String> changeEntryFields) {
        ArrayList<ChangeObject> changelist = new ArrayList<ChangeObject>(16);
        for (String reqField : changeEntryFields) {
            Object reqfield = XMftReqUtils.getreqChangeField(reqField, reqEntry);
            Object reqchangefield = XMftReqUtils.getreqChangeField(reqField, reqChangeEntry);
            XMftReqUtils.setChangeFieldList(changelist, reqfield, reqchangefield, reqField);
        }
        return changelist;
    }

    private static void setChangeFieldList(List<ChangeObject> changelist, Object reqfield, Object reqchangefield, String reqField) {
        ChangeObject changefield = new ChangeObject();
        changefield.setColName(reqField);
        changefield.setNewValue(XMftReqUtils.getValue(reqField, reqchangefield));
        changefield.setOldValue(XMftReqUtils.getValue(reqField, reqfield));
        changelist.add(changefield);
    }

    private static Object getValue(String reqField, Object reqchangefield) {
        Object value;
        if (reqchangefield instanceof DynamicObject) {
            DynamicObject dym = (DynamicObject)reqchangefield;
            value = "delivercycle".equals(reqField) ? (dym.get("deliverytime") == null ? "" : XMftReqUtils.getVideoFormat(dym.getLong("deliverytime"))) : (dym.getDynamicObjectType().getProperties().containsKey((Object)"name") ? dym.getString("name") : (dym.getDynamicObjectType().getProperties().containsKey((Object)"number") ? dym.getString("number") : dym.getPkValue()));
        } else {
            value = reqchangefield;
        }
        return value;
    }

    public static String getVideoFormat(Long time) {
        int temp = time.intValue();
        int hh = temp / 3600;
        int mm = temp % 3600 / 60;
        int ss = temp % 3600 % 60;
        return (hh < 10 ? "0" + hh : Integer.valueOf(hh)) + ":" + (mm < 10 ? "0" + mm : Integer.valueOf(mm)) + ":" + (ss < 10 ? "0" + ss : Integer.valueOf(ss));
    }

    private static Object getreqChangeField(String reqField, DynamicObject reqEntry) {
        if (reqEntry == null) {
            return "";
        }
        Object reqchangefield = reqEntry.get(reqField);
        if (StringUtils.isBlank((Object)reqchangefield)) {
            reqchangefield = "";
        }
        return reqchangefield;
    }

    private static DynamicObject getReqEntry(DynamicObjectCollection reqEntrys, Long reqEntryId) {
        for (DynamicObject reqEntry : reqEntrys) {
            if (!reqEntryId.equals(reqEntry.getPkValue())) continue;
            return reqEntry;
        }
        return null;
    }

    public static void validateLogIsExistAndDelete(DynamicObject[] reqChangeBills) {
        ORMImpl impl = new ORMImpl();
        ArrayList<Object> entryPks = new ArrayList<Object>(16);
        for (DynamicObject reqChangeBill : reqChangeBills) {
            DynamicObjectCollection entryCol = reqChangeBill.getDynamicObjectCollection("billentry");
            for (DynamicObject entryDym : entryCol) {
                entryPks.add(entryDym.getPkValue());
            }
        }
        QFilter qFilter = new QFilter("xreqentryid", "in", entryPks);
        boolean exists = impl.exists("im_mdc_mrbchangelog", new QFilter[]{qFilter});
        if (exists) {
            DeleteServiceHelper.delete((String)"im_mdc_mrbchangelog", (QFilter[])new QFilter[]{qFilter});
        }
    }

    public static Map<Long, DynamicObject> getReqIdDymMap(DynamicObject[] objs, List<String> changeEntryFields) {
        DynamicObject[] loads;
        HashSet<Long> reqBillIdSet = new HashSet<Long>(16);
        for (DynamicObject obj : objs) {
            reqBillIdSet.add(obj.getLong("reqbillid"));
        }
        HashMap<Long, DynamicObject> reqIdDymMap = new HashMap<Long, DynamicObject>(16);
        QFilter q = new QFilter("id", "in", reqBillIdSet);
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)"im_mdc_mftreqbill", (String)("rowstatus,useoutqty,qty,billstatus,closer,closedate," + XMftReqUtils.getSelectPro(changeEntryFields)), (QFilter[])new QFilter[]{q})) {
            reqIdDymMap.put((Long)load.getPkValue(), load);
        }
        return reqIdDymMap;
    }

    private static String getSelectPro(List<String> changeEntryFields) {
        StringBuilder sb = new StringBuilder();
        if (!changeEntryFields.isEmpty()) {
            sb.append(changeEntryFields.get(0));
            if (changeEntryFields.size() > 1) {
                for (int i = 1; i < changeEntryFields.size(); ++i) {
                    sb.append(",");
                    sb.append(changeEntryFields.get(i));
                }
            }
        }
        return sb.toString();
    }

    public static void setFieldsValue(DynamicObjectCollection billentrys, DynamicObjectCollection srcbillentrys, List<String> changeEntryFields) {
        for (DynamicObject billentry : billentrys) {
            String entrychangetype = billentry.getString("entrychangetype");
            BigDecimal baseqty = billentry.getBigDecimal("baseqty");
            BigDecimal srcbaseqty = billentry.getBigDecimal("srcbaseqty");
            if (!"B".equals(entrychangetype)) continue;
            for (DynamicObject srcbillentry : srcbillentrys) {
                if (!billentry.get("srcbillentryid").equals(srcbillentry.getPkValue())) continue;
                for (String field : changeEntryFields) {
                    if (baseqty.compareTo(srcbaseqty) >= 0 && (field.equals("qty") || field.equals("baseqty") || field.equals("auditqty") || field.equals("auditbaseqty"))) continue;
                    srcbillentry.set(field, billentry.get(field));
                }
            }
        }
    }

    public static Map<String, DynamicObject> getReqChangeMap(DynamicObject[] reqChangeBills, String reqChangeName) {
        DynamicObject[] reqDyms;
        HashMap<String, DynamicObject> reqChangeMap = new HashMap<String, DynamicObject>(16);
        HashSet<Long> reqChangeIdList = new HashSet<Long>();
        for (DynamicObject reqChangeBill : reqChangeBills) {
            if ("0".equals(reqChangeBill.getPkValue().toString())) continue;
            reqChangeIdList.add((Long)reqChangeBill.getPkValue());
        }
        for (DynamicObject reqDym : reqDyms = BusinessDataServiceHelper.load((String)reqChangeName, (String)XMftReqUtils.getSelectPro(XMftReqUtils.getChangeEntryFields()), (QFilter[])new QFilter[]{new QFilter("id", "in", reqChangeIdList)})) {
            reqChangeMap.put(reqDym.getPkValue().toString(), reqDym);
        }
        return reqChangeMap;
    }

    public static Map<Long, Boolean> getReqIdChangeMap(DynamicObject[] reqChangeBills, String reqChangeName) {
        DynamicObject[] reqChangeDyms;
        HashMap<Long, Boolean> reqNoDymMap = new HashMap<Long, Boolean>(16);
        HashSet<Long> reqBillIdSet = new HashSet<Long>(16);
        for (DynamicObject obj : reqChangeBills) {
            reqBillIdSet.add(obj.getLong("reqbillid"));
        }
        for (DynamicObject reqChangeDym : reqChangeDyms = BusinessDataServiceHelper.load((String)reqChangeName, (String)"reqbillid", (QFilter[])new QFilter[]{new QFilter("reqbillid", "in", reqBillIdSet).and(new QFilter("billstatus", "!=", (Object)"C"))})) {
            reqNoDymMap.put(reqChangeDym.getLong("reqbillid"), true);
        }
        return reqNoDymMap;
    }

    public static boolean changeExistUnAuditChange(DynamicObject manuChangeBill, Map<Long, Boolean> reqIdChangeMap) {
        Boolean isExit = reqIdChangeMap.get(manuChangeBill.getLong("reqbillid"));
        if (null == isExit) {
            return false;
        }
        return isExit;
    }

    public static void autoClose(DynamicObject[] array) {
        DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)"id");
        Date now = TimeServiceHelper.now();
        for (DynamicObject bill : array) {
            int label = 1;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                BigDecimal useoutqty = entry.getBigDecimal("useoutqty");
                BigDecimal qty = entry.getBigDecimal("qty");
                if (qty.compareTo(useoutqty) == 0) {
                    entry.set("rowstatus", (Object)"D");
                }
                if (entry.getString("rowstatus").equals("D")) continue;
                label = 2;
            }
            if (label != true) continue;
            bill.set("billstatus", (Object)"D");
            bill.set("closer", (Object)currentUser);
            bill.set("closedate", (Object)now);
        }
    }
}

