/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.mdc;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.mservice.api.mdc.MdcCalMaterialQtyService;
import org.apache.commons.lang3.ObjectUtils;

public class MdcCalMaterialQtyServiceImpl
implements MdcCalMaterialQtyService {
    private static final Log logger = LogFactory.getLog(MdcCalMaterialQtyServiceImpl.class);

    @Override
    public Map<String, BigDecimal[]> claMaterialforpurOrder(Object orderEntryId) {
        logger.info("\u8c03\u7528\u5fae\u670d\u52a1\u5f00\u59cb\u8ba1\u7b97");
        if (null == orderEntryId) {
            logger.info("\u5165\u53c2\u5de5\u5355id\u4e3a\u7a7a");
            return null;
        }
        QFilter qfilter = new QFilter("orderentryid", "=", orderEntryId);
        boolean isExists = QueryServiceHelper.exists((String)"om_componentlist", (QFilter[])new QFilter[]{qfilter});
        if (!isExists) {
            return null;
        }
        DynamicObject[] ds = BusinessDataServiceHelper.load((String)"om_componentlist", (String)"orderentryid", (QFilter[])new QFilter[]{qfilter});
        if (ds.length > 0) {
            return MdcCalMaterialQtyServiceImpl.calMaterialqty(ds[0]);
        }
        return null;
    }

    private static Map<String, BigDecimal[]> calMaterialqty(DynamicObject dynamicObject) {
        HashMap<String, BigDecimal[]> materialPropor = new HashMap<String, BigDecimal[]>();
        DynamicObject stockInfo = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getPkValue(), (String)dynamicObject.getDataEntityType().getName());
        BigDecimal baseqty = MdcCalMaterialQtyServiceImpl.getBigDecimal(stockInfo.getBigDecimal("baseqty"));
        logger.info("\u8868\u5934\u57fa\u672c\u6570\u91cf:" + baseqty);
        DynamicObjectCollection stocks = stockInfo.getDynamicObjectCollection("stockentry");
        for (int i = 0; i < stocks.size(); ++i) {
            StringBuilder keyStr = new StringBuilder();
            DynamicObject stockentry = (DynamicObject)stocks.get(i);
            long useratio = stockentry.getLong("useratio");
            BigDecimal qtynumerator = MdcCalMaterialQtyServiceImpl.getBigDecimal(stockentry.getBigDecimal("qtynumerator"));
            if (0L == useratio || BigDecimal.ZERO.compareTo(qtynumerator) == 0) continue;
            BigDecimal demandqty = MdcCalMaterialQtyServiceImpl.getBigDecimal(stockentry.getBigDecimal("demandqty"));
            Object materialPk = stockentry.getDynamicObject("materialid").getDynamicObject("masterid").getPkValue();
            keyStr.append(materialPk);
            MdcCalMaterialQtyServiceImpl.appendKey(keyStr, stockentry, "entryconfiguredcode");
            MdcCalMaterialQtyServiceImpl.appendKey(keyStr, stockentry, "childauxpropertyid");
            MdcCalMaterialQtyServiceImpl.appendKey(keyStr, stockentry, "bomreversion");
            String qtytype = stockentry.getString("qtytype");
            String issuemode = stockentry.getString("issuemode");
            if ("C".equals(issuemode)) continue;
            if ("B".equals(qtytype)) {
                BigDecimal actissueqty = MdcCalMaterialQtyServiceImpl.getBigDecimal(stockentry.getBigDecimal("actissueqty"));
                BigDecimal rejectedqty = MdcCalMaterialQtyServiceImpl.getBigDecimal(stockentry.getBigDecimal("rejectedqty"));
                BigDecimal feedingqty = MdcCalMaterialQtyServiceImpl.getBigDecimal(stockentry.getBigDecimal("feedingqty"));
                BigDecimal result = actissueqty.subtract(rejectedqty).add(feedingqty);
                if (result.compareTo(demandqty) >= 0) continue;
                logger.info("\u5b58\u5728\u56fa\u5b9a\u7528\u6599\u672a\u5b8c\u5168\u9886\u6599\uff0c\u4e0d\u5141\u8bb8\u7ee7\u7eed\u6838\u9500");
                return null;
            }
            BigDecimal[] proportion = new BigDecimal[]{demandqty, baseqty};
            logger.info("\u9700\u6c42\u57fa\u672c\u6570\u91cf:" + demandqty);
            String key = keyStr.toString();
            if (materialPropor.containsKey(key)) {
                proportion[0] = ((BigDecimal[])materialPropor.get(key))[0].add(demandqty);
            }
            materialPropor.put(key, proportion);
        }
        logger.info("\u5fae\u670d\u52a1\u8ba1\u7b97\u7269\u6599\u6bd4\u4f8b\u4e3a\uff1a" + JSONObject.toJSONString(materialPropor));
        return materialPropor;
    }

    private static void appendKey(StringBuilder keyStr, DynamicObject stockentry, String field) {
        DynamicObject dymObj = stockentry.getDynamicObject(field);
        if (ObjectUtils.isNotEmpty((Object)dymObj)) {
            keyStr.append(",").append(dymObj.getPkValue());
        }
    }

    private static BigDecimal getBigDecimal(BigDecimal num) {
        return num.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : num;
    }
}

