/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.mdc;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.ImBillBotpHelp;
import kd.scmc.im.business.helper.InvSchemeHelper;
import kd.scmc.im.common.mdc.utils.AutoBackFlushUtils;
import kd.scmc.im.common.mdc.utils.StockBackFlushUtils;
import kd.scmc.im.formplugin.mdc.mftreqbill.WorkcenterWarehouseUtils;
import kd.scmc.im.mservice.api.mdc.MdcCheckMftorderService;

public class MdcCheckMftorderServiceImpl
implements MdcCheckMftorderService {
    private static final String MftManuInBill = "im_mdc_mftmanuinbill";
    private static final String MFTPROORDER = "im_mdc_mftproorder";
    private static final String OMPROORDER = "im_mdc_omproorder";

    @Override
    public boolean isExistsNext(Object pkValue, String key, String billtype) throws KDException {
        if (pkValue == null) {
            return false;
        }
        ORM orm = ORM.create();
        QFilter qfilter = new QFilter("billentry.manuentryid", "=", pkValue);
        qfilter.and(new QFilter("billtype.number", "=", (Object)billtype));
        boolean isExistsOutBill = orm.exists(key, new QFilter[]{qfilter});
        return isExistsOutBill;
    }

    @Override
    public boolean isExistsMaterialReq(Object pkValue) throws KDException {
        if (pkValue == null) {
            return false;
        }
        ORM orm = ORM.create();
        QFilter qfilter = new QFilter("billentry.manuentryid", "=", pkValue);
        QFilter qfilter_1 = new QFilter("billtype.billformid", "=", (Object)MFTPROORDER);
        QFilter qfilter_2 = new QFilter("billstatus", "=", (Object)"C");
        boolean isExistsOutBill = orm.exists(MFTPROORDER, new QFilter[]{qfilter, qfilter_1, qfilter_2});
        return isExistsOutBill;
    }

    @Override
    public HashMap<String, Object> getInvSchemeInfo(DynamicObject invScheme, DynamicObject supplyowner) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (invScheme == null) {
            result.put("success", Boolean.FALSE);
            return result;
        }
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        result.put("isInUpdate", isInUpdate);
        result.put("isOutUpdate", isOutUpdate);
        if (isInUpdate) {
            String ownerType = invScheme.getString("ownertype");
            String keeperType = invScheme.getString("keepertype");
            DynamicObject invStatus = invScheme.getDynamicObject("invstatus");
            DynamicObject invType = InvSchemeHelper.getDefaltInvtype((DynamicObject)invScheme);
            Object invStatusId = invStatus == null ? null : invStatus.getPkValue();
            Object invTypeId = invType == null ? null : invType.getPkValue();
            result.put("ownerType", ownerType);
            result.put("keeperType", keeperType);
            result.put("invStatusId", invStatusId);
            result.put("invTypeId", invTypeId);
        }
        if (isOutUpdate) {
            String outOwnerType = invScheme.getString("outownertype");
            String outKeeperType = invScheme.getString("outkeepertype");
            DynamicObject outInvStatus = invScheme.getDynamicObject("outinvstatus");
            DynamicObject outInvType = InvSchemeHelper.getDefaltOutInvtype((DynamicObject)invScheme);
            Object outInvStatusId = outInvStatus == null ? null : outInvStatus.getPkValue();
            Object outInvTypeId = outInvType == null ? null : outInvType.getPkValue();
            result.put("outOwnerType", outOwnerType);
            result.put("outKeeperType", outKeeperType);
            result.put("outInvStatusId", outInvStatusId);
            result.put("outInvTypeId", outInvTypeId);
        }
        Long ownerId = (Long)supplyowner.getPkValue();
        Long keeperId = (Long)supplyowner.getPkValue();
        Long outOwnerId = (Long)supplyowner.getPkValue();
        Long outKeeperId = (Long)supplyowner.getPkValue();
        result.put("ownerId", ownerId);
        result.put("keeperId", keeperId);
        result.put("outOwnerId", outOwnerId);
        result.put("outKeeperId", outKeeperId);
        result.put("success", Boolean.TRUE);
        return result;
    }

    private static DynamicObject getAccountByOrg(Long orgId, String orgType) {
        if (orgId == null) {
            return null;
        }
        List idList = OrgUnitServiceHelper.getFromOrgs((String)orgType, (Long)orgId, (String)"10");
        DynamicObject account = null;
        if (idList != null && !idList.isEmpty()) {
            Object settleOrgId = idList.get(0);
            account = BusinessDataServiceHelper.loadSingle(settleOrgId, (String)"bos_org");
        }
        return account;
    }

    @Override
    public DynamicObject setProp(String tgtMainType, DynamicObject obj, DynamicObjectCollection entry) {
        DynamicObject org = obj.getDynamicObject("org");
        DynamicObject shipper = obj.getDynamicObject("supplyowner");
        if (org != null && shipper == null) {
            shipper = MdcCheckMftorderServiceImpl.getAccountByOrg(org.getLong("id"), "05");
            obj.set("supplyowner", (Object)shipper);
        }
        ImBillBotpHelp.setDefultVaule((String)tgtMainType, (DynamicObject)obj);
        DynamicObject invScheme = obj.getDynamicObject("invscheme");
        ImBillBotpHelp.dealEntryScheme((DynamicObject)obj, (DynamicObjectCollection)entry, (DynamicObject)invScheme);
        if (org != null) {
            Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)((Long)org.getPkValue()));
            if (map == null) {
                return null;
            }
            obj.set("settlecurrency", (Object)BusinessDataServiceHelper.loadSingle(map.get("baseCurrencyID"), (String)"bd_currency"));
        }
        return obj;
    }

    @Override
    public DynamicObject addprop(String tgtMainType, DynamicObject obj) {
        DynamicObject org = obj.getDynamicObject("org");
        DynamicObject shipper = obj.getDynamicObject("shipper");
        if (org != null && shipper == null) {
            shipper = MdcCheckMftorderServiceImpl.getAccountByOrg(org.getLong("id"), "05");
            obj.set("shipper", (Object)shipper);
        }
        ImBillBotpHelp.setDefultVaule((String)tgtMainType, (DynamicObject)obj);
        DynamicObject invScheme = obj.getDynamicObject("invscheme");
        DynamicObjectCollection entrycoll = obj.getDynamicObjectCollection("billentry");
        ImBillBotpHelp.dealEntryScheme((DynamicObject)obj, (DynamicObjectCollection)entrycoll, (DynamicObject)invScheme);
        if (org != null) {
            Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)((Long)org.getPkValue()));
            if (map == null) {
                return obj;
            }
            obj.set("settlecurrency", (Object)BusinessDataServiceHelper.loadSingle(map.get("baseCurrencyID"), (String)"bd_currency"));
        }
        return obj;
    }

    @Override
    public Map<Long, String> batchAutoBackFlush(List<Map<String, Object>> bfParam, boolean isOpenTX) {
        return AutoBackFlushUtils.backFlushbatchTX(bfParam, isOpenTX);
    }

    @Override
    public void batchBackFlushClose(Map<Object, Object> info, String bill) {
        StockBackFlushUtils.batchBackFlushClose(info, bill, "pom_mftstock");
    }

    @Override
    public void batchBackFlushClose(Map<Object, Object> info, String bill, String entityName) {
        StockBackFlushUtils.batchBackFlushClose(info, bill, entityName);
    }

    @Override
    public void updateReqWarehouseInfo(Set<Long> projectIdSet, Long orgId) throws ParseException {
        WorkcenterWarehouseUtils.updateReqWarehouseInfo(projectIdSet, orgId);
    }
}

