/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.mdc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.consts.APVerifyAsstEntryModel;
import kd.scmc.im.consts.APVerifyEntryModel;
import kd.scmc.im.enums.PrecisionAccountEnum;
import kd.scmc.im.mservice.api.mdc.MdcOminWriteOffService;

public class MdcOminWriteOffServiceImpl
implements MdcOminWriteOffService {
    private static final Log logger = LogFactory.getLog(MdcOminWriteOffServiceImpl.class);
    private static final String ENTITY_OMINBILL = "im_mdc_ominbill";

    @Override
    public void OminVerify(List<Map<String, Object>> disposeList) throws KDException {
        if (disposeList == null || disposeList.isEmpty()) {
            return;
        }
        boolean isVerify = true;
        Map<Long, APVerifyEntryModel> verifyEntryModelMap = this.buildVerifyModel(disposeList, isVerify);
        ArrayList<Object[]> purInBillParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> purBillParamList = new ArrayList<Object[]>();
        for (APVerifyEntryModel verifyEntryModel : verifyEntryModelMap.values()) {
            MdcOminWriteOffServiceImpl.addPurInBillRWParam(verifyEntryModel, purInBillParamList);
            MdcOminWriteOffServiceImpl.addPurBillRWParam(verifyEntryModel, purBillParamList);
        }
        try (TXHandle h = TX.required();){
            try {
                String sql;
                if (!purInBillParamList.isEmpty() && !this.isCommon(disposeList.get(0))) {
                    sql = " update t_im_mdc_ominbillentry_r set  funverifyqty = funverifyqty-?, fverifyqty = fverifyqty+?,   funverifybaseqty = funverifybaseqty-?, fverifybaseqty = fverifybaseqty+?,  fremainjoinpriceqty = fremainjoinpriceqty-?, fjoinpriceqty = fjoinpriceqty+?,  fremainjoinpricebaseqty = fremainjoinpricebaseqty-?, fjoinpricebaseqty = fjoinpricebaseqty+?  where fentryid=?";
                    DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, purInBillParamList);
                }
                if (!purBillParamList.isEmpty() && !"ominself".equals(disposeList.get(0).get("verifyrelation"))) {
                    sql = "update t_pm_om_purbillentry_r set fpayablepriceqty = fpayablepriceqty+?, fpayableamount= fpayableamount+? where fentryid in (select fentryid from t_pm_om_purbillentry where fentryid = ? And fentrysettleorgid = ? )";
                    DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, purBillParamList);
                }
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    private boolean isCommon(Map<String, Object> map) {
        if (map.containsKey("ismscommon")) {
            return (Boolean)map.get("ismscommon");
        }
        return false;
    }

    private static void addPurInBillRWParam(APVerifyEntryModel verifyEntryModel, List<Object[]> paramList) {
        String entity = verifyEntryModel.getEntity();
        if (!ENTITY_OMINBILL.equals(entity)) {
            return;
        }
        long entryPk = verifyEntryModel.getEntryPk();
        BigDecimal verifyQty = verifyEntryModel.getVerifyQty();
        BigDecimal verifyBaseQty = verifyEntryModel.getVerifyBaseQty();
        BigDecimal joinPriceQty = verifyEntryModel.getJoinPriceQty();
        BigDecimal joinPriceBaseQty = verifyEntryModel.getJoinPriceBaseQty();
        Object[] param = new Object[]{verifyQty, verifyQty, verifyBaseQty, verifyBaseQty, joinPriceQty, joinPriceQty, joinPriceBaseQty, joinPriceBaseQty, entryPk};
        paramList.add(param);
    }

    private static void addPurBillRWParam(APVerifyEntryModel verifyEntryModel, List<Object[]> paramList) {
        Long mainBillEntryid = verifyEntryModel.getMainBillEntryid();
        if (mainBillEntryid != null && mainBillEntryid != 0L) {
            BigDecimal verifyQty = verifyEntryModel.getVerifyQty();
            BigDecimal verifyAmt = verifyEntryModel.getVerifyAmt();
            Long orgid = verifyEntryModel.getOrgid();
            Object[] outForOrderParam = new Object[]{verifyQty, verifyAmt, mainBillEntryid, orgid};
            paramList.add(outForOrderParam);
        }
    }

    private Map<Long, APVerifyEntryModel> buildVerifyModel(List<Map<String, Object>> disposeList, boolean isVerify) {
        QFilter inForPoQF;
        DynamicObjectCollection inForPoBills;
        HashMap<Long, APVerifyEntryModel> verifyEntryModelMap = new HashMap<Long, APVerifyEntryModel>(disposeList.size());
        ArrayList<Long> inForPo = new ArrayList<Long>();
        for (Map<String, Object> dispose : disposeList) {
            logger.info("\u6784\u5efa\u6838\u9500\u6a21\u578b\u5165\u53c2dispose: Key:" + StringUtils.join((Object[])dispose.keySet().toArray(), (String)",") + " Value:" + StringUtils.join((Object[])dispose.values().toArray(), (String)","));
            APVerifyEntryModel entryModel = MdcOminWriteOffServiceImpl.getVerifyEntryModel(dispose);
            logger.info("\u6784\u5efa\u6838\u9500\u6a21\u578b: entryModel:" + entryModel.toString());
            Long entryModelPk = entryModel.getEntryPk();
            APVerifyEntryModel unVerifyEntryModel = (APVerifyEntryModel)verifyEntryModelMap.get(entryModelPk);
            if (unVerifyEntryModel != null) {
                entryModel.setVerifyQty(entryModel.getVerifyQty().add(unVerifyEntryModel.getVerifyQty()));
                entryModel.setVerifyBaseQty(entryModel.getVerifyBaseQty().add(unVerifyEntryModel.getVerifyBaseQty()));
                entryModel.setVerifyAmt(entryModel.getVerifyAmt().add(unVerifyEntryModel.getVerifyAmt()));
                List unVerifyEntryModelAsstEntry = unVerifyEntryModel.getAsstEntrys();
                if (!unVerifyEntryModelAsstEntry.isEmpty()) {
                    entryModel.getAsstEntrys().addAll(unVerifyEntryModelAsstEntry);
                }
            }
            verifyEntryModelMap.put(entryModelPk, entryModel);
            if (!ENTITY_OMINBILL.equals(entryModel.getEntity()) || inForPo.contains(entryModelPk)) continue;
            inForPo.add(entryModelPk);
        }
        Map<Long, List<Long>> purInApEntryMap = MdcOminWriteOffServiceImpl.getApEntryList(ENTITY_OMINBILL, inForPo);
        if (!inForPo.isEmpty() && (inForPoBills = QueryServiceHelper.query((String)ENTITY_OMINBILL, (String)"billentry.id,billentry.mainbillentity,billentry.mainbillentryid,billentry.material,billentry.unit.precision,billentry.unit.precisionaccount,billentry.remainjoinpriceqty,billentry.remainjoinpricebaseqty,billentry.joinpriceqty,billentry.joinpricebaseqty", (QFilter[])(inForPoQF = new QFilter("billentry.id", "in", inForPo)).toArray())) != null && !inForPoBills.isEmpty()) {
            for (DynamicObject inForPoBill : inForPoBills) {
                MdcOminWriteOffServiceImpl.addEntryModelInfo(isVerify, verifyEntryModelMap, inForPoBill, purInApEntryMap);
            }
        }
        return verifyEntryModelMap;
    }

    private static void addEntryModelInfo(Boolean isVerify, Map<Long, APVerifyEntryModel> verifyEntryModelMap, DynamicObject inForPoBillEntry, Map<Long, List<Long>> apEntryMap) {
        Long entryId = inForPoBillEntry.getLong("billentry.id");
        APVerifyEntryModel apVerifyEntryModel = verifyEntryModelMap.get(entryId);
        List<Long> apEntrylist = apEntryMap.get(entryId);
        if (apVerifyEntryModel == null) {
            return;
        }
        String mainbillentity = inForPoBillEntry.getString("billentry.mainbillentity");
        Long mainbillentryid = inForPoBillEntry.getLong("billentry.mainbillentryid");
        MdcOminWriteOffServiceImpl.setRwJoinPirceQty(isVerify, inForPoBillEntry, apVerifyEntryModel, apEntrylist);
        if (0L != mainbillentryid && "pm_om_purorderbill".equals(mainbillentity)) {
            apVerifyEntryModel.setMainBillEntryid(mainbillentryid);
        }
    }

    private static void setRwJoinPirceQty(Boolean isVerify, DynamicObject inForPoBillEntry, APVerifyEntryModel apVerifyEntryModel, List<Long> apEntrylist) {
        String verifyRelation = apVerifyEntryModel.getVerifyRelation();
        if ("ominself".equals(verifyRelation)) {
            return;
        }
        boolean isAllBotpGenArEntry = true;
        List asstEntrys = apVerifyEntryModel.getAsstEntrys();
        if (apEntrylist != null && !apEntrylist.isEmpty()) {
            for (APVerifyAsstEntryModel asstEntry : asstEntrys) {
                Long asstEntryPk = asstEntry.getAsstEntryPk();
                if (apEntrylist.contains(asstEntryPk)) {
                    asstEntry.setBotpGen(true);
                    continue;
                }
                isAllBotpGenArEntry = false;
            }
        } else {
            isAllBotpGenArEntry = false;
        }
        if (isAllBotpGenArEntry) {
            return;
        }
        BigDecimal needJoinPriceQty = BigDecimal.ZERO;
        BigDecimal needJoinPriceBaseQty = BigDecimal.ZERO;
        BigDecimal verifyQty = apVerifyEntryModel.getVerifyQty();
        Long measureunit = apVerifyEntryModel.getMeasureunit();
        Long materialid = inForPoBillEntry.getLong("billentry.material");
        Integer precision = inForPoBillEntry.getInt("billentry.unit.precision");
        Integer precisionaccount = inForPoBillEntry.getInt("billentry.unit.precisionaccount");
        HashMap cacheMap = new HashMap();
        for (APVerifyAsstEntryModel asstEntry : asstEntrys) {
            BigDecimal unit2ndRate;
            if (asstEntry.isBotpGen()) continue;
            Long asstmeasureunit = asstEntry.getAsstmeasureunit();
            BigDecimal asstVerifyQty = asstEntry.getAsstVerifyQty();
            if (measureunit != null && asstmeasureunit != null && !measureunit.equals(asstmeasureunit) && (unit2ndRate = BillUnitAndQtytHelper.getUnitRateConv((Long)materialid, (Long)measureunit, (Long)asstmeasureunit, cacheMap)) != null && BigDecimal.ZERO.compareTo(unit2ndRate) != 0 && BigDecimal.ONE.compareTo(unit2ndRate) != 0 && BigDecimal.ZERO.compareTo(verifyQty) != 0) {
                asstVerifyQty = asstVerifyQty.divide(unit2ndRate, (int)precision, PrecisionAccountEnum.getEnumByVal((int)precisionaccount));
            }
            needJoinPriceQty = needJoinPriceQty.add(asstVerifyQty);
            needJoinPriceBaseQty = needJoinPriceBaseQty.add(asstEntry.getAsstVerifyBaseQty());
        }
        if (isVerify.booleanValue()) {
            BigDecimal remainJoinPriceBaseQty = inForPoBillEntry.getBigDecimal("billentry.remainjoinpricebaseqty");
            BigDecimal remainJoinPriceQty = inForPoBillEntry.getBigDecimal("billentry.remainjoinpriceqty");
            if (remainJoinPriceBaseQty.abs().compareTo(needJoinPriceBaseQty.abs()) < 0 && remainJoinPriceQty.abs().compareTo(needJoinPriceQty.abs()) < 0) {
                apVerifyEntryModel.setJoinPriceQty(remainJoinPriceQty);
                apVerifyEntryModel.setJoinPriceBaseQty(remainJoinPriceBaseQty);
            } else {
                apVerifyEntryModel.setJoinPriceQty(needJoinPriceQty);
                apVerifyEntryModel.setJoinPriceBaseQty(needJoinPriceBaseQty);
            }
        } else {
            BigDecimal joinPriceQty = inForPoBillEntry.getBigDecimal("billentry.joinpriceqty");
            BigDecimal joinPriceBaseQty = inForPoBillEntry.getBigDecimal("billentry.joinpricebaseqty");
            if (joinPriceBaseQty.abs().compareTo(needJoinPriceBaseQty.abs()) < 0 && joinPriceQty.abs().compareTo(needJoinPriceQty.abs()) < 0) {
                apVerifyEntryModel.setJoinPriceQty(joinPriceQty);
                apVerifyEntryModel.setJoinPriceBaseQty(joinPriceBaseQty);
            } else {
                apVerifyEntryModel.setJoinPriceQty(needJoinPriceQty);
                apVerifyEntryModel.setJoinPriceBaseQty(needJoinPriceBaseQty);
            }
        }
    }

    private static Map<Long, List<Long>> getApEntryList(String billType, List<Long> entryIds) {
        HashMap<Long, List<Long>> arEntryIdMap = new HashMap<Long, List<Long>>();
        if (entryIds == null || entryIds.isEmpty()) {
            return arEntryIdMap;
        }
        List loadTargetRowIds = BFTrackerServiceHelper.loadTargetRowIds((String)billType, (String)"billentry", (Long[])entryIds.toArray(new Long[0]));
        if (loadTargetRowIds != null && !loadTargetRowIds.isEmpty()) {
            List<BFRowId> list;
            ConvertDataService reader2 = new ConvertDataService();
            TableDefine revcFmTableDefine = reader2.loadTableDefine("ap_finapbill", "detailentry");
            Long revcFmTableId = revcFmTableDefine.getTableId();
            ConvertDataService srReader = new ConvertDataService();
            TableDefine srTableDefine = srReader.loadTableDefine(billType, "billentry");
            Long srTableId = srTableDefine.getTableId();
            HashMap targetRowMap = new HashMap();
            for (BFRow bFRow : loadTargetRowIds) {
                BFRowId sid = bFRow.getSId();
                Long sTableId = sid.getTableId();
                Long sentryId = sid.getEntryId();
                BFRowId tagertId = bFRow.getId();
                Long tagertEntryId = tagertId.getEntryId();
                if (sTableId == null || !sTableId.equals(srTableId)) continue;
                list = (ArrayList)targetRowMap.get(sentryId);
                if (list == null) {
                    list = new ArrayList();
                    targetRowMap.put(sentryId, list);
                }
                boolean isContains = false;
                for (BFRowId bfRowId : list) {
                    if (!bfRowId.getEntryId().equals(tagertEntryId)) continue;
                    isContains = true;
                }
                if (isContains) continue;
                list.add(tagertId);
                MdcOminWriteOffServiceImpl.addTargetRowId(loadTargetRowIds, tagertId, list);
            }
            for (Map.Entry entry : targetRowMap.entrySet()) {
                Long sEntryId = (Long)entry.getKey();
                List tagerIdList = (List)entry.getValue();
                for (BFRowId tagerId : tagerIdList) {
                    Long tagerEntryId;
                    Long tableId = tagerId.getTableId();
                    if (!revcFmTableId.equals(tableId)) continue;
                    list = (List)arEntryIdMap.get(sEntryId);
                    if (list == null) {
                        list = new ArrayList();
                        arEntryIdMap.put(sEntryId, list);
                    }
                    if (list.contains(tagerEntryId = tagerId.getEntryId())) continue;
                    list.add((BFRowId)tagerEntryId);
                }
            }
        }
        return arEntryIdMap;
    }

    private static void addTargetRowId(List<BFRow> loadTargetRowIds, BFRowId targetRowId, List<BFRowId> targetRowIdList) {
        for (BFRow bfRow : loadTargetRowIds) {
            BFRowId sid = bfRow.getSId();
            Long sentryId = sid.getEntryId();
            BFRowId tagertId = bfRow.getId();
            Long tagertEntryId = tagertId.getEntryId();
            if (sentryId == null || !sentryId.equals(targetRowId.getEntryId())) continue;
            boolean isContains = false;
            for (BFRowId bfRowId : targetRowIdList) {
                if (!bfRowId.getEntryId().equals(tagertEntryId)) continue;
                isContains = true;
            }
            if (isContains) continue;
            targetRowIdList.add(tagertId);
            MdcOminWriteOffServiceImpl.addTargetRowId(loadTargetRowIds, tagertId, targetRowIdList);
        }
    }

    private static APVerifyEntryModel getVerifyEntryModel(Map<String, Object> dispose) {
        List asstDataList;
        Object isbotp;
        Object verifybaseqty;
        Object verifyqty;
        APVerifyEntryModel entryModel = new APVerifyEntryModel();
        entryModel.setEntity((String)dispose.get("entity"));
        entryModel.setEntryPk((Long)dispose.get("entrypk"));
        entryModel.setOrgid((Long)dispose.get("orgid"));
        entryModel.setVerifyRelation((String)dispose.get("verifyrelation"));
        entryModel.setVerifyType((String)dispose.get("verifytype"));
        Object verifyamt = dispose.get("verifyamt");
        Object measureunit = dispose.get("measureunit");
        if (measureunit != null) {
            entryModel.setMeasureunit((Long)measureunit);
        }
        if (verifyamt != null) {
            entryModel.setVerifyAmt((BigDecimal)verifyamt);
        }
        if ((verifyqty = dispose.get("verifyqty")) != null) {
            entryModel.setVerifyQty((BigDecimal)verifyqty);
        }
        if ((verifybaseqty = dispose.get("verifybaseqty")) != null) {
            entryModel.setVerifyBaseQty((BigDecimal)verifybaseqty);
        }
        if ((isbotp = dispose.get("isbotp")) != null) {
            entryModel.setBotp(((Boolean)isbotp).booleanValue());
        }
        if ((asstDataList = (List)dispose.get("asstdata")) != null && !asstDataList.isEmpty()) {
            for (Map asstData : asstDataList) {
                Object asstverifybaseqty;
                APVerifyAsstEntryModel asstEntry = new APVerifyAsstEntryModel();
                asstEntry.setAsstEntity((String)asstData.get("asstentity"));
                asstEntry.setAsstEntryPk((Long)asstData.get("asstentrypk"));
                asstEntry.setAsstmeasureunit((Long)asstData.get("asstmeasureunit"));
                Object asstverifyqty = asstData.get("asstverifyqty");
                if (asstverifyqty != null) {
                    asstEntry.setAsstVerifyQty((BigDecimal)asstverifyqty);
                }
                if ((asstverifybaseqty = asstData.get("asstverifybaseqty")) != null) {
                    asstEntry.setAsstVerifyBaseQty((BigDecimal)asstverifybaseqty);
                }
                entryModel.getAsstEntrys().add(asstEntry);
            }
        }
        return entryModel;
    }

    @Override
    public void OminUnVerify(List<Map<String, Object>> disposeList) throws KDException {
        if (disposeList == null || disposeList.isEmpty()) {
            return;
        }
        boolean isVerify = false;
        Map<Long, APVerifyEntryModel> verifyEntryModelMap = this.buildVerifyModel(disposeList, isVerify);
        ArrayList<Object[]> purInBillParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> purBillParamList = new ArrayList<Object[]>();
        for (APVerifyEntryModel verifyEntryModel : verifyEntryModelMap.values()) {
            MdcOminWriteOffServiceImpl.addPurInBillRWParam(verifyEntryModel, purInBillParamList);
            MdcOminWriteOffServiceImpl.addPurBillRWParam(verifyEntryModel, purBillParamList);
        }
        try (TXHandle h = TX.required();){
            try {
                String sql;
                if (!purInBillParamList.isEmpty() && !this.isCommon(disposeList.get(0))) {
                    sql = "update t_im_mdc_ominbillentry_r set  funverifyqty = funverifyqty+?,fverifyqty = fverifyqty-?,  funverifybaseqty = funverifybaseqty+?,fverifybaseqty = fverifybaseqty-?,  fremainjoinpriceqty = fremainjoinpriceqty+?, fjoinpriceqty = fjoinpriceqty-?,  fremainjoinpricebaseqty = fremainjoinpricebaseqty+?, fjoinpricebaseqty = fjoinpricebaseqty-?  where fentryid=?";
                    DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, purInBillParamList);
                }
                if (!purBillParamList.isEmpty() && !"ominself".equals(disposeList.get(0).get("verifyrelation"))) {
                    sql = "update t_pm_om_purbillentry_r set fpayablepriceqty = fpayablepriceqty-?,fpayableamount=fpayableamount-? where fentryid in (select fentryid from t_pm_om_purbillentry where fentryid = ? And fentrysettleorgid = ? )";
                    DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, purBillParamList);
                }
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
    }
}

