/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.upgrade;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.dataentity.SingleORM;
import kd.bos.param.ParameterCache;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;

public class BIllTypeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(BIllTypeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String qmcRouteKey, String sqlFileName) {
        return this.repaireBillType(null);
    }

    public UpgradeResult repaireBillType(Map<String, Object> params) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        this.repaireLogic(params, result);
        return result;
    }

    private void repaireLogic(Map<String, Object> params, UpgradeResult result) {
        try {
            ArrayList<String> repairBills = new ArrayList<String>();
            repairBills.add("im_mdc_mftomreqapplybill");
            repairBills.add("im_mdc_mftreturnapplybill");
            repairBills.add("im_mdc_mftproorder");
            repairBills.add("im_mdc_mftfeedorder");
            repairBills.add("im_mdc_mftreturnorder");
            repairBills.add("im_mdc_mftmanuinbill");
            String json = "{\"showmodal\":false,\"linkquerylayoutconfig\":\"\",\"submitandaudit\":false,\"onlyrunconditionrule\":true,\"showsearch\":false,\"showtipduration\":3,\"flexpropgroups\":16,\"printrulelog\":false,\"printconditionvalue\":\"\",\"writebackreport\":false,\"pushdrawlayoutconfig\":\"\",\"exchangemainorg_clearbill\":true,\"searchorforfast\":true,\"isenabled\":false,\"isenablesignorg\":false,\"reportstarttime\":\"2024-10-17 09:16:20\",\"bosentryserverfiltersort\":false,\"default_showreport\":false,\"checkexportencrypt\":false,\"_Type_\":\"bos_billparametertpl\",\"secondfield\":\"billno\",\"maxreturndata\":100000,\"f7listformat\":\"name\",\"mul_lan_input_setting\":{\"action\":\"setnull\"},\"linkquerylayoutconfigdata\":\"\",\"recursionapplylock\":true,\"isscrollload\":true,\"primaryfield\":\"billno\",\"softdelete\":false,\"openbillnopagecache\":false,\"listcolumnbasedatafilter\":true,\"isenabledtree\":true,\"searchtype\":\"1\",\"pagesize\":\"10\",\"sortorder\":{\"action\":\"setnull\"},\"daterecycletype\":false,\"iconfield\":{\"action\":\"setnull\"},\"saverecord\":false,\"defaultsort\":true,\"import_entry_number_limit\":20000,\"checkdownloadencrypt\":false,\"wholeconvert\":false,\"resultfrompopupreport\":false,\"billuniquekeys\":{\"action\":\"setnull\"},\"maxpagesize\":\"1000\",\"opbatchcount\":100,\"pushdrawlayoutconfigdata\":\"\",\"opexecutelog\":false,\"reportendtime\":\"2024-10-17 09:21:20\",\"pagerow\":\"20\",\"retainspace\":false,\"showprogressrowcount\":10,\"pushbatchnumbers\":false,\"listfilterbasedatacontrol\":true,\"isviewbill\":false,\"printcondition\":\"\",\"boscarryadminorg\":true,\"enablescheme\":true}";
            for (String fromId : repairBills) {
                this.saveBillParameter(fromId, json);
            }
        }
        catch (Exception e) {
            String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error(errMsg);
        }
    }

    public void saveBillParameter(String formId, String jsonData) {
        String sql = "SELECT count(*) FROM T_BAS_BILLPARAMETER WHERE FFORMID=?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        params.add(new SqlParameter(":FFORMID", 12, (Object)formId));
        DynamicObjectCollection count = SingleORM.query((DynamicObjectType)null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        if (count != null && !count.isEmpty() && ((DynamicObject)count.get(0)).getLong(0) != 0L) {
            sql = "SELECT fformid,fdata FROM T_BAS_BILLPARAMETER WHERE FFORMID=?";
            DynamicObjectCollection datas = SingleORM.query((DynamicObjectType)null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
            DynamicObject data = (DynamicObject)datas.get(0);
            if (Objects.isNull(data)) {
                return;
            }
            String data1 = data.getString("fdata");
            JSONObject jsonObject = JSONObject.parseObject((String)data1);
            jsonObject.put("_Type_", (Object)"bos_billparametertpl");
            jsonObject.put("onlyrunconditionrule", (Object)Boolean.TRUE);
            sql = "UPDATE T_BAS_BILLPARAMETER SET FDATA = ? WHERE FFORMID=?";
            params.add(0, new SqlParameter(":FDATA", 12, (Object)jsonObject.toString()));
            BIllTypeService.saveOrUpdateParam(params, sql, false);
        } else {
            sql = "INSERT INTO T_BAS_BILLPARAMETER (FFORMID, FDATA) VALUES (?, ?)";
            params.add(new SqlParameter(":FDATA", 12, (Object)jsonData));
            BIllTypeService.saveOrUpdateParam(params, sql, true);
        }
        BIllTypeService.removeBillParameter(formId);
        ParameterCache.removeBillParamCache((String)formId);
    }

    public static void removeBillParameter(String entityNumber) {
        LocalMemoryCache localMemoryCache = BIllTypeService.getLocalCache(CacheKeyUtil.getAcctId());
        localMemoryCache.remove(new String[]{BIllTypeService.genBillParamCacheKey(entityNumber)});
        localMemoryCache.remove(new String[]{BIllTypeService.genBillParamDynamicObjectCacheKey(entityNumber)});
    }

    private static String genBillParamCacheKey(String entityNumber) {
        return "BillParam_" + entityNumber + "_" + RequestContext.get().getLang().getLangTag();
    }

    private static String genBillParamDynamicObjectCacheKey(String entityNumber) {
        return "BillParam_Obj_" + entityNumber;
    }

    private static LocalMemoryCache getLocalCache(String acctId) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(43200);
        info.setMaxMemSize(10000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(acctId, "SYSTEM_PARAMETER", info);
    }

    public static void saveOrUpdateParam(List<SqlParameter> params, String sql, boolean isUpdate) {
        try (TXHandle h = TX.requiresNew();){
            if (isUpdate) {
                DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
            } else {
                DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
            }
        }
    }
}

