/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;

public class MdcMftBillUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(MdcMftBillUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        DBRoute sysRoute = new DBRoute("sys");
        ThreadPools.executeOnceIncludeRequestContext((String)"MdcMftBillUpgradeServiceImpl", (Runnable)ThreadLifeCycleManager.wrapRunnable(() -> this.doUpgrade(scmRoute, sysRoute, result)));
        return result;
    }

    private void doUpgrade(DBRoute scmRoute, DBRoute sysRoute, UpgradeResult result) {
        try (AlgoContext context = Algo.newContext();){
            String switchSql = "SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = ? ";
            try (DataSet countSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (String)switchSql, (Object[])new String[]{"t_bas_billtype"});){
                if (!countSet.hasNext()) {
                    String logstr = "MdcMftBillUpgradeServiceImpl upgrade t_bas_billtype ,t_bas_billtype has not exists.";
                    log.error(logstr);
                    result.setLog(logstr);
                    result.setSuccess(true);
                    return;
                }
            }
            countSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)switchSql, (Object[])new String[]{"t_im_mdc_mreqoutbill"});
            var8_11 = null;
            try {
                if (!countSet.hasNext()) {
                    String logstr = "MdcMftBillUpgradeServiceImpl upgrade t_im_mdc_mreqoutbill ,t_im_mdc_mreqoutbill has not exists.";
                    log.error(logstr);
                    result.setLog(logstr);
                    result.setSuccess(true);
                    return;
                }
            }
            catch (Throwable logstr) {
                var8_11 = logstr;
                throw logstr;
            }
            finally {
                if (countSet != null) {
                    if (var8_11 != null) {
                        try {
                            countSet.close();
                        }
                        catch (Throwable throwable) {
                            var8_11.addSuppressed(throwable);
                        }
                    } else {
                        countSet.close();
                    }
                }
            }
            SqlBuilder billTypeIdSql = new SqlBuilder();
            billTypeIdSql.append("select fid, fbilltypeid from t_im_mdc_mreqoutbill", new Object[0]);
            DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (SqlBuilder)billTypeIdSql);
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fid typeid,fbillformid from t_bas_billtype", new Object[0]);
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
            try (DataSet dataSet1 = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (SqlBuilder)sql);){
                DataSet finishDataSet = dataSet.leftJoin(dataSet1).on("fbilltypeid", "typeid").select(dataSet.getRowMeta().getFieldNames(), dataSet1.getRowMeta().getFieldNames()).finish();
                for (Row row : finishDataSet) {
                    paramsList.add(new Object[]{row.get("fbillformid"), row.get("fid")});
                }
            }
            if (CollectionUtils.isNotEmpty(paramsList)) {
                String updateSql = "update t_im_mdc_mreqoutbill set fbillentity = ? where fid = ?";
                List partition = ListUtils.partition(paramsList, (int)1000);
                for (List objects : partition) {
                    this.batchExcuteUpdate(DBRoute.of((String)"scm"), updateSql, objects);
                }
                log.info("MdcMftBillUpgradeServiceImpl upgrade t_im_mdc_mreqoutbill end,count:" + paramsList.size());
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            result.setLog(e.toString());
            result.setSuccess(false);
        }
    }

    private void batchExcuteUpdate(DBRoute dbKey, String updateSql, List<Object[]> objects) {
        DB.executeBatch((DBRoute)dbKey, (String)updateSql, objects);
    }
}

