/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.common.mdc.enums.OperateEnum;

public class LineTypeInBizTypeValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(LineTypeInBizTypeValidator.class);

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"LineTypeInBizTypeValidator", (String)"validate");){
            String operate = this.getOperateKey();
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject obj = this.dataEntities[i].getDataEntity();
                DynamicObject bizType = obj.getDynamicObject("biztype");
                if (bizType == null) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"LineTypeInBizTypeValidator_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                OrmLocaleValue bizName = (OrmLocaleValue)bizType.get("name");
                String value = bizName.getLocaleValue();
                DynamicObjectCollection lineTypeEntry = bizType.getDynamicObjectCollection("linetypeentry");
                List collect = lineTypeEntry.stream().map(var -> var.getDynamicObject("linetypeid").getLong("id")).collect(Collectors.toList());
                for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                    DynamicObject lineType = entryObj.getDynamicObject("linetype");
                    if (lineType == null) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u884c\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"LineTypeInBizTypeValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1));
                        continue;
                    }
                    OrmLocaleValue lineName = (OrmLocaleValue)lineType.get("name");
                    String localeValue = lineName.getLocaleValue();
                    long lineTypeId = lineType.getLong("id");
                    if (collect.contains(lineTypeId)) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u884c\u7c7b\u578b\u201c%2$s\u201d\u4e0d\u5b58\u5728\u4e8e\u201c%3$s\u201d\u4e1a\u52a1\u7c7b\u578b\u4e2d\uff0c\u4e0d\u5141\u8bb8\u201c%4$s\u201d\u3002", (String)"LineTypeInBizTypeValidator_3", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, localeValue, value, OperateEnum.getValue(operate)));
                }
            }
        }
    }
}

