/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.scmc.im.common.mdc.utils.OMStockBackFlushUtils;

public class MFTOmReqOutBillChargeAgainstOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MFTOmReqOutBillChargeAgainstOp.class);
    private static final String KEY_BILLENTRY = "billentry";
    private static final String KEY_MANUENTRYID = "manuentryid";
    private static final Set<String> billTypes = Sets.newHashSet((Object[])new String[]{"im_mdc_mftmanuinbill", "im_mdc_mftreturnbill", "im_mdc_omcmplinbill"});

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("srcbillentity");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("srcbillentryid");
        e.getFieldKeys().add("srcbillnumber");
        e.getFieldKeys().add("srcbillentryseq");
        e.getFieldKeys().add("mainbillentity");
        e.getFieldKeys().add("mainbillid");
        e.getFieldKeys().add("mainbillentryid");
        e.getFieldKeys().add("mainbillnumber");
        e.getFieldKeys().add("mainbillentryseq");
        e.getFieldKeys().add(KEY_BILLENTRY);
        e.getFieldKeys().add("manubill");
        e.getFieldKeys().add("manubillid");
        e.getFieldKeys().add("manuentry");
        e.getFieldKeys().add(KEY_MANUENTRYID);
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("ischargeoff");
        e.getFieldKeys().add("isbackflush");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dObjects = e.getDataEntities();
        if ("chargeagainst".equals(operationKey)) {
            HashSet<Long> orderEntryIds = new HashSet<Long>(16);
            HashSet<Long> orderIds = new HashSet<Long>(16);
            for (DynamicObject repOut : dObjects) {
                DynamicObjectCollection entryCol = repOut.getDynamicObjectCollection(KEY_BILLENTRY);
                HashSet<String> srcBillTypeSet = new HashSet<String>(16);
                HashSet<Long> srcBillIdSet = new HashSet<Long>(16);
                for (DynamicObject billEntry : entryCol) {
                    long manuBillId = billEntry.getLong("manubillid");
                    orderIds.add(manuBillId);
                    long billEntityId = billEntry.getLong(KEY_MANUENTRYID);
                    orderEntryIds.add(billEntityId);
                    srcBillTypeSet.add(billEntry.getString("srcbillentity"));
                    srcBillIdSet.add(billEntry.getLong("srcbillid"));
                }
                if (srcBillTypeSet.size() != 1 || !repOut.getBoolean("isbackflush") || !billTypes.containsAll(srcBillTypeSet)) continue;
                ArrayList<Object> orderReportBillEntryIds = new ArrayList<Object>(16);
                Long srcBillId = (Long)srcBillIdSet.toArray()[0];
                DynamicObject srcBillObject = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (String)"im_mdc_omcmplinbill");
                DynamicObjectCollection coll = srcBillObject.getDynamicObjectCollection(KEY_BILLENTRY);
                coll.forEach(a -> orderReportBillEntryIds.add(a.getLong("id")));
                if (orderReportBillEntryIds.isEmpty()) continue;
                OMStockBackFlushUtils.updateBFStatusByEntryId(orderReportBillEntryIds, "im_mdc_omcmplinbill");
            }
            HashMap<String, Object> calparam = new HashMap<String, Object>();
            calparam.put("orderentryids", orderEntryIds);
            calparam.put("orderids", orderIds);
            calparam.put("operate", operationKey);
            calparam.put("iscloseorder", "1");
            calparam.put("modetype", "2");
            calparam.put("isautocal", "0");
            calparam.put("isautoflag", "0");
            calparam.put("appId", "im");
            String jsonString = JSON.toJSONString(calparam);
            EventServiceHelper.triggerEventSubscribe((String)"auditCalMaterial", (String)jsonString);
        }
    }
}

