/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.common.mdc.enums.BillTypeEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MFTReqOutBillDeleteSrcStockEntryOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MFTReqOutBillDeleteSrcStockEntryOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("billhead_lk");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("srcbillentity");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("srcbillentryid");
        e.getFieldKeys().add("srcbillnumber");
        e.getFieldKeys().add("srcbillentryseq");
        e.getFieldKeys().add("mainbillentity");
        e.getFieldKeys().add("mainbillid");
        e.getFieldKeys().add("mainbillentryid");
        e.getFieldKeys().add("mainbillnumber");
        e.getFieldKeys().add("mainbillentryseq");
        e.getFieldKeys().add("billentry");
        e.getFieldKeys().add("manubill");
        e.getFieldKeys().add("manubillid");
        e.getFieldKeys().add("manuentry");
        e.getFieldKeys().add("manuentryid");
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("ischargeoff");
        e.getFieldKeys().add("isbackflush");
        e.getFieldKeys().add("isvirtualbill");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("bizorg");
        e.getFieldKeys().add("billcretype");
        e.getFieldKeys().add("billentry.stockentryid");
        e.getFieldKeys().add("billentry.stockno");
        e.getFieldKeys().add("billentry.stockentry");
        e.getFieldKeys().add("billentry.stockid");
        e.getFieldKeys().add("billentry.material");
        e.getFieldKeys().add("billentry.configuredcode");
        e.getFieldKeys().add("billentry.lotnumber");
        e.getFieldKeys().add("billentry.baseunit");
        e.getFieldKeys().add("billentry.auxpty");
        e.getFieldKeys().add("billentry.outownertype");
        e.getFieldKeys().add("billentry.outowner");
        e.getFieldKeys().add("billentry.warehouse");
        e.getFieldKeys().add("billentry.location");
        e.getFieldKeys().add("billentry.oprno");
        e.getFieldKeys().add("billentry.processseq");
        e.getFieldKeys().add("billentry.isadd");
        e.getFieldKeys().add("billentry.workprocedureid");
        e.getFieldKeys().add("billentry.operationdesc");
        e.getFieldKeys().add("billentry.oprworkcenter");
        e.getFieldKeys().add("billentry.workstation");
        e.getFieldKeys().add("billentry.workstation");
        e.getFieldKeys().add("billentry.billentry_lk");
        e.getFieldKeys().add("billentry.billentry_lk_stableid");
        e.getFieldKeys().add("billentry.billentry_lk_sbillid");
        e.getFieldKeys().add("billentry.billentry_lk_sid");
        e.getFieldKeys().add("billentry.linetype");
        e.getFieldKeys().add("billentry.materialname");
        e.getFieldKeys().add("billentry.isrework");
        e.getFieldKeys().add("billentry.updatestockresult");
        e.getFieldKeys().add("billentry.lot");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] reqOutBills = e.getDataEntities();
        Set<DynamicObject> deleteEntrys = this.queryDeleteSrcStockEntrys(reqOutBills);
        HashSet<Long> stockEntryIds = new HashSet<Long>(16);
        for (DynamicObject deleteEntry : deleteEntrys) {
            stockEntryIds.add(deleteEntry.getLong("mainbillentryid"));
        }
        this.deleteStockEntrys(stockEntryIds);
        this.clearStockEntryInfo(deleteEntrys, reqOutBills);
    }

    private void clearStockEntryInfo(Set<DynamicObject> deleteEntrys, DynamicObject[] reqOutBills) {
        if (CollectionUtils.isNotEmpty(deleteEntrys) && null != reqOutBills) {
            String entryName = "billentry";
            String tBillType = reqOutBills[0].getDynamicObjectType().getName();
            Long tTableId = ConvertMetaServiceHelper.loadTableDefine((String)tBillType, (String)entryName).getTableId();
            Long sTableId = ConvertMetaServiceHelper.loadTableDefine((String)"pom_mftstock", (String)"stockentry").getTableId();
            Long tMainTableId = ConvertMetaServiceHelper.loadMainTableDefine((String)tBillType).getTableId();
            Long sMainTableId = ConvertMetaServiceHelper.loadMainTableDefine((String)"pom_mftstock").getTableId();
            ArrayList<Object[]> deleteList = new ArrayList<Object[]>(10);
            HashMap<Long, HashSet<Long>> map = new HashMap<Long, HashSet<Long>>(16);
            HashMap notDeleteMap = new HashMap(16);
            for (DynamicObject reqOutBill : reqOutBills) {
                DynamicObjectCollection linkRows;
                DynamicObjectCollection billeEntrys = reqOutBill.getDynamicObjectCollection(entryName);
                int deleteRowNum = 0;
                Long reqOutBillId = reqOutBill.getLong("id");
                for (DynamicObject billeEntry : billeEntrys) {
                    HashSet<Long> temp;
                    Long mainbillid = billeEntry.getLong("mainbillid");
                    boolean isadd = billeEntry.getBoolean("isadd");
                    if (deleteEntrys.contains(billeEntry)) {
                        billeEntry.set("mainbillentryid", null);
                        billeEntry.set("srcbillentryid", null);
                        billeEntry.set("mainbillentryseq", null);
                        billeEntry.set("updatestockresult", (Object)"A");
                        DynamicObjectCollection tagLinkRows = (DynamicObjectCollection)billeEntry.get("billentry_lk");
                        tagLinkRows.clear();
                        ++deleteRowNum;
                    }
                    if (null == (temp = (HashSet<Long>)map.get(reqOutBillId))) {
                        temp = new HashSet<Long>(16);
                    }
                    temp.add(mainbillid);
                    map.put(reqOutBillId, temp);
                    if (isadd) continue;
                    HashSet<Long> notDeleteTemp = (HashSet<Long>)notDeleteMap.get(reqOutBillId);
                    if (null == notDeleteTemp) {
                        notDeleteTemp = new HashSet<Long>(16);
                    }
                    notDeleteTemp.add(mainbillid);
                    map.put(reqOutBillId, notDeleteTemp);
                }
                if (billeEntrys.size() != deleteRowNum || null == (linkRows = (DynamicObjectCollection)reqOutBill.get("billhead_lk"))) continue;
                linkRows.clear();
            }
            for (Map.Entry entry : map.entrySet()) {
                Long key = (Long)entry.getKey();
                Set value = (Set)entry.getValue();
                Set notDeletes = (Set)notDeleteMap.get(key);
                if (null != value && null != notDeletes) {
                    value.removeAll(notDeletes);
                }
                if (!CollectionUtils.isNotEmpty((Collection)value)) continue;
                for (Long aLong : value) {
                    deleteList.add(new Object[]{key, aLong});
                }
            }
            SaveServiceHelper.save((DynamicObject[])reqOutBills);
            if (deleteList.size() > 0) {
                String sql = "delete from t_im_mreqoutbill_tc where fttableid = " + tTableId + " and fstableid = " + sTableId + " and ftbillid = ? and fsbillid = ?";
                DBRoute dBRoute = new DBRoute("scm");
                DB.executeBatch((DBRoute)dBRoute, (String)sql, deleteList);
                String trackerSql = "delete from t_botp_billtracker where fttableid = " + tMainTableId + " and fstableid = " + sMainTableId + " and ftbillid = ? and fsbillid = ?";
                DBRoute sysRoute = new DBRoute("sys");
                DB.executeBatch((DBRoute)sysRoute, (String)trackerSql, deleteList);
            }
        }
    }

    private void deleteStockEntrys(Set<Long> stockEntryIds) {
        if (null != stockEntryIds && CollectionUtils.isNotEmpty(stockEntryIds)) {
            HashSet<String> deleteStockEntrySet = new HashSet<String>(16);
            QFilter qFilter = new QFilter("stockentry.id", "in", stockEntryIds);
            Map pomMftstockMap = BusinessDataServiceHelper.loadFromCache((String)"pom_mftstock", (QFilter[])new QFilter[]{qFilter});
            if (null != pomMftstockMap) {
                ArrayList<DynamicObject> saveDyn = new ArrayList<DynamicObject>(16);
                for (Map.Entry dynamicObjectEntry : pomMftstockMap.entrySet()) {
                    DynamicObject mftStockBill = (DynamicObject)dynamicObjectEntry.getValue();
                    ArrayList<DynamicObject> removeEntrys = new ArrayList<DynamicObject>(16);
                    DynamicObjectCollection stockEntrys = mftStockBill.getDynamicObjectCollection("stockentry");
                    for (DynamicObject stockEntry : stockEntrys) {
                        if (!stockEntryIds.contains(stockEntry.getLong("id"))) continue;
                        removeEntrys.add(stockEntry);
                        deleteStockEntrySet.add(stockEntry.getString("id"));
                    }
                    if (removeEntrys.size() > 0) {
                        stockEntrys.removeAll(removeEntrys);
                    }
                    saveDyn.add(mftStockBill);
                }
                if (CollectionUtils.isNotEmpty(saveDyn)) {
                    SaveServiceHelper.save((DynamicObject[])saveDyn.toArray(new DynamicObject[saveDyn.size()]));
                }
            }
            QFilter xLogQFilter = new QFilter("stockentryid", "in", deleteStockEntrySet);
            DeleteServiceHelper.delete((String)"pom_xmfstockchangelog", (QFilter[])new QFilter[]{xLogQFilter});
        }
    }

    private Set<DynamicObject> queryDeleteSrcStockEntrys(DynamicObject[] reqOutBills) {
        HashSet<DynamicObject> result = new HashSet<DynamicObject>(16);
        if (null != reqOutBills) {
            String entityNumber = "pom_mftstock";
            String entryKey = "stockentry";
            HashSet<Long> srcStockBillIds = new HashSet<Long>(16);
            HashSet<Long> srcStockEntryIds = new HashSet<Long>(16);
            boolean onlyDirtLink = false;
            for (DynamicObject reqOutBill : reqOutBills) {
                DynamicObjectCollection billEntrys = reqOutBill.getDynamicObjectCollection("billentry");
                for (DynamicObject billEntry : billEntrys) {
                    srcStockBillIds.add(billEntry.getLong("mainbillid"));
                    srcStockEntryIds.add(billEntry.getLong("mainbillentryid"));
                }
            }
            Map<Long, Map<String, HashSet<Long>>> trackInfo = this.findTrackInfo(entityNumber, entryKey, srcStockBillIds, srcStockEntryIds, onlyDirtLink);
            for (DynamicObject reqOutBill : reqOutBills) {
                DynamicObjectCollection billEntrys = reqOutBill.getDynamicObjectCollection("billentry");
                for (DynamicObject billEntry : billEntrys) {
                    if (!this.canBeDeleted(billEntry, trackInfo)) continue;
                    result.add(billEntry);
                }
            }
        }
        return result;
    }

    private boolean canBeDeleted(DynamicObject billEntry, Map<Long, Map<String, HashSet<Long>>> trackInfo) {
        boolean result = true;
        if (null != billEntry && null != trackInfo) {
            boolean isAdd = billEntry.getBoolean("isadd");
            if (isAdd) {
                long srcStockEntryId = billEntry.getLong("mainbillentryid");
                long billEntryId = billEntry.getLong("id");
                Map<String, HashSet<Long>> trackMap = trackInfo.get(srcStockEntryId);
                if (null != trackMap) {
                    block0: for (Map.Entry<String, HashSet<Long>> hashSetEntry : trackMap.entrySet()) {
                        String billKey = hashSetEntry.getKey();
                        HashSet<Long> valueSet = hashSetEntry.getValue();
                        if (BillTypeEnum.FEED_ORDER.getName().equals(billKey)) {
                            for (Long aLong : valueSet) {
                                if (aLong.equals(billEntryId)) continue;
                                result = false;
                                logger.info("\u542b\u6709\u5176\u5b83\u4e0b\u6e38\u8865\u6599\u5355");
                                continue block0;
                            }
                            continue;
                        }
                        result = false;
                        logger.info("\u542b\u6709\u5176\u5b83\u4e0b\u6e38\u5355\uff1a" + billKey);
                        break;
                    }
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    private Map<Long, Map<String, HashSet<Long>>> findTrackInfo(String entityNumber, String entryKey, Set<Long> billIds, Set<Long> entryIds, boolean onlyDirtLink) {
        HashMap<Long, Map<String, HashSet<Long>>> trackInfoMap = new HashMap<Long, Map<String, HashSet<Long>>>(16);
        if (StringUtils.isNotBlank((CharSequence)entityNumber) && StringUtils.isNotBlank((CharSequence)entryKey) && CollectionUtils.isNotEmpty(billIds) && CollectionUtils.isNotEmpty(entryIds)) {
            List bfRowLinkDownNodes;
            OperateOption option = OperateOption.create();
            if (onlyDirtLink) {
                option.setVariableValue("botp_track_only_dirt_link", "true");
            }
            if (null != (bfRowLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)"pom_mftstock", (String)"stockentry", (Long[])billIds.toArray(new Long[billIds.size()]), (Long[])entryIds.toArray(new Long[entryIds.size()]), (OperateOption)option))) {
                for (BFRowLinkDownNode bfRowLinkDownNode : bfRowLinkDownNodes) {
                    BFRowId sRowId = bfRowLinkDownNode.getRowId();
                    Long sEntryId = sRowId.getEntryId();
                    HashMap<String, HashSet<Long>> tempMap = (HashMap<String, HashSet<Long>>)trackInfoMap.get(sEntryId);
                    if (null == tempMap) {
                        tempMap = new HashMap<String, HashSet<Long>>(16);
                    }
                    Map tNodes = bfRowLinkDownNode.getTNodes();
                    for (Map.Entry next : tNodes.entrySet()) {
                        BFRowLinkDownNode value = (BFRowLinkDownNode)next.getValue();
                        BFRowId rowId = value.getRowId();
                        Long entryId = rowId.getEntryId();
                        Long mainTableId = rowId.getMainTableId();
                        String tEntityNumber = EntityMetadataCache.loadTableDefine((Long)mainTableId).getEntityNumber();
                        HashSet<Long> tEntityIds = (HashSet<Long>)tempMap.get(tEntityNumber);
                        if (null == tEntityIds) {
                            tEntityIds = new HashSet<Long>(16);
                        }
                        tEntityIds.add(entryId);
                        tempMap.put(tEntityNumber, tEntityIds);
                    }
                    trackInfoMap.put(sEntryId, tempMap);
                }
            }
        }
        return trackInfoMap;
    }
}

