/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import java.util.Collection;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scmc.im.common.mdc.enums.BillTypeEnum;
import org.apache.commons.collections4.CollectionUtils;

public class MFTReqOutBillFixLinkOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MFTReqOutBillFixLinkOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        TableDefine targetTableDefine = EntityMetadataCache.loadTableDefine((String)this.billEntityType.getName(), (String)"billentry");
        String lkEntryKey = targetTableDefine.getEntityKey() + "_lk";
        for (int i = 0; i < dataEntities.length; ++i) {
            dataEntities[i] = BusinessDataServiceHelper.loadSingle((Object)dataEntities[i].getPkValue(), (String)dataEntities[i].getDataEntityType().getName());
            if (dataEntities[i].getBoolean("ischargeoff")) continue;
            DynamicObjectCollection targetRows = dataEntities[i].getDynamicObjectCollection(targetTableDefine.getEntityKey());
            for (DynamicObject targetRow : targetRows) {
                String mainBillEntity = targetRow.getString("mainbillentity");
                String srcBillEntity = targetRow.getString("srcbillentity");
                String entityNumber = "";
                String entityKey = "";
                if (BillTypeEnum.PRO_ORDER.getName().equals(this.billEntityType.getName())) {
                    entityNumber = mainBillEntity;
                    entityKey = "stockentry";
                } else if (BillTypeEnum.FEED_ORDER.getName().equals(this.billEntityType.getName()) || BillTypeEnum.RETURN_ORDER.getName().equals(this.billEntityType.getName())) {
                    entityNumber = srcBillEntity;
                    entityKey = "pom_mftstock".equals(srcBillEntity) || "pom_mrostock".equals(srcBillEntity) ? "stockentry" : "billentry";
                }
                TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)entityNumber, (String)entityKey);
                Long srcTableId = srcTableDefine.getTableId();
                DynamicObjectCollection linkRows = targetRow.getDynamicObjectCollection(lkEntryKey);
                if (!CollectionUtils.isEmpty((Collection)linkRows)) continue;
                DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
                linkRow.set(lkEntryKey + "_stableid", (Object)srcTableId);
                if (BillTypeEnum.PRO_ORDER.getName().equals(this.billEntityType.getName())) {
                    linkRow.set(lkEntryKey + "_sbillid", targetRow.get("mainbillid"));
                    linkRow.set(lkEntryKey + "_sid", targetRow.get("mainbillentryid"));
                } else if (BillTypeEnum.FEED_ORDER.getName().equals(this.billEntityType.getName()) || BillTypeEnum.RETURN_ORDER.getName().equals(this.billEntityType.getName())) {
                    linkRow.set(lkEntryKey + "_sbillid", targetRow.get("srcbillid"));
                    linkRow.set(lkEntryKey + "_sid", targetRow.get("srcbillentryid"));
                }
                linkRows.add((Object)linkRow);
            }
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)this.billEntityType.getName(), (DynamicObject[])dataEntities, (OperateOption)this.createOperateOption());
    }

    private OperateOption createOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignorewarn", String.valueOf(true));
        operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        operateOption.setVariableValue("strictvalidation", String.valueOf(true));
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        operateOption.setVariableValue("ignoreValidation", String.valueOf(true));
        operateOption.setVariableValue("WF", "false");
        return operateOption;
    }
}

