/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.common.mdc.enums.BillTypeEnum;

public class MFTReqOutBillStatusValidator
extends AbstractValidator {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"MFTReqOutBillStatusValidator", (String)"validate");){
            String operate = this.getOperateKey();
            HashSet<Long> manuEntryId = new HashSet<Long>(16);
            HashSet<Long> mroManuEntryId = new HashSet<Long>(16);
            HashSet<Long> propManuEntryId = new HashSet<Long>(16);
            int i = 0;
            while (true) {
                DynamicObject obj;
                if (i < this.dataEntities.length) {
                    obj = this.dataEntities[i].getDataEntity();
                } else {
                    Map<String, Map<String, String>> mftOrder = this.getMftOrder(manuEntryId, "pom_mftorder");
                    mftOrder.putAll(this.getMftOrder(mroManuEntryId, "pom_mroorder"));
                    mftOrder.putAll(this.getMftOrder(propManuEntryId, "prop_mftorder"));
                    switch (operate) {
                        case "audit": 
                        case "unaudit": {
                            this.checkBizStatus(mftOrder, operate);
                            return;
                        }
                    }
                    return;
                }
                for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                    if (entryObj.getLong("mainbillentryid") <= 0L && !entryObj.getBoolean("isadd")) continue;
                    if ("pom_mftstock".equals(entryObj.getString("mainbillentity"))) {
                        manuEntryId.add(entryObj.getLong("manuentryid"));
                        continue;
                    }
                    if ("pom_mrostock".equals(entryObj.getString("mainbillentity"))) {
                        mroManuEntryId.add(entryObj.getLong("manuentryid"));
                        continue;
                    }
                    if (!"prop_mftstock".equals(entryObj.getString("mainbillentity"))) continue;
                    propManuEntryId.add(entryObj.getLong("manuentryid"));
                }
                ++i;
            }
        }
    }

    private void checkBizStatus(Map<String, Map<String, String>> mftOrder, String operate) {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                String format;
                DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                Map<String, String> manuObj = mftOrder.get(entryObj.getString("manuentryid"));
                if (manuObj == null) continue;
                if ("audit".equals(operate) && !obj.getBoolean("isvirtualbill") && !StringUtils.equals((CharSequence)"A", (CharSequence)manuObj.get("bizstatus"))) {
                    format = String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684\u751f\u4ea7\u5de5\u5355[%2$s]\u7b2c%3$s\u884c\u7684\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u6b63\u5e38\uff0c%4$s\u5ba1\u6838\u5931\u8d25\u3002", (String)"MFTReqOutBillStatusValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey), manuObj.get("billno"), manuObj.get("seq"), BillTypeEnum.getValue(this.entityKey));
                    this.addErrorMessage(this.dataEntities[i], format);
                    continue;
                }
                if (!"unaudit".equals(operate) || StringUtils.equals((CharSequence)"A", (CharSequence)manuObj.get("bizstatus"))) continue;
                format = String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684\u751f\u4ea7\u5de5\u5355[%2$s]\u7b2c%3$s\u884c\u7684\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u6b63\u5e38\uff0c%4$s\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"MFTReqOutBillStatusValidator_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey), manuObj.get("billno"), manuObj.get("seq"), BillTypeEnum.getValue(this.entityKey));
                this.addErrorMessage(this.dataEntities[i], format);
            }
        }
    }

    private Map<String, Map<String, String>> getMftOrder(Set<Long> manuEntryId, String entity) {
        String algoKey = "queryMftOrder";
        String selectFields = "id,billno,treeentryentity.id,treeentryentity.bizstatus,treeentryentity.seq";
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(256);
        QFilter qFilter = new QFilter("treeentryentity.id", "in", manuEntryId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, String> map1 = new HashMap<String, String>(16);
                map1.put("id", row.getString("id"));
                map1.put("billno", row.getString("billno"));
                map1.put("treeentryentity.id", row.getString("treeentryentity.id"));
                map1.put("bizstatus", row.getString("treeentryentity.bizstatus"));
                map1.put("seq", row.getString("treeentryentity.seq"));
                map.put(row.getString("treeentryentity.id"), map1);
            }
        }
        return map;
    }
}

