/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.EventServiceHelper;

public class MFTReqOutBillUpdateStockOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MFTReqOutBillUpdateStockOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("productiondomain");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        logger.info("MFTReqOutBillUpdateStockOp start->" + operationKey);
        String name = ((ExtendedDataEntity)e.getSelectedRows().get(0)).getDataEntity().getDataEntityType().getName();
        DynamicObject[] dataEntities2 = e.getDataEntities();
        HashSet<String> billEntitySet = new HashSet<String>(16);
        billEntitySet.add("im_mdc_mftfeedorder");
        billEntitySet.add("im_mdc_omfeedbill");
        billEntitySet.add("im_mdc_mftreturnorder");
        billEntitySet.add("im_mdc_omreturnbill");
        if (billEntitySet.contains(name) && dataEntities2 != null) {
            HashMap<String, Object> calparam;
            logger.info("MFTReqOutBillUpdateStockOp inner start->");
            HashSet<Long> outBillIds = new HashSet<Long>(16);
            HashSet<Long> propOutBillIds = new HashSet<Long>(16);
            for (DynamicObject outBill : dataEntities2) {
                boolean isProductionDomain = outBill.containsProperty("productiondomain");
                if (isProductionDomain && "E".equals(outBill.getString("productiondomain"))) {
                    propOutBillIds.add(outBill.getLong("id"));
                    continue;
                }
                outBillIds.add(outBill.getLong("id"));
            }
            if (!outBillIds.isEmpty()) {
                calparam = new HashMap<String, Object>(20);
                calparam.put("outBillIds", outBillIds);
                calparam.put("operation", "unaudit".equals(operationKey) ? "deleteStock" : "updateStock");
                calparam.put("outBillEntityType", this.billEntityType.getName());
                calparam.put("productionDomain", "");
                String jsonString = JSON.toJSONString(calparam);
                EventServiceHelper.triggerEventSubscribe((String)"mftstock.outupdate", (String)jsonString);
            }
            if (!propOutBillIds.isEmpty()) {
                calparam = new HashMap(20);
                calparam.put("outBillIds", propOutBillIds);
                calparam.put("operation", "unaudit".equals(operationKey) ? "deleteStock" : "updateStock");
                calparam.put("outBillEntityType", this.billEntityType.getName());
                calparam.put("productionDomain", "E");
                String jsonString = JSON.toJSONString(calparam);
                EventServiceHelper.triggerEventSubscribe((String)"mftstock.outupdate", (String)jsonString);
            }
            logger.info("MFTReqOutBillUpdateStockOp inner end." + operationKey);
        }
        logger.info("MFTReqOutBillUpdateStockOp end." + operationKey);
    }
}

