/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.common.mdc.enums.BillTypeEnum;
import kd.scmc.im.common.mdc.enums.OperateEnum;
import kd.scmc.im.utils.ArrayUtils;
import org.apache.commons.collections4.CollectionUtils;

public class MFTReqOutWarehouseValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(MFTReqOutWarehouseValidator.class);

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"MFTReqOutWarehouseValidator", (String)"validate");){
            String operate = this.getOperateKey();
            if ("delete".equals(operate)) {
                return;
            }
            HashSet<Long> orgIds = new HashSet<Long>(16);
            HashSet<Long> warehouseIds = new HashSet<Long>(16);
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject obj = this.dataEntities[i].getDataEntity();
                DynamicObject org = obj.getDynamicObject("org");
                if (org == null) continue;
                for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                    DynamicObject warehouse = entryObj.getDynamicObject("warehouse");
                    if (warehouse == null) continue;
                    orgIds.add(org.getLong("id"));
                    warehouseIds.add(warehouse.getLong("id"));
                }
            }
            Map<Object, Object> warehouseMap = new HashMap(16);
            if (!orgIds.isEmpty()) {
                warehouseMap = this.getWarehouse(this.entityKey, orgIds, warehouseIds);
            }
            HashSet<Object> warehousePkvalues = new HashSet<Object>();
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject obj = this.dataEntities[i].getDataEntity();
                for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                    DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                    DynamicObject warehouse = entryObj.getDynamicObject("warehouse");
                    if (warehouse == null) continue;
                    warehousePkvalues.add(warehouse.getPkValue());
                }
            }
            Map warehouseAndLocationIds = WarehouseHelper.getWarehouseAndLocationIds(warehousePkvalues);
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject obj = this.dataEntities[i].getDataEntity();
                Long[] longs = (Long[])warehouseMap.get(obj.getDynamicObject("org").getLong("id"));
                HashSet<Object> warehouseIDSet = new HashSet(16);
                if (longs != null && longs.length > 0) {
                    warehouseIDSet = new HashSet<Long>(Arrays.asList(longs));
                }
                for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
                    String format;
                    DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
                    DynamicObject warehouse = entryObj.getDynamicObject("warehouse");
                    DynamicObject location = entryObj.getDynamicObject("location");
                    if (warehouse == null) continue;
                    if (longs == null || longs.length == 0) {
                        format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u6240\u9009\u7684\u4ed3\u5e93\u6ca1\u6709\u6743\u9650\uff0c%2$s\u5931\u8d25\u3002", (String)"MFTReqOutWarehouseValidator_3", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, OperateEnum.getValue(operate));
                        this.addErrorMessage(this.dataEntities[i], format);
                        continue;
                    }
                    if (!warehouseIDSet.contains(warehouse.getLong("id"))) {
                        format = String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u6240\u9009\u7684\u4ed3\u5e93\u6ca1\u6709\u6743\u9650\uff0c%2$s\u5931\u8d25\u3002", (String)"MFTReqOutWarehouseValidator_3", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, OperateEnum.getValue(operate));
                        this.addErrorMessage(this.dataEntities[i], format);
                        continue;
                    }
                    if (warehouse.getBoolean("isopenlocation")) {
                        List locationIds = (List)warehouseAndLocationIds.get(warehouse.getPkValue());
                        if (location == null || locationIds.contains(location.getLong("id"))) continue;
                        String format2 = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7b2c%2$d\u884c\u5206\u5f55\u7684\u4ed3\u5e93\u542f\u7528\u4ed3\u4f4d\u4f46\u662f\u4ed3\u4f4d\u4e0e\u4ed3\u5e93\u4e0d\u7b26\uff0c%3$s\u5931\u8d25\u3002", (String)"MFTReqOutWarehouseValidator_4", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey), j + 1, OperateEnum.getValue(operate));
                        this.addErrorMessage(this.dataEntities[i], format2);
                        continue;
                    }
                    if (location == null) continue;
                    format = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7b2c%2$d\u884c\u5206\u5f55\u7684\u4ed3\u5e93\u672a\u542f\u7528\u4ed3\u4f4d\u4f46\u662f\u4ed3\u4f4d\u6709\u503c\uff0c%3$s\u5931\u8d25\u3002", (String)"MFTReqOutWarehouseValidator_5", (String)"scmc-mm-mdc", (Object[])new Object[0]), BillTypeEnum.getValue(this.entityKey), j + 1, OperateEnum.getValue(operate));
                    this.addErrorMessage(this.dataEntities[i], format);
                }
            }
        }
    }

    private Map<Long, Long[]> getWarehouse(String formId, Set<Long> orgIDs, Set<Long> warehouseIDs) {
        HashMap<Long, Long[]> resultMap = new HashMap<Long, Long[]>(16);
        if (CollectionUtils.isEmpty(orgIDs)) {
            return resultMap;
        }
        for (Long orgId : orgIDs) {
            List<Long> result = this.setWareHouseIsolate(formId, orgId);
            if (result == null) {
                Long[] allWarehouseIDs = this.getAllWarehouseIDs(orgId, warehouseIDs);
                resultMap.put(orgId, allWarehouseIDs);
                continue;
            }
            resultMap.put(orgId, result.toArray(new Long[result.size()]));
        }
        return resultMap;
    }

    private Long[] getAllWarehouseIDs(Long orgId, Set<Long> warehouseIDs) {
        QFilter orgf = new QFilter("org", "=", (Object)orgId);
        orgf.and(new QFilter("warehouse.id", "in", warehouseIDs));
        orgf.and(new QFilter("startstatus", "=", (Object)"B"));
        ArrayList<Object> result = new ArrayList(warehouseIDs.size());
        String selects = "warehouse.id";
        Map warehouseDycs = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)selects, (QFilter[])new QFilter[]{orgf});
        if (warehouseDycs != null && !warehouseDycs.isEmpty()) {
            Map warehouseMap = ArrayUtils.getDynamicObjectMap((String)selects, (DynamicObject[])warehouseDycs.values().toArray(new DynamicObject[0]));
            result = new ArrayList(warehouseMap.keySet());
        }
        return result.toArray(new Long[0]);
    }

    private List<Long> setWareHouseIsolate(String formId, Long id) {
        long userId = UserServiceHelper.getCurrentUserId();
        Object wareHouseIsolate = AppParameterHelper.getAppParameterByFormId((String)formId, (Long)id, (String)"fwarehouseisolate");
        if (wareHouseIsolate instanceof Boolean && !((Boolean)wareHouseIsolate).booleanValue()) {
            return null;
        }
        List wareHouses = WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId((Long)userId, Collections.singletonList(id));
        if (CollectionUtils.isEmpty((Collection)wareHouses)) {
            return null;
        }
        ArrayList<Long> wareHouseIds = new ArrayList<Long>(wareHouses.size());
        for (DynamicObject wareHose : wareHouses) {
            Long wareHosePkValue = (Long)wareHose.getPkValue();
            wareHouseIds.add(wareHosePkValue);
        }
        return wareHouseIds;
    }
}

