/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scmc.im.common.mdc.utils.AutoBackFlushUtils;
import kd.scmc.im.common.mdc.utils.OMComponentBackFlushUtils;
import kd.scmc.im.common.mdc.utils.OMStockBackFlushUtils;
import kd.scmc.im.common.mdc.utils.StockBackFlushUtils;

public class UnBackFlushOpValidator
extends AbstractValidator {
    private static final String KEY_BILLENTRY = "billentry";

    public void validate() {
        String operationKey = this.getOption().getVariableValue("opKey");
        if ("unbackflush".equals(operationKey)) {
            HashSet<Long> srcbillidSet = new HashSet<Long>(16);
            ArrayList<Object> entryIdList = new ArrayList<Object>(16);
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject obj = this.dataEntities[i].getDataEntity();
                if ("im_mdc_omcmplinbill".equals(this.entityKey) && "1".equals(StockBackFlushUtils.getBizDirection(obj.getDynamicObject("invscheme")))) {
                    this.getOption().setVariableValue("targetname", "im_mdc_omreturnbill");
                }
                boolean isOminbill = false;
                if ("im_mdc_ominbill".equals(this.getEntityKey()) && "1".equals(StockBackFlushUtils.getBizDirection(obj.getDynamicObject("invscheme")))) {
                    isOminbill = true;
                }
                if (isOminbill) {
                    this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5e93\u5b58\u4e8b\u52a1\u4e1a\u52a1\u65b9\u5411\u4e3a\u53cd\u5411,\u4e0d\u5141\u8bb8\u53cd\u5012\u51b2\u3002", (String)"UnBackFlushOpValidator_3", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                    continue;
                }
                if (!this.checkBill(this.dataEntities[i])) continue;
                srcbillidSet.add((Long)obj.getPkValue());
                DynamicObjectCollection entryCol = obj.getDynamicObjectCollection(KEY_BILLENTRY);
                for (Iterator entry : entryCol) {
                    entryIdList.add(entry.getPkValue());
                }
            }
            if (!srcbillidSet.isEmpty()) {
                String entityName;
                QFilter qfilter = new QFilter("billentry.srcbillid", "in", srcbillidSet);
                DynamicObjectCollection query = QueryServiceHelper.query((String)this.getOption().getVariableValue("targetname"), (String)"id,billentry.srcbillid", (QFilter[])new QFilter[]{qfilter});
                HashSet<Long> unBackFlushidSet = new HashSet<Long>(16);
                HashMap<Long, Long> proInMap = new HashMap<Long, Long>(16);
                HashMap proInErrorMap = new HashMap(16);
                for (DynamicObject proorder : query) {
                    Long proId = proorder.getLong("id");
                    Long inId = proorder.getLong("billentry.srcbillid");
                    unBackFlushidSet.add(proId);
                    proInMap.put(proId, inId);
                }
                if (!unBackFlushidSet.isEmpty()) {
                    OperateOption option = StockBackFlushUtils.getOperateOption();
                    OperationResult unAuditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)this.getOption().getVariableValue("targetname"), (Object[])unBackFlushidSet.toArray(), (OperateOption)option);
                    if (unAuditResult != null) {
                        String errDetail = StockBackFlushUtils.getErrDetail(unAuditResult);
                        List errorInfos = unAuditResult.getAllErrorOrValidateInfo();
                        List successPkIds = unAuditResult.getSuccessPkIds();
                        if (successPkIds.size() < unBackFlushidSet.size()) {
                            for (Long unBackFlushid : unBackFlushidSet) {
                                if (successPkIds.contains(unBackFlushid)) continue;
                                proInErrorMap.put(proInMap.get(unBackFlushid), errDetail);
                            }
                            for (IOperateInfo errorInfo : errorInfos) {
                                Long pkValue = errorInfo.getPkValue() == null ? 0L : Long.parseLong(errorInfo.getPkValue().toString());
                                String error = errorInfo.getTitle() + "," + errorInfo.getMessage();
                                if ("im_mdc_ominbill".equals(this.getEntityKey())) {
                                    error = ResManager.loadKDString((String)"\u53cd\u5012\u51b2\u4e0d\u6210\u529f\uff0c\u539f\u56e0\uff1a\u5bf9\u5e94\u7684\u7b80\u5355\u59d4\u5916\u9886\u6599\u5355\u53cd\u5ba1\u6838\u4e0d\u6210\u529f\u3002", (String)"UnBackFlushOpValidator_1", (String)"scmc-mm-om", (Object[])new Object[0]);
                                }
                                proInErrorMap.put(proInMap.get(pkValue), error);
                            }
                        }
                        if (!successPkIds.isEmpty()) {
                            OperationResult delResult = OperationServiceHelper.executeOperate((String)"delete", (String)this.getOption().getVariableValue("targetname"), (Object[])successPkIds.toArray(), (OperateOption)option);
                            List delErrorInfos = delResult.getAllErrorOrValidateInfo();
                            for (IOperateInfo errorInfo : delErrorInfos) {
                                Long pkValue = errorInfo.getPkValue() == null ? 0L : Long.parseLong(errorInfo.getPkValue().toString());
                                String error = errorInfo.getTitle() + "," + errorInfo.getMessage();
                                proInErrorMap.put(proInMap.get(pkValue), error);
                            }
                        }
                    }
                    for (int i = 0; i < this.dataEntities.length; ++i) {
                        DynamicObject obj = this.dataEntities[i].getDataEntity();
                        if (proInErrorMap.get(obj.getPkValue()) == null) continue;
                        String errorMessage = (String)proInErrorMap.get(obj.getPkValue());
                        this.addErrorMessage(this.dataEntities[i], errorMessage);
                    }
                }
                if (StringUtils.equals((CharSequence)"im_mdc_omcmplinbill", (CharSequence)(entityName = this.entityKey))) {
                    OMStockBackFlushUtils.updateBFStatusByEntryId(entryIdList, entityName);
                } else if (StringUtils.equals((CharSequence)"im_mdc_ominbill", (CharSequence)entityName)) {
                    OMComponentBackFlushUtils.updateBFStatusByEntryId(entryIdList, entityName);
                } else {
                    AutoBackFlushUtils.updateBFStatusByEntryId(entryIdList, entityName);
                }
            }
        }
    }

    private boolean checkBill(ExtendedDataEntity extendedDataEntity) {
        DynamicObject obj = extendedDataEntity.getDataEntity();
        DynamicObjectCollection entryCol = obj.getDynamicObjectCollection(KEY_BILLENTRY);
        boolean isNeedUnbackflush = true;
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryCol.get(i);
            if (!"D".equals(entryObj.get("backflushstatus").toString())) continue;
            isNeedUnbackflush = false;
        }
        if (!isNeedUnbackflush) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u53cd\u5012\u51b2\u7684\u6570\u636e\u3002", (String)"UnBackFlushOpValidator_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]));
        }
        return isNeedUnbackflush;
    }
}

