/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.applybill;

import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.im.formplugin.mdc.mftreqbill.MdcApplyBillUtils;
import kd.scmc.im.opplugin.mdc.applybill.validate.MdcApplyBillSubmitOnAddVal;

public class MdcApplyBillSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("org");
        keys.add("billentry");
        keys.add("material");
        keys.add("mainbillid");
        keys.add("baseqty");
        keys.add("qty");
        keys.add("auditqty");
        keys.add("rowstatus");
        keys.add("reqtype");
        keys.add("materialtype");
        keys.add("materielmasterid");
        keys.add("configuredcode");
        keys.add("auxpty");
        keys.add("mversion");
        keys.add("fullsize");
        keys.add("length");
        keys.add("width");
        keys.add("height");
        keys.add("workcard");
        keys.add("orderno");
        keys.add("material");
        keys.add("deliverdate");
        keys.add("demanddate");
        keys.add("billentry.ecostcenter");
        keys.add("billentry.rework");
        keys.add("billentry.baseqty");
        keys.add("billentry.auditbaseqty");
        keys.add("applydept");
        keys.add("workcenter");
        keys.add("workstation");
        keys.add("subentry");
        keys.add("subentry.refstockentryid");
        keys.add("subentry.refmaterial");
        keys.add("subentry.refunit");
        keys.add("subentry.refbaseqty");
        keys.add("subentry.refauditbaseqty");
        keys.add("subentry.refstockno");
        keys.add("subentry.refstockentryid");
        keys.add("subentry.refstockentryseq");
        keys.add("subentry.backbaseqty");
        keys.add("subentry.wipqty");
        keys.add("subentry.workcener");
        keys.add("subentry.refworkstation");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new MdcApplyBillSubmitOnAddVal());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String materialtype = "A";
        DynamicObject[] bills = e.getDataEntities();
        HashSet<Long> stockIdset = new HashSet<Long>(bills.length * 3);
        for (DynamicObject bill : bills) {
            String reqtype = (String)bill.get("reqtype");
            materialtype = (String)bill.get("materialtype");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                if (StringUtils.equals((CharSequence)"C", (CharSequence)reqtype) && StringUtils.equals((CharSequence)"A", (CharSequence)materialtype)) {
                    long stockid = entry.get("mainbillid") == null ? 0L : entry.getLong("mainbillid");
                    stockIdset.add(stockid);
                }
                entry.set("rowstatus", (Object)"B");
            }
        }
        if (stockIdset.size() > 0) {
            try (DataSet allDataSets = MdcApplyBillUtils.queryStockDataset(stockIdset, materialtype);){
                for (DynamicObject bill : bills) {
                    String reqtype = (String)bill.get("reqtype");
                    if (!StringUtils.equals((CharSequence)"C", (CharSequence)reqtype)) continue;
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
                    for (DynamicObject billentry : entrys) {
                        MdcApplyBillUtils.createSubEntryFromStockEntry(allDataSets, billentry);
                    }
                }
            }
        }
    }
}

