/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.backdiffshare;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.SourceRowReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scmc.im.common.mdc.utils.StockBackFlushUtils;
import kd.scmc.im.formplugin.mdc.mftouttpl.BackDiffShareUtil;

public class BaseAutoPushRunTask
implements Callable<String>,
Serializable {
    private static final long serialVersionUID = 1180321487745484112L;
    private static final Log logger = LogFactory.getLog(BaseAutoPushRunTask.class);
    private Map<Long, DynamicObject> subList = null;
    private String targetEntityNumber = "im_mdc_mftreturnorder";
    private Object invorgid = null;
    private Object mftorg = null;
    private Object diffshid = null;
    private Object detailid = null;
    private static final DBRoute scm = new DBRoute("scm");

    public BaseAutoPushRunTask() {
    }

    public BaseAutoPushRunTask(Map<Long, DynamicObject> sList, String dest, Object finvorgid, Object fmftorg, Object fdiffshid, Object detailpkid) {
        this.subList = sList;
        this.targetEntityNumber = dest;
        this.mftorg = fmftorg;
        this.invorgid = finvorgid;
        this.diffshid = fdiffshid;
        this.detailid = detailpkid;
    }

    @Override
    public String call() throws Exception {
        String replaceAll = UUID.randomUUID().toString().replaceAll("-", "1");
        logger.info("BaseCalcRunningTask888:\u591a\u7ebf\u7a0b.-------start\uff1a" + replaceAll + "------" + System.currentTimeMillis());
        String res = this.autoBackFlushStock();
        logger.info("BaseCalcRunningTask888:\u591a\u7ebf\u7a0b.-------end\uff1a" + replaceAll + "------" + System.currentTimeMillis());
        return res;
    }

    private String autoBackFlushStock() {
        String resStr;
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("pom_mftstock");
        pushArgs.setTargetEntityNumber(this.targetEntityNumber);
        pushArgs.setHasRight(false);
        pushArgs.setRuleId("1219565474166452224");
        String orderName = ResManager.loadKDString((String)"\u9886\u6599\u5355", (String)"BaseAutoPushRunTask_0", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        if (this.targetEntityNumber.equals("im_mdc_mftreturnorder")) {
            pushArgs.setRuleId("1213615382192310272");
            orderName = ResManager.loadKDString((String)"\u9000\u6599\u5355", (String)"BaseAutoPushRunTask_1", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        }
        pushArgs.setBuildConvReport(true);
        Map<Long, DynamicObject> stockList = this.subList;
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(stockList.size());
        HashMap<Long, DynamicObject> dMap = new HashMap<Long, DynamicObject>(this.subList.size());
        for (Map.Entry<Long, DynamicObject> smap : stockList.entrySet()) {
            DynamicObject dyDetail = smap.getValue();
            ListSelectedRow srcBill1 = new ListSelectedRow((Object)dyDetail.getLong("stockid"));
            srcBill1.setEntryEntityKey("stockentry");
            Long stockentryid = dyDetail.getLong("stockentryid");
            srcBill1.setEntryPrimaryKeyValue((Object)stockentryid);
            needPushRows.add(srcBill1);
            dMap.put(stockentryid, dyDetail);
        }
        pushArgs.setSelectedRows(needPushRows);
        long startTimeMillis = System.currentTimeMillis();
        logger.info("start--- ConvertServiceHelper.push---" + startTimeMillis);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        long endTimeMillis = System.currentTimeMillis();
        logger.info("endTime--- ConvertServiceHelper.push---" + endTimeMillis);
        logger.info("ConvertServiceHelper.push---totaltime--" + (endTimeMillis - startTimeMillis) / 1000L);
        if (!pushResult.isSuccess()) {
            StringBuilder errMessage = new StringBuilder().append(pushResult.getMessage());
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (billReport.isSuccess()) continue;
                errMessage.append(billReport.toString());
            }
            resStr = String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff1a%s", (String)"BaseAutoPushRunTask_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), errMessage);
            BackDiffShareUtil.updateDiffShareDetail(resStr, stockList, this.targetEntityNumber, "A");
            return "0";
        }
        StringBuilder errMessage = new StringBuilder();
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            if (billReport.isSuccess()) continue;
            errMessage.append(billReport.getBillNo());
            List linkEntityRowReports = billReport.getLinkEntityRowReports();
            for (SourceRowReport srreport : linkEntityRowReports) {
                errMessage.append(ResManager.loadKDString((String)"\u5206\u5f55\u884c\uff1a", (String)"BaseAutoPushRunTask_3", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                errMessage.append(srreport.getEntrySeq());
            }
            errMessage.append(billReport.getFailMessage());
        }
        if (StringUtils.isNotBlank((CharSequence)errMessage)) {
            resStr = String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff1a%s", (String)"BaseAutoPushRunTask_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), errMessage);
            BackDiffShareUtil.updateDiffShareDetail(resStr, stockList, this.targetEntityNumber, "A");
            return "0";
        }
        return this.delPushRes(pushResult, dMap, orderName);
    }

    private String delPushRes(ConvertOperationResult pushResult, Map<Long, DynamicObject> dMap, String orderName) {
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)this.targetEntityNumber);
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        long startTimeMillis = System.currentTimeMillis();
        logger.info("start--- handleTarget---" + startTimeMillis);
        this.handleTarget(targetBillObjs, dMap);
        long endTimeMillis = System.currentTimeMillis();
        logger.info("endTime---handleTarget---" + endTimeMillis);
        logger.info("handleTarget---totaltime--" + (endTimeMillis - startTimeMillis) / 1000L);
        OperateOption submitOption = StockBackFlushUtils.getOperateOption();
        startTimeMillis = System.currentTimeMillis();
        logger.info("start--- submit---" + startTimeMillis);
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)this.targetEntityNumber, (DynamicObject[])targetBillObjs.toArray(new DynamicObject[0]), (OperateOption)submitOption);
        endTimeMillis = System.currentTimeMillis();
        logger.info("endTime---submit---" + endTimeMillis);
        logger.info("submit---totaltime--" + (endTimeMillis - startTimeMillis) / 1000L);
        if (!submitResult.isSuccess()) {
            this.delFaildResult(submitResult.getSuccessPkIds(), orderName);
            String resStr = String.format(ResManager.loadKDString((String)"\u63d0\u4ea4%1$s\u5931\u8d25\uff1a%2$s", (String)"BaseAutoPushRunTask_4", (String)"scmc-mm-mdc", (Object[])new Object[0]), orderName, this.getErrDetail(submitResult));
            BackDiffShareUtil.updateDiffShareDetail(resStr, this.subList, this.targetEntityNumber, "A");
            return "0";
        }
        startTimeMillis = System.currentTimeMillis();
        logger.info("start--- audit---" + startTimeMillis);
        List successPkIds = submitResult.getSuccessPkIds();
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)this.targetEntityNumber, (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)submitOption);
        endTimeMillis = System.currentTimeMillis();
        logger.info("endTime---audit---" + endTimeMillis);
        logger.info("audit---totaltime--" + (endTimeMillis - startTimeMillis) / 1000L);
        if (!auditResult.isSuccess()) {
            String resDel = this.delFaildResult(successPkIds, orderName);
            if ("".equals(resDel)) {
                String resStr = String.format(ResManager.loadKDString((String)"\u5ba1\u6838%1$s\u5931\u8d25\uff1a2$", (String)"BaseAutoPushRunTask_5", (String)"scmc-mm-mdc", (Object[])new Object[0]), orderName, this.getErrDetail(auditResult));
                BackDiffShareUtil.updateDiffShareDetail(resStr, this.subList, this.targetEntityNumber, "A");
            } else {
                String resStr = String.format(ResManager.loadKDString((String)"\u5ba1\u6838%1$s\u5931\u8d25\uff0c\u53ef\u80fd\u4f1a\u5b58\u5728\u672a\u5220\u9664\u7684%2$s\u3002", (String)"BaseAutoPushRunTask_6", (String)"scmc-mm-mdc", (Object[])new Object[0]), orderName, orderName);
                BackDiffShareUtil.updateDiffShareDetail(resStr, this.subList, this.targetEntityNumber, "A");
            }
            return "0";
        }
        return "1";
    }

    private void handleTarget(List<DynamicObject> targetBillObjs, Map<Long, DynamicObject> detailMap) {
        String diffShareNo = this.getDiffShareNo(this.diffshid);
        for (int j = 0; j < targetBillObjs.size(); ++j) {
            DynamicObject targetBillObj = targetBillObjs.get(j);
            if (targetBillObj == null) continue;
            targetBillObj.set("bizorg", (Object)targetBillObj.getDynamicObject("org"));
            DynamicObjectCollection returnEntry = targetBillObj.getDynamicObjectCollection("billentry");
            for (DynamicObject mftorderEntryObj : returnEntry) {
                DynamicObject masterid = mftorderEntryObj.getDynamicObject("material").getDynamicObject("masterid");
                Long mainbillentryid = mftorderEntryObj.getLong("mainbillentryid");
                if (!detailMap.containsKey(mainbillentryid)) continue;
                DynamicObject detailRow = detailMap.get(mainbillentryid);
                DynamicObject unit = detailRow.getDynamicObject("invunit");
                DynamicObject baseunit = detailRow.getDynamicObject("shbaseunit");
                DynamicObject auxptyUnit = masterid.getDynamicObject("auxptyunit");
                targetBillObj.set("supplyowner", (Object)detailRow.getDynamicObject("showner"));
                BigDecimal actsharenum = detailRow.getBigDecimal("actsharenum");
                int precision = unit.getInt("precision");
                BigDecimal qty = actsharenum.setScale(precision, this.getRoundType(unit));
                mftorderEntryObj.set("qty", (Object)qty);
                Long baseunitid = (Long)baseunit.getPkValue();
                Long unitid = (Long)unit.getPkValue();
                BigDecimal baseqty = UnitConvertHelper.calculateNewQty((BigDecimal)qty, (Long)baseunitid, (Long)unitid, (Long)((Long)masterid.getPkValue()), (StringBuilder)new StringBuilder());
                if (auxptyUnit != null) {
                    Long auxptyUnitid = auxptyUnit.getLong("id");
                    BigDecimal auxptyqty = UnitConvertHelper.calculateNewQty((BigDecimal)qty, (Long)auxptyUnitid, (Long)unitid, (Long)((Long)masterid.getPkValue()), (StringBuilder)new StringBuilder());
                    mftorderEntryObj.set("qtyunit2nd", (Object)auxptyqty);
                    mftorderEntryObj.set("unit2nd", (Object)auxptyUnit);
                }
                mftorderEntryObj.set("baseqty", (Object)baseqty);
                mftorderEntryObj.set("srcbillnumber", (Object)diffShareNo);
                mftorderEntryObj.set("srcbillid", this.detailid);
                mftorderEntryObj.set("srcbillentryid", detailRow.getPkValue());
                mftorderEntryObj.set("srcbillentity", (Object)"im_mdc_backdifshare");
                mftorderEntryObj.set("mversion", (Object)detailRow.getDynamicObject("shmversion"));
                mftorderEntryObj.set("auxpty", (Object)detailRow.getDynamicObject("shauxpty"));
                mftorderEntryObj.set("lotnumber", (Object)detailRow.getString("shlotnumber"));
                mftorderEntryObj.set("project", (Object)detailRow.getDynamicObject("shproject"));
                mftorderEntryObj.set("producedate", (Object)detailRow.getDate("shproducedate"));
                mftorderEntryObj.set("expirydate", (Object)detailRow.getDate("shexpirydate"));
                mftorderEntryObj.set("warehouse", (Object)detailRow.getDynamicObject("shwarehouse"));
                mftorderEntryObj.set("location", (Object)detailRow.getDynamicObject("shlocation2"));
                mftorderEntryObj.set("unit", (Object)unit);
                mftorderEntryObj.set("baseunit", (Object)baseunit);
                mftorderEntryObj.set("outinvtype", (Object)detailRow.getDynamicObject("shinvtype"));
                mftorderEntryObj.set("outinvstatus", (Object)detailRow.getDynamicObject("shinvstatus"));
                mftorderEntryObj.set("outownertype", (Object)detailRow.getString("shownertype"));
                mftorderEntryObj.set("outowner", (Object)detailRow.getDynamicObject("showner"));
                mftorderEntryObj.set("outkeepertype", (Object)detailRow.getString("shkeepertype"));
                mftorderEntryObj.set("outkeeper", (Object)detailRow.getDynamicObject("shkeeper"));
            }
        }
    }

    private String delFaildResult(List<Object> successPkIds, String orderName) {
        DynamicObject[] loads;
        ArrayList<Object> auditPkIds = new ArrayList<Object>(successPkIds.size());
        ArrayList<DynamicObject> purinBillDymList = new ArrayList<DynamicObject>(successPkIds.size());
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)this.targetEntityNumber, (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", successPkIds)})) {
            purinBillDymList.add(load);
            if ("C".equals(load.getString("billstatus"))) continue;
            auditPkIds.add(load.getPkValue());
        }
        if (auditPkIds.isEmpty()) {
            return "success";
        }
        return this.delFaildResultDym(purinBillDymList, orderName);
    }

    private String delFaildResultDym(List<DynamicObject> purinBillDymList, String orderName) {
        HashSet<Object> auditPkIds = new HashSet<Object>(purinBillDymList.size());
        HashSet<Object> submitPkIds = new HashSet<Object>(purinBillDymList.size());
        HashSet<Object> delPkIds = new HashSet<Object>(purinBillDymList.size());
        for (DynamicObject purinBillDym : purinBillDymList) {
            if ("C".equals(purinBillDym.getString("billstatus"))) {
                auditPkIds.add(purinBillDym.getPkValue());
                continue;
            }
            if ("B".equals(purinBillDym.getString("billstatus"))) {
                submitPkIds.add(purinBillDym.getPkValue());
                continue;
            }
            delPkIds.add(purinBillDym.getPkValue());
        }
        return this.delFaildResultUnAudit(submitPkIds, auditPkIds, delPkIds, orderName);
    }

    private String delFaildResultUnAudit(Set<Object> submitPkIds, Set<Object> auditPkIds, Set<Object> delPkIds, String orderName) {
        OperationResult delResult;
        OperateOption option = StockBackFlushUtils.getOperateOption();
        if (!auditPkIds.isEmpty()) {
            OperationResult unAuditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)this.targetEntityNumber, (Object[])auditPkIds.toArray(), (OperateOption)option);
            if (!unAuditResult.isSuccess()) {
                logger.info("unaudit\u5012\u51b2\u9886\u6599\u5355\u5931\u8d25\uff1a" + auditPkIds.toArray() + this.getErrDetail(unAuditResult));
                return String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838%s\u5931\u8d25\u3002", (String)"BaseAutoPushRunTask_10", (String)"scmc-mm-mdc", (Object[])new Object[0]), orderName);
            }
            delPkIds.addAll(auditPkIds);
        }
        if (!submitPkIds.isEmpty()) {
            OperationResult unSubmitResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)this.targetEntityNumber, (Object[])submitPkIds.toArray(), (OperateOption)option);
            if (!unSubmitResult.isSuccess()) {
                logger.info("unsubmit\u5012\u51b2\u9886\u6599\u5355\u5931\u8d25\uff1a" + submitPkIds.toArray() + this.getErrDetail(unSubmitResult));
                return String.format(ResManager.loadKDString((String)"\u64a4\u9500%s\u5931\u8d25", (String)"BaseAutoPushRunTask_11", (String)"scmc-mm-mdc", (Object[])new Object[0]), orderName);
            }
            delPkIds.addAll(submitPkIds);
        }
        if (!(delResult = OperationServiceHelper.executeOperate((String)"delete", (String)this.targetEntityNumber, (Object[])delPkIds.toArray(), (OperateOption)option)).isSuccess()) {
            logger.info("delete\u5012\u51b2\u9886\u6599\u5355\u5931\u8d25\uff1a" + delPkIds.toArray() + this.getErrDetail(delResult));
            return String.format(ResManager.loadKDString((String)"\u5220\u9664%s\u5931\u8d25", (String)"BaseAutoPushRunTask_12", (String)"scmc-mm-mdc", (Object[])new Object[0]), orderName);
        }
        return "";
    }

    private String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        errDetail.append(optResult.getMessage().replaceAll("\\(\\)", "").replaceAll("</br>", ""));
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage().replaceAll("\\(\\)", "").replaceAll("</br>", ""));
        }
        return errDetail.toString();
    }

    private int getRoundType(DynamicObject unit) {
        String precisionAccount = unit.getString("precisionaccount");
        int roundType = 0;
        switch (precisionAccount) {
            case "1": {
                roundType = 4;
                break;
            }
            case "2": {
                roundType = 1;
                break;
            }
            case "3": {
                roundType = 0;
                break;
            }
        }
        return roundType;
    }

    public String getDiffShareNo(Object diffsId) {
        return (String)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)"select fbillno from t_im_mdc_backdifshare where fid=?", (Object[])new Object[]{diffsId}, rs -> {
            if (rs.next()) {
                return rs.getString(1);
            }
            return "";
        });
    }
}

