/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.backflush.validate;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.common.mdc.utils.StockBackFlushUtils;

public class AutoBackFlushOpTranValidator
extends AbstractValidator {
    private static final String KEY_BILLENTRY = "billentry";

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"AutoBackFlushOpTranValidator", (String)"validate");){
            DynamicObject[] objs = new DynamicObject[this.dataEntities.length];
            for (int i = 0; i < this.dataEntities.length; ++i) {
                objs[i] = this.dataEntities[i].getDataEntity();
            }
            Map<Long, DynamicObject> transMap = StockBackFlushUtils.getTransMap(objs, "backflusherr");
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject obj = this.dataEntities[i].getDataEntity();
                boolean isOminbill = false;
                if ("im_mdc_ominbill".equals(this.getEntityKey()) && "1".equals(StockBackFlushUtils.getBizDirection(obj.getDynamicObject("invscheme")))) {
                    isOminbill = true;
                }
                if (isOminbill || !"im_mdc_ominbill".equals(this.getEntityKey()) && !"im_mdc_mftmanuinbill".equals(this.getEntityKey())) continue;
                this.checkTran(this.dataEntities[i], transMap);
            }
        }
    }

    private void checkTran(ExtendedDataEntity extendedDataEntity, Map<Long, DynamicObject> transMap) {
        DynamicObject obj = extendedDataEntity.getDataEntity();
        DynamicObjectCollection entryCol = obj.getDynamicObjectCollection(KEY_BILLENTRY);
        if (entryCol == null || entryCol.isEmpty()) {
            return;
        }
        boolean isbackflush = true;
        DynamicObject firstEntryObj = (DynamicObject)entryCol.get(0);
        Long firstMainbillid = firstEntryObj.getLong("mainbillid");
        DynamicObject firstTran = transMap.get(firstMainbillid);
        if (firstTran == null) {
            return;
        }
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryCol.get(i);
            Long mainbillid = entryObj.getLong("mainbillid");
            DynamicObject tran = transMap.get(mainbillid);
            if (tran == null || firstTran.getBoolean("backflusherr") == tran.getBoolean("backflusherr")) continue;
            isbackflush = false;
        }
        if (!isbackflush) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u5bf9\u5e94\u7684\u4e8b\u52a1\u7c7b\u578b\u53c2\u6570\u201c\u5012\u51b2\u5931\u8d25\u4e2d\u6b62\u5ba1\u6838\u201d\u503c\uff0c\u53ea\u80fd\u662f\u552f\u4e00\u503c\u3002", (String)"AutoBackFlushOpTranValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]));
        }
    }
}

