/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.mftmanuinbill;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.trace.Tracer;
import kd.scmc.im.common.mdc.helper.GetEntityNameHelper;
import kd.scmc.im.common.mdc.utils.MftReqOutBillUtil;

public class CompletePickValidator
extends AbstractValidator {
    /*
     * Unable to fully structure code
     */
    public void validate() {
        span = Tracer.create((String)"CompletePickValidator", (String)"validate");
        var2_2 = null;
        try {
            var4_6 = operate = this.getOperateKey();
            var5_7 = -1;
            switch (var4_6.hashCode()) {
                case 93166555: {
                    if (!var4_6.equals("audit")) break;
                    var5_7 = 0;
                }
            }
            switch (var5_7) {
                case 0: {
                    manuBillIds = new HashSet<Long>(16);
                    manuEntryIds = new HashSet<Long>(16);
                    if (!"im_mdc_mftmanuinbill".equals(this.entityKey)) ** break;
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        obj = dataEntity.getDataEntity();
                        col = obj.getDynamicObjectCollection("billentry");
                        for (DynamicObject dyObj : col) {
                            manuBillIds.add(dyObj.getLong("manubillid"));
                            manuEntryIds.add(dyObj.getLong("manuentryid"));
                        }
                    }
                    orderById = MftReqOutBillUtil.getOrderById(manuBillIds, GetEntityNameHelper.getOrderEntityName(this.dataEntities));
                    orderEntryMap = null;
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        obj = dataEntity.getDataEntity();
                        col = obj.getDynamicObjectCollection("billentry");
                        for (DynamicObject entryObj : col) {
                            manuBill = orderById.get(entryObj.getLong("manuentryid"));
                            if (manuBill == null || !CompletePickValidator.needValid(entryObj, manuBill)) {
                                return;
                            }
                            curQTY = entryObj.getBigDecimal("baseqty");
                            materialNumber = entryObj.getDynamicObject("material").getDynamicObject("masterid").getString("number");
                            materialName = entryObj.getDynamicObject("material").getDynamicObject("masterid").getString("name");
                            if (orderEntryMap == null) {
                                orderEntryMap = CompletePickValidator.getOrderEntryMap(manuEntryIds, GetEntityNameHelper.getStockEntityName(this.dataEntities));
                            }
                            mapList = orderEntryMap.get(entryObj.getLong("manuentryid"));
                            accQty = BigDecimal.ZERO;
                            accQty = accQty.add((BigDecimal)manuBill.get("treeentryentity.quainwaqty")).add((BigDecimal)manuBill.get("treeentryentity.unquainwaqty")).add((BigDecimal)manuBill.get("treeentryentity.scrinwaqty"));
                            if (manuBill == null || mapList == null) continue;
                            for (i = 0; i < mapList.size(); ++i) {
                                if (null == mapList.get(i).get("stockentry.id") || 0L == (Long)mapList.get(i).get("stockentry.id")) continue;
                                precision = (Integer)mapList.get(i).get("stockentry.materialunitid.precision");
                                precisionaccount = (String)mapList.get(i).get("stockentry.materialunitid.precisionaccount");
                                deal = MftReqOutBillUtil.getPrecisionaccount(precisionaccount);
                                if (!CompletePickValidator.isInRange(mapList.get(i)).booleanValue()) continue;
                                judgeParam = new HashMap<String, Object>(32);
                                judgeParam.put("actissueqty", mapList.get(i).get("stockentry.actissueqty"));
                                judgeParam.put("rejectedqty", mapList.get(i).get("stockentry.rejectedqty"));
                                judgeParam.put("feedingqty", mapList.get(i).get("stockentry.feedingqty"));
                                judgeParam.put("qtytype", mapList.get(i).get("stockentry.qtytype"));
                                judgeParam.put("overissuecontrl", mapList.get(i).get("stockentry.overissuecontrl"));
                                judgeParam.put("fixscrap", mapList.get(i).get("stockentry.fixscrap"));
                                judgeParam.put("demandqty", mapList.get(i).get("stockentry.demandqty"));
                                judgeParam.put("lackraitioqty", mapList.get(i).get("stockentry.lackraitioqty"));
                                judgeParam.put("isconsiderloss", mapList.get(i).get("transactiontypeid.isconsiderloss"));
                                judgeParam.put("curQTY", curQTY);
                                judgeParam.put("accQty", accQty);
                                judgeParam.put("baseQty", mapList.get(i).get("baseqty"));
                                judgeResult = CompletePickValidator.qualityJudge(judgeParam, precision, deal);
                                isPass = (Boolean)judgeResult.get("isPass");
                                if (isPass) continue;
                                pNumber = (String)mapList.get(i).get("stockentry.materialid.masterid.number");
                                pName = (String)mapList.get(i).get("stockentry.materialid.masterid.name");
                                qtyA = (BigDecimal)judgeResult.get("qualityA");
                                qtyB = (BigDecimal)judgeResult.get("qualityB");
                                qtyT = accQty.add(curQTY);
                                message = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u5168\u9886\u6599\u7684\u7269\u6599\uff1a\u5165\u5e93\u4ea7\u54c1\u7f16\u7801\u201c%1$s\u201d \u4ea7\u54c1\u540d\u79f0\u201c%2$s\u201d \u7d2f\u8ba1\u5165\u5e93\u57fa\u672c\u6570\u91cf\u201c%3$s\u201d\uff0c\u7269\u6599\u7f16\u7801\u201c%4$s\u201d \u7269\u6599\u540d\u79f0\u201c%5$s\u201d\u5e94\u9886\u7528\u201c%6$s\u201d\uff0c\u5b9e\u9645\u9886\u7528\u201c%7$s\u201d\u3002", (String)"CompletePickValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[]{materialNumber, materialName, qtyT.compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(qtyT.intValue()) : qtyT.setScale(precision, deal).toPlainString(), pNumber, pName, qtyB.compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(qtyB.intValue()) : qtyB.setScale(precision, deal).toPlainString(), qtyA.compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(qtyA.intValue()) : qtyA.setScale(precision, deal).toPlainString()});
                                if ("A".equals(manuBill.get("transactiontype.warehouscontrol"))) {
                                    this.addWarningMessage(dataEntity, message);
                                    continue;
                                }
                                if (!"B".equals(manuBill.get("transactiontype.warehouscontrol"))) continue;
                                this.addErrorMessage(dataEntity, message);
                            }
                        }
                    }
                    break;
                }
                ** default:
lbl93:
                // 1 sources

                break;
            }
        }
        catch (Throwable var3_5) {
            var2_2 = var3_5;
            throw var3_5;
        }
        finally {
            if (span != null) {
                if (var2_2 != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable var19_26) {
                        var2_2.addSuppressed(var19_26);
                    }
                } else {
                    span.close();
                }
            }
        }
    }

    private static boolean needValid(DynamicObject entryObj, Map<String, Object> manuBill) {
        Boolean isWarehousingPick = (Boolean)manuBill.get("transactiontype.iswarehousingpick");
        if (!isWarehousingPick.booleanValue()) {
            return false;
        }
        return "C".equals(entryObj.getString("producttype"));
    }

    private static Boolean isInRange(Map<String, Object> stockMap) {
        String warehousrang = (String)stockMap.get("transactiontypeid.warehousrang");
        String issuemode = (String)stockMap.get("stockentry.issuemode");
        String isbackflush = (String)stockMap.get("stockentry.isbackflush");
        Boolean isbulkmaterial = (Boolean)stockMap.get("stockentry.isbulkmaterial");
        boolean iskeypart = (Boolean)stockMap.get("stockentry.iskeypart");
        Boolean inRangeFlag = false;
        switch (warehousrang) {
            case "A": {
                if (isbulkmaterial.booleanValue() || !"A".equals(isbackflush) || "C".equals(issuemode)) break;
                inRangeFlag = true;
                break;
            }
            case "B": {
                if (!iskeypart || "C".equals(issuemode)) break;
                inRangeFlag = true;
                break;
            }
            case "C": {
                if (isbulkmaterial.booleanValue() || "C".equals(issuemode)) break;
                inRangeFlag = true;
                break;
            }
        }
        return inRangeFlag;
    }

    private static HashMap<String, Object> qualityJudge(HashMap<String, Object> judgeParam, int precision, int deal) {
        boolean isPass;
        BigDecimal qualityA = BigDecimal.ZERO;
        BigDecimal qualityB = BigDecimal.ZERO;
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean isconsiderloss = (Boolean)judgeParam.get("isconsiderloss");
        BigDecimal curQTY = (BigDecimal)judgeParam.get("curQTY");
        BigDecimal accQty = (BigDecimal)judgeParam.get("accQty");
        BigDecimal baseQty = (BigDecimal)judgeParam.get("baseQty");
        qualityA = qualityA.add((BigDecimal)judgeParam.get("actissueqty")).subtract((BigDecimal)judgeParam.get("rejectedqty")).add((BigDecimal)judgeParam.get("feedingqty"));
        String qtytype = (String)judgeParam.get("qtytype");
        if ("A".equals(qtytype) || "C".equals(qtytype)) {
            String overissuecontrl = (String)judgeParam.get("overissuecontrl");
            qualityB = qualityB.add(accQty).add(curQTY);
            BigDecimal fixscrap = judgeParam.get("fixscrap") == null ? BigDecimal.ZERO : (BigDecimal)judgeParam.get("fixscrap");
            qualityB = qualityB.multiply(((BigDecimal)judgeParam.get("demandqty")).subtract(fixscrap)).divide(baseQty, precision, deal);
            if ("B".equals(overissuecontrl) && qualityB.compareTo((BigDecimal)judgeParam.get("lackraitioqty")) > 0) {
                qualityB = (BigDecimal)judgeParam.get("lackraitioqty");
            }
        } else {
            qualityB = (BigDecimal)judgeParam.get("demandqty");
        }
        if (qualityA.compareTo(qualityB) >= 0) {
            isPass = true;
        } else {
            isPass = false;
            result.put("qualityA", qualityA);
            result.put("qualityB", qualityB);
        }
        result.put("isPass", isPass);
        return result;
    }

    private static Map<Long, List<Map<String, Object>>> getOrderEntryMap(Set<Long> manuEntryIds, String entityName) {
        List<Map<String, Object>> list = MftReqOutBillUtil.getStockByOrderEntryIdV1(manuEntryIds, entityName);
        Map<Long, List<Map<String, Object>>> orderEntryMap = list.stream().collect(Collectors.groupingBy(var -> (Long)var.get("orderentryid")));
        return orderEntryMap;
    }
}

