/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.mftmanuinbill;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.common.mdc.helper.GetEntityNameHelper;
import kd.scmc.im.common.mdc.utils.MftReqOutBillUtil;
import kd.scmc.im.opplugin.mdc.utils.MPDMMftGenStocksUtils;
import org.apache.commons.lang3.StringUtils;

public class ManuFactureorderInwarehsBillXMFTValidator
extends AbstractValidator {
    private static final String KEY_SRCBILLENTRYID = "srcbillentryid";
    private static final String ENTITYID_XMFTORDER = "pom_xmftorder";
    private static final String ENTITYID_ENTRY = "treeentryentity";

    public void validate() {
        if ("A".equalsIgnoreCase(GetEntityNameHelper.getOrderEntityName(this.dataEntities))) {
            try (TraceSpan span = Tracer.create((String)"ManuFactureorderInwarehsBillXMFTValidator", (String)"validate");){
                String operate = this.getOperateKey();
                String operateName = String.format(ResManager.loadKDString((String)"\u5ba1\u6838", (String)"ManuFactureorderInwarehsBillXMFTValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]);
                switch (operate) {
                    case "delete": {
                        operateName = String.format(ResManager.loadKDString((String)"\u5220\u9664", (String)"ManuFactureorderInwarehsBillXMFTValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]);
                        break;
                    }
                    case "save": {
                        operateName = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ManuFactureorderInwarehsBillXMFTValidator_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]);
                        break;
                    }
                    case "submit": {
                        operateName = String.format(ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"ManuFactureorderInwarehsBillXMFTValidator_3", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]);
                        break;
                    }
                    case "submitandnew": {
                        operateName = String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u65b0\u589e", (String)"ManuFactureorderInwarehsBillXMFTValidator_4", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]);
                        break;
                    }
                    case "audit": {
                        operateName = String.format(ResManager.loadKDString((String)"\u5ba1\u6838", (String)"ManuFactureorderInwarehsBillXMFTValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]);
                        break;
                    }
                    case "unaudit": {
                        operateName = String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"ManuFactureorderInwarehsBillXMFTValidator_5", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]);
                        break;
                    }
                }
                HashSet<String> manuEntryIds = new HashSet<String>(16);
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
                    for (DynamicObject object : dataEntity.getDynamicObjectCollection("billentry")) {
                        if (!StringUtils.isNotBlank((CharSequence)object.getString("mainbillentryid"))) continue;
                        manuEntryIds.add(object.getString("mainbillentryid"));
                    }
                }
                Map<String, Map<String, String>> xmftOrder = MftReqOutBillUtil.getXmftOrderByManuEntryId(manuEntryIds, ENTITYID_XMFTORDER);
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
                    Map<String, Object> pmAppParameterMap = MPDMMftGenStocksUtils.getPmAppParameterMap((Long)dataEntity.getDynamicObject("org").getPkValue(), ENTITYID_XMFTORDER);
                    Boolean isMftOrderCtrlBusExe = (Boolean)pmAppParameterMap.get("ismftorderctrlbusexe");
                    for (int j = 0; j < dataEntity.getDynamicObjectCollection("billentry").size(); ++j) {
                        DynamicObject entryObj = (DynamicObject)dataEntity.getDynamicObjectCollection("billentry").get(j);
                        String mainBillEntryId = entryObj.getString("mainbillentryid");
                        Map<String, String> xmftOrderMap = xmftOrder.get(mainBillEntryId);
                        if (!isMftOrderCtrlBusExe.booleanValue() || xmftOrderMap == null || !StringUtils.equals((CharSequence)mainBillEntryId, (CharSequence)xmftOrderMap.get("treeentryentity.srcbillentryid"))) continue;
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u5355\u7b2c%1$s\u5206\u5f55\u5bf9\u5e94\u7684\u751f\u4ea7\u5de5\u5355\u5206\u5f55\u5b58\u5728\u201c\u672a\u5ba1\u6838\u7684\u5de5\u5355\u53d8\u66f4\u5355\u201d\uff0c\u201c%2$s\u201d\u5931\u8d25\u3002", (String)"ManuFactureorderInwarehsBillXMFTValidator_7", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1, operateName));
                    }
                }
            }
        }
    }
}

