/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.mftmanuinbill;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.common.mdc.utils.MftReqOutBillUtil;
import kd.scmc.im.utils.DateUtils;

public class ManuFactureorderInwarehsBizDateValidator
extends AbstractValidator {
    private static final String ENTITYID_MANUFACTUREBILL = "pom_mftorder";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"ManuFactureorderInwarehsBizDateValidator", (String)"validate");){
            String operate;
            switch (operate = this.getOperateKey()) {
                case "submit": 
                case "submitandnew": {
                    HashSet<Long> manuBillIds = new HashSet<Long>(16);
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        DynamicObject obj = dataEntity.getDataEntity();
                        DynamicObjectCollection col = obj.getDynamicObjectCollection("billentry");
                        for (DynamicObject dyObj : col) {
                            manuBillIds.add(dyObj.getLong("manubillid"));
                        }
                    }
                    Map<Long, Map<String, Object>> orderById = MftReqOutBillUtil.getOrderById(manuBillIds, ENTITYID_MANUFACTUREBILL);
                    ExtendedDataEntity[] extendedDataEntityArray = this.dataEntities;
                    int n = extendedDataEntityArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ExtendedDataEntity dataEntity = extendedDataEntityArray[n2];
                        this.bizDateValid(dataEntity, orderById);
                        ++n2;
                    }
                    return;
                }
            }
            return;
        }
    }

    private void bizDateValid(ExtendedDataEntity dataEntity, Map<Long, Map<String, Object>> orderById) {
        DynamicObject obj = dataEntity.getDataEntity();
        Date biztime = obj.getDate("biztime");
        if (biztime == null) {
            String format = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"ManuFactureorderInwarehsBizDateValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), new Object[0]);
            this.addErrorMessage(dataEntity, format);
            return;
        }
        Date dayEndTime = DateUtils.getDate((Date)biztime);
        for (int j = 0; j < obj.getDynamicObjectCollection("billentry").size(); ++j) {
            String format;
            DynamicObject entryObj = (DynamicObject)obj.getDynamicObjectCollection("billentry").get(j);
            Long entryId = entryObj.getLong("manuentryid");
            if (!orderById.containsKey(entryId)) continue;
            Map<String, Object> map = orderById.get(entryId);
            Date transmitTime = (Date)map.get("treeentryentity.transmittime");
            if (transmitTime == null) {
                format = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u5206\u5f55\u5bf9\u5e94\u5de5\u5355\u7684\u4e0b\u8fbe\u65e5\u671f\u4e3a\u7a7a\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"ManuFactureorderInwarehsBizDateValidator_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1);
                this.addErrorMessage(dataEntity, format);
                continue;
            }
            if ((transmitTime = DateUtils.getDate((Date)transmitTime)) == null || !dayEndTime.before(transmitTime)) continue;
            format = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u5206\u5f55\u5bf9\u5e94\u5de5\u5355\u7684\u4e0b\u8fbe\u65e5\u671f\u5927\u4e8e\u5165\u5e93\u5355\u7684\u4e1a\u52a1\u65e5\u671f\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"ManuFactureorderInwarehsBizDateValidator_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), j + 1);
            this.addErrorMessage(dataEntity, format);
        }
    }
}

