/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.mftmanuinbill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;

public class MftManuInBillAuditUtils {
    private static final Log logger = LogFactory.getLog(MftManuInBillAuditUtils.class);
    private static String outTcTable = "t_im_productinbill_tc";

    public static DynamicObject[] push(String sourceEntity, String targetEntity, String ruleId, DynamicObject info) {
        if (info == null) {
            return null;
        }
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        ORM orm = ORM.create();
        QFilter[] qfilters = new QFilter[]{new QFilter("id", "=", info.getPkValue()), new QFilter("stockentry.isbackflush", "=", (Object)"1"), new QFilter("billstatus", "=", (Object)"C"), new QFilter("stockentry.backflushtime", "=", (Object)"A")};
        DynamicObjectCollection col = orm.query("pom_mftstock", "id,stockentry.id", qfilters);
        if (col.size() == 0) {
            return null;
        }
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject obj = (DynamicObject)col.get(i);
            DynamicObjectCollection stockentry = obj.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < stockentry.size(); ++j) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue(info.getPkValue());
                row.setEntryPrimaryKeyValue(((DynamicObject)stockentry.get(j)).get("id"));
                selectedRows.add(row);
            }
        }
        if (selectedRows.size() == 0) {
            return null;
        }
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(targetEntity);
        args.setRuleId(ruleId);
        args.setSelectedRows(selectedRows);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        if (!result.isSuccess()) {
            ErrorCode ec = new ErrorCode("botp", result.getMessage());
            throw new KDBizException(ec, new Object[0]);
        }
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
        List dynamicresults = result.loadTargetDataObjects(refDataProvider, mainType);
        DynamicObject[] dataEntities = new DynamicObject[dynamicresults.size()];
        for (int i = 0; i < dynamicresults.size(); ++i) {
            DynamicObject destBill;
            dataEntities[i] = destBill = (DynamicObject)dynamicresults.get(i);
            String billno = CodeRuleServiceHelper.getNumber((String)targetEntity, (DynamicObject)destBill, (String)destBill.getDynamicObject("org").getPkValue().toString());
            if (StringUtils.isEmpty((CharSequence)billno)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u751f\u6210\u6ca1\u6709\u201c\u7f16\u7801\u89c4\u5219\u201d\u7684\u4e0b\u6e38\u5355\u636e\u3002", (String)"MftManuInBillAuditUtils_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            dataEntities[i].set("billno", (Object)billno);
        }
        return dataEntities;
    }

    public static void dealManuInbillData(DynamicObject[] dataArray) {
        HashSet<Long> orderIdSet = new HashSet<Long>(8);
        HashSet<Long> orderEntryIdSet = new HashSet<Long>(8);
        for (DynamicObject dataEntity : dataArray) {
            DynamicObjectCollection coll = dataEntity.getDynamicObjectCollection("billentry");
            for (DynamicObject row : coll) {
                orderEntryIdSet.add(row.getLong("manuentryid"));
                orderIdSet.add(row.getLong("manubillid"));
            }
        }
        Map<Long, Map<String, HashSet<Long>>> trackInfo = MftManuInBillAuditUtils.findTrackInfo("pom_mftorder", "treeentryentity", orderIdSet, orderEntryIdSet, true);
        HashMap<Long, DynamicObject> deleteMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject reqOutBill : dataArray) {
            DynamicObjectCollection billEntrys = reqOutBill.getDynamicObjectCollection("billentry");
            for (DynamicObject billEntry : billEntrys) {
                if (!MftManuInBillAuditUtils.canBeDeleted(billEntry, trackInfo, "im_mdc_mftmanuinbill")) continue;
                Long manuentryid = billEntry.getLong("manuentryid");
                deleteMap.put(manuentryid, billEntry);
            }
        }
        if (!deleteMap.isEmpty()) {
            HashMap<Long, Long> pidMap = new HashMap<Long, Long>(16);
            MftManuInBillAuditUtils.deleteOrderEntrys(deleteMap.keySet(), "pom_mftorder", "treeentryentity", pidMap);
            MftManuInBillAuditUtils.clearOrderEntryInfo(pidMap, deleteMap, dataArray, "billentry", "pom_mftorder", "treeentryentity");
        }
    }

    public static Map<Long, Map<String, HashSet<Long>>> findTrackInfo(String entityNumber, String entryKey, Set<Long> billIds, Set<Long> entryIds, boolean onlyDirtLink) {
        HashMap<Long, Map<String, HashSet<Long>>> trackInfoMap = new HashMap<Long, Map<String, HashSet<Long>>>(16);
        if (StringUtils.isNotBlank((CharSequence)entityNumber) && StringUtils.isNotBlank((CharSequence)entryKey) && CollectionUtils.isNotEmpty(billIds) && CollectionUtils.isNotEmpty(entryIds)) {
            List bfRowLinkDownNodes;
            OperateOption option = OperateOption.create();
            if (onlyDirtLink) {
                option.setVariableValue("botp_track_only_dirt_link", "true");
            }
            if (null != (bfRowLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)entityNumber, (String)entryKey, (Long[])billIds.toArray(new Long[billIds.size()]), (Long[])entryIds.toArray(new Long[entryIds.size()]), (OperateOption)option))) {
                for (BFRowLinkDownNode bfRowLinkDownNode : bfRowLinkDownNodes) {
                    BFRowId sRowId = bfRowLinkDownNode.getRowId();
                    Long sEntryId = sRowId.getEntryId();
                    HashMap<String, HashSet<Long>> tempMap = (HashMap<String, HashSet<Long>>)trackInfoMap.get(sEntryId);
                    if (null == tempMap) {
                        tempMap = new HashMap<String, HashSet<Long>>(16);
                    }
                    Map tNodes = bfRowLinkDownNode.getTNodes();
                    for (Map.Entry next : tNodes.entrySet()) {
                        BFRowLinkDownNode value = (BFRowLinkDownNode)next.getValue();
                        BFRowId rowId = value.getRowId();
                        Long entryId = rowId.getEntryId();
                        Long mainTableId = rowId.getMainTableId();
                        String tEntityNumber = EntityMetadataCache.loadTableDefine((Long)mainTableId).getEntityNumber();
                        HashSet<Long> tEntityIds = (HashSet<Long>)tempMap.get(tEntityNumber);
                        if (null == tEntityIds) {
                            tEntityIds = new HashSet<Long>(16);
                        }
                        tEntityIds.add(entryId);
                        tempMap.put(tEntityNumber, tEntityIds);
                    }
                    trackInfoMap.put(sEntryId, tempMap);
                }
            }
        }
        return trackInfoMap;
    }

    public static boolean canBeDeleted(DynamicObject billEntry, Map<Long, Map<String, HashSet<Long>>> trackInfo, String manuinbilEntity) {
        boolean result = true;
        if (null != trackInfo) {
            boolean isAdd = billEntry.getBoolean("isadd");
            if (isAdd) {
                Long manuentryid = billEntry.getLong("manuentryid");
                long billEntryId = billEntry.getLong("id");
                Map<String, HashSet<Long>> trackMap = trackInfo.get(manuentryid);
                if (null != trackMap) {
                    block0: for (Map.Entry<String, HashSet<Long>> hashSetEntry : trackMap.entrySet()) {
                        String billKey = hashSetEntry.getKey();
                        HashSet<Long> valueSet = hashSetEntry.getValue();
                        if (manuinbilEntity.equals(billKey)) {
                            for (Long aLong : valueSet) {
                                if (aLong.equals(billEntryId)) continue;
                                result = false;
                                logger.info("\u542b\u6709\u5176\u5b83\u4e0b\u6e38\u5165\u5e93\u5355");
                                continue block0;
                            }
                            continue;
                        }
                        result = false;
                        logger.info("\u542b\u6709\u5176\u5b83\u4e0b\u6e38\u5355\uff1a" + billKey);
                        break;
                    }
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    private static void deleteOrderEntrys(Set<Long> orderEntryIds, String orderEntity, String orderEntryEntity, Map<Long, Long> deleteMap) {
        logger.info("deleteOrderEntrys---" + orderEntryIds + "orderEntity---" + orderEntity + "orderEntryEntity---" + orderEntryEntity);
        if (null != orderEntryIds && CollectionUtils.isNotEmpty(orderEntryIds)) {
            DynamicObject[] load;
            HashSet<Long> deleteStockEntrySet = new HashSet<Long>(16);
            QFilter qFilter = new QFilter("treeentryentity.id", "in", orderEntryIds);
            HashMap<Object, DynamicObject> pomMftstockMap = new HashMap<Object, DynamicObject>(orderEntryIds.size());
            for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)orderEntity, (String)"id,billno,treeentryentity,treeentryentity.id,treeentryentity.pid", (QFilter[])qFilter.toArray())) {
                pomMftstockMap.put(dynamicObject.getPkValue(), dynamicObject);
            }
            if (null != pomMftstockMap) {
                ArrayList<DynamicObject> saveDyn = new ArrayList<DynamicObject>(16);
                for (Map.Entry dynamicObjectEntry : pomMftstockMap.entrySet()) {
                    DynamicObject mftStockBill = (DynamicObject)dynamicObjectEntry.getValue();
                    ArrayList<DynamicObject> removeEntrys = new ArrayList<DynamicObject>(16);
                    DynamicObjectCollection orderEntrys = mftStockBill.getDynamicObjectCollection(orderEntryEntity);
                    for (DynamicObject orderEntry : orderEntrys) {
                        if (!orderEntryIds.contains(orderEntry.getLong("id"))) continue;
                        removeEntrys.add(orderEntry);
                        deleteStockEntrySet.add(orderEntry.getLong("id"));
                        deleteMap.put(orderEntry.getLong("id"), orderEntry.getLong("pid"));
                    }
                    if (removeEntrys.size() > 0) {
                        orderEntrys.removeAll(removeEntrys);
                    }
                    saveDyn.add(mftStockBill);
                }
                if (CollectionUtils.isNotEmpty(saveDyn)) {
                    SaveServiceHelper.save((DynamicObject[])saveDyn.toArray(new DynamicObject[saveDyn.size()]));
                }
            }
            logger.info("deleteOrderEntrys---" + orderEntryIds + "deleteMap---" + deleteMap);
            QFilter xLogQFilter = new QFilter("srcbillentryid", "in", deleteStockEntrySet);
            logger.info("deleteOrderEntrys---deleteStockEntrySet--" + deleteStockEntrySet);
            DeleteServiceHelper.delete((String)"pom_xmftorderlog", (QFilter[])new QFilter[]{xLogQFilter});
        }
    }

    private static void clearOrderEntryInfo(Map<Long, Long> pidMap, Map<Long, DynamicObject> deleteOrderMap, DynamicObject[] reqOutBills, String tarEntryEntity, String srcEntity, String srcEntryEntity) {
        if (!deleteOrderMap.isEmpty() && null != reqOutBills && reqOutBills.length > 0) {
            String tBillType = reqOutBills[0].getDynamicObjectType().getName();
            Long tTableId = ConvertMetaServiceHelper.loadTableDefine((String)tBillType, (String)tarEntryEntity).getTableId();
            Long sTableId = ConvertMetaServiceHelper.loadTableDefine((String)srcEntity, (String)srcEntryEntity).getTableId();
            Long tMainTableId = ConvertMetaServiceHelper.loadMainTableDefine((String)tBillType).getTableId();
            Long sMainTableId = ConvertMetaServiceHelper.loadMainTableDefine((String)srcEntity).getTableId();
            ArrayList<Object[]> deleteList = new ArrayList<Object[]>(10);
            HashMap<Long, HashSet<Long>> deleteMap = new HashMap<Long, HashSet<Long>>(16);
            for (DynamicObject reqOutBill : reqOutBills) {
                DynamicObjectCollection billeEntrys = reqOutBill.getDynamicObjectCollection(tarEntryEntity);
                Long reqOutBillId = reqOutBill.getLong("id");
                for (DynamicObject billeEntry : billeEntrys) {
                    HashSet<Long> temp;
                    Long manuentryid = billeEntry.getLong("manuentryid");
                    Long mainbillid = billeEntry.getLong("manubillid");
                    boolean isadd = billeEntry.getBoolean("isadd");
                    if (!isadd || !deleteOrderMap.containsKey(manuentryid)) continue;
                    billeEntry.set("manuentryid", (Object)pidMap.get(manuentryid));
                    billeEntry.set("manuentry", null);
                    billeEntry.set("srcbillentryid", null);
                    boolean isDeleteFlag = false;
                    HashSet<DynamicObject> deleteSet = new HashSet<DynamicObject>(16);
                    DynamicObjectCollection tagLinkRows = (DynamicObjectCollection)billeEntry.get("billentry_lk");
                    for (DynamicObject tagLinkRow : tagLinkRows) {
                        if (!sTableId.equals(tagLinkRow.getLong("billentry_lk_stableid"))) continue;
                        deleteSet.add(tagLinkRow);
                        isDeleteFlag = true;
                    }
                    if (CollectionUtils.isNotEmpty(deleteSet)) {
                        tagLinkRows.removeAll(deleteSet);
                    }
                    if (null == (temp = (HashSet<Long>)deleteMap.get(reqOutBillId))) {
                        temp = new HashSet<Long>(16);
                    }
                    temp.add(mainbillid);
                    deleteMap.put(reqOutBillId, temp);
                }
            }
            for (Map.Entry entry : deleteMap.entrySet()) {
                Long key = (Long)entry.getKey();
                Set value = (Set)entry.getValue();
                if (!CollectionUtils.isNotEmpty((Collection)value)) continue;
                for (Long aLong : value) {
                    deleteList.add(new Object[]{key, aLong});
                }
            }
            SaveServiceHelper.save((DynamicObject[])reqOutBills);
            if (deleteList.size() > 0) {
                String sql = "delete from " + outTcTable + " where fttableid = " + tTableId + " and fstableid = " + sTableId + " and ftbillid = ? and fsbillid = ?";
                DBRoute dBRoute = new DBRoute("scm");
                DB.executeBatch((DBRoute)dBRoute, (String)sql, deleteList);
                String trackerSql = "delete from t_botp_billtracker where fttableid = " + tMainTableId + " and fstableid = " + sMainTableId + " and ftbillid = ? and fsbillid = ?";
                DBRoute sysRoute = new DBRoute("sys");
                DB.executeBatch((DBRoute)sysRoute, (String)trackerSql, deleteList);
            }
        }
    }
}

