/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.mftmanuinbill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MftManuInBillDeleteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MftManuInBillDeleteOp.class);
    private static final String ENTITYID_MANUFACTUREBILL = "pom_mftorder";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("manubill");
        e.getFieldKeys().add("manubillid");
        e.getFieldKeys().add("manuentry");
        e.getFieldKeys().add("manuentryid");
        e.getFieldKeys().add("producttype");
        e.getFieldKeys().add("qualitystatus");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("receivalqty");
        e.getFieldKeys().add("receivedqty");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("srcbillnumber");
        e.getFieldKeys().add("srcbillentity");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("srcbillentryseq");
        e.getFieldKeys().add("srcbillentryid");
        e.getFieldKeys().add("mainbillnumber");
        e.getFieldKeys().add("mainbillentity");
        e.getFieldKeys().add("mainbillid");
        e.getFieldKeys().add("mainbillentryseq");
        e.getFieldKeys().add("mainbillentryid");
        e.getFieldKeys().add("productionorg");
        e.getFieldKeys().add("billentry");
        e.getFieldKeys().add("billentry.manuentryid");
        e.getFieldKeys().add("billentry.manubillid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataArray;
        for (DynamicObject manuInBill : dataArray = e.getDataEntities()) {
            DynamicObjectCollection entryCol = manuInBill.getDynamicObjectCollection("billentry");
            if (!"delete".equals(e.getOperationKey())) continue;
            logger.error((Object)(manuInBill.getDataEntityType().getName() + "\u5e93\u5b58\u5355\u636e\u6267\u884c\u5220\u9664\u64cd\u4f5c"));
            this.SaveAndDelete(entryCol, "delete");
        }
    }

    private void SaveAndDelete(DynamicObjectCollection entryCol, String operationKey) {
        for (DynamicObject entryObj : entryCol) {
            if (!ENTITYID_MANUFACTUREBILL.equals(entryObj.getString("mainbillentity"))) continue;
            DynamicObject manuObj = BusinessDataServiceHelper.loadSingle((Object)entryObj.getLong("manubillid"), (String)ENTITYID_MANUFACTUREBILL);
            logger.info((Object)("\u751f\u4ea7\u5de5\u5355:\u7f16\u7801" + manuObj.get("billno")));
            Long entryId = entryObj.getLong("manuentryid");
            for (DynamicObject manuEntryObj : manuObj.getDynamicObjectCollection("treeentryentity")) {
                if (!entryId.equals(manuEntryObj.getPkValue())) continue;
                manuEntryObj.set("stockqty", (Object)this.getQualityQTY(operationKey, manuEntryObj, "stockqty", entryObj, "baseqty"));
                logger.info((Object)("\u751f\u4ea7\u5de5\u5355:\u4e0b\u63a8\u5165\u5e93\u6570\u91cf" + manuEntryObj.getBigDecimal("stockqty")));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{manuObj});
            }
        }
    }

    private BigDecimal getQualityQTY(String operationKey, DynamicObject manuEntryObj, String qtyFirstFieldName, DynamicObject entryObj, String qtySecondFieldName) {
        BigDecimal result = BigDecimal.ZERO;
        logger.error((Object)("\u64cd\u4f5c\u4e2d\u5f53\u524d\u5b8c\u5de5\u5165\u5e93/\u9000\u5e93\u5355\u6570\u91cf\u4e3a:" + entryObj.getBigDecimal(qtySecondFieldName)));
        switch (operationKey) {
            case "save": {
                result = manuEntryObj.getBigDecimal(qtyFirstFieldName).add(entryObj.getBigDecimal(qtySecondFieldName));
                break;
            }
            case "delete": {
                result = manuEntryObj.getBigDecimal(qtyFirstFieldName).subtract(entryObj.getBigDecimal(qtySecondFieldName));
                break;
            }
        }
        return result;
    }
}

