/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.mftmanuinbill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.scmc.im.common.mdc.helper.GetEntityNameHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MftOrderCalWriteUtils {
    private static final Log logger = LogFactory.getLog(MftOrderCalWriteUtils.class);
    public static final Map<String, String> entityName = new HashMap<String, String>(16);

    public static void calManuInBillInfo(Map<String, DynamicObject> mftOrderMap, String[] split, DynamicObject entryCol, String operationKey, int flag, String productiondomain) {
        String manubillid = entryCol.getString("manubillid");
        logger.info("operationKey--------" + operationKey);
        switch (operationKey) {
            case "Draft": 
            case "Save": 
            case "Delete": {
                MftOrderCalWriteUtils.SaveAndDelete(entryCol, mftOrderMap.get(manubillid), split, flag);
                break;
            }
            case "Audit": 
            case "UnAudit": {
                MftOrderCalWriteUtils.AuditAndUn(entryCol, mftOrderMap.get(manubillid), split, flag, productiondomain);
                MftOrderCalWriteUtils.updateMftEndworktime(mftOrderMap.keySet().stream().map(Long::parseLong).collect(Collectors.toSet()), GetEntityNameHelper.getOrderEntityName(productiondomain));
                break;
            }
            case "Cancel": {
                if (!"E".equalsIgnoreCase(productiondomain)) {
                    MftOrderCalWriteUtils.SaveAndDelete(entryCol, mftOrderMap.get(manubillid), split, flag);
                }
                MftOrderCalWriteUtils.AuditAndUn(entryCol, mftOrderMap.get(manubillid), split, flag, productiondomain);
                MftOrderCalWriteUtils.updateMftEndworktime(mftOrderMap.keySet().stream().map(Long::parseLong).collect(Collectors.toSet()), GetEntityNameHelper.getOrderEntityName(productiondomain));
                break;
            }
        }
    }

    public static void updateMftEndworktime(Set<Long> mftIdList, String entity) {
        logger.info("updateMftEndworktime---------start----");
        if (CollectionUtils.isNotEmpty(mftIdList)) {
            DynamicObject[] manuObjList;
            QFilter qf = new QFilter("id", "in", mftIdList);
            HashSet<Long> orderEntryIds = new HashSet<Long>(16);
            HashSet<Long> orderEntryIdSet = new HashSet<Long>(16);
            for (DynamicObject mftOrder : manuObjList = BusinessDataServiceHelper.load((String)entity, (String)MftOrderCalWriteUtils.mftOrderSelected(), (QFilter[])new QFilter[]{qf})) {
                Object mid = mftOrder.getPkValue();
                for (DynamicObject mEntry : mftOrder.getDynamicObjectCollection("treeentryentity")) {
                    orderEntryIdSet.add(mEntry.getLong("id"));
                }
            }
            Map<String, Date> endWorkTimeData = MftOrderCalWriteUtils.getEndWorkTimeData(orderEntryIdSet, mftIdList, entityName.get(entity));
            for (DynamicObject mftOrder : manuObjList) {
                Object mid = mftOrder.getPkValue();
                for (DynamicObject mEntry : mftOrder.getDynamicObjectCollection("treeentryentity")) {
                    MftOrderCalWriteUtils.setStartWorkTimeNew(orderEntryIds, mEntry, mid, endWorkTimeData);
                }
            }
            if (manuObjList.length > 0) {
                logger.info("updateMftEndworktime---------save----");
                SaveServiceHelper.save((DynamicObject[])manuObjList);
            }
        }
    }

    private static void setBeginBookDate(Set<Long> orderEntryIds, String entity) {
        HashMap<String, Object> calparam = new HashMap<String, Object>(20);
        calparam.put("orderentryids", orderEntryIds);
        calparam.put("modetype", "beginbookdate");
        calparam.put("pageEntity", entity);
        calparam.put("optype", "beginwork");
        calparam.put("appId", "im");
        String jsonString = JSON.toJSONString(calparam);
        EventServiceHelper.triggerEventSubscribe((String)"mftorder.setbookdate", (String)jsonString);
    }

    private static void setStartWorkTime(DynamicObject mEntry, Set<Long> orderEntryIds, Date endWorkTime) {
        String taskStatus = mEntry.getString("taskstatus");
        if (StringUtils.equals((CharSequence)"C", (CharSequence)taskStatus) || StringUtils.equals((CharSequence)"D", (CharSequence)taskStatus) || StringUtils.equals((CharSequence)"B", (CharSequence)taskStatus)) {
            Date startWorkTime = mEntry.getDate("startworktime");
            if (null == startWorkTime) {
                mEntry.set("startworktime", (Object)endWorkTime);
                orderEntryIds.add(mEntry.getLong("id"));
            }
        } else {
            mEntry.set("startworktime", null);
        }
    }

    public static Date setEndWorkTime(DynamicObject mEntry, Object mid, String entity) {
        Object entryid = mEntry.getPkValue();
        QFilter qf2 = new QFilter("billentry.manuentryid", "=", (Object)Long.parseLong(entryid.toString()));
        qf2.and(new QFilter("billentry.manubillid", "=", (Object)Long.parseLong(mid.toString())));
        qf2.and(new QFilter("billstatus", "=", (Object)"C"));
        qf2.and(new QFilter("billentry.remainreturnqty", ">", (Object)0));
        qf2.and(new QFilter("ischargeoff", "=", (Object)Boolean.FALSE));
        qf2.and(new QFilter("ischargeoffed", "=", (Object)Boolean.FALSE));
        DynamicObjectCollection query = QueryServiceHelper.query((String)entity, (String)"id,biztime,billentry.manuentryid,billentry.manubillid", (QFilter[])new QFilter[]{qf2}, (String)"biztime desc", (int)1);
        if (!query.isEmpty() && query.size() > 0) {
            Date biztime = ((DynamicObject)query.get(0)).getDate("biztime");
            logger.info("setEndWorkTime----------" + biztime);
            mEntry.set("endworktime", (Object)biztime);
            return biztime;
        }
        logger.info("setEndWorkTime----------\u7a7a---");
        mEntry.set("endworktime", null);
        return null;
    }

    public static void setStartWorkTimeNew(Set<Long> orderEntryIds, DynamicObject mEntry, Object mid, Map<String, Date> endWorkTimeData) {
        Object entryid = mEntry.getPkValue();
        String keystr = mid + "@@" + entryid;
        if (endWorkTimeData.containsKey(keystr)) {
            Date biztime = endWorkTimeData.get(keystr);
            logger.info("setEndWorkTime----------" + biztime);
            mEntry.set("endworktime", (Object)biztime);
        } else {
            logger.info("setEndWorkTime----------\u7a7a---");
            mEntry.set("endworktime", null);
        }
        String taskStatus = mEntry.getString("taskstatus");
        if (StringUtils.equals((CharSequence)"C", (CharSequence)taskStatus) || StringUtils.equals((CharSequence)"D", (CharSequence)taskStatus) || StringUtils.equals((CharSequence)"B", (CharSequence)taskStatus)) {
            Date startWorkTime = mEntry.getDate("startworktime");
            if (null == startWorkTime) {
                mEntry.set("startworktime", (Object)mEntry.getDate("endworktime"));
                orderEntryIds.add(mEntry.getLong("id"));
            }
        } else {
            mEntry.set("startworktime", null);
        }
    }

    public static Map<String, Date> getEndWorkTimeData(Set<Long> mftEntryidSet, Set<Long> mftidSet, String entity) {
        HashMap<String, Date> resultMap = new HashMap<String, Date>(16);
        QFilter qf2 = new QFilter("billentry.manuentryid", "in", mftEntryidSet);
        qf2.and(new QFilter("billentry.manubillid", "in", mftidSet));
        qf2.and(new QFilter("billstatus", "=", (Object)"C"));
        qf2.and(new QFilter("billentry.remainreturnqty", ">", (Object)0));
        qf2.and(new QFilter("ischargeoff", "=", (Object)Boolean.FALSE));
        qf2.and(new QFilter("ischargeoffed", "=", (Object)Boolean.FALSE));
        DynamicObjectCollection query = QueryServiceHelper.query((String)entity, (String)"id,biztime,billentry.manuentryid,billentry.manubillid", (QFilter[])new QFilter[]{qf2}, null);
        if (!query.isEmpty() && query.size() > 0) {
            for (DynamicObject row : query) {
                Long manuentryid = row.getLong("billentry.manuentryid");
                Long manubillid = row.getLong("billentry.manubillid");
                Date biztime = row.getDate("biztime");
                String keystr = manubillid + "@@" + manuentryid;
                logger.info("setEndWorkTime----------" + biztime + "---keystr---" + keystr);
                if (resultMap.containsKey(keystr)) {
                    Date date = (Date)resultMap.get(keystr);
                    if (!biztime.after(date)) continue;
                    resultMap.put(keystr, biztime);
                    continue;
                }
                resultMap.put(keystr, biztime);
            }
        }
        logger.info("setEndWorkTime-------resultMap---" + resultMap);
        return resultMap;
    }

    public static void saveManuInBill(Map<String, DynamicObject> mftOrderMap) {
        List collect = mftOrderMap.entrySet().stream().map(e -> (DynamicObject)e.getValue()).collect(Collectors.toList());
        DynamicObject[] array = (DynamicObject[])collect.stream().toArray(DynamicObject[]::new);
        SaveServiceHelper.save((DynamicObject[])array);
    }

    public static void setEntryStockqty(DynamicObject delmanuObj, DynamicObject entryObj) {
        Long entryId = entryObj.getLong("manuentryid");
        for (DynamicObject delEntry : delmanuObj.getDynamicObjectCollection("treeentryentity")) {
            if (!entryId.equals(delEntry.getPkValue())) continue;
            BigDecimal subtract = delmanuObj.getBigDecimal("stockqty").subtract(entryObj.getBigDecimal("baseqty"));
            delmanuObj.set("stockqty", (Object)subtract);
        }
    }

    public static void SaveAndDelete(DynamicObject entryCol, DynamicObject mftOrder, String[] split, int flag) {
        if ("pom_mftorder".equals(entryCol.getString("mainbillentity")) || "prop_mftorder".equals(entryCol.getString("mainbillentity"))) {
            Long entryId = entryCol.getLong("manuentryid");
            for (DynamicObject manuEntryObj : mftOrder.getDynamicObjectCollection("treeentryentity")) {
                if (!entryId.equals(manuEntryObj.getPkValue())) continue;
                logger.info("\u751f\u4ea7\u5de5\u5355:" + mftOrder.get("billno") + "\u4e0b\u63a8\u5165\u5e93\u6570\u91cf\u524d" + manuEntryObj.getBigDecimal("stockqty"));
                manuEntryObj.set("stockqty", (Object)manuEntryObj.getBigDecimal("stockqty").add(new BigDecimal(split[3])));
                logger.info("\u751f\u4ea7\u5de5\u5355:" + mftOrder.get("billno") + "\u4e0b\u63a8\u5165\u5e93\u6570\u91cf\u540e" + manuEntryObj.getBigDecimal("stockqty"));
            }
        }
    }

    public static void AuditAndUn(DynamicObject entryObj, DynamicObject manuObj, String[] split, int flag, String productiondomain) {
        String manftechName = "sfc_manftech";
        HashSet<Long> oprentryids = new HashSet<Long>(16);
        if (!"E".equalsIgnoreCase(productiondomain)) {
            for (DynamicObject manuEntryObj : manuObj.getDynamicObjectCollection("treeentryentity")) {
                long oprentryid = manuEntryObj.getLong("oprentryid");
                if (oprentryid == 0L) continue;
                oprentryids.add(oprentryid);
            }
        } else {
            manftechName = "prop_manftech";
        }
        HashMap<Long, DynamicObject> oprentryentityid_sfcmanftecheEntrysMap = new HashMap<Long, DynamicObject>(16);
        HashSet<DynamicObject> manfteches = new HashSet<DynamicObject>(16);
        if (!oprentryids.isEmpty()) {
            String selects = "id,oprentryentity,oprentryentity.id,oprentryentity.entrustrinqty,oprentryentity.entrustfinqty,oprentryentity.entrustdinqty";
            QFilter[] qfs = new QFilter[]{new QFilter("oprentryentity.id", "in", oprentryids)};
            DynamicObject[] sfc_manfteches = BusinessDataServiceHelper.load((String)manftechName, (String)selects, (QFilter[])qfs);
            if (sfc_manfteches != null) {
                for (DynamicObject dynamicObject : sfc_manfteches) {
                    DynamicObjectCollection oprentryentityColl = dynamicObject.getDynamicObjectCollection("oprentryentity");
                    manfteches.add(dynamicObject);
                    for (DynamicObject opEntry : oprentryentityColl) {
                        long opEntryId = opEntry.getLong("id");
                        oprentryentityid_sfcmanftecheEntrysMap.put(opEntryId, opEntry);
                    }
                }
            }
        }
        Long entryId = entryObj.getLong("manuentryid");
        for (DynamicObject manuEntryObj : manuObj.getDynamicObjectCollection("treeentryentity")) {
            if (!entryId.equals(manuEntryObj.getPkValue())) continue;
            Long oprentryid = 0L;
            if ("A".equalsIgnoreCase(productiondomain)) {
                oprentryid = manuEntryObj.getLong("oprentryid");
            }
            DynamicObject opEntry = (DynamicObject)oprentryentityid_sfcmanftecheEntrysMap.get(oprentryid);
            BigDecimal qtynumber = new BigDecimal(split[3]);
            switch (entryObj.getString("qualitystatus")) {
                case "A": {
                    manuEntryObj.set("quainwaqty", (Object)manuEntryObj.getBigDecimal("quainwaqty").add(qtynumber));
                    if (opEntry == null) break;
                    opEntry.set("entrustrinqty", (Object)opEntry.getBigDecimal("entrustrinqty").add(qtynumber));
                    break;
                }
                case "B": {
                    manuEntryObj.set("unquainwaqty", (Object)manuEntryObj.getBigDecimal("unquainwaqty").add(qtynumber));
                    if (opEntry == null) break;
                    opEntry.set("entrustfinqty", (Object)opEntry.getBigDecimal("entrustfinqty").add(qtynumber));
                    break;
                }
                case "C": {
                    manuEntryObj.set("waitcheckqty", (Object)manuEntryObj.getBigDecimal("waitcheckqty").add(qtynumber));
                    break;
                }
                case "D": {
                    manuEntryObj.set("scrinwaqty", (Object)manuEntryObj.getBigDecimal("scrinwaqty").add(qtynumber));
                    if (opEntry == null) break;
                    opEntry.set("entrustdinqty", (Object)opEntry.getBigDecimal("entrustdinqty").add(qtynumber));
                    break;
                }
            }
            logger.info("\u751f\u4ea7\u5de5\u5355:billno" + manuObj.get("billno"));
            logger.info("\u751f\u4ea7\u5de5\u5355:\u5408\u683c\u54c1\u5165\u5e93\u6570\u91cf" + manuEntryObj.getBigDecimal("quainwaqty"));
            logger.info("\u751f\u4ea7\u5de5\u5355:\u4e0d\u5408\u683c\u54c1\u5165\u5e93\u6570\u91cf" + manuEntryObj.getBigDecimal("unquainwaqty"));
            logger.info("\u751f\u4ea7\u5de5\u5355:\u5f85\u68c0\u54c1\u6570\u91cf" + manuEntryObj.getBigDecimal("waitcheckqty"));
            logger.info("\u751f\u4ea7\u5de5\u5355:\u62a5\u5e9f\u6570\u91cf" + manuEntryObj.getBigDecimal("scrinwaqty"));
            logger.info("\u751f\u4ea7\u5de5\u5355:inwarmin" + manuEntryObj.getBigDecimal("inwarmin"));
            logger.info("\u751f\u4ea7\u5de5\u5355\u5f53\u524d\u72b6\u6001:" + manuEntryObj.getString("taskstatus"));
            BigDecimal bigDecimal = manuEntryObj.getBigDecimal("quainwaqty").add(manuEntryObj.getBigDecimal("unquainwaqty")).add(manuEntryObj.getBigDecimal("waitcheckqty")).add(manuEntryObj.getBigDecimal("scrinwaqty"));
            logger.info("\u751f\u4ea7\u5de5\u5355:qty" + bigDecimal + " - iscontrolqty:" + manuEntryObj.getBoolean("iscontrolqty"));
            if (manuEntryObj.getBoolean("iscontrolqty")) {
                if (bigDecimal.compareTo(manuEntryObj.getBigDecimal("inwarmin")) >= 0) {
                    manuEntryObj.set("taskstatus", (Object)"C");
                    continue;
                }
                if (BigDecimal.ZERO.compareTo(bigDecimal) >= 0) {
                    manuEntryObj.set("taskstatus", (Object)"B");
                    continue;
                }
                manuEntryObj.set("taskstatus", (Object)"D");
                continue;
            }
            if (bigDecimal.compareTo(manuEntryObj.getBigDecimal("baseqty")) >= 0) {
                manuEntryObj.set("taskstatus", (Object)"C");
            } else {
                manuEntryObj.set("taskstatus", (Object)"D");
            }
            if (BigDecimal.ZERO.compareTo(bigDecimal) < 0) continue;
            manuEntryObj.set("taskstatus", (Object)"B");
        }
        if (!manfteches.isEmpty()) {
            logger.info("---MftOrderCalWriteUtils.AuditAndUn---320 manfteches.size:" + manfteches.size());
            SaveServiceHelper.save((DynamicObject[])manfteches.toArray(new DynamicObject[manfteches.size()]));
        }
    }

    public static String mftOrderSelected() {
        StringBuilder sql = new StringBuilder();
        sql.append("billno, id,transactiontype,");
        sql.append("treeentryentity.quainwaqty , treeentryentity.unquainwaqty,treeentryentity.waitcheckqty,treeentryentity.scrinwaqty, ");
        sql.append("treeentryentity.inwarmin , treeentryentity.inwarmin,treeentryentity.taskstatus,treeentryentity.stockqty,treeentryentity.baseqty ,");
        sql.append("treeentryentity.seq , treeentryentity.endworktime ,treeentryentity.iscontrolqty,treeentryentity.pid,");
        sql.append("treeentryentity.transmittime , treeentryentity.startworktime,treeentryentity.endworktime,treeentryentity.oprentryid");
        return sql.toString();
    }

    public static String selectManuColumn() {
        StringBuilder sql = new StringBuilder();
        sql.append("id,invscheme,productiondomain,");
        sql.append("billentry.manubillid,billentry.manuentryid,billentry.baseqty,");
        sql.append("billentry.qty,billentry.mainbillentity,billentry.srcbillentity,");
        sql.append("billentry.mainbillentryid");
        return sql.toString();
    }

    static {
        entityName.put("pom_mftorder", "im_mdc_mftmanuinbill");
        entityName.put("om_mftorder", "im_mdc_omcmplinbill");
        entityName.put("prop_mftorder", "im_mdc_mftmanuinbill");
    }
}

